/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestQueueCapacities {
    private static final Log LOG = LogFactory.getLog(TestQueueCapacities.class);
    private String suffix;

    @Parameterized.Parameters
    public static Collection<String[]> getParameters() {
        return Arrays.asList({"Capacity"}, {"AbsoluteCapacity"}, {"UsedCapacity"}, {"AbsoluteUsedCapacity"}, {"MaximumCapacity"}, {"AbsoluteMaximumCapacity"}, {"MaxAMResourcePercentage"});
    }

    public TestQueueCapacities(String suffix) {
        this.suffix = suffix;
    }

    private static float get(QueueCapacities obj, String suffix, String label) throws Exception {
        return TestQueueCapacities.executeByName(obj, "get" + suffix, label, -1.0f);
    }

    private static void set(QueueCapacities obj, String suffix, String label, float value) throws Exception {
        TestQueueCapacities.executeByName(obj, "set" + suffix, label, value);
    }

    private static float executeByName(QueueCapacities obj, String methodName, String label, float value) throws Exception {
        if (methodName.startsWith("get")) {
            float result;
            if (label == null) {
                Method method = QueueCapacities.class.getDeclaredMethod(methodName, new Class[0]);
                result = ((Float)method.invoke((Object)obj, new Object[0])).floatValue();
            } else {
                Method method = QueueCapacities.class.getDeclaredMethod(methodName, String.class);
                result = ((Float)method.invoke((Object)obj, label)).floatValue();
            }
            return result;
        }
        if (label == null) {
            Method method = QueueCapacities.class.getDeclaredMethod(methodName, Float.TYPE);
            method.invoke((Object)obj, Float.valueOf(value));
        } else {
            Method method = QueueCapacities.class.getDeclaredMethod(methodName, String.class, Float.TYPE);
            method.invoke((Object)obj, label, Float.valueOf(value));
        }
        return -1.0f;
    }

    private void internalTestModifyAndRead(String label) throws Exception {
        QueueCapacities qc = new QueueCapacities(false);
        Assert.assertEquals((double)0.0, (double)TestQueueCapacities.get(qc, this.suffix, label), (double)1.0E-8);
        TestQueueCapacities.set(qc, this.suffix, label, 1.0f);
        Assert.assertEquals((double)1.0, (double)TestQueueCapacities.get(qc, this.suffix, label), (double)1.0E-8);
        TestQueueCapacities.set(qc, this.suffix, label, 2.0f);
        Assert.assertEquals((double)2.0, (double)TestQueueCapacities.get(qc, this.suffix, label), (double)1.0E-8);
    }

    void check(int mem, int cpu, Resource res) {
        Assert.assertEquals((long)mem, (long)res.getMemory());
        Assert.assertEquals((long)cpu, (long)res.getVirtualCores());
    }

    @Test
    public void testModifyAndRead() throws Exception {
        LOG.info((Object)("Test - " + this.suffix));
        this.internalTestModifyAndRead(null);
        this.internalTestModifyAndRead("label");
    }
}

