/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAppRunnability
extends FairSchedulerTestBase {
    private static final String ALLOC_FILE = new File(TEST_DIR, "test-queues").getAbsolutePath();

    @Before
    public void setUp() throws IOException {
        this.conf = this.createConfiguration();
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
    }

    @After
    public void tearDown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.shutdown();
    }

    @Test
    public void testUserAsDefaultQueue() throws Exception {
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "true");
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(appAttemptId, "default", "user1", null);
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("default", true).getNumRunnableApps());
        Assert.assertEquals((Object)"root.user1", (Object)((RMApp)this.resourceManager.getRMContext().getRMApps().get(appAttemptId.getApplicationId())).getQueue());
    }

    @Test
    public void testNotUserAsDefaultQueue() throws Exception {
        this.resourceManager.stop();
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "false");
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(appAttemptId, "default", "user2", null);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("default", true).getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("user2", true).getNumRunnableApps());
    }

    @Test
    public void testAppAdditionAndRemoval() throws Exception {
        ApplicationAttemptId attemptId = this.createAppAttemptId(1, 1);
        AppAddedSchedulerEvent appAddedEvent = new AppAddedSchedulerEvent(attemptId.getApplicationId(), "default", "user1");
        this.scheduler.handle((SchedulerEvent)appAddedEvent);
        AppAttemptAddedSchedulerEvent attemptAddedEvent = new AppAttemptAddedSchedulerEvent(this.createAppAttemptId(1, 1), false);
        this.scheduler.handle((SchedulerEvent)attemptAddedEvent);
        Assert.assertEquals((long)2L, (long)this.scheduler.getQueueManager().getLeafQueues().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getNumRunnableApps());
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(this.createAppAttemptId(1, 1), RMAppAttemptState.FINISHED, false);
        this.scheduler.handle((SchedulerEvent)appRemovedEvent1);
        Assert.assertEquals((long)0L, (long)this.scheduler.getQueueManager().getLeafQueue("user1", true).getNumRunnableApps());
    }

    @Test
    public void testPreemptionVariablesForQueueCreatedRuntime() throws Exception {
        FSParentQueue root = this.scheduler.getQueueManager().getRootQueue();
        root.setMinSharePreemptionTimeout(10000L);
        root.setFairSharePreemptionTimeout(15000L);
        root.setFairSharePreemptionThreshold(0.6f);
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(1, 1);
        this.createApplicationWithAMResource(appAttemptId, "default", "user1", null);
        FSLeafQueue userQueue = this.scheduler.getQueueManager().getLeafQueue("user1", true);
        Assert.assertEquals((long)1L, (long)userQueue.getNumRunnableApps());
        Assert.assertEquals((long)10000L, (long)userQueue.getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)userQueue.getFairSharePreemptionTimeout());
        Assert.assertEquals((double)0.6f, (double)userQueue.getFairSharePreemptionThreshold(), (double)0.001);
    }

    @Test
    public void testDontAllowUndeclaredPools() throws Exception {
        this.conf.setBoolean("yarn.scheduler.fair.allow-undeclared-pools", false);
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"jerry\">");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.resourceManager.stop();
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        QueueManager queueManager = this.scheduler.getQueueManager();
        FSLeafQueue jerryQueue = queueManager.getLeafQueue("jerry", false);
        FSLeafQueue defaultQueue = queueManager.getLeafQueue("default", false);
        this.createSchedulingRequest(1024, "jerry", "someuser");
        Assert.assertEquals((long)1L, (long)jerryQueue.getNumRunnableApps());
        this.createSchedulingRequest(1024, "newqueue", "someuser");
        Assert.assertEquals((long)1L, (long)jerryQueue.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)defaultQueue.getNumRunnableApps());
        this.createSchedulingRequest(1024, "default", "someuser");
        Assert.assertEquals((long)1L, (long)jerryQueue.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)defaultQueue.getNumRunnableApps());
        this.createSchedulingRequest(1024, "default", "jerry");
        Assert.assertEquals((long)2L, (long)jerryQueue.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)defaultQueue.getNumRunnableApps());
    }

    @Test
    public void testMoveRunnableApp() throws Exception {
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue oldQueue = queueMgr.getLeafQueue("queue1", true);
        FSLeafQueue targetQueue = queueMgr.getLeafQueue("queue2", true);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        ApplicationId appId = appAttId.getApplicationId();
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)1024));
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        this.scheduler.handle((SchedulerEvent)updateEvent);
        Assert.assertEquals((Object)Resource.newInstance((int)1024, (int)1), (Object)oldQueue.getResourceUsage());
        this.scheduler.update();
        Assert.assertEquals((Object)Resource.newInstance((int)3072, (int)3), (Object)oldQueue.getDemand());
        this.scheduler.moveApplication(appId, "queue2");
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttId);
        Assert.assertSame((Object)targetQueue, (Object)app.getQueue());
        Assert.assertFalse((boolean)oldQueue.isRunnableApp(app));
        Assert.assertTrue((boolean)targetQueue.isRunnableApp(app));
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)oldQueue.getResourceUsage());
        Assert.assertEquals((Object)Resource.newInstance((int)1024, (int)1), (Object)targetQueue.getResourceUsage());
        Assert.assertEquals((long)0L, (long)oldQueue.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)targetQueue.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)queueMgr.getRootQueue().getNumRunnableApps());
        this.scheduler.update();
        Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)oldQueue.getDemand());
        Assert.assertEquals((Object)Resource.newInstance((int)3072, (int)3), (Object)targetQueue.getDemand());
    }

    @Test
    public void testMoveNonRunnableApp() throws Exception {
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue oldQueue = queueMgr.getLeafQueue("queue1", true);
        FSLeafQueue targetQueue = queueMgr.getLeafQueue("queue2", true);
        this.scheduler.getAllocationConfiguration().queueMaxApps.put("root.queue1", 0);
        this.scheduler.getAllocationConfiguration().queueMaxApps.put("root.queue2", 0);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        Assert.assertEquals((long)0L, (long)oldQueue.getNumRunnableApps());
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
        Assert.assertEquals((long)0L, (long)oldQueue.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)targetQueue.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)queueMgr.getRootQueue().getNumRunnableApps());
    }

    @Test
    public void testMoveMakesAppRunnable() throws Exception {
        QueueManager queueMgr = this.scheduler.getQueueManager();
        FSLeafQueue oldQueue = queueMgr.getLeafQueue("queue1", true);
        FSLeafQueue targetQueue = queueMgr.getLeafQueue("queue2", true);
        this.scheduler.getAllocationConfiguration().queueMaxApps.put("root.queue1", 0);
        ApplicationAttemptId appAttId = this.createSchedulingRequest(1024, 1, "queue1", "user1", 3);
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttId);
        Assert.assertTrue((boolean)oldQueue.isNonRunnableApp(app));
        this.scheduler.moveApplication(appAttId.getApplicationId(), "queue2");
        Assert.assertFalse((boolean)oldQueue.isNonRunnableApp(app));
        Assert.assertFalse((boolean)targetQueue.isNonRunnableApp(app));
        Assert.assertTrue((boolean)targetQueue.isRunnableApp(app));
        Assert.assertEquals((long)1L, (long)targetQueue.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)queueMgr.getRootQueue().getNumRunnableApps());
    }
}

