/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestContinuousScheduling
extends FairSchedulerTestBase {
    private ControlledClock mockClock;

    @Override
    public Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.setBoolean("yarn.scheduler.fair.continuous-scheduling-enabled", true);
        conf.setInt("yarn.scheduler.fair.locality-delay-node-ms", 100);
        conf.setInt("yarn.scheduler.fair.locality-delay-rack-ms", 100);
        return conf;
    }

    @Before
    public void setup() {
        this.mockClock = new ControlledClock();
        this.conf = this.createConfiguration();
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        this.scheduler.setClock((Clock)this.mockClock);
        Assert.assertTrue((boolean)this.scheduler.isContinuousSchedulingEnabled());
        Assert.assertEquals((long)5L, (long)this.scheduler.getContinuousSchedulingSleepMs());
        Assert.assertEquals((Object)this.mockClock, (Object)this.scheduler.getClock());
    }

    @After
    public void teardown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
    }

    @Test(timeout=60000L)
    public void testBasic() throws InterruptedException {
        String host = "127.0.0.1";
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 1, host);
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        NodeUpdateSchedulerEvent nodeUpdateEvent = new NodeUpdateSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeUpdateEvent);
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.createMockRMApp(appAttemptId);
        this.scheduler.addApplication(appAttemptId.getApplicationId(), "queue11", "user11", false);
        this.scheduler.addApplicationAttempt(appAttemptId, false, false);
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ask.add(this.createResourceRequest(1024, 1, "*", 1, 1, true));
        this.scheduler.allocate(appAttemptId, ask, new ArrayList(), null, null, null, null);
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttemptId);
        this.triggerSchedulingAttempt();
        this.checkAppConsumption(app, Resources.createResource((int)1024, (int)1));
    }

    @Test(timeout=10000L)
    public void testSortedNodes() throws Exception {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        Assert.assertEquals((long)this.scheduler.getClusterResource().getMemory(), (long)16384L);
        Assert.assertEquals((long)this.scheduler.getClusterResource().getVirtualCores(), (long)16L);
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(this.APP_ID++, this.ATTEMPT_ID++);
        this.createMockRMApp(appAttemptId);
        this.scheduler.addApplication(appAttemptId.getApplicationId(), "queue11", "user11", false);
        this.scheduler.addApplicationAttempt(appAttemptId, false, false);
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest request = this.createResourceRequest(1024, 1, "*", 1, 1, true);
        ask.add(request);
        this.scheduler.allocate(appAttemptId, ask, new ArrayList(), null, null, null, null);
        this.triggerSchedulingAttempt();
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttemptId);
        this.checkAppConsumption(app, Resources.createResource((int)1024, (int)1));
        request = this.createResourceRequest(1024, 1, "*", 2, 1, true);
        ask.clear();
        ask.add(request);
        this.scheduler.allocate(appAttemptId, ask, new ArrayList(), null, null, null, null);
        this.triggerSchedulingAttempt();
        this.checkAppConsumption(app, Resources.createResource((int)2048, (int)2));
        HashSet<NodeId> nodes = new HashSet<NodeId>();
        Iterator it = app.getLiveContainers().iterator();
        while (it.hasNext()) {
            nodes.add(((RMContainer)it.next()).getContainer().getNodeId());
        }
        Assert.assertEquals((long)2L, (long)nodes.size());
    }

    private void triggerSchedulingAttempt() {
        this.mockClock.tickMsec((long)(2 * this.scheduler.getConf().getContinuousSchedulingSleepMs()));
    }
}

