/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFairSchedulerPreemption
extends FairSchedulerTestBase {
    private static final String ALLOC_FILE = new File(TEST_DIR, TestFairSchedulerPreemption.class.getName() + ".xml").getAbsolutePath();
    private ControlledClock clock;

    @Override
    public Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", StubbedFairScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.scheduler.fair.preemption", true);
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        return conf;
    }

    @Before
    public void setup() throws IOException {
        this.conf = this.createConfiguration();
        this.clock = new ControlledClock();
    }

    @After
    public void teardown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
        this.conf = null;
    }

    private void startResourceManagerWithStubbedFairScheduler(float utilizationThreshold) {
        this.conf.setFloat("yarn.scheduler.fair.preemption.cluster-utilization-threshold", utilizationThreshold);
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        Assert.assertTrue((boolean)(this.resourceManager.getResourceScheduler() instanceof StubbedFairScheduler));
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        this.scheduler.setClock((Clock)this.clock);
        this.scheduler.updateInterval = 60000L;
    }

    private void startResourceManagerWithRealFairScheduler() {
        this.scheduler = new FairScheduler();
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        this.conf.setInt("yarn.scheduler.minimum-allocation-mb", 0);
        this.conf.setInt("yarn.scheduler.increment-allocation-mb", 1024);
        this.conf.setInt("yarn.scheduler.maximum-allocation-mb", 10240);
        this.conf.setBoolean("yarn.scheduler.fair.assignmultiple", false);
        this.conf.setFloat("yarn.scheduler.fair.preemption.cluster-utilization-threshold", 0.0f);
        this.conf.setFloat("yarn.scheduler.reservation-threshold.increment-multiple", 0.09f);
        this.resourceManager = new MockRM(this.conf);
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.resourceManager.getRMContext().getStateStore().start();
        this.resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        this.scheduler.setRMContext(this.resourceManager.getRMContext());
    }

    private void stopResourceManager() {
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
        QueueMetrics.clearQueueMetrics();
        DefaultMetricsSystem.shutdown();
    }

    private void registerNodeAndSubmitApp(int memory, int vcores, int appContainers, int appMemory) {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)memory, (int)vcores), 1, "node1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((String)"Incorrect amount of resources in the cluster", (long)memory, (long)this.scheduler.rootMetrics.getAvailableMB());
        Assert.assertEquals((String)"Incorrect amount of resources in the cluster", (long)vcores, (long)this.scheduler.rootMetrics.getAvailableVirtualCores());
        this.createSchedulingRequest(appMemory, "queueA", "user1", appContainers);
        this.scheduler.update();
        for (int i = 0; i < 3; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
        }
        Assert.assertEquals((String)"app1's request is not met", (long)(memory - appContainers * appMemory), (long)this.scheduler.rootMetrics.getAvailableMB());
    }

    @Test
    public void testPreemptionWithFreeResources() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<maxResources>0mb,0vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>1</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>1</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.print("<defaultMinSharePreemptionTimeout>5</defaultMinSharePreemptionTimeout>");
        out.print("<fairSharePreemptionTimeout>10</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        this.startResourceManagerWithStubbedFairScheduler(0.0f);
        this.registerNodeAndSubmitApp(4096, 4, 2, 1024);
        this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        this.scheduler.update();
        this.clock.tickSec(6);
        ((StubbedFairScheduler)this.scheduler).resetLastPreemptResources();
        this.scheduler.preemptTasksIfNecessary();
        Assert.assertEquals((String)"preemptResources() should have been called", (long)1024L, (long)((StubbedFairScheduler)this.scheduler).lastPreemptMemory);
        this.resourceManager.stop();
        this.startResourceManagerWithStubbedFairScheduler(0.8f);
        this.registerNodeAndSubmitApp(4096, 4, 3, 1024);
        this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        this.scheduler.update();
        this.clock.tickSec(6);
        ((StubbedFairScheduler)this.scheduler).resetLastPreemptResources();
        this.scheduler.preemptTasksIfNecessary();
        Assert.assertEquals((String)"preemptResources() should not have been called", (long)-1L, (long)((StubbedFairScheduler)this.scheduler).lastPreemptMemory);
        this.resourceManager.stop();
        this.startResourceManagerWithStubbedFairScheduler(0.7f);
        this.registerNodeAndSubmitApp(4096, 4, 3, 1024);
        this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        this.scheduler.update();
        this.clock.tickSec(6);
        ((StubbedFairScheduler)this.scheduler).resetLastPreemptResources();
        this.scheduler.preemptTasksIfNecessary();
        Assert.assertEquals((String)"preemptResources() should have been called", (long)1024L, (long)((StubbedFairScheduler)this.scheduler).lastPreemptMemory);
    }

    @Test(timeout=5000L)
    public void testChoiceOfPreemptedContainers() throws Exception {
        this.startResourceManagerWithRealFairScheduler();
        this.conf.setLong("yarn.scheduler.fair.preemptionInterval", 5000L);
        this.conf.setLong("yarn.scheduler.fair.waitTimeBeforeKill", 10000L);
        this.conf.set("yarn.scheduler.fair.allocation.file.allocation.file", ALLOC_FILE);
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "false");
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("<queue name=\"default\">");
        out.println("<weight>.25</weight>");
        out.println("</queue>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)4096, (int)4), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, 1, "queueA", "user1", 1, 1);
        this.createSchedulingRequestExistingApplication(1024, 1, 2, app1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, 1, "queueA", "user1", 1, 3);
        this.createSchedulingRequestExistingApplication(1024, 1, 4, app2);
        ApplicationAttemptId app3 = this.createSchedulingRequest(1024, 1, "queueB", "user1", 1, 1);
        this.createSchedulingRequestExistingApplication(1024, 1, 2, app3);
        ApplicationAttemptId app4 = this.createSchedulingRequest(1024, 1, "queueB", "user1", 1, 3);
        this.createSchedulingRequestExistingApplication(1024, 1, 4, app4);
        this.scheduler.update();
        this.scheduler.getQueueManager().getLeafQueue("queueA", true).setPolicy(SchedulingPolicy.parse((String)"fifo"));
        this.scheduler.getQueueManager().getLeafQueue("queueB", true).setPolicy(SchedulingPolicy.parse((String)"fair"));
        NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
        NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
        for (int i = 0; i < 4; ++i) {
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate2);
        }
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(app3).getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(app4).getLiveContainers().size());
        this.createSchedulingRequest(1024, 1, "queueC", "user1", 1, 1);
        this.createSchedulingRequest(1024, 1, "queueC", "user1", 1, 1);
        this.createSchedulingRequest(1024, 1, "default", "user1", 1, 1);
        this.createSchedulingRequest(1024, 1, "default", "user1", 1, 1);
        this.scheduler.update();
        this.scheduler.preemptResources(Resources.createResource((int)2048));
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(app3).getLiveContainers().size());
        Assert.assertTrue((String)"App2 should have container to be preempted", (!Collections.disjoint(this.scheduler.getSchedulerApp(app2).getLiveContainers(), this.scheduler.getSchedulerApp(app2).getPreemptionContainers()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"App4 should have container to be preempted", (!Collections.disjoint(this.scheduler.getSchedulerApp(app2).getLiveContainers(), this.scheduler.getSchedulerApp(app2).getPreemptionContainers()) ? 1 : 0) != 0);
        clock.tickSec(15);
        this.scheduler.preemptResources(Resources.createResource((int)2048));
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app4).getLiveContainers().size());
        HashSet<RMContainer> set = new HashSet<RMContainer>();
        for (RMContainer container : this.scheduler.getSchedulerApp(app2).getLiveContainers()) {
            if (container.getAllocatedPriority().getPriority() != 4) continue;
            set.add(container);
        }
        for (RMContainer container : this.scheduler.getSchedulerApp(app4).getLiveContainers()) {
            if (container.getAllocatedPriority().getPriority() != 4) continue;
            set.add(container);
        }
        Assert.assertTrue((String)"Containers with priority=4 in app2 and app4 should be preempted.", (boolean)set.isEmpty());
        this.scheduler.preemptResources(Resources.createResource((int)2048));
        clock.tickSec(15);
        this.scheduler.preemptResources(Resources.createResource((int)2048));
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app3).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app4).getLiveContainers().size());
        this.scheduler.preemptResources(Resources.createResource((int)2048));
        Assert.assertTrue((String)"App1 should have no container to be preempted", (boolean)this.scheduler.getSchedulerApp(app1).getPreemptionContainers().isEmpty());
        Assert.assertTrue((String)"App2 should have no container to be preempted", (boolean)this.scheduler.getSchedulerApp(app2).getPreemptionContainers().isEmpty());
        Assert.assertTrue((String)"App3 should have no container to be preempted", (boolean)this.scheduler.getSchedulerApp(app3).getPreemptionContainers().isEmpty());
        Assert.assertTrue((String)"App4 should have no container to be preempted", (boolean)this.scheduler.getSchedulerApp(app4).getPreemptionContainers().isEmpty());
        this.stopResourceManager();
    }

    @Test
    public void testPreemptionIsNotDelayedToNextRound() throws Exception {
        this.startResourceManagerWithRealFairScheduler();
        this.conf.setLong("yarn.scheduler.fair.preemptionInterval", 5000L);
        this.conf.setLong("yarn.scheduler.fair.waitTimeBeforeKill", 10000L);
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        this.conf.set("yarn.scheduler.fair.user-as-default-queue", "false");
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>8</weight>");
        out.println("<queue name=\"queueA1\" />");
        out.println("<queue name=\"queueA2\" />");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>2</weight>");
        out.println("</queue>");
        out.println("<defaultFairSharePreemptionTimeout>10</defaultFairSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>.5</defaultFairSharePreemptionThreshold>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, 1, "queueA.queueA1", "user1", 7, 1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, 1, "queueB", "user2", 1, 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
        for (int i = 0; i < 8; ++i) {
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
        }
        Assert.assertEquals((long)7L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        ApplicationAttemptId app3 = this.createSchedulingRequest(1024, 1, "queueA.queueA2", "user3", 7, 1);
        this.scheduler.update();
        clock.tickSec(11);
        this.scheduler.update();
        Resource toPreempt = this.scheduler.resourceDeficit(this.scheduler.getQueueManager().getLeafQueue("queueA.queueA2", false), clock.getTime());
        Assert.assertEquals((long)3277L, (long)toPreempt.getMemory());
        this.scheduler.preemptResources(toPreempt);
        Assert.assertEquals((long)3L, (long)this.scheduler.getSchedulerApp(app1).getPreemptionContainers().size());
        this.stopResourceManager();
    }

    @Test(timeout=5000L)
    public void testPreemptionDecision() throws Exception {
        this.startResourceManagerWithRealFairScheduler();
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<maxResources>0mb,0vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<defaultMinSharePreemptionTimeout>5</defaultMinSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionTimeout>10</defaultFairSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>.5</defaultFairSharePreemptionThreshold>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        RMNode node3 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)2), 3, "127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent3 = new NodeAddedSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 2);
        ApplicationAttemptId app3 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 3);
        ApplicationAttemptId app4 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        ApplicationAttemptId app5 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 2);
        ApplicationAttemptId app6 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 3);
        this.scheduler.update();
        for (int i = 0; i < 2; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
            NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
            this.scheduler.handle((SchedulerEvent)nodeUpdate2);
            NodeUpdateSchedulerEvent nodeUpdate3 = new NodeUpdateSchedulerEvent(node3);
            this.scheduler.handle((SchedulerEvent)nodeUpdate3);
        }
        ApplicationAttemptId app7 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 1);
        ApplicationAttemptId app8 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 2);
        ApplicationAttemptId app9 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 3);
        ApplicationAttemptId app10 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 1);
        ApplicationAttemptId app11 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 2);
        ApplicationAttemptId app12 = this.createSchedulingRequest(1024, "queueD", "user1", 1, 3);
        this.scheduler.update();
        FSLeafQueue schedC = this.scheduler.getQueueManager().getLeafQueue("queueC", true);
        FSLeafQueue schedD = this.scheduler.getQueueManager().getLeafQueue("queueD", true);
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.scheduler.resourceDeficit(schedC, clock.getTime())));
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.scheduler.resourceDeficit(schedD, clock.getTime())));
        clock.tickSec(6);
        Assert.assertEquals((long)1024L, (long)this.scheduler.resourceDeficit(schedC, clock.getTime()).getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.resourceDeficit(schedD, clock.getTime()).getMemory());
        this.scheduler.update();
        clock.tickSec(6);
        Assert.assertEquals((long)1536L, (long)this.scheduler.resourceDeficit(schedC, clock.getTime()).getMemory());
        Assert.assertEquals((long)1536L, (long)this.scheduler.resourceDeficit(schedD, clock.getTime()).getMemory());
        this.stopResourceManager();
    }

    @Test
    public void testPreemptionDecisionWithDRF() throws Exception {
        this.startResourceManagerWithRealFairScheduler();
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<maxResources>0mb,0vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,1vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,2vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,3vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,2vcores</minResources>");
        out.println("</queue>");
        out.println("<defaultMinSharePreemptionTimeout>5</defaultMinSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionTimeout>10</defaultFairSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>.5</defaultFairSharePreemptionThreshold>");
        out.println("<defaultQueueSchedulingPolicy>drf</defaultQueueSchedulingPolicy>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)4), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        RMNode node3 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)4), 3, "127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent3 = new NodeAddedSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 2);
        ApplicationAttemptId app3 = this.createSchedulingRequest(1024, "queueA", "user1", 1, 3);
        ApplicationAttemptId app4 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        ApplicationAttemptId app5 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 2);
        ApplicationAttemptId app6 = this.createSchedulingRequest(1024, "queueB", "user1", 1, 3);
        this.scheduler.update();
        for (int i = 0; i < 2; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
            NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
            this.scheduler.handle((SchedulerEvent)nodeUpdate2);
            NodeUpdateSchedulerEvent nodeUpdate3 = new NodeUpdateSchedulerEvent(node3);
            this.scheduler.handle((SchedulerEvent)nodeUpdate3);
        }
        ApplicationAttemptId app7 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 1);
        ApplicationAttemptId app8 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 2);
        ApplicationAttemptId app9 = this.createSchedulingRequest(1024, "queueC", "user1", 1, 3);
        ApplicationAttemptId app10 = this.createSchedulingRequest(1024, "queueD", "user1", 2, 1);
        ApplicationAttemptId app11 = this.createSchedulingRequest(1024, "queueD", "user1", 2, 2);
        ApplicationAttemptId app12 = this.createSchedulingRequest(1024, "queueD", "user1", 2, 3);
        this.scheduler.update();
        FSLeafQueue schedC = this.scheduler.getQueueManager().getLeafQueue("queueC", true);
        FSLeafQueue schedD = this.scheduler.getQueueManager().getLeafQueue("queueD", true);
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.scheduler.resourceDeficit(schedC, clock.getTime())));
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.scheduler.resourceDeficit(schedD, clock.getTime())));
        clock.tickSec(6);
        Resource res = this.scheduler.resourceDeficit(schedC, clock.getTime());
        Assert.assertEquals((long)1024L, (long)res.getMemory());
        Assert.assertEquals((long)3L, (long)res.getVirtualCores());
        res = this.scheduler.resourceDeficit(schedD, clock.getTime());
        Assert.assertEquals((long)1024L, (long)res.getMemory());
        Assert.assertEquals((long)2L, (long)res.getVirtualCores());
        this.scheduler.update();
        clock.tickSec(6);
        res = this.scheduler.resourceDeficit(schedC, clock.getTime());
        Assert.assertEquals((long)1536L, (long)res.getMemory());
        Assert.assertEquals((long)3L, (long)res.getVirtualCores());
        res = this.scheduler.resourceDeficit(schedD, clock.getTime());
        Assert.assertEquals((long)1536L, (long)res.getMemory());
        Assert.assertEquals((long)3L, (long)res.getVirtualCores());
        this.stopResourceManager();
    }

    @Test
    public void testPreemptionDecisionWithVariousTimeout() throws Exception {
        this.startResourceManagerWithRealFairScheduler();
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<maxResources>0mb,0vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>1</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>2</weight>");
        out.println("<minSharePreemptionTimeout>10</minSharePreemptionTimeout>");
        out.println("<fairSharePreemptionTimeout>25</fairSharePreemptionTimeout>");
        out.println("<queue name=\"queueB1\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("<minSharePreemptionTimeout>5</minSharePreemptionTimeout>");
        out.println("</queue>");
        out.println("<queue name=\"queueB2\">");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("<fairSharePreemptionTimeout>20</fairSharePreemptionTimeout>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("<weight>1</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.print("<defaultMinSharePreemptionTimeout>15</defaultMinSharePreemptionTimeout>");
        out.print("<defaultFairSharePreemptionTimeout>30</defaultFairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("root").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("default").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueA").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)25000L, (long)queueMgr.getQueue("queueB").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)25000L, (long)queueMgr.getQueue("queueB.queueB1").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)20000L, (long)queueMgr.getQueue("queueB.queueB2").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueC").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("root").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("default").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueA").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)10000L, (long)queueMgr.getQueue("queueB").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)5000L, (long)queueMgr.getQueue("queueB.queueB1").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)10000L, (long)queueMgr.getQueue("queueB.queueB2").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueC").getMinSharePreemptionTimeout());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)6144, (int)6), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        for (int i = 0; i < 6; ++i) {
            this.createSchedulingRequest(1024, "queueA", "user1", 1, 1);
        }
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
        for (int i = 0; i < 6; ++i) {
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
        }
        this.createSchedulingRequest(1024, "queueB.queueB1", "user1", 1, 1);
        this.createSchedulingRequest(1024, "queueB.queueB1", "user1", 1, 2);
        this.createSchedulingRequest(1024, "queueB.queueB1", "user1", 1, 3);
        this.createSchedulingRequest(1024, "queueB.queueB2", "user1", 1, 1);
        this.createSchedulingRequest(1024, "queueB.queueB2", "user1", 1, 2);
        this.createSchedulingRequest(1024, "queueB.queueB2", "user1", 1, 3);
        this.createSchedulingRequest(1024, "queueC", "user1", 1, 1);
        this.createSchedulingRequest(1024, "queueC", "user1", 1, 2);
        this.createSchedulingRequest(1024, "queueC", "user1", 1, 3);
        this.scheduler.update();
        FSLeafQueue queueB1 = queueMgr.getLeafQueue("queueB.queueB1", true);
        FSLeafQueue queueB2 = queueMgr.getLeafQueue("queueB.queueB2", true);
        FSLeafQueue queueC = queueMgr.getLeafQueue("queueC", true);
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.scheduler.resourceDeficit(queueB1, clock.getTime())));
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.scheduler.resourceDeficit(queueB2, clock.getTime())));
        Assert.assertTrue((boolean)Resources.equals((Resource)Resources.none(), (Resource)this.scheduler.resourceDeficit(queueC, clock.getTime())));
        this.scheduler.update();
        clock.tickSec(6);
        Assert.assertEquals((long)1024L, (long)this.scheduler.resourceDeficit(queueB1, clock.getTime()).getMemory());
        Assert.assertEquals((long)0L, (long)this.scheduler.resourceDeficit(queueB2, clock.getTime()).getMemory());
        Assert.assertEquals((long)0L, (long)this.scheduler.resourceDeficit(queueC, clock.getTime()).getMemory());
        this.scheduler.update();
        clock.tickSec(5);
        Assert.assertEquals((long)1024L, (long)this.scheduler.resourceDeficit(queueB1, clock.getTime()).getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.resourceDeficit(queueB2, clock.getTime()).getMemory());
        Assert.assertEquals((long)0L, (long)this.scheduler.resourceDeficit(queueC, clock.getTime()).getMemory());
        this.scheduler.update();
        clock.tickSec(5);
        Assert.assertEquals((long)1024L, (long)this.scheduler.resourceDeficit(queueB1, clock.getTime()).getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.resourceDeficit(queueB2, clock.getTime()).getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.resourceDeficit(queueC, clock.getTime()).getMemory());
        this.scheduler.update();
        clock.tickSec(5);
        Assert.assertEquals((long)1024L, (long)this.scheduler.resourceDeficit(queueB1, clock.getTime()).getMemory());
        Assert.assertEquals((long)1536L, (long)this.scheduler.resourceDeficit(queueB2, clock.getTime()).getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.resourceDeficit(queueC, clock.getTime()).getMemory());
        this.scheduler.update();
        clock.tickSec(5);
        Assert.assertEquals((long)1536L, (long)this.scheduler.resourceDeficit(queueB1, clock.getTime()).getMemory());
        Assert.assertEquals((long)1536L, (long)this.scheduler.resourceDeficit(queueB2, clock.getTime()).getMemory());
        Assert.assertEquals((long)1024L, (long)this.scheduler.resourceDeficit(queueC, clock.getTime()).getMemory());
        this.scheduler.update();
        clock.tickSec(5);
        Assert.assertEquals((long)1536L, (long)this.scheduler.resourceDeficit(queueB1, clock.getTime()).getMemory());
        Assert.assertEquals((long)1536L, (long)this.scheduler.resourceDeficit(queueB2, clock.getTime()).getMemory());
        Assert.assertEquals((long)1536L, (long)this.scheduler.resourceDeficit(queueC, clock.getTime()).getMemory());
        this.stopResourceManager();
    }

    @Test
    public void testPreemptionDecisionWithNonPreemptableQueue() throws Exception {
        this.startResourceManagerWithRealFairScheduler();
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<maxResources>0mb,0vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("<allowPreemptionFrom>false</allowPreemptionFrom>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"parentQueue\">");
        out.println("<allowPreemptionFrom>false</allowPreemptionFrom>");
        out.println("<queue name=\"queueC\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("<queue name=\"queueD\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<defaultMinSharePreemptionTimeout>5</defaultMinSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionTimeout>10</defaultFairSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>.5</defaultFairSharePreemptionThreshold>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)3), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)3), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        RMNode node3 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)3), 3, "127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent3 = new NodeAddedSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        RMNode node4 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)3), 4, "127.0.0.4");
        NodeAddedSchedulerEvent nodeEvent4 = new NodeAddedSchedulerEvent(node4);
        this.scheduler.handle((SchedulerEvent)nodeEvent4);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, "queueA", "user1", 4, 1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, "queueB", "user1", 4, 2);
        ApplicationAttemptId app3 = this.createSchedulingRequest(1024, "parentQueue.queueC", "user1", 4, 3);
        this.scheduler.update();
        for (int i = 0; i < 3; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
            NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
            this.scheduler.handle((SchedulerEvent)nodeUpdate2);
            NodeUpdateSchedulerEvent nodeUpdate3 = new NodeUpdateSchedulerEvent(node3);
            this.scheduler.handle((SchedulerEvent)nodeUpdate3);
            NodeUpdateSchedulerEvent nodeUpdate4 = new NodeUpdateSchedulerEvent(node4);
            this.scheduler.handle((SchedulerEvent)nodeUpdate4);
        }
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app3).getLiveContainers().size());
        ApplicationAttemptId app4 = this.createSchedulingRequest(1024, "queueD", "user1", 4, 1);
        this.scheduler.update();
        FSLeafQueue schedD = this.scheduler.getQueueManager().getLeafQueue("queueD", true);
        clock.tickSec(6);
        Assert.assertEquals((long)2048L, (long)this.scheduler.resourceDeficit(schedD, clock.getTime()).getMemory());
        this.scheduler.preemptResources(Resources.createResource((int)2048));
        Assert.assertTrue((String)"App2 should have container to be preempted", (!Collections.disjoint(this.scheduler.getSchedulerApp(app2).getLiveContainers(), this.scheduler.getSchedulerApp(app2).getPreemptionContainers()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"App1 should not have container to be preempted", (boolean)Collections.disjoint(this.scheduler.getSchedulerApp(app1).getLiveContainers(), this.scheduler.getSchedulerApp(app1).getPreemptionContainers()));
        Assert.assertTrue((String)"App3 should not have container to be preempted", (boolean)Collections.disjoint(this.scheduler.getSchedulerApp(app3).getLiveContainers(), this.scheduler.getSchedulerApp(app3).getPreemptionContainers()));
        clock.tickSec(20);
        this.scheduler.preemptResources(Resources.createResource((int)2048));
        for (int i = 0; i < 3; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
            NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
            this.scheduler.handle((SchedulerEvent)nodeUpdate2);
            NodeUpdateSchedulerEvent nodeUpdate3 = new NodeUpdateSchedulerEvent(node3);
            this.scheduler.handle((SchedulerEvent)nodeUpdate3);
            NodeUpdateSchedulerEvent nodeUpdate4 = new NodeUpdateSchedulerEvent(node4);
            this.scheduler.handle((SchedulerEvent)nodeUpdate4);
        }
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app3).getLiveContainers().size());
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(app4).getLiveContainers().size());
        this.stopResourceManager();
    }

    @Test
    public void testPreemptionDecisionWhenPreemptionDisabledOnAllQueues() throws Exception {
        this.startResourceManagerWithRealFairScheduler();
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<maxResources>0mb,0vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>2048mb,0vcores</minResources>");
        out.println("<allowPreemptionFrom>false</allowPreemptionFrom>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("<allowPreemptionFrom>false</allowPreemptionFrom>");
        out.println("</queue>");
        out.println("<queue name=\"parentQueue1\">");
        out.println("<allowPreemptionFrom>false</allowPreemptionFrom>");
        out.println("<queue name=\"queueC\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("<queue name=\"parentQueue2\">");
        out.println("<queue name=\"queueD\">");
        out.println("<weight>.25</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("<allowPreemptionFrom>false</allowPreemptionFrom>");
        out.println("</queue>");
        out.println("</queue>");
        out.println("<defaultMinSharePreemptionTimeout>5</defaultMinSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionTimeout>10</defaultFairSharePreemptionTimeout>");
        out.println("<defaultFairSharePreemptionThreshold>.5</defaultFairSharePreemptionThreshold>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)3), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        RMNode node2 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)3), 2, "127.0.0.2");
        NodeAddedSchedulerEvent nodeEvent2 = new NodeAddedSchedulerEvent(node2);
        this.scheduler.handle((SchedulerEvent)nodeEvent2);
        RMNode node3 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)3), 3, "127.0.0.3");
        NodeAddedSchedulerEvent nodeEvent3 = new NodeAddedSchedulerEvent(node3);
        this.scheduler.handle((SchedulerEvent)nodeEvent3);
        RMNode node4 = MockNodes.newNodeInfo(1, Resources.createResource((int)3072, (int)3), 4, "127.0.0.4");
        NodeAddedSchedulerEvent nodeEvent4 = new NodeAddedSchedulerEvent(node4);
        this.scheduler.handle((SchedulerEvent)nodeEvent4);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, "queueB", "user1", 4, 1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, "parentQueue1.queueC", "user1", 4, 2);
        ApplicationAttemptId app3 = this.createSchedulingRequest(1024, "parentQueue2.queueD", "user1", 4, 3);
        this.scheduler.update();
        for (int i = 0; i < 3; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
            NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
            this.scheduler.handle((SchedulerEvent)nodeUpdate2);
            NodeUpdateSchedulerEvent nodeUpdate3 = new NodeUpdateSchedulerEvent(node3);
            this.scheduler.handle((SchedulerEvent)nodeUpdate3);
            NodeUpdateSchedulerEvent nodeUpdate4 = new NodeUpdateSchedulerEvent(node4);
            this.scheduler.handle((SchedulerEvent)nodeUpdate4);
        }
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app3).getLiveContainers().size());
        ApplicationAttemptId app4 = this.createSchedulingRequest(1024, "queueA", "user1", 4, 1);
        this.scheduler.update();
        FSLeafQueue schedA = this.scheduler.getQueueManager().getLeafQueue("queueA", true);
        clock.tickSec(6);
        Assert.assertEquals((long)2048L, (long)this.scheduler.resourceDeficit(schedA, clock.getTime()).getMemory());
        this.scheduler.preemptResources(Resources.createResource((int)2048));
        Assert.assertTrue((String)"App1 should have container to be preempted", (boolean)Collections.disjoint(this.scheduler.getSchedulerApp(app1).getLiveContainers(), this.scheduler.getSchedulerApp(app1).getPreemptionContainers()));
        Assert.assertTrue((String)"App2 should not have container to be preempted", (boolean)Collections.disjoint(this.scheduler.getSchedulerApp(app2).getLiveContainers(), this.scheduler.getSchedulerApp(app2).getPreemptionContainers()));
        Assert.assertTrue((String)"App3 should not have container to be preempted", (boolean)Collections.disjoint(this.scheduler.getSchedulerApp(app3).getLiveContainers(), this.scheduler.getSchedulerApp(app3).getPreemptionContainers()));
        clock.tickSec(20);
        this.scheduler.preemptResources(Resources.createResource((int)2048));
        for (int i = 0; i < 3; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
            NodeUpdateSchedulerEvent nodeUpdate2 = new NodeUpdateSchedulerEvent(node2);
            this.scheduler.handle((SchedulerEvent)nodeUpdate2);
            NodeUpdateSchedulerEvent nodeUpdate3 = new NodeUpdateSchedulerEvent(node3);
            this.scheduler.handle((SchedulerEvent)nodeUpdate3);
            NodeUpdateSchedulerEvent nodeUpdate4 = new NodeUpdateSchedulerEvent(node4);
            this.scheduler.handle((SchedulerEvent)nodeUpdate4);
        }
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app3).getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app4).getLiveContainers().size());
        this.stopResourceManager();
    }

    @Test
    public void testBackwardsCompatiblePreemptionConfiguration() throws Exception {
        this.startResourceManagerWithRealFairScheduler();
        this.conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<queue name=\"queueB1\">");
        out.println("<minSharePreemptionTimeout>5</minSharePreemptionTimeout>");
        out.println("</queue>");
        out.println("<queue name=\"queueB2\">");
        out.println("</queue>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("</queue>");
        out.print("<defaultMinSharePreemptionTimeout>15</defaultMinSharePreemptionTimeout>");
        out.print("<defaultFairSharePreemptionTimeout>30</defaultFairSharePreemptionTimeout>");
        out.print("<fairSharePreemptionTimeout>40</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        QueueManager queueMgr = this.scheduler.getQueueManager();
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("root").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("default").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueA").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueB").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueB.queueB1").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueB.queueB2").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)30000L, (long)queueMgr.getQueue("queueC").getFairSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("root").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("default").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueA").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueB").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)5000L, (long)queueMgr.getQueue("queueB.queueB1").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueB.queueB2").getMinSharePreemptionTimeout());
        Assert.assertEquals((long)15000L, (long)queueMgr.getQueue("queueC").getMinSharePreemptionTimeout());
        out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<queue name=\"queueB1\">");
        out.println("<minSharePreemptionTimeout>5</minSharePreemptionTimeout>");
        out.println("</queue>");
        out.println("<queue name=\"queueB2\">");
        out.println("</queue>");
        out.println("</queue>");
        out.println("<queue name=\"queueC\">");
        out.println("</queue>");
        out.print("<defaultMinSharePreemptionTimeout>15</defaultMinSharePreemptionTimeout>");
        out.print("<defaultFairSharePreemptionTimeout>25</defaultFairSharePreemptionTimeout>");
        out.print("<fairSharePreemptionTimeout>30</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Assert.assertEquals((long)25000L, (long)queueMgr.getQueue("root").getFairSharePreemptionTimeout());
        this.stopResourceManager();
    }

    @Test(timeout=5000L)
    public void testRecoverRequestAfterPreemption() throws Exception {
        this.startResourceManagerWithRealFairScheduler();
        this.conf.setLong("yarn.scheduler.fair.waitTimeBeforeKill", 10L);
        ControlledClock clock = new ControlledClock();
        this.scheduler.setClock((Clock)clock);
        this.scheduler.init(this.conf);
        this.scheduler.start();
        this.scheduler.reinitialize(this.conf, this.resourceManager.getRMContext());
        Priority priority2 = Priority.newInstance((int)20);
        String host = "127.0.0.1";
        int GB = 1024;
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)16384, (int)4), 0, host);
        NodeAddedSchedulerEvent nodeEvent = new NodeAddedSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeEvent);
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest nodeLocalRequest = this.createResourceRequest(GB, 1, host, priority2.getPriority(), 1, true);
        ResourceRequest rackLocalRequest = this.createResourceRequest(GB, 1, node.getRackName(), priority2.getPriority(), 1, true);
        ResourceRequest offRackRequest = this.createResourceRequest(GB, 1, "*", priority2.getPriority(), 1, true);
        ask.add(nodeLocalRequest);
        ask.add(rackLocalRequest);
        ask.add(offRackRequest);
        ApplicationAttemptId appAttemptId = this.createSchedulingRequest("queueA", "user1", ask);
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdate = new NodeUpdateSchedulerEvent(node);
        this.scheduler.handle((SchedulerEvent)nodeUpdate);
        Assert.assertEquals((long)1L, (long)this.scheduler.getSchedulerApp(appAttemptId).getLiveContainers().size());
        FSAppAttempt app = this.scheduler.getSchedulerApp(appAttemptId);
        Assert.assertNull((Object)app.getResourceRequest(priority2, host));
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        RMContainer rmContainer = app.getRMContainer(containerId1);
        this.scheduler.warnOrKillContainer(rmContainer);
        clock.tickSec(5);
        this.scheduler.warnOrKillContainer(rmContainer);
        this.scheduler.handle((SchedulerEvent)new ContainerPreemptEvent(appAttemptId, rmContainer, SchedulerEventType.MARK_CONTAINER_FOR_KILLABLE));
        List requests = rmContainer.getResourceRequests();
        Assert.assertEquals((long)3L, (long)requests.size());
        for (ResourceRequest request : requests) {
            Assert.assertEquals((long)1L, (long)app.getResourceRequest(priority2, request.getResourceName()).getNumContainers());
        }
        this.scheduler.update();
        this.scheduler.handle((SchedulerEvent)nodeUpdate);
        List containers = this.scheduler.allocate(appAttemptId, Collections.emptyList(), Collections.emptyList(), null, null, null, null).getContainers();
        Assert.assertTrue((containers.size() == 1 ? 1 : 0) != 0);
        this.stopResourceManager();
    }

    private static class StubbedFairScheduler
    extends FairScheduler {
        public int lastPreemptMemory = -1;

        private StubbedFairScheduler() {
        }

        protected void preemptResources(Resource toPreempt) {
            this.lastPreemptMemory = toPreempt.getMemory();
        }

        public void resetLastPreemptResources() {
            this.lastPreemptMemory = -1;
        }
    }
}

