/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.MaxRunningAppsEnforcer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestMaxRunningAppsEnforcer {
    private QueueManager queueManager;
    private Map<String, Integer> queueMaxApps;
    private Map<String, Integer> userMaxApps;
    private MaxRunningAppsEnforcer maxAppsEnforcer;
    private int appNum;
    private ControlledClock clock;
    private RMContext rmContext;
    private FairScheduler scheduler;

    @Before
    public void setup() throws Exception {
        Configuration conf = new Configuration();
        this.clock = new ControlledClock();
        this.scheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        Mockito.when((Object)this.scheduler.getConf()).thenReturn((Object)new FairSchedulerConfiguration(conf));
        Mockito.when((Object)this.scheduler.getClock()).thenReturn((Object)this.clock);
        AllocationConfiguration allocConf = new AllocationConfiguration(conf);
        Mockito.when((Object)this.scheduler.getAllocationConfiguration()).thenReturn((Object)allocConf);
        this.queueManager = new QueueManager(this.scheduler);
        this.queueManager.initialize(conf);
        this.queueMaxApps = allocConf.queueMaxApps;
        this.userMaxApps = allocConf.userMaxApps;
        this.maxAppsEnforcer = new MaxRunningAppsEnforcer(this.scheduler);
        this.appNum = 0;
        this.rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.rmContext.getEpoch()).thenReturn((Object)0L);
    }

    private FSAppAttempt addApp(FSLeafQueue queue, String user) {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)this.appNum++);
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        boolean runnable = this.maxAppsEnforcer.canAppBeRunnable((FSQueue)queue, user);
        FSAppAttempt app = new FSAppAttempt(this.scheduler, attId, user, queue, null, this.rmContext);
        queue.addApp(app, runnable);
        if (runnable) {
            this.maxAppsEnforcer.trackRunnableApp(app);
        } else {
            this.maxAppsEnforcer.trackNonRunnableApp(app);
        }
        return app;
    }

    private void removeApp(FSAppAttempt app) {
        app.getQueue().removeApp(app);
        this.maxAppsEnforcer.untrackRunnableApp(app);
        this.maxAppsEnforcer.updateRunnabilityOnAppRemoval(app, app.getQueue());
    }

    @Test
    public void testRemoveDoesNotEnableAnyApp() {
        FSLeafQueue leaf1 = this.queueManager.getLeafQueue("root.queue1", true);
        FSLeafQueue leaf2 = this.queueManager.getLeafQueue("root.queue2", true);
        this.queueMaxApps.put("root", 2);
        this.queueMaxApps.put("root.queue1", 1);
        this.queueMaxApps.put("root.queue2", 1);
        FSAppAttempt app1 = this.addApp(leaf1, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        Assert.assertEquals((long)1L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)0L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testRemoveEnablesAppOnCousinQueue() {
        FSLeafQueue leaf1 = this.queueManager.getLeafQueue("root.queue1.subqueue1.leaf1", true);
        FSLeafQueue leaf2 = this.queueManager.getLeafQueue("root.queue1.subqueue2.leaf2", true);
        this.queueMaxApps.put("root.queue1", 2);
        FSAppAttempt app1 = this.addApp(leaf1, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        Assert.assertEquals((long)1L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)0L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testRemoveEnablesOneByQueueOneByUser() {
        FSLeafQueue leaf1 = this.queueManager.getLeafQueue("root.queue1.leaf1", true);
        FSLeafQueue leaf2 = this.queueManager.getLeafQueue("root.queue1.leaf2", true);
        this.queueMaxApps.put("root.queue1.leaf1", 2);
        this.userMaxApps.put("user1", 1);
        FSAppAttempt app1 = this.addApp(leaf1, "user1");
        this.addApp(leaf1, "user2");
        this.addApp(leaf1, "user3");
        this.addApp(leaf2, "user1");
        Assert.assertEquals((long)2L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf1.getNumNonRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)2L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)leaf1.getNumNonRunnableApps());
        Assert.assertEquals((long)0L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testRemoveEnablingOrderedByStartTime() {
        FSLeafQueue leaf1 = this.queueManager.getLeafQueue("root.queue1.subqueue1.leaf1", true);
        FSLeafQueue leaf2 = this.queueManager.getLeafQueue("root.queue1.subqueue2.leaf2", true);
        this.queueMaxApps.put("root.queue1", 2);
        FSAppAttempt app1 = this.addApp(leaf1, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        this.clock.tickSec(20);
        this.addApp(leaf1, "user");
        Assert.assertEquals((long)1L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf1.getNumNonRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)0L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)0L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testMultipleAppsWaitingOnCousinQueue() {
        FSLeafQueue leaf1 = this.queueManager.getLeafQueue("root.queue1.subqueue1.leaf1", true);
        FSLeafQueue leaf2 = this.queueManager.getLeafQueue("root.queue1.subqueue2.leaf2", true);
        this.queueMaxApps.put("root.queue1", 2);
        FSAppAttempt app1 = this.addApp(leaf1, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        this.addApp(leaf2, "user");
        Assert.assertEquals((long)1L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)leaf2.getNumNonRunnableApps());
        this.removeApp(app1);
        Assert.assertEquals((long)0L, (long)leaf1.getNumRunnableApps());
        Assert.assertEquals((long)2L, (long)leaf2.getNumRunnableApps());
        Assert.assertEquals((long)1L, (long)leaf2.getNumNonRunnableApps());
    }

    @Test
    public void testMultiListStartTimeIteratorEmptyAppLists() {
        ArrayList<List<FSAppAttempt>> lists = new ArrayList<List<FSAppAttempt>>();
        lists.add(Arrays.asList(this.mockAppAttempt(1L)));
        lists.add(Arrays.asList(this.mockAppAttempt(2L)));
        MaxRunningAppsEnforcer.MultiListStartTimeIterator iter = new MaxRunningAppsEnforcer.MultiListStartTimeIterator(lists);
        Assert.assertEquals((long)1L, (long)((FSAppAttempt)iter.next()).getStartTime());
        Assert.assertEquals((long)2L, (long)((FSAppAttempt)iter.next()).getStartTime());
    }

    private FSAppAttempt mockAppAttempt(long startTime) {
        FSAppAttempt schedApp = (FSAppAttempt)Mockito.mock(FSAppAttempt.class);
        Mockito.when((Object)schedApp.getStartTime()).thenReturn((Object)startTime);
        return schedApp;
    }
}

