/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.PeriodGroupsMapping;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestQueuePlacementPolicy {
    private static final Configuration conf = new Configuration();
    private Map<FSQueueType, Set<String>> configuredQueues;

    @BeforeClass
    public static void setup() {
        conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
    }

    @Before
    public void initTest() {
        this.configuredQueues = new HashMap<FSQueueType, Set<String>>();
        for (FSQueueType type : FSQueueType.values()) {
            this.configuredQueues.put(type, new HashSet());
        }
    }

    @Test
    public void testSpecifiedUserPolicy() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='user' />");
        sb.append("</queuePlacementPolicy>");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.specifiedq", (Object)policy.assignAppToQueue("specifiedq", "someuser"));
        Assert.assertEquals((Object)"root.someuser", (Object)policy.assignAppToQueue("default", "someuser"));
        Assert.assertEquals((Object)"root.otheruser", (Object)policy.assignAppToQueue("default", "otheruser"));
    }

    @Test
    public void testNoCreate() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='user' create=\"false\" />");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        this.configuredQueues.get(FSQueueType.LEAF).add("root.someuser");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.specifiedq", (Object)policy.assignAppToQueue("specifiedq", "someuser"));
        Assert.assertEquals((Object)"root.someuser", (Object)policy.assignAppToQueue("default", "someuser"));
        Assert.assertEquals((Object)"root.specifiedq", (Object)policy.assignAppToQueue("specifiedq", "otheruser"));
        Assert.assertEquals((Object)"root.default", (Object)policy.assignAppToQueue("default", "otheruser"));
    }

    @Test
    public void testSpecifiedThenReject() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='reject' />");
        sb.append("</queuePlacementPolicy>");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.specifiedq", (Object)policy.assignAppToQueue("specifiedq", "someuser"));
        Assert.assertEquals(null, (Object)policy.assignAppToQueue("default", "someuser"));
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testOmittedTerminalRule() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='user' create=\"false\" />");
        sb.append("</queuePlacementPolicy>");
        this.parse(sb.toString());
    }

    @Test(expected=AllocationConfigurationException.class)
    public void testTerminalRuleInMiddle() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='default' />");
        sb.append("  <rule name='user' />");
        sb.append("</queuePlacementPolicy>");
        this.parse(sb.toString());
    }

    @Test
    public void testTerminals() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='secondaryGroupExistingQueue' create='true'/>");
        sb.append("  <rule name='default' create='false'/>");
        sb.append("</queuePlacementPolicy>");
        this.parse(sb.toString());
    }

    @Test
    public void testDefaultRuleWithQueueAttribute() throws Exception {
        this.configuredQueues.get(FSQueueType.LEAF).add("root.someDefaultQueue");
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' create='false' />");
        sb.append("  <rule name='default' queue='root.someDefaultQueue'/>");
        sb.append("</queuePlacementPolicy>");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.someDefaultQueue", (Object)policy.assignAppToQueue("root.default", "user1"));
    }

    @Test
    public void testNestedUserQueueParsingErrors() {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='nestedUserQueue'/>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        this.assertIfExceptionThrown(sb);
        sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='unknownRule'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        this.assertIfExceptionThrown(sb);
    }

    private void assertIfExceptionThrown(StringBuffer sb) {
        Exception th = null;
        try {
            this.parse(sb.toString());
        }
        catch (Exception e) {
            th = e;
        }
        Assert.assertTrue((boolean)(th instanceof AllocationConfigurationException));
    }

    @Test
    public void testNestedUserQueueParsing() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='primaryGroup'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        Exception th = null;
        try {
            this.parse(sb.toString());
        }
        catch (Exception e) {
            th = e;
        }
        Assert.assertNull((Object)th);
    }

    @Test
    public void testNestedUserQueuePrimaryGroup() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' create='false' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='primaryGroup'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.user1group.user1", (Object)policy.assignAppToQueue("root.default", "user1"));
        this.configuredQueues.get(FSQueueType.LEAF).add("root.specifiedq");
        Assert.assertEquals((Object)"root.specifiedq", (Object)policy.assignAppToQueue("root.specifiedq", "user2"));
        this.configuredQueues.get(FSQueueType.LEAF).add("root.user3group");
        Assert.assertEquals((Object)"root.default", (Object)policy.assignAppToQueue("root.default", "user3"));
    }

    @Test
    public void testNestedUserQueuePrimaryGroupNoCreate() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='primaryGroup' create='false'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.default", (Object)policy.assignAppToQueue("root.default", "user1"));
        this.configuredQueues.get(FSQueueType.PARENT).add("root.user1group");
        policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.user1group.user1", (Object)policy.assignAppToQueue("root.default", "user1"));
        sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue' create='false'>");
        sb.append("       <rule name='primaryGroup' create='false'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        Assert.assertEquals((Object)"root.default", (Object)policy.assignAppToQueue("root.default", "user2"));
        this.configuredQueues.get(FSQueueType.PARENT).add("root.user2group");
        this.configuredQueues.get(FSQueueType.LEAF).add("root.user2group.user2");
        policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.user2group.user2", (Object)policy.assignAppToQueue("root.default", "user2"));
    }

    @Test
    public void testNestedUserQueueSecondaryGroup() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='secondaryGroupExistingQueue'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.default", (Object)policy.assignAppToQueue("root.default", "user1"));
        this.configuredQueues.get(FSQueueType.PARENT).add("root.user1subgroup1");
        policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.user1subgroup1.user1", (Object)policy.assignAppToQueue("root.default", "user1"));
    }

    @Test
    public void testNestedUserQueueSpecificRule() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='specified' create='false'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        this.configuredQueues.get(FSQueueType.PARENT).add("root.parent1");
        this.configuredQueues.get(FSQueueType.PARENT).add("root.parent2");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.parent1.user1", (Object)policy.assignAppToQueue("root.parent1", "user1"));
        Assert.assertEquals((Object)"root.parent2.user2", (Object)policy.assignAppToQueue("root.parent2", "user2"));
    }

    @Test
    public void testNestedUserQueueDefaultRule() throws Exception {
        this.configuredQueues.get(FSQueueType.PARENT).add("root.parentq");
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' create='false' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='default' queue='root.parentq'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.parentq.user1", (Object)policy.assignAppToQueue("root.default", "user1"));
    }

    @Test
    public void testUserContainsPeriod() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='user' />");
        sb.append("</queuePlacementPolicy>");
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.first_dot_last", (Object)policy.assignAppToQueue("default", "first.last"));
        sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' create='false' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='default'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.default.first_dot_last", (Object)policy.assignAppToQueue("root.default", "first.last"));
    }

    @Test
    public void testGroupContainsPeriod() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='specified' create='false' />");
        sb.append("  <rule name='nestedUserQueue'>");
        sb.append("       <rule name='primaryGroup'/>");
        sb.append("  </rule>");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        conf.setClass("hadoop.security.group.mapping", PeriodGroupsMapping.class, GroupMappingServiceProvider.class);
        QueuePlacementPolicy policy = this.parse(sb.toString());
        Assert.assertEquals((Object)"root.user1_dot_group.user1", (Object)policy.assignAppToQueue("root.default", "user1"));
        conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
    }

    @Test(expected=IOException.class)
    public void testEmptyGroupsPrimaryGroupRule() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<queuePlacementPolicy>");
        sb.append("  <rule name='primaryGroup' create=\"false\" />");
        sb.append("  <rule name='default' />");
        sb.append("</queuePlacementPolicy>");
        conf.setStrings("hadoop.user.group.static.mapping.overrides", new String[]{"emptygroupuser="});
        QueuePlacementPolicy policy = this.parse(sb.toString());
        policy.assignAppToQueue(null, "emptygroupuser");
    }

    private QueuePlacementPolicy parse(String str) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        Document doc = builder.parse(IOUtils.toInputStream((String)str));
        Element root = doc.getDocumentElement();
        return QueuePlacementPolicy.fromXml((Element)root, this.configuredQueues, (Configuration)conf);
    }
}

