/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.DelegationToken;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesDelegationTokens
extends JerseyTestBase {
    private static File testRootDir;
    private static File httpSpnegoKeytabFile;
    private static String httpSpnegoPrincipal;
    private static MiniKdc testMiniKDC;
    private static MockRM rm;
    private Injector injector;
    private boolean isKerberosAuth = false;
    final String yarnTokenHeader = "Hadoop-YARN-RM-Delegation-Token";

    private Injector getSimpleAuthInjector() {
        return Guice.createInjector((Module[])new Module[]{new TestServletModule(){

            @Override
            protected void configureServlets() {
                TestRMWebServicesDelegationTokens.this.isKerberosAuth = false;
                this.rmconf.set("hadoop.security.authentication", "simple");
                super.configureServlets();
            }
        }});
    }

    private Injector getKerberosAuthInjector() {
        return Guice.createInjector((Module[])new Module[]{new TestServletModule(){

            @Override
            protected void configureServlets() {
                TestRMWebServicesDelegationTokens.this.isKerberosAuth = true;
                this.rmconf.set("hadoop.security.authentication", "kerberos");
                this.rmconf.set("yarn.resourcemanager.webapp.spnego-principal", httpSpnegoPrincipal);
                this.rmconf.set("yarn.resourcemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
                this.rmconf.set("yarn.nodemanager.webapp.spnego-principal", httpSpnegoPrincipal);
                this.rmconf.set("yarn.nodemanager.webapp.spnego-keytab-file", httpSpnegoKeytabFile.getAbsolutePath());
                super.configureServlets();
            }
        }});
    }

    @Parameterized.Parameters
    public static Collection<Object[]> guiceConfigs() {
        return Arrays.asList({0}, {1});
    }

    public TestRMWebServicesDelegationTokens(int run) throws Exception {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
        switch (run) {
            default: {
                this.injector = this.getKerberosAuthInjector();
                break;
            }
            case 1: {
                this.injector = this.getSimpleAuthInjector();
            }
        }
    }

    @BeforeClass
    public static void setupKDC() throws Exception {
        testRootDir = new File("target", TestRMWebServicesDelegationTokens.class.getName() + "-root");
        testMiniKDC = new MiniKdc(MiniKdc.createConf(), testRootDir);
        testMiniKDC.start();
        testMiniKDC.createPrincipal(httpSpnegoKeytabFile, new String[]{"HTTP/localhost", "client", "client2", "client3"});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        httpSpnegoKeytabFile.deleteOnExit();
        testRootDir.deleteOnExit();
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @AfterClass
    public static void shutdownKdc() {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
    }

    @After
    public void tearDown() throws Exception {
        rm.stop();
        super.tearDown();
        UserGroupInformation.setConfiguration((Configuration)new Configuration());
    }

    @Test
    public void testCreateDelegationToken() throws Exception {
        rm.start();
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        String renewer = "test-renewer";
        String jsonBody = "{ \"renewer\" : \"test-renewer\" }";
        String xmlBody = "<delegation-token><renewer>test-renewer</renewer></delegation-token>";
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("application/json", jsonBody);
        bodyMap.put("application/xml", xmlBody);
        for (String mediaType : mediaTypes) {
            String body = (String)bodyMap.get(mediaType);
            for (String contentType : mediaTypes) {
                if (this.isKerberosAuth) {
                    this.verifyKerberosAuthCreate(mediaType, contentType, body, "test-renewer");
                    continue;
                }
                this.verifySimpleAuthCreate(mediaType, contentType, body);
            }
        }
        rm.stop();
    }

    private void verifySimpleAuthCreate(String mediaType, String contentType, String body) {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.resource().path("ws").path("v1").path("cluster").path("delegation-token").queryParam("user.name", "testuser").accept(new String[]{contentType}).entity((Object)body, mediaType)).post(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
    }

    private void verifyKerberosAuthCreate(String mType, String cType, String reqBody, String renUser) throws Exception {
        final String mediaType = mType;
        final String contentType = cType;
        final String body = reqBody;
        final String renewer = renUser;
        KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ClientResponse response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").accept(new String[]{contentType}).entity((Object)body, mediaType)).post(ClientResponse.class);
                Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                Assert.assertFalse((boolean)tok.getToken().isEmpty());
                Token token = new Token();
                token.decodeFromUrlString(tok.getToken());
                Assert.assertEquals((Object)renewer, (Object)((RMDelegationTokenIdentifier)token.decodeIdentifier()).getRenewer().toString());
                TestRMWebServicesDelegationTokens.this.assertValidRMToken(tok.getToken());
                DelegationToken dtoken = new DelegationToken();
                response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").accept(new String[]{contentType}).entity((Object)dtoken, mediaType)).post(ClientResponse.class);
                Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                Assert.assertFalse((boolean)tok.getToken().isEmpty());
                token = new Token();
                token.decodeFromUrlString(tok.getToken());
                Assert.assertEquals((Object)"", (Object)((RMDelegationTokenIdentifier)token.decodeIdentifier()).getRenewer().toString());
                TestRMWebServicesDelegationTokens.this.assertValidRMToken(tok.getToken());
                return null;
            }
        });
    }

    @Test
    public void testRenewDelegationToken() throws Exception {
        String[] mediaTypes;
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        rm.start();
        String renewer = "client2";
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        final DelegationToken dummyToken = new DelegationToken();
        dummyToken.setRenewer("client2");
        for (final String mediaType : mediaTypes = new String[]{"application/json", "application/xml"}) {
            for (final String contentType : mediaTypes) {
                if (!this.isKerberosAuth) {
                    this.verifySimpleAuthRenew(mediaType, contentType);
                    continue;
                }
                final DelegationToken responseToken = (DelegationToken)KerberosTestUtils.doAsClient((Callable)new Callable<DelegationToken>(){

                    @Override
                    public DelegationToken call() throws Exception {
                        ClientResponse response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").accept(new String[]{contentType}).entity((Object)dummyToken, mediaType)).post(ClientResponse.class);
                        Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                        DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                        Assert.assertFalse((boolean)tok.getToken().isEmpty());
                        String body = TestRMWebServicesDelegationTokens.generateRenewTokenBody(mediaType, tok.getToken());
                        response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").path("expiration").header("Hadoop-YARN-RM-Delegation-Token", (Object)tok.getToken()).accept(new String[]{contentType})).entity((Object)body, mediaType)).post(ClientResponse.class);
                        Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
                        return tok;
                    }
                });
                KerberosTestUtils.doAs((String)"client2", (Callable)new Callable<DelegationToken>(){

                    @Override
                    public DelegationToken call() throws Exception {
                        long oldExpirationTime = Time.now();
                        TestRMWebServicesDelegationTokens.this.assertValidRMToken(responseToken.getToken());
                        String body = TestRMWebServicesDelegationTokens.generateRenewTokenBody(mediaType, responseToken.getToken());
                        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").path("expiration").header("Hadoop-YARN-RM-Delegation-Token", (Object)responseToken.getToken()).accept(new String[]{contentType})).entity((Object)body, mediaType)).post(ClientResponse.class);
                        Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                        DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                        String message = "Expiration time not as expected: old = " + oldExpirationTime + "; new = " + tok.getNextExpirationTime();
                        Assert.assertTrue((String)message, (tok.getNextExpirationTime() > oldExpirationTime ? 1 : 0) != 0);
                        oldExpirationTime = tok.getNextExpirationTime();
                        Thread.sleep(1000L);
                        response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").path("expiration").header("Hadoop-YARN-RM-Delegation-Token", (Object)responseToken.getToken()).accept(new String[]{contentType})).entity((Object)body, mediaType)).post(ClientResponse.class);
                        Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                        tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                        message = "Expiration time not as expected: old = " + oldExpirationTime + "; new = " + tok.getNextExpirationTime();
                        Assert.assertTrue((String)message, (tok.getNextExpirationTime() > oldExpirationTime ? 1 : 0) != 0);
                        return tok;
                    }
                });
                KerberosTestUtils.doAs((String)"client3", (Callable)new Callable<DelegationToken>(){

                    @Override
                    public DelegationToken call() throws Exception {
                        String body = TestRMWebServicesDelegationTokens.generateRenewTokenBody(mediaType, responseToken.getToken());
                        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").path("expiration").header("Hadoop-YARN-RM-Delegation-Token", (Object)responseToken.getToken()).accept(new String[]{contentType})).entity((Object)body, mediaType)).post(ClientResponse.class);
                        Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
                        return null;
                    }
                });
                KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        String token = "TEST_TOKEN_STRING";
                        String body = "";
                        body = mediaType.equals("application/json") ? "{\"token\": \"" + token + "\" }" : "<delegation-token><token>" + token + "</token></delegation-token>";
                        ClientResponse response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").path("expiration").accept(new String[]{contentType}).entity((Object)body, mediaType)).post(ClientResponse.class);
                        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
                        return null;
                    }
                });
            }
        }
        rm.stop();
    }

    private void verifySimpleAuthRenew(String mediaType, String contentType) {
        String token = "TEST_TOKEN_STRING";
        String body = "";
        if (mediaType.equals("application/json")) {
            body = "{\"token\": \"" + token + "\" }";
            body = "{\"abcd\": \"test-123\" }";
        } else {
            body = "<delegation-token><token>" + token + "</token></delegation-token>";
            body = "<delegation-token><xml>abcd</xml></delegation-token>";
        }
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.resource().path("ws").path("v1").path("cluster").path("delegation-token").queryParam("user.name", "testuser").accept(new String[]{contentType}).entity((Object)body, mediaType)).post(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
    }

    @Test
    public void testCancelDelegationToken() throws Exception {
        String[] mediaTypes;
        rm.start();
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        if (!this.isKerberosAuth) {
            this.verifySimpleAuthCancel();
            return;
        }
        final DelegationToken dtoken = new DelegationToken();
        String renewer = "client2";
        dtoken.setRenewer(renewer);
        for (final String mediaType : mediaTypes = new String[]{"application/json", "application/xml"}) {
            for (final String contentType : mediaTypes) {
                KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ClientResponse response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").accept(new String[]{contentType}).entity((Object)dtoken, mediaType)).post(ClientResponse.class);
                        Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                        DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                        response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").header("Hadoop-YARN-RM-Delegation-Token", (Object)tok.getToken()).accept(new String[]{contentType})).delete(ClientResponse.class);
                        Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                        TestRMWebServicesDelegationTokens.this.assertTokenCancelled(tok.getToken());
                        return null;
                    }
                });
                final DelegationToken tmpToken = (DelegationToken)KerberosTestUtils.doAsClient((Callable)new Callable<DelegationToken>(){

                    @Override
                    public DelegationToken call() throws Exception {
                        ClientResponse response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").accept(new String[]{contentType}).entity((Object)dtoken, mediaType)).post(ClientResponse.class);
                        Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                        DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                        return tok;
                    }
                });
                KerberosTestUtils.doAs((String)renewer, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ClientResponse response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").header("Hadoop-YARN-RM-Delegation-Token", (Object)tmpToken.getToken()).accept(new String[]{contentType})).delete(ClientResponse.class);
                        Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                        TestRMWebServicesDelegationTokens.this.assertTokenCancelled(tmpToken.getToken());
                        return null;
                    }
                });
                final DelegationToken tmpToken2 = (DelegationToken)KerberosTestUtils.doAsClient((Callable)new Callable<DelegationToken>(){

                    @Override
                    public DelegationToken call() throws Exception {
                        ClientResponse response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").accept(new String[]{contentType}).entity((Object)dtoken, mediaType)).post(ClientResponse.class);
                        Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                        DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                        return tok;
                    }
                });
                KerberosTestUtils.doAs((String)"client3", (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ClientResponse response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").header("Hadoop-YARN-RM-Delegation-Token", (Object)tmpToken2.getToken()).accept(new String[]{contentType})).delete(ClientResponse.class);
                        Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
                        TestRMWebServicesDelegationTokens.this.assertValidRMToken(tmpToken2.getToken());
                        return null;
                    }
                });
                this.testCancelTokenBadRequests(mediaType, contentType);
            }
        }
        rm.stop();
    }

    private void testCancelTokenBadRequests(String mType, String cType) throws Exception {
        final String mediaType = mType;
        final String contentType = cType;
        final DelegationToken dtoken = new DelegationToken();
        String renewer = "client2";
        dtoken.setRenewer(renewer);
        KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ClientResponse response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").header("Hadoop-YARN-RM-Delegation-Token", (Object)"random-string").accept(new String[]{contentType})).delete(ClientResponse.class);
                Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
                return null;
            }
        });
        KerberosTestUtils.doAsClient((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ClientResponse response = (ClientResponse)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").accept(new String[]{contentType}).delete(ClientResponse.class);
                Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
                return null;
            }
        });
        final DelegationToken tmpToken = (DelegationToken)KerberosTestUtils.doAsClient((Callable)new Callable<DelegationToken>(){

            @Override
            public DelegationToken call() throws Exception {
                ClientResponse response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").accept(new String[]{contentType}).entity((Object)dtoken, mediaType)).post(ClientResponse.class);
                Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                DelegationToken tok = TestRMWebServicesDelegationTokens.this.getDelegationTokenFromResponse(response);
                return tok;
            }
        });
        KerberosTestUtils.doAs((String)renewer, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ClientResponse response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").header("Hadoop-YARN-RM-Delegation-Token", (Object)tmpToken.getToken()).accept(new String[]{contentType})).delete(ClientResponse.class);
                Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                response = (ClientResponse)((WebResource.Builder)TestRMWebServicesDelegationTokens.this.resource().path("ws").path("v1").path("cluster").path("delegation-token").header("Hadoop-YARN-RM-Delegation-Token", (Object)tmpToken.getToken()).accept(new String[]{contentType})).delete(ClientResponse.class);
                Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
                return null;
            }
        });
    }

    private void verifySimpleAuthCancel() {
        ClientResponse response = (ClientResponse)this.resource().path("ws").path("v1").path("cluster").path("delegation-token").queryParam("user.name", "testuser").header("Hadoop-YARN-RM-Delegation-Token", (Object)"random").delete(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
    }

    private DelegationToken getDelegationTokenFromResponse(ClientResponse response) throws IOException, ParserConfigurationException, SAXException, JSONException {
        if (response.getType().toString().equals("application/json")) {
            return TestRMWebServicesDelegationTokens.getDelegationTokenFromJson((JSONObject)response.getEntity(JSONObject.class));
        }
        return TestRMWebServicesDelegationTokens.getDelegationTokenFromXML((String)response.getEntity(String.class));
    }

    public static DelegationToken getDelegationTokenFromXML(String tokenXML) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(tokenXML));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("delegation-token");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        Element element = (Element)nodes.item(0);
        DelegationToken ret = new DelegationToken();
        String token = WebServicesTestUtils.getXmlString((Element)element, (String)"token");
        if (token != null) {
            ret.setToken(token);
        } else {
            long expiration = WebServicesTestUtils.getXmlLong((Element)element, (String)"expiration-time");
            ret.setNextExpirationTime(expiration);
        }
        return ret;
    }

    public static DelegationToken getDelegationTokenFromJson(JSONObject json) throws JSONException {
        DelegationToken ret = new DelegationToken();
        if (json.has("token")) {
            ret.setToken(json.getString("token"));
        } else if (json.has("expiration-time")) {
            ret.setNextExpirationTime(json.getLong("expiration-time"));
        }
        return ret;
    }

    private void assertValidRMToken(String encodedToken) throws IOException {
        Token realToken = new Token();
        realToken.decodeFromUrlString(encodedToken);
        RMDelegationTokenIdentifier ident = (RMDelegationTokenIdentifier)rm.getRMContext().getRMDelegationTokenSecretManager().decodeTokenIdentifier(realToken);
        rm.getRMContext().getRMDelegationTokenSecretManager().verifyToken((AbstractDelegationTokenIdentifier)ident, realToken.getPassword());
        Assert.assertTrue((boolean)rm.getRMContext().getRMDelegationTokenSecretManager().getAllTokens().containsKey(ident));
    }

    private void assertTokenCancelled(String encodedToken) throws Exception {
        Token realToken = new Token();
        realToken.decodeFromUrlString(encodedToken);
        RMDelegationTokenIdentifier ident = (RMDelegationTokenIdentifier)rm.getRMContext().getRMDelegationTokenSecretManager().decodeTokenIdentifier(realToken);
        boolean exceptionCaught = false;
        try {
            rm.getRMContext().getRMDelegationTokenSecretManager().verifyToken((AbstractDelegationTokenIdentifier)ident, realToken.getPassword());
        }
        catch (SecretManager.InvalidToken it) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"InvalidToken exception not thrown", (boolean)exceptionCaught);
        Assert.assertFalse((boolean)rm.getRMContext().getRMDelegationTokenSecretManager().getAllTokens().containsKey(ident));
    }

    private static String generateRenewTokenBody(String mediaType, String token) {
        String body = "";
        body = mediaType.equals("application/json") ? "{\"token\": \"" + token + "\" }" : "<delegation-token><token>" + token + "</token></delegation-token>";
        return body;
    }

    static {
        httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
        httpSpnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    }

    public class GuiceServletConfig
    extends GuiceServletContextListener {
        protected Injector getInjector() {
            return TestRMWebServicesDelegationTokens.this.injector;
        }
    }

    private class TestServletModule
    extends ServletModule {
        public Configuration rmconf = new Configuration();

        private TestServletModule() {
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            Configuration rmconf = new Configuration();
            rmconf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            rmconf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
            rmconf.setBoolean("yarn.acl.enable", true);
            rm = new MockRM(rmconf);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            if (TestRMWebServicesDelegationTokens.this.isKerberosAuth) {
                this.filter("/*", new String[0]).through(TestKerberosAuthFilter.class);
            } else {
                this.filter("/*", new String[0]).through(TestSimpleAuthFilter.class);
            }
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }

    @Singleton
    public static class TestSimpleAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties properties = super.getConfiguration(configPrefix, filterConfig);
            properties.put("kerberos.principal", httpSpnegoPrincipal);
            properties.put("kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
            properties.put("type", "simple");
            properties.put("simple.anonymous.allowed", "false");
            return properties;
        }
    }

    @Singleton
    public static class TestKerberosAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties properties = super.getConfiguration(configPrefix, filterConfig);
            properties.put("kerberos.principal", httpSpnegoPrincipal);
            properties.put("kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
            properties.put("type", "kerberos");
            return properties;
        }
    }
}

