/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONMarshaller;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodeIDsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesAppsModification;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LabelsToNodesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeLabelsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntry;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsEntryList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.NodeToLabelsInfo;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONException;
import org.junit.Assert;
import org.junit.Test;

public class TestRMWebServicesNodeLabels
extends JerseyTestBase {
    private static final Log LOG = LogFactory.getLog(TestRMWebServicesNodeLabels.class);
    private static MockRM rm;
    private YarnConfiguration conf;
    private String userName;
    private String notUserName;
    private RMWebServices rmWebService;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new ServletModule(){

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            try {
                TestRMWebServicesNodeLabels.this.userName = UserGroupInformation.getCurrentUser().getShortUserName();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to get current user name " + ioe.getMessage(), ioe);
            }
            TestRMWebServicesNodeLabels.this.notUserName = TestRMWebServicesNodeLabels.this.userName + "abc123";
            TestRMWebServicesNodeLabels.this.conf = new YarnConfiguration();
            TestRMWebServicesNodeLabels.this.conf.set("yarn.admin.acl", TestRMWebServicesNodeLabels.this.userName);
            rm = new MockRM((Configuration)TestRMWebServicesNodeLabels.this.conf);
            TestRMWebServicesNodeLabels.this.rmWebService = new RMWebServices((ResourceManager)rm, (Configuration)TestRMWebServicesNodeLabels.this.conf);
            this.bind(RMWebServices.class).toInstance((Object)TestRMWebServicesNodeLabels.this.rmWebService);
            this.bind(GenericExceptionHandler.class);
            this.bind(ResourceManager.class).toInstance((Object)rm);
            this.filter("/*", new String[0]).through(TestRMWebServicesAppsModification.TestRMCustomAuthFilter.class);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }});

    public TestRMWebServicesNodeLabels() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testNodeLabels() throws JSONException, Exception {
        WebResource r = this.resource();
        NodeLabelsInfo nlsifo = new NodeLabelsInfo();
        nlsifo.getNodeLabelsInfo().add(new NodeLabelInfo("a"));
        ClientResponse response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("add-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)this.toJson(nlsifo, NodeLabelsInfo.class), "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertEquals((long)1L, (long)nlsifo.getNodeLabels().size());
        for (NodeLabelInfo nl : nlsifo.getNodeLabelsInfo()) {
            Assert.assertEquals((Object)"a", (Object)nl.getName());
            Assert.assertTrue((boolean)nl.getExclusivity());
        }
        nlsifo = new NodeLabelsInfo();
        nlsifo.getNodeLabelsInfo().add(new NodeLabelInfo("b", false));
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("add-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)this.toJson(nlsifo, NodeLabelsInfo.class), "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertEquals((long)2L, (long)nlsifo.getNodeLabels().size());
        for (NodeLabelInfo nl : nlsifo.getNodeLabelsInfo()) {
            if (!nl.getName().equals("b")) continue;
            Assert.assertFalse((boolean)nl.getExclusivity());
        }
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add("labels", "a");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("replace-labels").queryParam("user.name", this.userName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).post(ClientResponse.class);
        LOG.info((Object)"posted node nodelabel");
        params = new MultivaluedMapImpl();
        params.add("labels", "b");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid1:0").path("replace-labels").queryParam("user.name", this.userName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).post(ClientResponse.class);
        LOG.info((Object)"posted node nodelabel");
        params = new MultivaluedMapImpl();
        params.add("labels", "b");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid2:0").path("replace-labels").queryParam("user.name", this.userName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).post(ClientResponse.class);
        LOG.info((Object)"posted node nodelabel");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("label-mappings").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        LabelsToNodesInfo ltni = (LabelsToNodesInfo)response.getEntity(LabelsToNodesInfo.class);
        Assert.assertEquals((long)2L, (long)ltni.getLabelsToNodes().size());
        NodeIDsInfo nodes = (NodeIDsInfo)ltni.getLabelsToNodes().get(new NodeLabelInfo("b", false));
        Assert.assertTrue((boolean)nodes.getNodeIDs().contains("nid2:0"));
        Assert.assertTrue((boolean)nodes.getNodeIDs().contains("nid1:0"));
        nodes = (NodeIDsInfo)ltni.getLabelsToNodes().get(new NodeLabelInfo("a"));
        Assert.assertTrue((boolean)nodes.getNodeIDs().contains("nid:0"));
        params = new MultivaluedMapImpl();
        params.add("labels", "a");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("label-mappings").queryParam("user.name", this.userName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        ltni = (LabelsToNodesInfo)response.getEntity(LabelsToNodesInfo.class);
        Assert.assertEquals((long)1L, (long)ltni.getLabelsToNodes().size());
        nodes = (NodeIDsInfo)ltni.getLabelsToNodes().get(new NodeLabelInfo("a"));
        Assert.assertTrue((boolean)nodes.getNodeIDs().contains("nid:0"));
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("get-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertTrue((boolean)nlsifo.getNodeLabelsInfo().contains(new NodeLabelInfo("a")));
        params = new MultivaluedMapImpl();
        params.add("labels", "b");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("replace-labels").queryParam("user.name", this.userName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).post(ClientResponse.class);
        LOG.info((Object)"posted node nodelabel");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("get-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertTrue((boolean)nlsifo.getNodeLabelsInfo().contains(new NodeLabelInfo("b", false)));
        NodeToLabelsEntryList ntli = new NodeToLabelsEntryList();
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("a");
        NodeToLabelsEntry nli = new NodeToLabelsEntry("nid:0", labels);
        ntli.getNodeToLabels().add(nli);
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("replace-node-to-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)this.toJson(ntli, NodeToLabelsEntryList.class), "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-to-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        NodeToLabelsInfo ntlinfo = (NodeToLabelsInfo)response.getEntity(NodeToLabelsInfo.class);
        NodeLabelsInfo nlinfo = (NodeLabelsInfo)ntlinfo.getNodeToLabels().get("nid:0");
        Assert.assertEquals((long)1L, (long)nlinfo.getNodeLabels().size());
        Assert.assertTrue((boolean)nlinfo.getNodeLabelsInfo().contains(new NodeLabelInfo("a")));
        params = new MultivaluedMapImpl();
        params.add("labels", "");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("replace-labels").queryParam("user.name", this.userName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).post(ClientResponse.class);
        LOG.info((Object)"posted node nodelabel");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("get-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertTrue((boolean)nlsifo.getNodeLabelsInfo().isEmpty());
        params = new MultivaluedMapImpl();
        params.add("labels", "a");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("replace-labels").queryParam("user.name", this.userName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).post(ClientResponse.class);
        LOG.info((Object)"posted node nodelabel");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("get-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertTrue((boolean)nlsifo.getNodeLabelsInfo().contains(new NodeLabelInfo("a")));
        params = new MultivaluedMapImpl();
        params.add("labels", "b");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("replace-labels").queryParam("user.name", this.notUserName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("get-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertTrue((boolean)nlsifo.getNodeLabelsInfo().contains(new NodeLabelInfo("a")));
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("add-node-labels").queryParam("user.name", this.notUserName).accept(new String[]{"application/json"}).entity((Object)"{\"nodeLabels\":\"c\"}", "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertEquals((long)2L, (long)nlsifo.getNodeLabels().size());
        params = new MultivaluedMapImpl();
        params.add("labels", "b");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("remove-node-labels").queryParam("user.name", this.userName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertEquals((long)1L, (long)nlsifo.getNodeLabels().size());
        for (NodeLabelInfo nl : nlsifo.getNodeLabelsInfo()) {
            Assert.assertEquals((Object)"a", (Object)nl.getName());
            Assert.assertTrue((boolean)nl.getExclusivity());
        }
        params = new MultivaluedMapImpl();
        params.add("labels", "a");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("remove-node-labels").queryParam("user.name", this.userName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertEquals((long)0L, (long)nlsifo.getNodeLabels().size());
        nlsifo = new NodeLabelsInfo();
        nlsifo.getNodeLabelsInfo().add(new NodeLabelInfo("x", false));
        nlsifo.getNodeLabelsInfo().add(new NodeLabelInfo("y", false));
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("add-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)this.toJson(nlsifo, NodeLabelsInfo.class), "application/json")).post(ClientResponse.class);
        params = new MultivaluedMapImpl();
        params.add("labels", "y");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("replace-labels").queryParam("user.name", this.userName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).post(ClientResponse.class);
        LOG.info((Object)"posted node nodelabel");
        this.rmWebService.isCentralizedNodeLabelConfiguration = false;
        ntli = new NodeToLabelsEntryList();
        labels = new ArrayList();
        labels.add("x");
        nli = new NodeToLabelsEntry("nid:0", labels);
        ntli.getNodeToLabels().add(nli);
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("replace-node-to-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)this.toJson(ntli, NodeToLabelsEntryList.class), "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-to-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        ntlinfo = (NodeToLabelsInfo)response.getEntity(NodeToLabelsInfo.class);
        nlinfo = (NodeLabelsInfo)ntlinfo.getNodeToLabels().get("nid:0");
        Assert.assertEquals((long)1L, (long)nlinfo.getNodeLabels().size());
        Assert.assertFalse((boolean)nlinfo.getNodeLabelsInfo().contains(new NodeLabelInfo("x", false)));
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("nodes").path("nid:0").path("replace-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)"{\"nodeLabelName\": [\"x\"]}", "application/json")).post(ClientResponse.class);
        LOG.info((Object)"posted node nodelabel");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-to-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        ntlinfo = (NodeToLabelsInfo)response.getEntity(NodeToLabelsInfo.class);
        nlinfo = (NodeLabelsInfo)ntlinfo.getNodeToLabels().get("nid:0");
        Assert.assertEquals((long)1L, (long)nlinfo.getNodeLabels().size());
        Assert.assertFalse((boolean)nlinfo.getNodeLabelsInfo().contains(new NodeLabelInfo("x", false)));
        params = new MultivaluedMapImpl();
        params.add("labels", "x");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("remove-node-labels").queryParam("user.name", this.userName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertEquals((Object)new NodeLabelInfo("y", false), nlsifo.getNodeLabelsInfo().get(0));
        Assert.assertEquals((Object)"y", (Object)((NodeLabelInfo)nlsifo.getNodeLabelsInfo().get(0)).getName());
        Assert.assertFalse((boolean)((NodeLabelInfo)nlsifo.getNodeLabelsInfo().get(0)).getExclusivity());
        params = new MultivaluedMapImpl();
        params.add("labels", "y");
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("remove-node-labels").queryParam("user.name", this.userName).queryParams((MultivaluedMap)params).accept(new String[]{"application/json"}).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertTrue((boolean)nlsifo.getNodeLabelsInfo().isEmpty());
        nlsifo = new NodeLabelsInfo();
        nlsifo.getNodeLabelsInfo().add(new NodeLabelInfo("z", false));
        response = (ClientResponse)((WebResource.Builder)r.path("ws").path("v1").path("cluster").path("add-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).entity((Object)this.toJson(nlsifo, NodeLabelsInfo.class), "application/json")).post(ClientResponse.class);
        response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("get-node-labels").queryParam("user.name", this.userName).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        nlsifo = (NodeLabelsInfo)response.getEntity(NodeLabelsInfo.class);
        Assert.assertEquals((Object)"z", (Object)((NodeLabelInfo)nlsifo.getNodeLabelsInfo().get(0)).getName());
        Assert.assertFalse((boolean)((NodeLabelInfo)nlsifo.getNodeLabelsInfo().get(0)).getExclusivity());
        Assert.assertEquals((long)1L, (long)nlsifo.getNodeLabels().size());
    }

    private String toJson(Object nsli, Class klass) throws Exception {
        StringWriter sw = new StringWriter();
        JSONJAXBContext ctx = new JSONJAXBContext(new Class[]{klass});
        JSONMarshaller jm = ctx.createJSONMarshaller();
        jm.marshallToJSON(nsli, (Writer)sw);
        return sw.toString();
    }

    public class GuiceServletConfig
    extends GuiceServletContextListener {
        protected Injector getInjector() {
            return TestRMWebServicesNodeLabels.this.injector;
        }
    }
}

