/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerQueueInfo;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFairSchedulerQueueInfo {
    @Test
    public void testEmptyChildQueues() throws Exception {
        FairSchedulerConfiguration conf = new FairSchedulerConfiguration();
        FairScheduler scheduler = (FairScheduler)Mockito.mock(FairScheduler.class);
        AllocationConfiguration allocConf = new AllocationConfiguration((Configuration)conf);
        Mockito.when((Object)scheduler.getAllocationConfiguration()).thenReturn((Object)allocConf);
        Mockito.when((Object)scheduler.getConf()).thenReturn((Object)conf);
        Mockito.when((Object)scheduler.getClusterResource()).thenReturn((Object)Resource.newInstance((int)1, (int)1));
        SystemClock clock = SystemClock.getInstance();
        Mockito.when((Object)scheduler.getClock()).thenReturn((Object)clock);
        QueueManager queueManager = new QueueManager(scheduler);
        queueManager.initialize((Configuration)conf);
        FSLeafQueue testQueue = queueManager.getLeafQueue("test", true);
        FairSchedulerQueueInfo queueInfo = new FairSchedulerQueueInfo((FSQueue)testQueue, scheduler);
        Collection childQueues = queueInfo.getChildQueues();
        Assert.assertNotNull((Object)childQueues);
        Assert.assertEquals((String)"Child QueueInfo was not empty", (long)0L, (long)childQueues.size());
    }
}

