/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.metrics.CustomResourceMetricValue;
import org.apache.hadoop.yarn.metrics.CustomResourceMetrics;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;

@InterfaceAudience.Private
@Metrics(context="yarn")
public class ClusterMetrics {
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    @Metric(value={"# of active NMs"})
    MutableGaugeInt numActiveNMs;
    @Metric(value={"# of decommissioning NMs"})
    MutableGaugeInt numDecommissioningNMs;
    @Metric(value={"# of decommissioned NMs"})
    MutableGaugeInt numDecommissionedNMs;
    @Metric(value={"# of lost NMs"})
    MutableGaugeInt numLostNMs;
    @Metric(value={"# of unhealthy NMs"})
    MutableGaugeInt numUnhealthyNMs;
    @Metric(value={"# of Rebooted NMs"})
    MutableGaugeInt numRebootedNMs;
    @Metric(value={"# of Shutdown NMs"})
    MutableGaugeInt numShutdownNMs;
    @Metric(value={"AM container launch delay"})
    MutableRate aMLaunchDelay;
    @Metric(value={"AM register delay"})
    MutableRate aMRegisterDelay;
    @Metric(value={"AM container allocation delay"})
    private MutableRate aMContainerAllocationDelay;
    @Metric(value={"Memory Utilization"})
    MutableGaugeLong utilizedMB;
    @Metric(value={"Vcore Utilization"})
    MutableGaugeLong utilizedVirtualCores;
    @Metric(value={"Memory Capability"})
    MutableGaugeLong capabilityMB;
    @Metric(value={"Vcore Capability"})
    MutableGaugeLong capabilityVirtualCores;
    @Metric(value={"RM Event Processor CPU Usage 60 second Avg"})
    MutableGaugeLong rmEventProcCPUAvg;
    @Metric(value={"RM Event Processor CPU Usage 60 second Max"})
    MutableGaugeLong rmEventProcCPUMax;
    @Metric(value={"# of Containers assigned in the last second"})
    MutableGaugeInt containerAssignedPerSecond;
    @Metric(value={"# of rm dispatcher event queue size"})
    MutableGaugeInt rmDispatcherEventQueueSize;
    @Metric(value={"# of scheduler dispatcher event queue size"})
    MutableGaugeInt schedulerDispatcherEventQueueSize;
    private boolean rmEventProcMonitorEnable = false;
    private static final MetricsInfo RECORD_INFO = Interns.info((String)"ClusterMetrics", (String)"Metrics for the Yarn Cluster");
    private static final String CUSTOM_RESOURCE_CAPABILITY_METRIC_PREFIX = "Capability.";
    private static final String CUSTOM_RESOURCE_CAPABILITY_METRIC_DESC = "NAME Capability";
    private static CustomResourceMetrics customResourceMetrics;
    private final CustomResourceMetricValue customResourceCapability = new CustomResourceMetricValue();
    private static volatile ClusterMetrics INSTANCE;
    private static MetricsRegistry registry;
    private AtomicInteger numContainersAssigned = new AtomicInteger(0);
    private ScheduledThreadPoolExecutor assignCounterExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ContainerAssignmentCounterThread").build());

    ClusterMetrics() {
        this.assignCounterExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ClusterMetrics.this.containerAssignedPerSecond.set(ClusterMetrics.this.numContainersAssigned.getAndSet(0));
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterMetrics getMetrics() {
        if (isInitialized.get()) return INSTANCE;
        Class<ClusterMetrics> clazz = ClusterMetrics.class;
        synchronized (ClusterMetrics.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ClusterMetrics();
            ClusterMetrics.registerMetrics();
            isInitialized.set(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static void registerMetrics() {
        registry = new MetricsRegistry(RECORD_INFO);
        registry.tag(RECORD_INFO, "ResourceManager");
        MetricsSystem ms = DefaultMetricsSystem.instance();
        if (ms != null) {
            ms.register("ClusterMetrics", "Metrics for the Yarn Cluster", (Object)INSTANCE);
        }
        if (ResourceUtils.getNumberOfKnownResourceTypes() > 2) {
            customResourceMetrics = new CustomResourceMetrics();
            Map customResources = customResourceMetrics.initAndGetCustomResources();
            customResourceMetrics.registerCustomResources(customResources, registry, CUSTOM_RESOURCE_CAPABILITY_METRIC_PREFIX, CUSTOM_RESOURCE_CAPABILITY_METRIC_DESC);
        }
    }

    @VisibleForTesting
    public static synchronized void destroy() {
        if (INSTANCE != null && INSTANCE.getAssignCounterExecutor() != null) {
            INSTANCE.getAssignCounterExecutor().shutdownNow();
        }
        isInitialized.set(false);
        INSTANCE = null;
    }

    public void setRmEventProcMonitorEnable(boolean value) {
        this.rmEventProcMonitorEnable = value;
    }

    public boolean getRmEventProcMonitorEnable() {
        return this.rmEventProcMonitorEnable;
    }

    public long getRmEventProcCPUAvg() {
        return this.rmEventProcCPUAvg.value();
    }

    public void setRmEventProcCPUAvg(long value) {
        this.rmEventProcCPUAvg.set(value);
    }

    public long getRmEventProcCPUMax() {
        return this.rmEventProcCPUMax.value();
    }

    public void setRmEventProcCPUMax(long value) {
        this.rmEventProcCPUMax.set(value);
    }

    public int getNumActiveNMs() {
        return this.numActiveNMs.value();
    }

    public int getNumDecommissioningNMs() {
        return this.numDecommissioningNMs.value();
    }

    public void incrDecommissioningNMs() {
        this.numDecommissioningNMs.incr();
    }

    public void setDecommissioningNMs(int num) {
        this.numDecommissioningNMs.set(num);
    }

    public void decrDecommissioningNMs() {
        this.numDecommissioningNMs.decr();
    }

    public int getNumDecommisionedNMs() {
        return this.numDecommissionedNMs.value();
    }

    public void incrDecommisionedNMs() {
        this.numDecommissionedNMs.incr();
    }

    public void setDecommisionedNMs(int num) {
        this.numDecommissionedNMs.set(num);
    }

    public void decrDecommisionedNMs() {
        this.numDecommissionedNMs.decr();
    }

    public int getNumLostNMs() {
        return this.numLostNMs.value();
    }

    public void incrNumLostNMs() {
        this.numLostNMs.incr();
    }

    public void decrNumLostNMs() {
        this.numLostNMs.decr();
    }

    public int getUnhealthyNMs() {
        return this.numUnhealthyNMs.value();
    }

    public void incrNumUnhealthyNMs() {
        this.numUnhealthyNMs.incr();
    }

    public void decrNumUnhealthyNMs() {
        this.numUnhealthyNMs.decr();
    }

    public int getNumRebootedNMs() {
        return this.numRebootedNMs.value();
    }

    public void incrNumRebootedNMs() {
        this.numRebootedNMs.incr();
    }

    public void decrNumRebootedNMs() {
        this.numRebootedNMs.decr();
    }

    public int getNumShutdownNMs() {
        return this.numShutdownNMs.value();
    }

    public void incrNumShutdownNMs() {
        this.numShutdownNMs.incr();
    }

    public void decrNumShutdownNMs() {
        this.numShutdownNMs.decr();
    }

    public void incrNumActiveNodes() {
        this.numActiveNMs.incr();
    }

    public void decrNumActiveNodes() {
        this.numActiveNMs.decr();
    }

    public void addAMLaunchDelay(long delay) {
        this.aMLaunchDelay.add(delay);
    }

    public void addAMRegisterDelay(long delay) {
        this.aMRegisterDelay.add(delay);
    }

    public long getCapabilityMB() {
        return this.capabilityMB.value();
    }

    public long getCapabilityVirtualCores() {
        return this.capabilityVirtualCores.value();
    }

    public Map<String, Long> getCustomResourceCapability() {
        return this.customResourceCapability.getValues();
    }

    public void setCustomResourceCapability(Resource res) {
        this.customResourceCapability.set(res);
    }

    public void incrCapability(Resource res) {
        if (res != null) {
            this.capabilityMB.incr(res.getMemorySize());
            this.capabilityVirtualCores.incr((long)res.getVirtualCores());
            if (this.customResourceCapability != null) {
                this.customResourceCapability.increase(res);
            }
        }
    }

    public void decrCapability(Resource res) {
        if (res != null) {
            this.capabilityMB.decr(res.getMemorySize());
            this.capabilityVirtualCores.decr((long)res.getVirtualCores());
            if (this.customResourceCapability != null) {
                this.customResourceCapability.decrease(res);
            }
        }
    }

    public void addAMContainerAllocationDelay(long delay) {
        this.aMContainerAllocationDelay.add(delay);
    }

    public MutableRate getAMContainerAllocationDelay() {
        return this.aMContainerAllocationDelay;
    }

    public long getUtilizedMB() {
        return this.utilizedMB.value();
    }

    public void incrUtilizedMB(long delta) {
        this.utilizedMB.incr(delta);
    }

    public void decrUtilizedMB(long delta) {
        this.utilizedMB.decr(delta);
    }

    public void decrUtilizedVirtualCores(long delta) {
        this.utilizedVirtualCores.decr(delta);
    }

    public long getUtilizedVirtualCores() {
        return this.utilizedVirtualCores.value();
    }

    public void incrUtilizedVirtualCores(long delta) {
        this.utilizedVirtualCores.incr(delta);
    }

    public int getContainerAssignedPerSecond() {
        return this.containerAssignedPerSecond.value();
    }

    public void incrNumContainerAssigned() {
        this.numContainersAssigned.incrementAndGet();
    }

    private ScheduledThreadPoolExecutor getAssignCounterExecutor() {
        return this.assignCounterExecutor;
    }

    public int getRmEventQueueSize() {
        return this.rmDispatcherEventQueueSize.value();
    }

    public void setRmEventQueueSize(int rmEventQueueSize) {
        this.rmDispatcherEventQueueSize.set(rmEventQueueSize);
    }

    public int getSchedulerEventQueueSize() {
        return this.schedulerDispatcherEventQueueSize.value();
    }

    public void setSchedulerEventQueueSize(int schedulerEventQueueSize) {
        this.schedulerDispatcherEventQueueSize.set(schedulerEventQueueSize);
    }

    static {
        INSTANCE = null;
    }
}

