/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.metrics;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.AbstractSystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineServiceV1Publisher
extends AbstractSystemMetricsPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineServiceV1Publisher.class);
    private TimelineClient client;

    public TimelineServiceV1Publisher() {
        super("TimelineserviceV1Publisher");
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.client = TimelineClient.createTimelineClient();
        this.addIfService(this.client);
        super.serviceInit(conf);
        this.getDispatcher().register(AbstractSystemMetricsPublisher.SystemMetricsEventType.class, (EventHandler)new TimelineV1EventHandler());
    }

    @Override
    public void appCreated(RMApp app, long createdTime) {
        TimelineEntity entity = TimelineServiceV1Publisher.createApplicationEntity(app.getApplicationId());
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("YARN_APPLICATION_NAME", app.getName());
        entityInfo.put("YARN_APPLICATION_TYPE", app.getApplicationType());
        entityInfo.put("YARN_APPLICATION_USER", app.getUser());
        entityInfo.put("YARN_APPLICATION_QUEUE", app.getQueue());
        entityInfo.put("YARN_APPLICATION_SUBMITTED_TIME", app.getSubmitTime());
        entityInfo.put("YARN_APPLICATION_TAGS", app.getApplicationTags());
        entityInfo.put("YARN_APPLICATION_UNMANAGED_APPLICATION", app.getApplicationSubmissionContext().getUnmanagedAM());
        entityInfo.put("YARN_APPLICATION_PRIORITY", app.getApplicationPriority().getPriority());
        entityInfo.put("YARN_AM_NODE_LABEL_EXPRESSION", app.getAmNodeLabelExpression());
        entityInfo.put("YARN_APP_NODE_LABEL_EXPRESSION", app.getAppNodeLabelExpression());
        if (app.getCallerContext() != null) {
            if (app.getCallerContext().isContextValid()) {
                entityInfo.put("YARN_APPLICATION_CALLER_CONTEXT", app.getCallerContext().getContext());
            }
            if (app.getCallerContext().getSignature() != null) {
                entityInfo.put("YARN_APPLICATION_CALLER_SIGNATURE", app.getCallerContext().getSignature());
            }
        }
        ContainerLaunchContext amContainerSpec = app.getApplicationSubmissionContext().getAMContainerSpec();
        entityInfo.put("YARN_AM_CONTAINER_LAUNCH_COMMAND", amContainerSpec.getCommands());
        entityInfo.put("YARN_APPLICATION_STATE", RMServerUtils.createApplicationState(app.getState()).toString());
        entity.setOtherInfo(entityInfo);
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_CREATED");
        tEvent.setTimestamp(createdTime);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV1PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, entity, app.getApplicationId()));
    }

    @Override
    public void appLaunched(RMApp app, long launchTime) {
        TimelineEntity entity = TimelineServiceV1Publisher.createApplicationEntity(app.getApplicationId());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_LAUNCHED");
        tEvent.setTimestamp(launchTime);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV1PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, entity, app.getApplicationId()));
    }

    @Override
    public void appFinished(RMApp app, RMAppState state, long finishedTime) {
        String latestApplicationAttemptId;
        TimelineEntity entity = TimelineServiceV1Publisher.createApplicationEntity(app.getApplicationId());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_FINISHED");
        tEvent.setTimestamp(finishedTime);
        HashMap<String, String> eventInfo = new HashMap<String, String>();
        eventInfo.put("YARN_APPLICATION_DIAGNOSTICS_INFO", app.getDiagnostics().toString());
        eventInfo.put("YARN_APPLICATION_FINAL_STATUS", app.getFinalApplicationStatus().toString());
        eventInfo.put("YARN_APPLICATION_STATE", RMServerUtils.createApplicationState(state).toString());
        String string = latestApplicationAttemptId = app.getCurrentAppAttempt() == null ? null : app.getCurrentAppAttempt().getAppAttemptId().toString();
        if (latestApplicationAttemptId != null) {
            eventInfo.put("YARN_APPLICATION_LATEST_APP_ATTEMPT", latestApplicationAttemptId);
        }
        RMAppMetrics appMetrics = app.getRMAppMetrics();
        entity.addOtherInfo("YARN_APPLICATION_CPU", (Object)appMetrics.getVcoreSeconds());
        entity.addOtherInfo("YARN_APPLICATION_MEMORY", (Object)appMetrics.getMemorySeconds());
        entity.addOtherInfo("YARN_APPLICATION_MEM_PREEMPT_METRIC", (Object)appMetrics.getPreemptedMemorySeconds());
        entity.addOtherInfo("YARN_APPLICATION_CPU_PREEMPT_METRIC", (Object)appMetrics.getPreemptedVcoreSeconds());
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV1PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, entity, app.getApplicationId()));
    }

    @Override
    public void appUpdated(RMApp app, long updatedTime) {
        TimelineEntity entity = TimelineServiceV1Publisher.createApplicationEntity(app.getApplicationId());
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        eventInfo.put("YARN_APPLICATION_QUEUE", app.getQueue());
        eventInfo.put("YARN_APPLICATION_PRIORITY", app.getApplicationPriority().getPriority());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_UPDATED");
        tEvent.setTimestamp(updatedTime);
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV1PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, entity, app.getApplicationId()));
    }

    @Override
    public void appStateUpdated(RMApp app, YarnApplicationState appState, long updatedTime) {
        TimelineEntity entity = TimelineServiceV1Publisher.createApplicationEntity(app.getApplicationId());
        HashMap<String, YarnApplicationState> eventInfo = new HashMap<String, YarnApplicationState>();
        eventInfo.put("YARN_APPLICATION_STATE", appState);
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_STATE_UPDATED");
        tEvent.setTimestamp(updatedTime);
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV1PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, entity, app.getApplicationId()));
    }

    @Override
    public void appACLsUpdated(RMApp app, String appViewACLs, long updatedTime) {
        TimelineEntity entity = TimelineServiceV1Publisher.createApplicationEntity(app.getApplicationId());
        TimelineEvent tEvent = new TimelineEvent();
        HashMap<String, String> entityInfo = new HashMap<String, String>();
        entityInfo.put("YARN_APPLICATION_VIEW_ACLS", appViewACLs == null ? "" : appViewACLs);
        entity.setOtherInfo(entityInfo);
        tEvent.setEventType("YARN_APPLICATION_ACLS_UPDATED");
        tEvent.setTimestamp(updatedTime);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV1PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, entity, app.getApplicationId()));
    }

    @Override
    public void appAttemptRegistered(RMAppAttempt appAttempt, long registeredTime) {
        TimelineEntity entity = TimelineServiceV1Publisher.createAppAttemptEntity(appAttempt.getAppAttemptId());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_ATTEMPT_REGISTERED");
        tEvent.setTimestamp(registeredTime);
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        eventInfo.put("YARN_APPLICATION_ATTEMPT_TRACKING_URL", appAttempt.getTrackingUrl());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL", appAttempt.getOriginalTrackingUrl());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_HOST", appAttempt.getHost());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_RPC_PORT", appAttempt.getRpcPort());
        if (appAttempt.getMasterContainer() != null) {
            eventInfo.put("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER", appAttempt.getMasterContainer().getId().toString());
        }
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV1PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, entity, appAttempt.getAppAttemptId().getApplicationId()));
    }

    @Override
    public void appAttemptFinished(RMAppAttempt appAttempt, RMAppAttemptState appAttemtpState, RMApp app, long finishedTime) {
        TimelineEntity entity = TimelineServiceV1Publisher.createAppAttemptEntity(appAttempt.getAppAttemptId());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_ATTEMPT_FINISHED");
        tEvent.setTimestamp(finishedTime);
        HashMap<String, String> eventInfo = new HashMap<String, String>();
        eventInfo.put("YARN_APPLICATION_ATTEMPT_TRACKING_URL", appAttempt.getTrackingUrl());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL", appAttempt.getOriginalTrackingUrl());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO", appAttempt.getDiagnostics());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_FINAL_STATUS", app.getFinalApplicationStatus().toString());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_STATE", RMServerUtils.createApplicationAttemptState(appAttemtpState).toString());
        if (appAttempt.getMasterContainer() != null) {
            eventInfo.put("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER", appAttempt.getMasterContainer().getId().toString());
        }
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV1PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, entity, appAttempt.getAppAttemptId().getApplicationId()));
    }

    @Override
    public void containerCreated(RMContainer container, long createdTime) {
        TimelineEntity entity = TimelineServiceV1Publisher.createContainerEntity(container.getContainerId());
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("YARN_CONTAINER_ALLOCATED_MEMORY", container.getAllocatedResource().getMemorySize());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_VCORE", container.getAllocatedResource().getVirtualCores());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST", container.getAllocatedNode().getHost());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_PORT", container.getAllocatedNode().getPort());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_PRIORITY", container.getAllocatedPriority().getPriority());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS", container.getNodeHttpAddress());
        entity.setOtherInfo(entityInfo);
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_CONTAINER_CREATED");
        tEvent.setTimestamp(createdTime);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV1PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, entity, container.getContainerId().getApplicationAttemptId().getApplicationId()));
    }

    @Override
    public void containerFinished(RMContainer container, long finishedTime) {
        TimelineEntity entity = TimelineServiceV1Publisher.createContainerEntity(container.getContainerId());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_CONTAINER_FINISHED");
        tEvent.setTimestamp(finishedTime);
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        eventInfo.put("YARN_CONTAINER_DIAGNOSTICS_INFO", container.getDiagnosticsInfo());
        eventInfo.put("YARN_CONTAINER_EXIT_STATUS", container.getContainerExitStatus());
        eventInfo.put("YARN_CONTAINER_STATE", container.getContainerState().toString());
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST", container.getAllocatedNode().getHost());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_PORT", container.getAllocatedNode().getPort());
        entity.setOtherInfo(entityInfo);
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        this.getDispatcher().getEventHandler().handle((Event)new TimelineV1PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType.PUBLISH_ENTITY, entity, container.getContainerId().getApplicationAttemptId().getApplicationId()));
    }

    private static TimelineEntity createApplicationEntity(ApplicationId applicationId) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityType("YARN_APPLICATION");
        entity.setEntityId(applicationId.toString());
        return entity;
    }

    private static TimelineEntity createAppAttemptEntity(ApplicationAttemptId appAttemptId) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityType("YARN_APPLICATION_ATTEMPT");
        entity.setEntityId(appAttemptId.toString());
        entity.addPrimaryFilter("YARN_APPLICATION_ATTEMPT_PARENT", (Object)appAttemptId.getApplicationId().toString());
        return entity;
    }

    private static TimelineEntity createContainerEntity(ContainerId containerId) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityType("YARN_CONTAINER");
        entity.setEntityId(containerId.toString());
        entity.addPrimaryFilter("YARN_CONTAINER_PARENT", (Object)containerId.getApplicationAttemptId().toString());
        return entity;
    }

    private void putEntity(TimelineEntity entity) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Publishing the entity " + entity.getEntityId() + ", JSON-style content: " + TimelineUtils.dumpTimelineRecordtoJSON((Object)entity));
            }
            this.client.putEntities(new TimelineEntity[]{entity});
        }
        catch (Exception e) {
            LOG.error("Error when publishing entity [" + entity.getEntityType() + "," + entity.getEntityId() + "]", (Throwable)e);
        }
    }

    private class TimelineV1EventHandler
    implements EventHandler<TimelineV1PublishEvent> {
        private TimelineV1EventHandler() {
        }

        public void handle(TimelineV1PublishEvent event) {
            TimelineServiceV1Publisher.this.putEntity(event.getEntity());
        }
    }

    private class TimelineV1PublishEvent
    extends AbstractSystemMetricsPublisher.TimelinePublishEvent {
        private TimelineEntity entity;

        public TimelineV1PublishEvent(AbstractSystemMetricsPublisher.SystemMetricsEventType type, TimelineEntity entity, ApplicationId appId) {
            super(type, appId);
            this.entity = entity;
        }

        public TimelineEntity getEntity() {
            return this.entity;
        }
    }
}

