/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;

public class CSQueuePreemption {
    private final boolean preemptionDisabled;
    private final boolean intraQueuePreemptionDisabledInHierarchy;

    public CSQueuePreemption(CSQueue queue, CapacitySchedulerContext csContext, CapacitySchedulerConfiguration configuration) {
        this.preemptionDisabled = this.isQueueHierarchyPreemptionDisabled(queue, csContext, configuration);
        this.intraQueuePreemptionDisabledInHierarchy = this.isIntraQueueHierarchyPreemptionDisabled(queue, csContext, configuration);
    }

    private boolean isQueueHierarchyPreemptionDisabled(CSQueue q, CapacitySchedulerContext csContext, CapacitySchedulerConfiguration configuration) {
        boolean systemWidePreemption = csContext.getConfiguration().getBoolean("yarn.resourcemanager.scheduler.monitor.enable", false);
        CSQueue parentQ = q.getParent();
        if (!systemWidePreemption) {
            return true;
        }
        if (parentQ == null) {
            return configuration.getPreemptionDisabled(q.getQueuePath(), false);
        }
        return configuration.getPreemptionDisabled(q.getQueuePath(), parentQ.getPreemptionDisabled());
    }

    private boolean isIntraQueueHierarchyPreemptionDisabled(CSQueue q, CapacitySchedulerContext csContext, CapacitySchedulerConfiguration configuration) {
        boolean systemWideIntraQueuePreemption = csContext.getConfiguration().getBoolean("yarn.resourcemanager.monitor.capacity.preemption.intra-queue-preemption.enabled", false);
        if (!systemWideIntraQueuePreemption) {
            return true;
        }
        CSQueue parentQ = q.getParent();
        if (parentQ == null) {
            return configuration.getIntraQueuePreemptionDisabled(q.getQueuePath(), false);
        }
        return configuration.getIntraQueuePreemptionDisabled(q.getQueuePath(), parentQ.getIntraQueuePreemptionDisabledInHierarchy());
    }

    public boolean isIntraQueuePreemptionDisabledInHierarchy() {
        return this.intraQueuePreemptionDisabledInHierarchy;
    }

    public boolean isPreemptionDisabled() {
        return this.preemptionDisabled;
    }
}

