/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
@Metrics(context="yarn")
public class CapacitySchedulerMetrics {
    private static AtomicBoolean isInitialized = new AtomicBoolean(false);
    private static final MetricsInfo RECORD_INFO = Interns.info((String)"CapacitySchedulerMetrics", (String)"Metrics for the Yarn Capacity Scheduler");
    @Metric(value={"Scheduler allocate containers"})
    MutableRate allocate;
    @Metric(value={"Scheduler commit success"})
    MutableRate commitSuccess;
    @Metric(value={"Scheduler commit failure"})
    MutableRate commitFailure;
    @Metric(value={"Scheduler node update"})
    MutableRate nodeUpdate;
    @Metric(value={"Scheduler node heartbeat interval"})
    MutableQuantiles schedulerNodeHBInterval;
    private static volatile CapacitySchedulerMetrics INSTANCE = null;
    private static MetricsRegistry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CapacitySchedulerMetrics getMetrics() {
        if (isInitialized.get()) return INSTANCE;
        Class<CapacitySchedulerMetrics> clazz = CapacitySchedulerMetrics.class;
        synchronized (CapacitySchedulerMetrics.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new CapacitySchedulerMetrics();
            CapacitySchedulerMetrics.registerMetrics();
            isInitialized.set(true);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static void registerMetrics() {
        registry = new MetricsRegistry(RECORD_INFO);
        registry.tag(RECORD_INFO, "ResourceManager");
        MetricsSystem ms = DefaultMetricsSystem.instance();
        if (ms != null) {
            ms.register("CapacitySchedulerMetrics", "Metrics for the Yarn Capacity Scheduler", (Object)INSTANCE);
        }
    }

    @VisibleForTesting
    public static synchronized void destroy() {
        isInitialized.set(false);
        INSTANCE = null;
        MetricsSystem ms = DefaultMetricsSystem.instance();
        if (ms != null) {
            ms.unregisterSource("CapacitySchedulerMetrics");
        }
    }

    public void addAllocate(long latency) {
        this.allocate.add(latency);
    }

    public void addCommitSuccess(long latency) {
        this.commitSuccess.add(latency);
    }

    public void addCommitFailure(long latency) {
        this.commitFailure.add(latency);
    }

    public void addNodeUpdate(long latency) {
        this.nodeUpdate.add(latency);
    }

    @VisibleForTesting
    public long getNumOfNodeUpdate() {
        return this.nodeUpdate.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumOfAllocates() {
        return this.allocate.lastStat().numSamples();
    }

    @VisibleForTesting
    public long getNumOfCommitSuccess() {
        return this.commitSuccess.lastStat().numSamples();
    }

    public void addSchedulerNodeHBInterval(long heartbeatInterval) {
        this.schedulerNodeHBInterval.add(heartbeatInterval);
    }

    @VisibleForTesting
    public long getNumOfSchedulerNodeHBInterval() {
        return this.schedulerNodeHBInterval.getEstimator().getCount();
    }
}

