/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.Permission;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueStateManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractAutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfigValidator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ConfiguredNodeLabels;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ReservationQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.server.resourcemanager.security.AppPriorityACLsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CapacitySchedulerQueueManager
implements SchedulerQueueManager<CSQueue, CapacitySchedulerConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(CapacitySchedulerQueueManager.class);
    private static final int MAXIMUM_DYNAMIC_QUEUE_DEPTH = 2;
    private static final QueueHook NOOP = new QueueHook();
    private CapacitySchedulerContext csContext;
    private final YarnAuthorizationProvider authorizer;
    private final CSQueueStore queues = new CSQueueStore();
    private CSQueue root;
    private final RMNodeLabelsManager labelManager;
    private AppPriorityACLsManager appPriorityACLManager;
    private QueueStateManager<CSQueue, CapacitySchedulerConfiguration> queueStateManager;
    private ConfiguredNodeLabels configuredNodeLabels;

    public CapacitySchedulerQueueManager(Configuration conf, RMNodeLabelsManager labelManager, AppPriorityACLsManager appPriorityACLManager) {
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
        this.labelManager = labelManager;
        this.queueStateManager = new QueueStateManager();
        this.appPriorityACLManager = appPriorityACLManager;
        this.configuredNodeLabels = new ConfiguredNodeLabels();
    }

    @Override
    public CSQueue getRootQueue() {
        return this.root;
    }

    @Override
    public Map<String, CSQueue> getQueues() {
        return this.queues.getFullNameQueues();
    }

    @VisibleForTesting
    public Map<String, CSQueue> getShortNameQueues() {
        return this.queues.getShortNameQueues();
    }

    @Override
    public void removeQueue(String queueName) {
        this.queues.remove(queueName);
    }

    @Override
    public void addQueue(String queueName, CSQueue queue) {
        this.queues.add(queue);
    }

    @Override
    public CSQueue getQueue(String queueName) {
        return this.queues.get(queueName);
    }

    public CSQueue getQueueByFullName(String name) {
        return this.queues.getByFullName(name);
    }

    String normalizeQueueName(String name) {
        CSQueue queue = this.queues.get(name);
        if (queue != null) {
            return queue.getQueuePath();
        }
        return name;
    }

    public boolean isAmbiguous(String shortName) {
        return this.queues.isAmbiguous(shortName);
    }

    public void setCapacitySchedulerContext(CapacitySchedulerContext capacitySchedulerContext) {
        this.csContext = capacitySchedulerContext;
    }

    public void initializeQueues(CapacitySchedulerConfiguration conf) throws IOException {
        this.configuredNodeLabels = new ConfiguredNodeLabels(conf);
        this.root = CapacitySchedulerQueueManager.parseQueue(this.csContext, conf, null, "root", this.queues, this.queues, NOOP);
        CapacitySchedulerQueueManager.setQueueAcls(this.authorizer, this.appPriorityACLManager, this.queues);
        this.labelManager.reinitializeQueueLabels(this.getQueueToLabels());
        this.queueStateManager.initialize(this);
        this.root.updateClusterResource(this.csContext.getClusterResource(), new ResourceLimits(this.csContext.getClusterResource()));
        LOG.info("Initialized root queue " + this.root);
    }

    @Override
    public void reinitializeQueues(CapacitySchedulerConfiguration newConf) throws IOException {
        CSQueueStore newQueues = new CSQueueStore();
        this.configuredNodeLabels = new ConfiguredNodeLabels(newConf);
        CSQueue newRoot = CapacitySchedulerQueueManager.parseQueue(this.csContext, newConf, null, "root", newQueues, this.queues, NOOP);
        if (!this.csContext.isConfigurationMutable() || this.csContext.getRMContext().getHAServiceState() != HAServiceProtocol.HAServiceState.STANDBY) {
            CapacitySchedulerConfigValidator.validateQueueHierarchy(this.queues, newQueues, newConf);
        }
        this.updateQueues(this.queues, newQueues);
        this.root.reinitialize(newRoot, this.csContext.getClusterResource());
        CapacitySchedulerQueueManager.setQueueAcls(this.authorizer, this.appPriorityACLManager, this.queues);
        Resource clusterResource = this.csContext.getClusterResource();
        this.root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        this.labelManager.reinitializeQueueLabels(this.getQueueToLabels());
        this.queueStateManager.initialize(this);
    }

    static CSQueue parseQueue(CapacitySchedulerContext csContext, CapacitySchedulerConfiguration conf, CSQueue parent, String queueName, CSQueueStore newQueues, CSQueueStore oldQueues, QueueHook hook) throws IOException {
        CSQueue queue;
        String fullQueueName = parent == null ? queueName : parent.getQueuePath() + "." + queueName;
        String[] staticChildQueueNames = conf.getQueues(fullQueueName);
        List<Object> childQueueNames = staticChildQueueNames != null ? Arrays.asList(staticChildQueueNames) : Collections.emptyList();
        boolean isReservableQueue = conf.isReservable(fullQueueName);
        boolean isAutoCreateEnabled = conf.isAutoCreateChildQueueEnabled(fullQueueName);
        boolean isAutoQueueCreationV2Enabled = conf.isAutoQueueCreationV2Enabled(fullQueueName);
        boolean isDynamicParent = false;
        CSQueue oldQueue = oldQueues.get(fullQueueName);
        if (oldQueue instanceof ParentQueue) {
            isDynamicParent = ((ParentQueue)oldQueue).isDynamicQueue();
        }
        if (childQueueNames.size() == 0 && !isDynamicParent && !isAutoQueueCreationV2Enabled) {
            if (null == parent) {
                throw new IllegalStateException("Queue configuration missing child queue names for " + queueName);
            }
            if (isReservableQueue) {
                queue = new PlanQueue(csContext, queueName, parent, oldQueues.get(fullQueueName));
                String defReservationId = queueName + "-default";
                ArrayList<CSQueue> childQueues = new ArrayList<CSQueue>();
                ReservationQueue resQueue = new ReservationQueue(csContext, defReservationId, (PlanQueue)queue);
                try {
                    resQueue.setEntitlement(new QueueEntitlement(1.0f, 1.0f));
                }
                catch (SchedulerDynamicEditException schedulerDynamicEditException) {
                    throw new IllegalStateException((Throwable)((Object)schedulerDynamicEditException));
                }
                childQueues.add(resQueue);
                ((PlanQueue)queue).setChildQueues(childQueues);
                newQueues.add(resQueue);
            } else if (isAutoCreateEnabled) {
                queue = new ManagedParentQueue(csContext, queueName, parent, oldQueues.get(fullQueueName));
            } else {
                queue = new LeafQueue(csContext, queueName, parent, oldQueues.get(fullQueueName));
                queue = hook.hook(queue);
            }
        } else {
            if (isReservableQueue) {
                throw new IllegalStateException("Only Leaf Queues can be reservable for " + fullQueueName);
            }
            ParentQueue parentQueue = isAutoCreateEnabled ? new ManagedParentQueue(csContext, queueName, parent, oldQueues.get(fullQueueName)) : new ParentQueue(csContext, queueName, parent, oldQueues.get(fullQueueName));
            queue = hook.hook(parentQueue);
            ArrayList<CSQueue> childQueues = new ArrayList<CSQueue>();
            for (String string : childQueueNames) {
                CSQueue childQueue = CapacitySchedulerQueueManager.parseQueue(csContext, conf, queue, string, newQueues, oldQueues, hook);
                childQueues.add(childQueue);
            }
            parentQueue.setChildQueues(childQueues);
        }
        newQueues.add(queue);
        LOG.info("Initialized queue: " + fullQueueName);
        return queue;
    }

    private void updateQueues(CSQueueStore existingQueues, CSQueueStore newQueues) {
        CapacitySchedulerConfiguration conf = this.csContext.getConfiguration();
        for (CSQueue queue : newQueues.getQueues()) {
            if (existingQueues.get(queue.getQueuePath()) != null) continue;
            existingQueues.add(queue);
        }
        for (CSQueue queue : existingQueues.getQueues()) {
            boolean isDanglingDynamicQueue = this.isDanglingDynamicQueue(newQueues, existingQueues, queue);
            boolean isRemovable = isDanglingDynamicQueue || !this.isDynamicQueue(queue) && newQueues.get(queue.getQueuePath()) == null && (!(queue instanceof AutoCreatedLeafQueue) || !conf.isAutoCreateChildQueueEnabled(queue.getParent().getQueuePath()));
            if (!isRemovable) continue;
            existingQueues.remove(queue);
        }
    }

    @VisibleForTesting
    public static void setQueueAcls(YarnAuthorizationProvider authorizer, AppPriorityACLsManager appPriorityACLManager, CSQueueStore queues) throws IOException {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (CSQueue queue : queues.getQueues()) {
            AbstractCSQueue csQueue = (AbstractCSQueue)queue;
            permissions.add(new Permission(csQueue.getPrivilegedEntity(), csQueue.getACLs()));
            if (!(queue instanceof LeafQueue)) continue;
            LeafQueue lQueue = (LeafQueue)queue;
            appPriorityACLManager.clearPriorityACLs(lQueue.getQueuePath());
            appPriorityACLManager.addPrioirityACLs(lQueue.getPriorityACLs(), lQueue.getQueuePath());
        }
        authorizer.setPermission(permissions, UserGroupInformation.getCurrentUser());
    }

    public LeafQueue getAndCheckLeafQueue(String queue) throws YarnException {
        CSQueue ret = this.getQueue(queue);
        if (ret == null) {
            throw new YarnException("The specified Queue: " + queue + " doesn't exist");
        }
        if (!(ret instanceof LeafQueue)) {
            throw new YarnException("The specified Queue: " + queue + " is not a Leaf Queue.");
        }
        return (LeafQueue)ret;
    }

    public Priority getDefaultPriorityForQueue(String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (null == queue || null == queue.getDefaultApplicationPriority()) {
            return Priority.newInstance((int)CapacitySchedulerConfiguration.DEFAULT_CONFIGURATION_APPLICATION_PRIORITY);
        }
        return Priority.newInstance((int)queue.getDefaultApplicationPriority().getPriority());
    }

    private Map<String, Set<String>> getQueueToLabels() {
        HashMap<String, Set<String>> queueToLabels = new HashMap<String, Set<String>>();
        for (CSQueue queue : this.getQueues().values()) {
            queueToLabels.put(queue.getQueuePath(), queue.getAccessibleNodeLabels());
        }
        return queueToLabels;
    }

    @InterfaceAudience.Private
    public QueueStateManager<CSQueue, CapacitySchedulerConfiguration> getQueueStateManager() {
        return this.queueStateManager;
    }

    public void removeLegacyDynamicQueue(String queueName) throws SchedulerDynamicEditException {
        LOG.info("Removing queue: " + queueName);
        CSQueue q = this.getQueue(queueName);
        if (q == null || !AbstractAutoCreatedLeafQueue.class.isAssignableFrom(q.getClass())) {
            throw new SchedulerDynamicEditException("The queue that we are asked to remove (" + queueName + ") is not a AutoCreatedLeafQueue or ReservationQueue");
        }
        AbstractAutoCreatedLeafQueue disposableLeafQueue = (AbstractAutoCreatedLeafQueue)q;
        if (disposableLeafQueue.getNumApplications() > 0) {
            throw new SchedulerDynamicEditException("The queue " + queueName + " is not empty " + disposableLeafQueue.getApplications().size() + " active apps " + disposableLeafQueue.getPendingApplications().size() + " pending apps");
        }
        ((AbstractManagedParentQueue)disposableLeafQueue.getParent()).removeChildQueue(q);
        this.removeQueue(queueName);
        LOG.info("Removal of AutoCreatedLeafQueue " + queueName + " has succeeded");
    }

    public void addLegacyDynamicQueue(Queue queue) throws SchedulerDynamicEditException, IOException {
        if (queue == null) {
            throw new SchedulerDynamicEditException("Queue specified is null. Should be an implementation of AbstractAutoCreatedLeafQueue");
        }
        if (!AbstractAutoCreatedLeafQueue.class.isAssignableFrom(queue.getClass())) {
            throw new SchedulerDynamicEditException("Queue is not an implementation of AbstractAutoCreatedLeafQueue : " + queue.getClass());
        }
        AbstractAutoCreatedLeafQueue newQueue = (AbstractAutoCreatedLeafQueue)queue;
        if (newQueue.getParent() == null || !AbstractManagedParentQueue.class.isAssignableFrom(newQueue.getParent().getClass())) {
            throw new SchedulerDynamicEditException("ParentQueue for " + newQueue + " is not properly set (should be set and be a PlanQueue or ManagedParentQueue)");
        }
        AbstractManagedParentQueue parent = (AbstractManagedParentQueue)newQueue.getParent();
        String queuePath = newQueue.getQueuePath();
        parent.addChildQueue(newQueue);
        this.addQueue(queuePath, newQueue);
        LOG.info("Creation of AutoCreatedLeafQueue " + newQueue + " succeeded");
    }

    public LeafQueue createQueue(QueuePath queue) throws YarnException, IOException {
        String leafQueueName = queue.getLeafName();
        String parentQueueName = queue.getParent();
        if (!StringUtils.isEmpty((CharSequence)parentQueueName)) {
            CSQueue parentQueue = this.getQueue(parentQueueName);
            if (parentQueue != null && this.csContext.getConfiguration().isAutoCreateChildQueueEnabled(parentQueue.getQueuePath())) {
                return this.createLegacyAutoQueue(queue);
            }
            return this.createAutoQueue(queue);
        }
        throw new SchedulerDynamicEditException("Could not auto-create leaf queue for " + leafQueueName + ". Queue mapping does not specify which parent queue it needs to be created under.");
    }

    public List<String> determineMissingParents(QueuePath queue) throws SchedulerDynamicEditException {
        CSQueue firstExistingParent;
        if (!queue.hasParent()) {
            throw new SchedulerDynamicEditException("Can not auto create queue " + queue.getFullPath() + " due to missing ParentQueue path.");
        }
        if (this.isAmbiguous(queue.getParent())) {
            throw new SchedulerDynamicEditException("Could not auto-create queue " + queue + " due to ParentQueue " + queue.getParent() + " being ambiguous.");
        }
        int firstStaticParentDistance = 1;
        StringBuilder parentCandidate = new StringBuilder(queue.getParent());
        LinkedList<String> parentsToCreate = new LinkedList<String>();
        CSQueue firstExistingStaticParent = firstExistingParent = this.getQueue(parentCandidate.toString());
        while (this.isNonStaticParent(firstExistingStaticParent) && parentCandidate.length() != 0) {
            if (++firstStaticParentDistance > 2) {
                throw new SchedulerDynamicEditException("Could not auto create queue " + queue.getFullPath() + ". The distance of the LeafQueue from the first static ParentQueue is " + firstStaticParentDistance + ", which is above the limit.");
            }
            if (firstExistingParent == null) {
                parentsToCreate.addFirst(parentCandidate.toString());
            }
            int lastIndex = parentCandidate.lastIndexOf(".");
            parentCandidate.setLength(Math.max(lastIndex, 0));
            if (firstExistingParent == null) {
                firstExistingParent = this.getQueue(parentCandidate.toString());
            }
            firstExistingStaticParent = this.getQueue(parentCandidate.toString());
        }
        if (!(firstExistingParent instanceof ParentQueue)) {
            throw new SchedulerDynamicEditException("Could not auto create hierarchy of " + queue.getFullPath() + ". Queue " + queue.getParent() + " is not a ParentQueue.");
        }
        ParentQueue existingParentQueue = (ParentQueue)firstExistingParent;
        if (!existingParentQueue.isEligibleForAutoQueueCreation()) {
            throw new SchedulerDynamicEditException("Auto creation of queue " + queue.getFullPath() + " is not enabled under parent " + existingParentQueue.getQueuePath());
        }
        return parentsToCreate;
    }

    public ConfiguredNodeLabels getConfiguredNodeLabels() {
        return this.configuredNodeLabels;
    }

    @VisibleForTesting
    public void reinitConfiguredNodeLabels(CapacitySchedulerConfiguration conf) {
        this.configuredNodeLabels = new ConfiguredNodeLabels(conf);
    }

    private LeafQueue createAutoQueue(QueuePath queue) throws SchedulerDynamicEditException {
        List<String> parentsToCreate = this.determineMissingParents(queue);
        String existingParentName = queue.getParent();
        if (!parentsToCreate.isEmpty()) {
            existingParentName = parentsToCreate.get(0).substring(0, parentsToCreate.get(0).lastIndexOf("."));
        }
        ParentQueue existingParentQueue = (ParentQueue)this.getQueue(existingParentName);
        for (String current : parentsToCreate) {
            existingParentQueue = existingParentQueue.addDynamicParentQueue(current);
            this.addQueue(existingParentQueue.getQueuePath(), existingParentQueue);
        }
        LeafQueue leafQueue = existingParentQueue.addDynamicLeafQueue(queue.getFullPath());
        this.addQueue(leafQueue.getQueuePath(), leafQueue);
        return leafQueue;
    }

    private LeafQueue createLegacyAutoQueue(QueuePath queue) throws IOException, SchedulerDynamicEditException {
        CSQueue parentQueue = this.getQueue(queue.getParent());
        ManagedParentQueue autoCreateEnabledParentQueue = (ManagedParentQueue)parentQueue;
        AutoCreatedLeafQueue autoCreatedLeafQueue = new AutoCreatedLeafQueue(this.csContext, queue.getLeafName(), autoCreateEnabledParentQueue);
        this.addLegacyDynamicQueue(autoCreatedLeafQueue);
        return autoCreatedLeafQueue;
    }

    private boolean isNonStaticParent(CSQueue queue) {
        return !(queue instanceof AbstractCSQueue) || ((AbstractCSQueue)queue).isDynamicQueue();
    }

    private boolean isDynamicQueue(CSQueue queue) {
        return queue instanceof AbstractCSQueue && ((AbstractCSQueue)queue).isDynamicQueue();
    }

    private boolean isDanglingDynamicQueue(CSQueueStore newQueues, CSQueueStore existingQueues, CSQueue queue) {
        if (!this.isDynamicQueue(queue)) {
            return false;
        }
        if (queue.getParent() == null) {
            return true;
        }
        if (newQueues.get(queue.getParent().getQueuePath()) != null) {
            return false;
        }
        CSQueue parent = existingQueues.get(queue.getParent().getQueuePath());
        if (parent == null) {
            return true;
        }
        return !this.isDynamicQueue(parent);
    }

    static class QueueHook {
        QueueHook() {
        }

        public CSQueue hook(CSQueue queue) {
            return queue;
        }
    }
}

