/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanQueue
extends AbstractManagedParentQueue {
    private static final Logger LOG = LoggerFactory.getLogger(PlanQueue.class);
    private int maxAppsForReservation;
    private int maxAppsPerUserForReservation;
    private float userLimit;
    private float userLimitFactor;
    protected CapacitySchedulerContext schedulerContext;
    private boolean showReservationsAsQueues;

    public PlanQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        super(cs, queueName, parent, old);
        this.updateAbsoluteCapacities();
        this.schedulerContext = cs;
        CapacitySchedulerConfiguration conf = cs.getConfiguration();
        String queuePath = super.getQueuePath();
        int maxAppsForReservation = conf.getMaximumApplicationsPerQueue(queuePath);
        this.showReservationsAsQueues = conf.getShowReservationAsQueues(queuePath);
        if (maxAppsForReservation < 0) {
            maxAppsForReservation = (int)(10000.0f * super.getAbsoluteCapacity());
        }
        float configuredUserLimit = conf.getUserLimit(queuePath);
        float configuredUserLimitFactor = conf.getUserLimitFactor(queuePath);
        int configuredMaxAppsPerUserForReservation = (int)((float)maxAppsForReservation * (configuredUserLimit / 100.0f) * configuredUserLimitFactor);
        if (configuredUserLimitFactor == -1.0f) {
            configuredMaxAppsPerUserForReservation = maxAppsForReservation;
        }
        this.updateQuotas(configuredUserLimit, configuredUserLimitFactor, maxAppsForReservation, configuredMaxAppsPerUserForReservation);
        StringBuffer queueInfo = new StringBuffer();
        queueInfo.append("Created Plan Queue: ").append(queueName).append("\nwith capacity: [").append(super.getCapacity()).append("]\nwith max capacity: [").append(super.getMaximumCapacity()).append("\nwith max reservation apps: [").append(maxAppsForReservation).append("]\nwith max reservation apps per user: [").append(configuredMaxAppsPerUserForReservation).append("]\nwith user limit: [").append(configuredUserLimit).append("]\nwith user limit factor: [").append(configuredUserLimitFactor).append("].");
        LOG.info(queueInfo.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        this.writeLock.lock();
        try {
            if (!(newlyParsedQueue instanceof PlanQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
                throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
            }
            PlanQueue newlyParsedParentQueue = (PlanQueue)newlyParsedQueue;
            if (newlyParsedParentQueue.getChildQueues().size() != 1) {
                throw new IOException("Reservable Queue should not have sub-queues in theconfiguration expect the default reservation queue");
            }
            this.setupQueueConfigs(clusterResource, this.csContext.getConfiguration());
            this.updateQuotas(newlyParsedParentQueue.userLimit, newlyParsedParentQueue.userLimitFactor, newlyParsedParentQueue.maxAppsForReservation, newlyParsedParentQueue.maxAppsPerUserForReservation);
            for (CSQueue res : this.getChildQueues()) {
                res.reinitialize(res, clusterResource);
            }
            this.showReservationsAsQueues = newlyParsedParentQueue.showReservationsAsQueues;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateQuotas(float newUserLimit, float newUserLimitFactor, int newMaxAppsForReservation, int newMaxAppsPerUserForReservation) {
        this.userLimit = newUserLimit;
        this.userLimitFactor = newUserLimitFactor;
        this.maxAppsForReservation = newMaxAppsForReservation;
        this.maxAppsPerUserForReservation = newMaxAppsPerUserForReservation;
    }

    public int getMaxApplicationsForReservations() {
        return this.maxAppsForReservation;
    }

    public int getMaxApplicationsPerUserForReservation() {
        return this.maxAppsPerUserForReservation;
    }

    public float getUserLimitForReservation() {
        return this.userLimit;
    }

    public float getUserLimitFactor() {
        return this.userLimitFactor;
    }

    public boolean showReservationsAsQueues() {
        return this.showReservationsAsQueues;
    }
}

