/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.yarn.api.records.NodeId;

public class ClusterNode {
    private final AtomicInteger queueLength = new AtomicInteger(0);
    private final AtomicInteger queueWaitTime = new AtomicInteger(-1);
    private long timestamp;
    final NodeId nodeId;
    private int queueCapacity = 0;
    private final HashSet<String> labels;

    public ClusterNode(NodeId nodeId) {
        this.nodeId = nodeId;
        this.labels = new HashSet();
        this.updateTimestamp();
    }

    public ClusterNode setQueueLength(int qLength) {
        this.queueLength.set(qLength);
        return this;
    }

    public ClusterNode setQueueWaitTime(int wTime) {
        this.queueWaitTime.set(wTime);
        return this;
    }

    public ClusterNode updateTimestamp() {
        this.timestamp = System.currentTimeMillis();
        return this;
    }

    public ClusterNode setQueueCapacity(int capacity) {
        this.queueCapacity = capacity;
        return this;
    }

    public ClusterNode setNodeLabels(Collection<String> labelsToAdd) {
        this.labels.clear();
        this.labels.addAll(labelsToAdd);
        return this;
    }

    public boolean hasLabel(String label) {
        return this.labels.contains(label);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public AtomicInteger getQueueLength() {
        return this.queueLength;
    }

    public AtomicInteger getQueueWaitTime() {
        return this.queueWaitTime;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public boolean isQueueFull() {
        return this.queueCapacity > 0 && this.queueLength.get() >= this.queueCapacity;
    }
}

