/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.CapacityConverter;

public class WeightToPercentConverter
implements CapacityConverter {
    private static final BigDecimal HUNDRED = new BigDecimal(100).setScale(3);
    private static final BigDecimal ZERO = new BigDecimal(0).setScale(3);

    @Override
    public void convertWeightsForChildQueues(FSQueue queue, Configuration csConfig) {
        List<FSQueue> children = queue.getChildQueues();
        int totalWeight = this.getTotalWeight(children);
        Pair<Map<String, BigDecimal>, Boolean> result = this.getCapacities(totalWeight, children);
        Map capacities = (Map)result.getLeft();
        boolean shouldAllowZeroSumCapacity = (Boolean)result.getRight();
        capacities.forEach((key, value) -> csConfig.set("yarn.scheduler.capacity." + key + ".capacity", value.toString()));
        if (shouldAllowZeroSumCapacity) {
            String queueName = queue.getName();
            csConfig.setBoolean("yarn.scheduler.capacity." + queueName + ".allow-zero-capacity-sum", true);
        }
    }

    private Pair<Map<String, BigDecimal>, Boolean> getCapacities(int totalWeight, List<FSQueue> children) {
        if (children.size() == 0) {
            return Pair.of(new HashMap(), (Object)false);
        }
        if (children.size() == 1) {
            HashMap<String, BigDecimal> capacity = new HashMap<String, BigDecimal>();
            String queueName = children.get(0).getName();
            capacity.put(queueName, HUNDRED);
            return Pair.of(capacity, (Object)false);
        }
        HashMap<String, BigDecimal> capacities = new HashMap<String, BigDecimal>();
        children.stream().forEach(queue -> {
            BigDecimal pct;
            if (totalWeight == 0) {
                pct = ZERO;
            } else {
                BigDecimal total = new BigDecimal(totalWeight);
                BigDecimal weight = new BigDecimal(queue.getWeight());
                pct = weight.setScale(5).divide(total, RoundingMode.HALF_UP).multiply(HUNDRED).setScale(3);
            }
            capacities.put(queue.getName(), pct);
        });
        BigDecimal totalPct = ZERO;
        for (Map.Entry entry : capacities.entrySet()) {
            totalPct = totalPct.add((BigDecimal)entry.getValue());
        }
        boolean shouldAllowZeroSumCapacity = false;
        if (!totalPct.equals(HUNDRED)) {
            shouldAllowZeroSumCapacity = this.fixCapacities(capacities, totalPct);
        }
        return Pair.of(capacities, (Object)shouldAllowZeroSumCapacity);
    }

    @VisibleForTesting
    boolean fixCapacities(Map<String, BigDecimal> capacities, BigDecimal totalPct) {
        boolean shouldAllowZeroSumCapacity = false;
        List sortedEntries = capacities.entrySet().stream().sorted(new Comparator<Map.Entry<String, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<String, BigDecimal> e1, Map.Entry<String, BigDecimal> e2) {
                return e2.getValue().compareTo(e1.getValue());
            }
        }).collect(Collectors.toList());
        String highestCapacityQueue = (String)((Map.Entry)sortedEntries.get(0)).getKey();
        BigDecimal highestCapacity = (BigDecimal)((Map.Entry)sortedEntries.get(0)).getValue();
        if (highestCapacity.equals(ZERO)) {
            shouldAllowZeroSumCapacity = true;
        } else {
            BigDecimal diff = HUNDRED.subtract(totalPct);
            BigDecimal correctedHighest = highestCapacity.add(diff);
            capacities.put(highestCapacityQueue, correctedHighest);
        }
        return shouldAllowZeroSumCapacity;
    }

    private int getTotalWeight(List<FSQueue> children) {
        double sum = children.stream().mapToDouble(c -> c.getWeight()).sum();
        return (int)sum;
    }
}

