/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.CapacityQueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.FairQueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.GenericQueueACLsManager;

public abstract class QueueACLsManager {
    ResourceScheduler scheduler;
    boolean isACLsEnable;
    YarnAuthorizationProvider authorizer;

    @VisibleForTesting
    public QueueACLsManager(Configuration conf) {
        this(null, new Configuration());
    }

    public QueueACLsManager(ResourceScheduler scheduler, Configuration conf) {
        this.scheduler = scheduler;
        this.isACLsEnable = conf.getBoolean("yarn.acl.enable", false);
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
    }

    public static QueueACLsManager getQueueACLsManager(ResourceScheduler scheduler, Configuration conf) {
        if (scheduler instanceof CapacityScheduler) {
            return new CapacityQueueACLsManager(scheduler, conf);
        }
        if (scheduler instanceof FairScheduler) {
            return new FairQueueACLsManager(scheduler, conf);
        }
        return new GenericQueueACLsManager(scheduler, conf);
    }

    public abstract boolean checkAccess(UserGroupInformation var1, QueueACL var2, RMApp var3, String var4, List<String> var5);

    public abstract boolean checkAccess(UserGroupInformation var1, QueueACL var2, RMApp var3, String var4, List<String> var5, String var6);
}

