/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.QueueCapacitiesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourcesInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.UsersInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CapacitySchedulerLeafQueueInfo
extends CapacitySchedulerQueueInfo {
    protected int numActiveApplications;
    protected int numPendingApplications;
    protected int numContainers;
    protected int maxApplications;
    protected int maxApplicationsPerUser;
    protected float userLimit;
    protected UsersInfo users;
    protected float userLimitFactor;
    protected float configuredMaxAMResourceLimit;
    protected ResourceInfo AMResourceLimit;
    protected ResourceInfo usedAMResource;
    protected ResourceInfo userAMResourceLimit;
    protected boolean preemptionDisabled;
    protected boolean intraQueuePreemptionDisabled;
    protected int defaultPriority;
    protected boolean isAutoCreatedLeafQueue;
    protected long maxApplicationLifetime;
    protected long defaultApplicationLifetime;
    @XmlTransient
    protected String orderingPolicyDisplayName;

    CapacitySchedulerLeafQueueInfo() {
    }

    CapacitySchedulerLeafQueueInfo(CapacityScheduler cs, LeafQueue q) {
        super(cs, q);
        this.numActiveApplications = q.getNumActiveApplications();
        this.numPendingApplications = q.getNumPendingApplications();
        this.numContainers = q.getNumContainers();
        this.maxApplications = q.getMaxApplications();
        this.maxApplicationsPerUser = q.getMaxApplicationsPerUser();
        this.userLimit = q.getUserLimit();
        this.users = new UsersInfo(q.getUsersManager().getUsersInfo());
        this.userLimitFactor = q.getUserLimitFactor();
        this.configuredMaxAMResourceLimit = q.getMaxAMResourcePerQueuePercent();
        this.AMResourceLimit = new ResourceInfo(q.getAMResourceLimit());
        this.usedAMResource = new ResourceInfo(q.getQueueResourceUsage().getAMUsed());
        this.preemptionDisabled = q.getPreemptionDisabled();
        this.intraQueuePreemptionDisabled = q.getIntraQueuePreemptionDisabled();
        this.orderingPolicyDisplayName = q.getOrderingPolicy().getInfo();
        this.orderingPolicyInfo = q.getOrderingPolicy().getConfigName();
        this.defaultPriority = q.getDefaultApplicationPriority().getPriority();
        ArrayList<UserInfo> usersList = this.users.getUsersList();
        this.userAMResourceLimit = usersList.isEmpty() ? this.resources.getPartitionResourceUsageInfo("").getAMLimit() : usersList.get(0).getResourceUsageInfo().getPartitionResourceUsageInfo("").getAMLimit();
        if (q instanceof AutoCreatedLeafQueue) {
            this.isAutoCreatedLeafQueue = true;
        }
        this.defaultApplicationLifetime = q.getDefaultApplicationLifetime();
        this.maxApplicationLifetime = q.getMaximumApplicationLifetime();
    }

    @Override
    protected void populateQueueResourceUsage(ResourceUsage queueResourceUsage) {
        this.resources = new ResourcesInfo(queueResourceUsage);
    }

    @Override
    protected void populateQueueCapacities(QueueCapacities qCapacities, QueueResourceQuotas qResQuotas) {
        this.capacities = new QueueCapacitiesInfo(qCapacities, qResQuotas);
    }

    public int getNumActiveApplications() {
        return this.numActiveApplications;
    }

    public int getNumPendingApplications() {
        return this.numPendingApplications;
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    public int getMaxApplications() {
        return this.maxApplications;
    }

    public int getMaxApplicationsPerUser() {
        return this.maxApplicationsPerUser;
    }

    public float getUserLimit() {
        return this.userLimit;
    }

    public UsersInfo getUsers() {
        return this.users;
    }

    public float getUserLimitFactor() {
        return this.userLimitFactor;
    }

    public float getConfiguredMaxAMResourceLimit() {
        return this.configuredMaxAMResourceLimit;
    }

    public ResourceInfo getAMResourceLimit() {
        return this.AMResourceLimit;
    }

    public ResourceInfo getUsedAMResource() {
        return this.usedAMResource;
    }

    public ResourceInfo getUserAMResourceLimit() {
        return this.userAMResourceLimit;
    }

    public boolean getPreemptionDisabled() {
        return this.preemptionDisabled;
    }

    public boolean getIntraQueuePreemptionDisabled() {
        return this.intraQueuePreemptionDisabled;
    }

    public String getOrderingPolicyDisplayName() {
        return this.orderingPolicyDisplayName;
    }

    public int getDefaultApplicationPriority() {
        return this.defaultPriority;
    }

    public boolean isAutoCreatedLeafQueue() {
        return this.isAutoCreatedLeafQueue;
    }

    public long getDefaultApplicationLifetime() {
        return this.defaultApplicationLifetime;
    }

    public long getMaxApplicationLifetime() {
        return this.maxApplicationLifetime;
    }
}

