/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.NullGroupsMapping;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.CSMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.MockQueueHierarchyBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.placement.QueueMapping;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRule;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.PrimaryGroupMapping;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SimpleGroupsMapping;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestUserGroupMappingPlacementRule {
    private final YarnConfiguration conf = new YarnConfiguration();

    @Before
    public void setup() {
        this.conf.setClass("hadoop.security.group.mapping", SimpleGroupsMapping.class, GroupMappingServiceProvider.class);
    }

    private void createQueueHierarchy(CapacitySchedulerQueueManager queueManager) {
        MockQueueHierarchyBuilder.create().withQueueManager(queueManager).withQueue("root.default").withQueue("root.agroup.a").withQueue("root.bgroup").withQueue("root.usergroup.c").withQueue("root.asubgroup2").withQueue("root.bsubgroup2.b").withQueue("root.users.primarygrouponly").withQueue("root.devs.primarygrouponly").withQueue("root.admins.primarygrouponly").withManagedParentQueue("root.managedParent").build();
        Mockito.when((Object)queueManager.getQueue((String)Mockito.isNull())).thenReturn(null);
    }

    private void verifyQueueMapping(QueueMappingTestData queueMappingTestData) throws IOException, YarnException {
        QueueMapping queueMapping = queueMappingTestData.queueMapping;
        String inputUser = queueMappingTestData.inputUser;
        String inputQueue = queueMappingTestData.inputQueue;
        String expectedQueue = queueMappingTestData.expectedQueue;
        boolean overwrite = queueMappingTestData.overwrite;
        String expectedParentQueue = queueMappingTestData.expectedParentQueue;
        MappingRule rule = MappingRule.createLegacyRule((String)queueMapping.getType().toString(), (String)queueMapping.getSource(), (String)queueMapping.getFullPath());
        CSMappingPlacementRule engine = this.setupEngine(rule, overwrite);
        ApplicationSubmissionContext asc = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        asc.setQueue(inputQueue);
        ApplicationPlacementContext ctx = engine.getPlacementForApp(asc, inputUser);
        Assert.assertEquals((String)"Queue", (Object)expectedQueue, (Object)(ctx != null ? ctx.getQueue() : inputQueue));
        if (ctx != null && expectedParentQueue != null) {
            Assert.assertEquals((String)"Parent Queue", (Object)expectedParentQueue, (Object)ctx.getParentQueue());
        }
    }

    CSMappingPlacementRule setupEngine(MappingRule rule, boolean override) throws IOException {
        CapacitySchedulerConfiguration csConf = (CapacitySchedulerConfiguration)Mockito.mock(CapacitySchedulerConfiguration.class);
        Mockito.when((Object)csConf.getMappingRules()).thenReturn(Collections.singletonList(rule));
        Mockito.when((Object)csConf.getOverrideWithQueueMappings()).thenReturn((Object)override);
        CapacitySchedulerQueueManager queueManager = (CapacitySchedulerQueueManager)Mockito.mock(CapacitySchedulerQueueManager.class);
        this.createQueueHierarchy(queueManager);
        CSMappingPlacementRule engine = new CSMappingPlacementRule();
        Groups groups = new Groups((Configuration)this.conf);
        CapacityScheduler cs = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)cs.getConfiguration()).thenReturn((Object)csConf);
        Mockito.when((Object)cs.getCapacitySchedulerQueueManager()).thenReturn((Object)queueManager);
        engine.setGroups(groups);
        engine.setFailOnConfigError(false);
        engine.initialize((ResourceScheduler)cs);
        return engine;
    }

    @Test
    public void testSecondaryGroupMapping() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%secondary_group").build()).inputUser("a").expectedQueue("asubgroup2").expectedParentQueue("root").build());
        this.conf.setClass("hadoop.security.group.mapping", PrimaryGroupMapping.class, GroupMappingServiceProvider.class);
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%secondary_group").build()).inputUser("a").expectedQueue("default").build());
    }

    @Test
    public void testNullGroupMapping() throws IOException, YarnException {
        this.conf.setClass("hadoop.security.group.mapping", NullGroupsMapping.class, GroupMappingServiceProvider.class);
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%secondary_group").build()).inputUser("a").expectedQueue("default").build());
    }

    @Test
    public void testSimpleUserMappingToSpecificQueue() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("a").queue("a").build()).inputUser("a").expectedQueue("a").build());
    }

    @Test
    public void testSimpleGroupMappingToSpecificQueue() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source("agroup").queue("a").build()).inputUser("a").expectedQueue("a").build());
    }

    @Test
    public void testUserMappingToSpecificQueueForEachUser() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("b").build()).inputUser("a").expectedQueue("b").build());
    }

    @Test
    public void testUserMappingToQueueNamedAsUsername() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%user").build()).inputUser("a").expectedQueue("a").build());
    }

    @Test
    public void testUserMappingToQueueNamedGroupOfTheUser() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%primary_group").build()).inputUser("b").expectedQueue("bgroup").expectedParentQueue("root").build());
    }

    @Test
    public void testUserMappingToQueueNamedAsUsernameWithPrimaryGroupAsParentQueue() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%user").parentQueue("%primary_group").build()).inputUser("a").expectedQueue("a").expectedParentQueue("root.agroup").build());
    }

    @Test
    public void testUserMappingToPrimaryGroupInvalidNestedPlaceholder() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%random").parentQueue("%primary_group").build()).inputUser("a").expectedQueue("default").build());
    }

    @Test
    public void testUserMappingToSecondaryGroupInvalidNestedPlaceholder() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%random").parentQueue("%secondary_group").build()).inputUser("a").expectedQueue("default").build());
    }

    @Test
    public void testUserMappingDiffersFromSubmitterQueueDoesNotExist() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("a").queue("%random").build()).inputUser("xyz").expectedQueue("default").build());
    }

    @Test
    public void testSpecificUserMappingToPrimaryGroup() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("b").queue("%primary_group").build()).inputUser("b").expectedQueue("bgroup").build());
    }

    @Test
    public void testSpecificUserMappingToSecondaryGroup() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("a").queue("%secondary_group").build()).inputUser("a").expectedQueue("asubgroup2").build());
    }

    @Test
    public void testSpecificUserMappingWithNoSecondaryGroup() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("nosecondarygroupuser").queue("%secondary_group").build()).inputUser("nosecondarygroupuser").expectedQueue("default").build());
    }

    @Test
    public void testGenericUserMappingWithNoSecondaryGroup() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%user").parentQueue("%secondary_group").build()).inputUser("nosecondarygroupuser").expectedQueue("default").build());
    }

    @Test
    public void testUserMappingToNestedUserPrimaryGroupWithAmbiguousQueues() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%user").parentQueue("%primary_group").build()).inputUser("nosecondarygroupuser").expectedQueue("default").build());
    }

    @Test
    public void testResolvedQueueIsNotManaged() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%user").parentQueue("%primary_group").build()).inputUser("admins").expectedQueue("default").build());
    }

    @Test
    public void testUserMappingToPrimaryGroupWithAmbiguousQueues() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%primary_group").build()).inputUser("nosecondarygroupuser").expectedQueue("default").build());
    }

    @Test
    public void testUserMappingToQueueNamedAsUsernameWithSecondaryGroupAsParentQueue() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%user").parentQueue("%secondary_group").build()).inputUser("b").expectedQueue("b").expectedParentQueue("root.bsubgroup2").build());
    }

    @Test
    public void testGroupMappingToStaticQueue() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source("asubgroup1").queue("a").build()).inputUser("a").expectedQueue("a").build());
    }

    @Test
    public void testUserMappingToQueueNamedAsGroupNameWithRootAsParentQueue() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%primary_group").parentQueue("root").build()).inputUser("b").expectedQueue("bgroup").expectedParentQueue("root").build());
    }

    @Test
    public void testUserMappingToPrimaryGroupQueueDoesNotExistUnmanagedParent() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%primary_group").parentQueue("bsubgroup2").build()).inputUser("abc").expectedQueue("default").build());
    }

    @Test
    public void testUserMappingToPrimaryGroupQueueDoesNotExistManagedParent() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%primary_group").parentQueue("managedParent").build()).inputUser("abc").expectedQueue("abcgroup").expectedParentQueue("root.managedParent").build());
    }

    @Test
    public void testUserMappingToSecondaryGroupQueueDoesNotExist() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%secondary_group").parentQueue("bsubgroup2").build()).inputUser("abc").expectedQueue("default").build());
    }

    @Test
    public void testUserMappingToSecondaryGroupQueueUnderParent() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("%user").queue("%secondary_group").parentQueue("root").build()).inputUser("a").expectedQueue("asubgroup2").expectedParentQueue("root").build());
    }

    @Test
    public void testUserMappingToSpecifiedQueueOverwritesInputQueueFromMapping() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("user").queue("a").build()).inputUser("user").inputQueue("b").expectedQueue("a").overwrite(true).build());
    }

    @Test
    public void testUserMappingToExplicitlySpecifiedQueue() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.USER).source("user").queue("a").build()).inputUser("user").inputQueue("b").expectedQueue("b").build());
    }

    @Test
    public void testGroupMappingToExplicitlySpecifiedQueue() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source("usergroup").queue("%user").parentQueue("usergroup").build()).inputUser("user").inputQueue("c").expectedQueue("c").build());
    }

    @Test
    public void testGroupMappingToSpecifiedQueueOverwritesInputQueueFromMapping() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source("usergroup").queue("b").parentQueue("root.bsubgroup2").build()).inputUser("user").inputQueue("a").expectedQueue("b").overwrite(true).build());
    }

    @Test
    public void testGroupMappingToSpecifiedQueueUnderAGivenParentQueue() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source("agroup").queue("%user").parentQueue("root.agroup").build()).inputUser("a").expectedQueue("a").build());
    }

    @Test
    public void testGroupMappingToSpecifiedQueueWithoutParentQueue() throws IOException, YarnException {
        this.verifyQueueMapping(QueueMappingTestData.QueueMappingTestDataBuilder.create().queueMapping(QueueMapping.QueueMappingBuilder.create().type(QueueMapping.MappingType.GROUP).source("agroup").queue("%user").build()).inputUser("a").expectedQueue("a").build());
    }

    public static final class QueueMappingTestData {
        private QueueMapping queueMapping;
        private String inputUser;
        private String inputQueue;
        private String expectedQueue;
        private boolean overwrite;
        private String expectedParentQueue;

        private QueueMappingTestData(QueueMappingTestDataBuilder builder) {
            this.queueMapping = builder.queueMapping;
            this.inputUser = builder.inputUser;
            this.inputQueue = builder.inputQueue;
            this.expectedQueue = builder.expectedQueue;
            this.overwrite = builder.overwrite;
            this.expectedParentQueue = builder.expectedParentQueue;
        }

        public static class QueueMappingTestDataBuilder {
            private QueueMapping queueMapping = null;
            private String inputUser = null;
            private String inputQueue = "default";
            private String expectedQueue = null;
            private boolean overwrite = false;
            private String expectedParentQueue = null;

            public static QueueMappingTestDataBuilder create() {
                return new QueueMappingTestDataBuilder();
            }

            public QueueMappingTestDataBuilder queueMapping(QueueMapping mapping) {
                this.queueMapping = mapping;
                return this;
            }

            public QueueMappingTestDataBuilder inputUser(String user) {
                this.inputUser = user;
                return this;
            }

            public QueueMappingTestDataBuilder inputQueue(String queue) {
                this.inputQueue = queue;
                return this;
            }

            public QueueMappingTestDataBuilder expectedQueue(String outputQueue) {
                this.expectedQueue = outputQueue;
                return this;
            }

            public QueueMappingTestDataBuilder overwrite(boolean overwriteMappings) {
                this.overwrite = overwriteMappings;
                return this;
            }

            public QueueMappingTestDataBuilder expectedParentQueue(String outputParentQueue) {
                this.expectedParentQueue = outputParentQueue;
                return this;
            }

            public QueueMappingTestData build() {
                return new QueueMappingTestData(this);
            }
        }
    }
}

