/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import java.util.Set;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.placement.VariableContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleAction;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleActions;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleMatcher;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleMatchers;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleResult;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleResultType;
import org.junit.Assert;
import org.junit.Test;

public class TestMappingRule {
    VariableContext setupVariables(String user, String group, String secGroup, String appName) {
        VariableContext variables = new VariableContext();
        variables.put("%default", "root.default");
        variables.put("%user", user);
        variables.put("%primary_group", group);
        variables.put("%secondary_group", secGroup);
        variables.put("%application", appName);
        variables.put("%sub", "xxx");
        variables.put("%empty", "");
        variables.put("%null", null);
        variables.setImmutables(new String[]{"%user", "%primary_group", "%secondary_group", "%application"});
        return variables;
    }

    void assertSkipResult(MappingRuleResult result) {
        Assert.assertTrue((MappingRuleResultType.SKIP == result.getResult() ? 1 : 0) != 0);
    }

    void assertPlaceResult(MappingRuleResult result, String queue) {
        Assert.assertTrue((MappingRuleResultType.PLACE == result.getResult() ? 1 : 0) != 0);
        Assert.assertEquals((Object)queue, (Object)result.getQueue());
    }

    @Test
    public void testMappingRuleEvaluation() {
        VariableContext matching = this.setupVariables("bob", "developer", "users", "MR");
        VariableContext mismatching = this.setupVariables("joe", "tester", "admins", "Spark");
        MappingRule rule = new MappingRule(MappingRuleMatchers.createUserMatcher((String)"bob"), new MappingRuleActions.PlaceToQueueAction("%default.%default", true).setFallbackSkip());
        this.assertSkipResult(rule.getFallback());
        MappingRuleResult matchingResult = rule.evaluate(matching);
        MappingRuleResult mismatchingResult = rule.evaluate(mismatching);
        this.assertSkipResult(mismatchingResult);
        this.assertPlaceResult(matchingResult, "root.default.root.default");
    }

    MappingRule createMappingRuleFromLegacyString(String legacyMapping) {
        String[] mapping = StringUtils.getTrimmedStringCollection((String)legacyMapping, (String)":").toArray(new String[0]);
        if (mapping.length == 2) {
            return MappingRule.createLegacyRule((String)mapping[0], (String)mapping[1]);
        }
        return MappingRule.createLegacyRule((String)mapping[0], (String)mapping[1], (String)mapping[2]);
    }

    void evaluateLegacyStringTestcase(String legacyString, VariableContext variables, String expectedQueue) {
        MappingRule rule = this.createMappingRuleFromLegacyString(legacyString);
        MappingRuleResult result = rule.evaluate(variables);
        Assert.assertEquals((Object)rule.getFallback().getResult(), (Object)MappingRuleResultType.PLACE_TO_DEFAULT);
        if (expectedQueue == null) {
            this.assertSkipResult(result);
            return;
        }
        this.assertPlaceResult(result, expectedQueue);
    }

    @Test
    public void testLegacyEvaluation() {
        VariableContext matching = this.setupVariables("bob", "developer", "users", "MR");
        matching.putExtraDataset("groups", (Set)Sets.newHashSet((Object[])new String[]{"developer"}));
        VariableContext mismatching = this.setupVariables("joe", "tester", "admins", "Spark");
        this.evaluateLegacyStringTestcase("u:bob:root.%primary_group", matching, "root.developer");
        this.evaluateLegacyStringTestcase("u:bob:root.%primary_group", mismatching, null);
        this.evaluateLegacyStringTestcase("g:developer:%secondary_group.%user", matching, "users.bob");
        this.evaluateLegacyStringTestcase("g:developer:%secondary_group.%user", mismatching, null);
        this.evaluateLegacyStringTestcase("MR:root.static", matching, "root.static");
        this.evaluateLegacyStringTestcase("MR:root.static", mismatching, null);
        this.evaluateLegacyStringTestcase("u:%user:root.%primary_group", matching, "root.developer");
        this.evaluateLegacyStringTestcase("u:%user:root.%primary_group", mismatching, "root.tester");
    }

    @Test
    public void testToStrings() {
        MappingRuleActions.PlaceToQueueAction action = new MappingRuleActions.PlaceToQueueAction("queue", true);
        MappingRuleMatcher matcher = MappingRuleMatchers.createUserMatcher((String)"bob");
        MappingRule rule = new MappingRule(matcher, (MappingRuleAction)action);
        Assert.assertEquals((Object)("MappingRule{matcher=" + matcher.toString() + ", action=" + action.toString() + "}"), (Object)rule.toString());
    }
}

