/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueHelpers;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.mockito.Mockito;

public final class CapacitySchedulerTestUtilities {
    public static final int GB = 1024;

    private CapacitySchedulerTestUtilities() {
    }

    public static <E> Set<E> toSet(E ... elements) {
        return Sets.newHashSet((Object[])elements);
    }

    public static void checkPendingResource(MockRM rm, String queueName, int memory, String label) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = cs.getQueue(queueName);
        Assert.assertEquals((long)memory, (long)queue.getQueueResourceUsage().getPending(label == null ? "" : label).getMemorySize());
    }

    public static void checkPendingResourceGreaterThanZero(MockRM rm, String queueName, String label) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CSQueue queue = cs.getQueue(queueName);
        Assert.assertTrue((queue.getQueueResourceUsage().getPending(label == null ? "" : label).getMemorySize() > 0L ? 1 : 0) != 0);
    }

    public static void waitforNMRegistered(ResourceScheduler scheduler, int nodecount, int timesec) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)(timesec * 1000) && scheduler.getNumClusterNodes() < nodecount) {
            Thread.sleep(100L);
        }
    }

    public static ResourceManager createResourceManager() throws Exception {
        ResourceUtils.resetResourceTypes((Configuration)new Configuration());
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
        ResourceManager resourceManager = new ResourceManager(){

            protected RMNodeLabelsManager createNodeLabelManager() {
                NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
                mgr.init(this.getConfig());
                return mgr;
            }
        };
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        resourceManager.init((Configuration)conf);
        resourceManager.getRMContext().getContainerTokenSecretManager().rollMasterKey();
        resourceManager.getRMContext().getNMTokenSecretManager().rollMasterKey();
        ((AsyncDispatcher)resourceManager.getRMContext().getDispatcher()).start();
        return resourceManager;
    }

    public static RMContext createMockRMContext() {
        RMContext mockContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)mockContext.getConfigurationProvider()).thenReturn((Object)new LocalConfigurationProvider());
        return mockContext;
    }

    public static void stopResourceManager(ResourceManager resourceManager) throws Exception {
        if (resourceManager != null) {
            QueueMetrics.clearQueueMetrics();
            DefaultMetricsSystem.shutdown();
            resourceManager.stop();
        }
    }

    public static ApplicationAttemptId appHelper(MockRM rm, CapacityScheduler cs, int clusterTs, int appId, String queue, String user) {
        ApplicationId appId1 = BuilderUtils.newApplicationId((long)clusterTs, (int)appId);
        ApplicationAttemptId appAttemptId1 = BuilderUtils.newApplicationAttemptId((ApplicationId)appId1, (int)appId);
        RMAppAttemptMetrics attemptMetric1 = new RMAppAttemptMetrics(appAttemptId1, rm.getRMContext());
        RMAppImpl app1 = (RMAppImpl)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app1.getApplicationId()).thenReturn((Object)appId1);
        RMAppAttemptImpl attempt1 = (RMAppAttemptImpl)Mockito.mock(RMAppAttemptImpl.class);
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)attempt1.getMasterContainer()).thenReturn((Object)container);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)attempt1.getSubmissionContext()).thenReturn((Object)submissionContext);
        Mockito.when((Object)attempt1.getAppAttemptId()).thenReturn((Object)appAttemptId1);
        Mockito.when((Object)attempt1.getRMAppAttemptMetrics()).thenReturn((Object)attemptMetric1);
        Mockito.when((Object)app1.getCurrentAppAttempt()).thenReturn((Object)attempt1);
        rm.getRMContext().getRMApps().put(appId1, app1);
        AppAddedSchedulerEvent addAppEvent1 = new AppAddedSchedulerEvent(appId1, queue, user);
        cs.handle((SchedulerEvent)addAppEvent1);
        AppAttemptAddedSchedulerEvent addAttemptEvent1 = new AppAttemptAddedSchedulerEvent(appAttemptId1, false);
        cs.handle((SchedulerEvent)addAttemptEvent1);
        return appAttemptId1;
    }

    public static MockRM setUpMoveAmbiguousQueue() {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfAmbiguousQueue(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        return rm;
    }

    public static MockRM setUpMove() {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        return CapacitySchedulerTestUtilities.setUpMove((Configuration)conf);
    }

    public static MockRM setUpMove(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(conf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        return rm;
    }

    public static void nodeUpdate(ResourceManager rm, NodeManager nm) {
        RMNode node = (RMNode)rm.getRMContext().getRMNodes().get(nm.getNodeId());
        NodeUpdateSchedulerEvent nodeUpdate = new NodeUpdateSchedulerEvent(node);
        rm.getResourceScheduler().handle((Event)nodeUpdate);
    }

    public static NodeManager registerNode(ResourceManager rm, String hostName, int containerManagerPort, int httpPort, String rackName, Resource capability, NodeStatus nodeStatus) throws IOException, YarnException {
        NodeManager nm = new NodeManager(hostName, containerManagerPort, httpPort, rackName, capability, rm, nodeStatus);
        NodeAddedSchedulerEvent nodeAddEvent1 = new NodeAddedSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm.getNodeId()));
        rm.getResourceScheduler().handle((Event)nodeAddEvent1);
        return nm;
    }

    public static void checkApplicationResourceUsage(int expected, Application application) {
        Assert.assertEquals((long)expected, (long)application.getUsedResources().getMemorySize());
    }

    public static void checkNodeResourceUsage(int expected, NodeManager node) {
        Assert.assertEquals((long)expected, (long)node.getUsed().getMemorySize());
        node.checkResourceUsage();
    }
}

