/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.junit.Assert;

class QueueAssertionBuilder {
    private static final String EFFECTIVE_MAX_RES_INFO = "Effective Maximum Resource";
    private static final BiFunction<QueueResourceQuotas, String, Resource> EFFECTIVE_MAX_RES = QueueResourceQuotas::getEffectiveMaxResource;
    private static final String EFFECTIVE_MIN_RES_INFO = "Effective Minimum Resource";
    private static final BiFunction<QueueResourceQuotas, String, Resource> EFFECTIVE_MIN_RES = QueueResourceQuotas::getEffectiveMinResource;
    private static final String CAPACITY_INFO = "Capacity";
    private static final BiFunction<QueueCapacities, String, Float> CAPACITY = QueueCapacities::getCapacity;
    private static final String ABS_CAPACITY_INFO = "Absolute Capacity";
    private static final BiFunction<QueueCapacities, String, Float> ABS_CAPACITY = QueueCapacities::getAbsoluteCapacity;
    private static final String ASSERTION_ERROR_MESSAGE = "'%s' of queue '%s' does not match %f for label %s";
    private static final String RESOURCE_ASSERTION_ERROR_MESSAGE = "'%s' of queue '%s' does not match %s for label %s";
    private final CapacityScheduler cs;
    private final Map<String, QueueAssertion> assertions = new LinkedHashMap<String, QueueAssertion>();

    QueueAssertionBuilder(CapacityScheduler cs) {
        this.cs = cs;
    }

    public QueueAssertionBuilder build() {
        return this;
    }

    public QueueAssertion withQueue(String queuePath) {
        this.assertions.putIfAbsent(queuePath, new QueueAssertion(queuePath));
        return this.assertions.get(queuePath);
    }

    public void finishAssertion() {
        for (Map.Entry<String, QueueAssertion> assertionEntry : this.assertions.entrySet()) {
            for (QueueAssertion.ValueAssertion assertion : assertionEntry.getValue().assertions) {
                String errorMessage;
                if (assertion.resourceSupplier != null) {
                    errorMessage = String.format(RESOURCE_ASSERTION_ERROR_MESSAGE, assertion.assertionType, assertionEntry.getKey(), assertion.expectedResource.toString(), assertion.label);
                    Assert.assertEquals((String)errorMessage, (Object)assertion.expectedResource, assertion.resourceSupplier.get());
                    continue;
                }
                errorMessage = String.format(ASSERTION_ERROR_MESSAGE, assertion.assertionType, assertionEntry.getKey(), assertion.expectedValue, assertion.label);
                Assert.assertEquals((String)errorMessage, (double)assertion.expectedValue, (double)((Float)assertion.valueSupplier.get()).floatValue(), (double)1.0E-4f);
            }
        }
    }

    public Set<String> getQueues() {
        return this.assertions.keySet();
    }

    public class QueueAssertion {
        private final String queuePath;
        private final List<ValueAssertion> assertions = new ArrayList<ValueAssertion>();

        QueueAssertion(String queuePath) {
            this.queuePath = queuePath;
        }

        public QueueAssertion withQueue(String queuePath) {
            return QueueAssertionBuilder.this.withQueue(queuePath);
        }

        public QueueAssertionBuilder build() {
            return QueueAssertionBuilder.this.build();
        }

        public QueueAssertion assertEffectiveMaxResource(Resource expected) {
            ValueAssertion valueAssertion = new ValueAssertion(expected);
            valueAssertion.withResourceSupplier(EFFECTIVE_MAX_RES, QueueAssertionBuilder.EFFECTIVE_MAX_RES_INFO);
            this.assertions.add(valueAssertion);
            return this;
        }

        public QueueAssertion assertEffectiveMinResource(Resource expected, String label) {
            ValueAssertion valueAssertion = new ValueAssertion(expected);
            valueAssertion.withResourceSupplier(EFFECTIVE_MIN_RES, QueueAssertionBuilder.EFFECTIVE_MIN_RES_INFO);
            this.assertions.add(valueAssertion);
            valueAssertion.label = label;
            return this;
        }

        public QueueAssertion assertEffectiveMinResource(Resource expected) {
            return this.assertEffectiveMinResource(expected, "");
        }

        public QueueAssertion assertCapacity(double expected) {
            ValueAssertion valueAssertion = new ValueAssertion(expected);
            valueAssertion.withCapacitySupplier(CAPACITY, QueueAssertionBuilder.CAPACITY_INFO);
            this.assertions.add(valueAssertion);
            return this;
        }

        public QueueAssertion assertAbsoluteCapacity(double expected) {
            ValueAssertion valueAssertion = new ValueAssertion(expected);
            valueAssertion.withCapacitySupplier(ABS_CAPACITY, QueueAssertionBuilder.ABS_CAPACITY_INFO);
            this.assertions.add(valueAssertion);
            return this;
        }

        private class ValueAssertion {
            private double expectedValue = 0.0;
            private Resource expectedResource = null;
            private String assertionType;
            private Supplier<Float> valueSupplier;
            private Supplier<Resource> resourceSupplier;
            private String label = "";

            ValueAssertion(double expectedValue) {
                this.expectedValue = expectedValue;
            }

            ValueAssertion(Resource expectedResource) {
                this.expectedResource = expectedResource;
            }

            public void setLabel(String label) {
                this.label = label;
            }

            public void withResourceSupplier(BiFunction<QueueResourceQuotas, String, Resource> assertion, String messageInfo) {
                CSQueue queue = QueueAssertionBuilder.this.cs.getQueue(QueueAssertion.this.queuePath);
                if (queue == null) {
                    Assert.fail((String)("Queue " + QueueAssertion.this.queuePath + " is not found"));
                }
                this.assertionType = messageInfo;
                this.resourceSupplier = () -> (Resource)assertion.apply(queue.getQueueResourceQuotas(), this.label);
            }

            public void withCapacitySupplier(BiFunction<QueueCapacities, String, Float> assertion, String messageInfo) {
                CSQueue queue = QueueAssertionBuilder.this.cs.getQueue(QueueAssertion.this.queuePath);
                if (queue == null) {
                    Assert.fail((String)("Queue " + QueueAssertion.this.queuePath + " is not found"));
                }
                this.assertionType = messageInfo;
                this.valueSupplier = () -> (Float)assertion.apply(queue.getQueueCapacities(), this.label);
            }
        }
    }
}

