/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAMAllocatedToNonExclusivePartition {
    private Configuration conf;
    private RMNodeLabelsManager mgr;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        this.conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init(this.conf);
    }

    private <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    @Test
    public void testAMAllowToNonExclusivePartition() throws Exception {
        this.conf.setBoolean("yarn.resourcemanager.node-labels.am.allow-non-exclusive-allocation", true);
        this.mgr.addToCluserNodeLabels(Arrays.asList(NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        this.conf = TestUtils.getConfigurationWithDefaultQueueLabels(this.conf);
        MockRM rm1 = new MockRM(this.conf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestAMAllocatedToNonExclusivePartition.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8000);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data2);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED));
        rm1.close();
    }
}

