/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedQueueDeletionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerNewQueueAutoCreation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.junit.Assert;
import org.junit.Test;

public class TestAutoCreatedQueueDeletionPolicy
extends TestCapacitySchedulerNewQueueAutoCreation {
    private CapacityScheduler cs;
    private AutoCreatedQueueDeletionPolicy policy;

    public void prepareForSchedule() throws Exception {
        super.startScheduler();
        this.policy = this.getPolicy();
        this.cs = this.getCs();
        this.policy.editSchedule();
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)0L);
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)0L);
        this.createQueue("root.e.e1");
    }

    @Test
    public void testEditSchedule() throws Exception {
        this.prepareForSchedule();
        AbstractCSQueue e = (AbstractCSQueue)this.cs.getQueue("root.e");
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((boolean)e.isDynamicQueue());
        AbstractCSQueue e1 = (AbstractCSQueue)this.cs.getQueue("root.e.e1");
        Assert.assertNotNull((Object)e1);
        Assert.assertTrue((boolean)e1.isDynamicQueue());
        e1.setLastSubmittedTimestamp(Time.monotonicNow());
        ApplicationAttemptId user0AppAttemptId = this.submitApp(this.cs, "user_0", "user_0", "root.e");
        GenericTestUtils.waitFor(() -> this.cs.getQueue("root.e.user_0") != null, (long)100L, (long)2000L);
        AbstractCSQueue user0 = (AbstractCSQueue)this.cs.getQueue("root.e.user_0");
        Assert.assertNotNull((Object)user0);
        Assert.assertTrue((boolean)user0.isDynamicQueue());
        AppAttemptRemovedSchedulerEvent event = new AppAttemptRemovedSchedulerEvent(user0AppAttemptId, RMAppAttemptState.FINISHED, false);
        this.cs.handle((SchedulerEvent)event);
        AppRemovedSchedulerEvent rEvent = new AppRemovedSchedulerEvent(user0AppAttemptId.getApplicationId(), RMAppState.FINISHED);
        this.cs.handle((SchedulerEvent)rEvent);
        Assert.assertEquals((long)user0.getNumApplications(), (long)0L);
        long l1 = user0.getLastSubmittedTimestamp();
        GenericTestUtils.waitFor(() -> {
            long duration = (Time.monotonicNow() - l1) / 1000L;
            return duration > this.getCs().getConfiguration().getAutoExpiredDeletionTime();
        }, (long)100L, (long)2000L);
        long l2 = e1.getLastSubmittedTimestamp();
        GenericTestUtils.waitFor(() -> {
            long duration = (Time.monotonicNow() - l2) / 1000L;
            return duration > this.getCs().getConfiguration().getAutoExpiredDeletionTime();
        }, (long)100L, (long)2000L);
        this.policy.editSchedule();
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)2L);
        Assert.assertTrue((boolean)this.policy.getMarkedForDeletion().contains("root.e.user_0"));
        Assert.assertTrue((boolean)this.policy.getMarkedForDeletion().contains("root.e.e1"));
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)0L);
        this.policy.prepareForAutoDeletion();
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)0L);
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)2L);
        e1 = (AbstractCSQueue)this.cs.getQueue("root.e.e1");
        Assert.assertNotNull((Object)e1);
        user0 = (AbstractCSQueue)this.cs.getQueue("root.e.user_0");
        Assert.assertNotNull((Object)user0);
        this.policy.triggerAutoDeletionForExpiredQueues();
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)0L);
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)0L);
        GenericTestUtils.waitFor(() -> this.cs.getQueue("root.e.e1") == null, (long)100L, (long)2000L);
        GenericTestUtils.waitFor(() -> this.cs.getQueue("root.e.user_0") == null, (long)100L, (long)2000L);
        e1 = (AbstractCSQueue)this.cs.getQueue("root.e.e1");
        Assert.assertNull((Object)e1);
        user0 = (AbstractCSQueue)this.cs.getQueue("root.e.user_0");
        Assert.assertNull((Object)user0);
        e = (AbstractCSQueue)this.cs.getQueue("root.e");
        Assert.assertNotNull((Object)e);
        long l3 = e.getLastSubmittedTimestamp();
        GenericTestUtils.waitFor(() -> {
            long duration = (Time.monotonicNow() - l3) / 1000L;
            return duration > this.getCs().getConfiguration().getAutoExpiredDeletionTime();
        }, (long)100L, (long)2000L);
        this.policy.editSchedule();
        e = (AbstractCSQueue)this.cs.getQueue("root.e");
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)1L);
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)0L);
        Assert.assertTrue((boolean)this.policy.getMarkedForDeletion().contains("root.e"));
        this.policy.prepareForAutoDeletion();
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)0L);
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)1L);
        e = (AbstractCSQueue)this.cs.getQueue("root.e");
        Assert.assertNotNull((Object)e);
        this.policy.triggerAutoDeletionForExpiredQueues();
        GenericTestUtils.waitFor(() -> this.cs.getQueue("root.e") == null, (long)100L, (long)2000L);
        Assert.assertEquals((long)this.policy.getMarkedForDeletion().size(), (long)0L);
        Assert.assertEquals((long)this.policy.getSentForDeletion().size(), (long)0L);
        e = (AbstractCSQueue)this.cs.getQueue("root.e");
        Assert.assertNull((Object)e);
    }
}

