/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Test;

public class TestCapacitySchedulerAmbiguousLeafs {
    int appId = 0;

    private ApplicationId submitApplication(MockRM rm, String queue) throws IOException, YarnException {
        ApplicationAttemptId appAttemptId = TestUtils.getMockApplicationAttemptId(this.appId++, 1);
        Resource resource = Resources.createResource((int)1024);
        ContainerLaunchContext amContainerSpec = ContainerLaunchContext.newInstance(null, null, null, null, null, null);
        ApplicationSubmissionContext asc = ApplicationSubmissionContext.newInstance((ApplicationId)appAttemptId.getApplicationId(), (String)"Test application", (String)queue, null, (ContainerLaunchContext)amContainerSpec, (boolean)false, (boolean)true, (int)1, (Resource)resource, (String)"applicationType");
        SubmitApplicationRequest req = SubmitApplicationRequest.newInstance((ApplicationSubmissionContext)asc);
        rm.getClientRMService().submitApplication(req);
        return appAttemptId.getApplicationId();
    }

    @Test
    public void testAmbiguousSubmissionWithACL() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
        conf.setBoolean("yarn.acl.enable", true);
        MockRM rm = new MockRM((Configuration)conf);
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        CapacitySchedulerConfiguration schedulerConf = cs.getConfiguration();
        schedulerConf.setQueues("root", new String[]{"a", "b", "default"});
        schedulerConf.setAcl("root", QueueACL.SUBMIT_APPLICATIONS, " ");
        schedulerConf.setAcl("root", QueueACL.ADMINISTER_QUEUE, "forbidden forbidden");
        schedulerConf.setQueues("root.a", new String[]{"unique", "ambi"});
        schedulerConf.setAcl("root.a", QueueACL.SUBMIT_APPLICATIONS, "forbidden forbidden");
        schedulerConf.setCapacity("root.a", 45.0f);
        schedulerConf.setQueues("root.b", new String[]{"ambi"});
        schedulerConf.setCapacity("root.b", 45.0f);
        schedulerConf.setCapacity("root.default", 10.0f);
        schedulerConf.setCapacity("root.a.unique", 50.0f);
        schedulerConf.setAcl("root.a.unique", QueueACL.SUBMIT_APPLICATIONS, "* *");
        schedulerConf.setCapacity("root.a.ambi", 50.0f);
        schedulerConf.setAcl("root.a.ambi", QueueACL.SUBMIT_APPLICATIONS, "* *");
        schedulerConf.setCapacity("root.b.ambi", 100.0f);
        schedulerConf.set("yarn.scheduler.capacity.mapping-rule-format", "json");
        schedulerConf.set("yarn.scheduler.capacity.mapping-rule-json", "{\"rules\" : [{\"type\": \"user\", \"policy\" : \"specified\", \"fallbackResult\" : \"skip\", \"matches\" : \"*\"}]}");
        schedulerConf.setOverrideWithQueueMappings(true);
        rm.start();
        cs.reinitialize((Configuration)schedulerConf, rm.getRMContext());
        ApplicationId id = this.submitApplication(rm, "root.a.unique");
        rm.waitForState(id, RMAppState.ACCEPTED);
        id = this.submitApplication(rm, "unique");
        rm.waitForState(id, RMAppState.ACCEPTED);
        id = this.submitApplication(rm, "ambi");
        rm.waitForState(id, RMAppState.FAILED);
        id = this.submitApplication(rm, "root.a.ambi");
        rm.waitForState(id, RMAppState.ACCEPTED);
        rm.stop();
    }
}

