/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.Task;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeResourceUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueHelpers;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerTestUtilities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestCapacitySchedulerAutoCreatedQueueBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.SimpleCandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCapacitySchedulerNodes {
    private ResourceManager resourceManager = null;

    @Before
    public void setUp() throws Exception {
        this.resourceManager = CapacitySchedulerTestUtilities.createResourceManager();
    }

    @After
    public void tearDown() throws Exception {
        CapacitySchedulerTestUtilities.stopResourceManager(this.resourceManager);
    }

    @Test
    public void testReconnectedNode() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(csConf);
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        cs.init((Configuration)csConf);
        cs.start();
        cs.reinitialize((Configuration)csConf, (RMContext)new RMContextImpl(null, null, null, null, null, null, new RMContainerTokenSecretManager((Configuration)csConf), new NMTokenSecretManagerInRM((Configuration)csConf), new ClientToAMTokenSecretManagerInRM(), null));
        RMNode n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1);
        RMNode n2 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 2);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n2));
        Assert.assertEquals((long)6144L, (long)cs.getClusterResource().getMemorySize());
        n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 1);
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n1));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        Assert.assertEquals((long)4096L, (long)cs.getClusterResource().getMemorySize());
        cs.stop();
    }

    @Test
    public void testBlackListNodes() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        String host = "127.0.0.1";
        RMNode node = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, host);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        ApplicationAttemptId appAttemptId = CapacitySchedulerTestUtilities.appHelper(rm, cs, 100, 1, "default", "user");
        cs.allocate(appAttemptId, Collections.emptyList(), null, Collections.emptyList(), Collections.singletonList(host), null, TestCapacitySchedulerAutoCreatedQueueBase.NULL_UPDATE_REQUESTS);
        Assert.assertTrue((boolean)cs.getApplicationAttempt(appAttemptId).isPlaceBlacklisted(host));
        cs.allocate(appAttemptId, Collections.emptyList(), null, Collections.emptyList(), null, Collections.singletonList(host), TestCapacitySchedulerAutoCreatedQueueBase.NULL_UPDATE_REQUESTS);
        Assert.assertFalse((boolean)cs.getApplicationAttempt(appAttemptId).isPlaceBlacklisted(host));
        rm.stop();
    }

    @Test
    public void testNumClusterNodes() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        CapacityScheduler cs = new CapacityScheduler();
        cs.setConf((Configuration)conf);
        RMContext rmContext = TestUtils.getMockRMContext();
        cs.setRMContext(rmContext);
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(csConf);
        cs.init((Configuration)csConf);
        cs.start();
        Assert.assertEquals((long)0L, (long)cs.getNumClusterNodes());
        RMNode n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1);
        RMNode n2 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 2);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n2));
        Assert.assertEquals((long)2L, (long)cs.getNumClusterNodes());
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n1));
        Assert.assertEquals((long)1L, (long)cs.getNumClusterNodes());
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        Assert.assertEquals((long)2L, (long)cs.getNumClusterNodes());
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n2));
        cs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n1));
        Assert.assertEquals((long)0L, (long)cs.getNumClusterNodes());
        cs.stop();
    }

    @Test
    public void testDefaultNodeLabelExpressionQueueConfig() throws Exception {
        CapacityScheduler cs = new CapacityScheduler();
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        CapacitySchedulerQueueHelpers.setupQueueConfiguration(conf);
        conf.setDefaultNodeLabelExpression("root.a", " x");
        conf.setDefaultNodeLabelExpression("root.b", " y ");
        cs.setConf((Configuration)new YarnConfiguration());
        cs.setRMContext(this.resourceManager.getRMContext());
        cs.init((Configuration)conf);
        cs.start();
        QueueInfo queueInfoA = cs.getQueueInfo("a", true, false);
        Assert.assertEquals((String)"Queue Name should be a", (Object)"a", (Object)queueInfoA.getQueueName());
        Assert.assertEquals((String)"Queue Path should be root.a", (Object)"root.a", (Object)queueInfoA.getQueuePath());
        Assert.assertEquals((String)"Default Node Label Expression should be x", (Object)"x", (Object)queueInfoA.getDefaultNodeLabelExpression());
        QueueInfo queueInfoB = cs.getQueueInfo("b", true, false);
        Assert.assertEquals((String)"Queue Name should be b", (Object)"b", (Object)queueInfoB.getQueueName());
        Assert.assertEquals((String)"Queue Path should be root.b", (Object)"root.b", (Object)queueInfoB.getQueuePath());
        Assert.assertEquals((String)"Default Node Label Expression should be y", (Object)"y", (Object)queueInfoB.getDefaultNodeLabelExpression());
    }

    @Test
    public void testRemovedNodeDecommissioningNode() throws Exception {
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        NodeManager nm = CapacitySchedulerTestUtilities.registerNode(this.resourceManager, "host_decom", 1234, 2345, "/default-rack", Resources.createResource((int)8192, (int)4), mockNodeStatus);
        RMNode node = (RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId());
        NodeUpdateSchedulerEvent nodeUpdate = new NodeUpdateSchedulerEvent(node);
        this.resourceManager.getResourceScheduler().handle((Event)nodeUpdate);
        ((CapacityScheduler)this.resourceManager.getResourceScheduler()).getNodeTracker().removeNode(nm.getNodeId());
        RMNode spyNode = (RMNode)Mockito.spy(this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId()));
        Mockito.when((Object)spyNode.getState()).thenReturn((Object)NodeState.DECOMMISSIONING);
        this.resourceManager.getResourceScheduler().handle((Event)new NodeUpdateSchedulerEvent(spyNode));
    }

    @Test
    public void testResourceUpdateDecommissioningNode() throws Exception {
        RMContext spyContext = (RMContext)Mockito.spy((Object)this.resourceManager.getRMContext());
        Dispatcher mockDispatcher = (Dispatcher)Mockito.mock(AsyncDispatcher.class);
        Mockito.when((Object)mockDispatcher.getEventHandler()).thenReturn((Object)new EventHandler<Event>(){

            public void handle(Event event) {
                if (event instanceof RMNodeResourceUpdateEvent) {
                    RMNodeResourceUpdateEvent resourceEvent = (RMNodeResourceUpdateEvent)event;
                    TestCapacitySchedulerNodes.this.resourceManager.getResourceScheduler().getSchedulerNode(resourceEvent.getNodeId()).updateTotalResource(resourceEvent.getResourceOption().getResource());
                }
            }
        });
        ((RMContext)Mockito.doReturn((Object)mockDispatcher).when((Object)spyContext)).getDispatcher();
        ((CapacityScheduler)this.resourceManager.getResourceScheduler()).setRMContext(spyContext);
        ((AsyncDispatcher)mockDispatcher).start();
        NodeStatus mockNodeStatus = MockNM.createMockNodeStatus();
        String host0 = "host_0";
        NodeManager nm0 = CapacitySchedulerTestUtilities.registerNode(this.resourceManager, host0, 1234, 2345, "/default-rack", Resources.createResource((int)8192, (int)4), mockNodeStatus);
        Priority priority0 = Priority.newInstance((int)0);
        Application application0 = new Application("user_0", "a1", this.resourceManager);
        application0.submit();
        application0.addNodeManager(host0, 1234, nm0);
        Resource capability00 = Resources.createResource((int)1024, (int)1);
        application0.addResourceRequestSpec(priority0, capability00);
        Task task00 = new Task(application0, priority0, new String[]{host0});
        application0.addTask(task00);
        application0.schedule();
        CapacitySchedulerTestUtilities.nodeUpdate(this.resourceManager, nm0);
        RMNode spyNode = (RMNode)Mockito.spy(this.resourceManager.getRMContext().getRMNodes().get(nm0.getNodeId()));
        Mockito.when((Object)spyNode.getState()).thenReturn((Object)NodeState.DECOMMISSIONING);
        this.resourceManager.getResourceScheduler().handle((Event)new NodeUpdateSchedulerEvent(spyNode));
        application0.schedule();
        Assert.assertEquals((long)1024L, (long)nm0.getUsed().getMemorySize());
        Resource usedResource = this.resourceManager.getResourceScheduler().getSchedulerNode(nm0.getNodeId()).getAllocatedResource();
        Assert.assertEquals((String)"Used Resource Memory Size should be 1GB", (long)1024L, (long)usedResource.getMemorySize());
        Assert.assertEquals((String)"Used Resource Virtual Cores should be 1", (long)1L, (long)usedResource.getVirtualCores());
        Resource totalResource = this.resourceManager.getResourceScheduler().getSchedulerNode(nm0.getNodeId()).getTotalResource();
        Assert.assertEquals((String)"Total Resource Memory Size should be 1GB", (long)1024L, (long)totalResource.getMemorySize());
        Assert.assertEquals((String)"Total Resource Virtual Cores should be 1", (long)1L, (long)totalResource.getVirtualCores());
        Resource availableResource = this.resourceManager.getResourceScheduler().getSchedulerNode(nm0.getNodeId()).getUnallocatedResource();
        Assert.assertEquals((String)"Available Resource Memory Size should be 0", (long)0L, (long)availableResource.getMemorySize());
        Assert.assertEquals((String)"Available Resource Memory Size should be 0", (long)0L, (long)availableResource.getVirtualCores());
        Mockito.when((Object)spyNode.getState()).thenReturn((Object)NodeState.DECOMMISSIONING);
        this.resourceManager.getResourceScheduler().handle((Event)new NodeUpdateSchedulerEvent(spyNode));
        ((Dispatcher)Mockito.verify((Object)mockDispatcher, (VerificationMode)Mockito.times((int)4))).getEventHandler();
    }

    @Test
    public void testSchedulingOnRemovedNode() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", false);
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        RMApp app = MockRMAppSubmitter.submitWithMemory(100L, rm);
        rm.drainEvents();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 10240, 10);
        MockAM am = MockRM.launchAndRegisterAM(app, rm, nm1);
        MockNM nm2 = rm.registerNode("127.0.0.1:1235", 10240, 10);
        am.allocate("*", 2048, 1, null);
        CapacityScheduler scheduler = (CapacityScheduler)rm.getRMContext().getScheduler();
        FiCaSchedulerNode node = (FiCaSchedulerNode)scheduler.getNodeTracker().getNode(nm2.getNodeId());
        scheduler.handle((SchedulerEvent)new NodeRemovedSchedulerEvent((RMNode)rm.getRMContext().getRMNodes().get(nm2.getNodeId())));
        scheduler.allocateContainersToNode((CandidateNodeSet)new SimpleCandidateNodeSet((SchedulerNode)node), true);
        AppAttemptRemovedSchedulerEvent appRemovedEvent1 = new AppAttemptRemovedSchedulerEvent(am.getApplicationAttemptId(), RMAppAttemptState.FINISHED, false);
        scheduler.handle((SchedulerEvent)appRemovedEvent1);
        rm.stop();
    }
}

