/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueCalculationTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueAssertionBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityUpdateContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueUpdateWarning;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestMixedQueueResourceCalculation
extends CapacitySchedulerQueueCalculationTestBase {
    private static final long MEMORY = 16384L;
    private static final long VCORES = 16L;
    private static final String C_VECTOR_WITH_WARNING = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.weight(3.0f), TestMixedQueueResourceCalculation.absolute(4.0));
    private static final String A11_VECTOR_WITH_WARNING = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.weight(1.0f), TestMixedQueueResourceCalculation.absolute(4.0));
    private static final String A1_VECTOR_WITH_WARNING = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(2048.0), TestMixedQueueResourceCalculation.absolute(4.0));
    private static final String C_VECTOR_NO_REMAINING_RESOURCE = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.weight(3.0f), TestMixedQueueResourceCalculation.absolute(4.0));
    private static final String A1_VECTOR_NO_REMAINING_RESOURCE = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.weight(1.0f), TestMixedQueueResourceCalculation.absolute(4.0));
    private static final Resource A12_EXPECTED_MAX_RESOURCE_MAX_WARNINGS = TestMixedQueueResourceCalculation.createResource(8192.0, 16.0);
    private static final Resource A11_EXPECTED_MAX_RESOURCE_MAX_WARNINGS = TestMixedQueueResourceCalculation.createResource(8192.0, 1.6);
    private static final Resource A11_EXPECTED_MIN_RESOURCE_MAX_WARNINGS = TestMixedQueueResourceCalculation.createResource(4096.0, 1.6);
    private static final Resource A12_EXPECTED_MIN_RESOURCE_MAX_WARNINGS = TestMixedQueueResourceCalculation.createResource(4096.0, 0.0);
    private static final String A11_MAX_VECTOR_MAX_WARNINGS = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(16384.0), TestMixedQueueResourceCalculation.percentage(10.0f));
    private static final String A1_MAX_VECTOR_MAX_WARNINGS = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(8192.0), TestMixedQueueResourceCalculation.percentage(100.0f));
    private static final Resource UPDATE_RESOURCE = Resource.newInstance((int)16384, (int)16);
    private static final Resource ZERO_RESOURCE = Resource.newInstance((int)0, (int)0);
    private static final Resource A_COMPLEX_NO_REMAINING_RESOURCE = Resource.newInstance((int)2486, (int)9);
    private static final Resource A1_COMPLEX_NO_REMAINING_RESOURCE = Resource.newInstance((int)621, (int)4);
    private static final Resource A11_COMPLEX_NO_REMAINING_RESOURCE = Resource.newInstance((int)217, (int)1);
    private static final Resource A12_COMPLEX_NO_REMAINING_RESOURCE = Resource.newInstance((int)403, (int)3);
    private static final Resource A2_COMPLEX_NO_REMAINING_RESOURCE = Resource.newInstance((int)1865, (int)5);
    private static final Resource B_COMPLEX_NO_REMAINING_RESOURCE = Resource.newInstance((int)8095, (int)3);
    private static final Resource B1_COMPLEX_NO_REMAINING_RESOURCE = Resource.newInstance((int)8095, (int)3);
    private static final Resource C_COMPLEX_NO_REMAINING_RESOURCE = Resource.newInstance((int)5803, (int)4);
    private static final Resource B_WARNING_RESOURCE = Resource.newInstance((int)8096, (int)4);
    private static final Resource B1_WARNING_RESOURCE = Resource.newInstance((int)8096, (int)3);
    private static final Resource A_WARNING_RESOURCE = Resource.newInstance((int)8288, (int)12);
    private static final Resource A1_WARNING_RESOURCE = Resource.newInstance((int)2048, (int)4);
    private static final Resource A2_WARNING_RESOURCE = Resource.newInstance((int)2048, (int)8);
    private static final Resource A12_WARNING_RESOURCE = Resource.newInstance((int)2048, (int)4);
    private static final String A_VECTOR_ZERO_RESOURCE = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(100.0f), TestMixedQueueResourceCalculation.weight(6.0f));
    private static final String B_VECTOR_ZERO_RESOURCE = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(16384.0), TestMixedQueueResourceCalculation.absolute(8.0));
    private static final String A_MAX_VECTOR_DIFFERENT_MIN_MAX = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(16384.0), TestMixedQueueResourceCalculation.percentage(80.0f));
    private static final Resource B_EXPECTED_MAX_RESOURCE_DIFFERENT_MIN_MAX = Resource.newInstance((long)16384L, (int)8);
    private static final Resource A_EXPECTED_MAX_RESOURCE_DIFFERENT_MIN_MAX = Resource.newInstance((long)16384L, (int)12);
    private static final String B_MAX_VECTOR_DIFFERENT_MIN_MAX = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(16384.0), TestMixedQueueResourceCalculation.absolute(8.0));
    private static final String A_MIN_VECTOR_DIFFERENT_MIN_MAX = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(50.0f), TestMixedQueueResourceCalculation.absolute(8.0));
    private static final String B_MIN_VECTOR_DIFFERENT_MIN_MAX = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.weight(6.0f), TestMixedQueueResourceCalculation.percentage(100.0f));
    private static final String B_INVALID_MAX_VECTOR = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(16384.0), TestMixedQueueResourceCalculation.weight(10.0f));
    private static final String X_LABEL = "x";
    private static final String Y_LABEL = "y";
    private static final String Z_LABEL = "z";
    private static final String H1_NODE = "h1";
    private static final String H2_NODE = "h2";
    private static final String H3_NODE = "h3";
    private static final String H4_NODE = "h4";
    private static final String H5_NODE = "h5";
    private static final int H1_MEMORY = 61440;
    private static final int H1_VCORES = 60;
    private static final int H2_MEMORY = 10240;
    private static final int H2_VCORES = 25;
    private static final int H3_VCORES = 35;
    private static final int H3_MEMORY = 10240;
    private static final int H4_MEMORY = 10240;
    private static final int H4_VCORES = 15;
    private static final String A11_MIN_VECTOR_MAX_WARNINGS = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(50.0f), TestMixedQueueResourceCalculation.percentage(100.0f));
    private static final String A12_MIN_VECTOR_MAX_WARNINGS = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(50.0f), TestMixedQueueResourceCalculation.percentage(0.0f));
    private static final Resource A_EXPECTED_MIN_RESOURCE_NO_LABEL = TestMixedQueueResourceCalculation.createResource(2048.0, 8.0);
    private static final Resource A1_EXPECTED_MIN_RESOURCE_NO_LABEL = TestMixedQueueResourceCalculation.createResource(1024.0, 5.0);
    private static final Resource A2_EXPECTED_MIN_RESOURCE_NO_LABEL = TestMixedQueueResourceCalculation.createResource(1024.0, 2.0);
    private static final Resource B_EXPECTED_MIN_RESOURCE_NO_LABEL = TestMixedQueueResourceCalculation.createResource(3072.0, 8.0);
    private static final Resource A_EXPECTED_MIN_RESOURCE_X_LABEL = TestMixedQueueResourceCalculation.createResource(30720.0, 30.0);
    private static final Resource A1_EXPECTED_MIN_RESOURCE_X_LABEL = TestMixedQueueResourceCalculation.createResource(20480.0, 0.0);
    private static final Resource A2_EXPECTED_MIN_RESOURCE_X_LABEL = TestMixedQueueResourceCalculation.createResource(10240.0, 30.0);
    private static final Resource B_EXPECTED_MIN_RESOURCE_X_LABEL = TestMixedQueueResourceCalculation.createResource(30720.0, 30.0);
    private static final Resource A_EXPECTED_MIN_RESOURCE_Y_LABEL = TestMixedQueueResourceCalculation.createResource(8096.0, 42.0);
    private static final Resource A1_EXPECTED_MIN_RESOURCE_Y_LABEL = TestMixedQueueResourceCalculation.createResource(6186.0, 21.0);
    private static final Resource A2_EXPECTED_MIN_RESOURCE_Y_LABEL = TestMixedQueueResourceCalculation.createResource(1910.0, 21.0);
    private static final Resource B_EXPECTED_MIN_RESOURCE_Y_LABEL = TestMixedQueueResourceCalculation.createResource(12384.0, 18.0);
    private static final Resource A_EXPECTED_MIN_RESOURCE_Z_LABEL = TestMixedQueueResourceCalculation.createResource(7168.0, 11.0);
    private static final Resource A1_EXPECTED_MIN_RESOURCE_Z_LABEL = TestMixedQueueResourceCalculation.createResource(6451.0, 4.0);
    private static final Resource A2_EXPECTED_MIN_RESOURCE_Z_LABEL = TestMixedQueueResourceCalculation.createResource(716.0, 7.0);
    private static final Resource B_EXPECTED_MIN_RESOURCE_Z_LABEL = TestMixedQueueResourceCalculation.createResource(3072.0, 4.0);
    private static final Resource EMPTY_LABEL_RESOURCE = Resource.newInstance((int)5120, (int)16);
    private static final String A_VECTOR_NO_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(2048.0), TestMixedQueueResourceCalculation.percentage(50.0f));
    private static final String A1_VECTOR_NO_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(1024.0), TestMixedQueueResourceCalculation.percentage(70.0f));
    private static final String A2_VECTOR_NO_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(1024.0), TestMixedQueueResourceCalculation.percentage(30.0f));
    private static final String B_VECTOR_NO_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.weight(3.0f), TestMixedQueueResourceCalculation.percentage(50.0f));
    private static final String A_VECTOR_X_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(50.0f), TestMixedQueueResourceCalculation.weight(3.0f));
    private static final String A1_VECTOR_X_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(20480.0), TestMixedQueueResourceCalculation.percentage(10.0f));
    private static final String A2_VECTOR_X_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(10240.0), TestMixedQueueResourceCalculation.absolute(30.0));
    private static final String B_VECTOR_X_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(50.0f), TestMixedQueueResourceCalculation.percentage(50.0f));
    private static final String A_VECTOR_Y_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(8096.0), TestMixedQueueResourceCalculation.weight(1.0f));
    private static final String A1_VECTOR_Y_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(6186.0), TestMixedQueueResourceCalculation.weight(3.0f));
    private static final String A2_VECTOR_Y_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.weight(3.0f), TestMixedQueueResourceCalculation.weight(3.0f));
    private static final String B_VECTOR_Y_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(100.0f), TestMixedQueueResourceCalculation.percentage(30.0f));
    private static final String A_VECTOR_Z_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(70.0f), TestMixedQueueResourceCalculation.absolute(11.0));
    private static final String A1_VECTOR_Z_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(90.0f), TestMixedQueueResourceCalculation.percentage(40.0f));
    private static final String A2_VECTOR_Z_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(10.0f), TestMixedQueueResourceCalculation.weight(4.0f));
    private static final String B_VECTOR_Z_LABEL = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(30.0f), TestMixedQueueResourceCalculation.absolute(4.0));
    private static final String A_VECTOR_NO_REMAINING_RESOURCE = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(30.0f), TestMixedQueueResourceCalculation.weight(6.0f));
    private static final String A11_VECTOR_NO_REMAINING_RESOURCE = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(35.0f), TestMixedQueueResourceCalculation.percentage(25.0f));
    private static final String A12_VECTOR_NO_REMAINING_RESOURCE = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(65.0f), TestMixedQueueResourceCalculation.percentage(75.0f));
    private static final String A2_VECTOR_NO_REMAINING_RESOURCE = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.weight(3.0f), TestMixedQueueResourceCalculation.percentage(100.0f));
    private static final String B_VECTOR_NO_REMAINING_RESOURCE = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(8095.0), TestMixedQueueResourceCalculation.percentage(30.0f));
    private static final String B1_VECTOR_NO_REMAINING_RESOURCE = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.weight(5.0f), TestMixedQueueResourceCalculation.absolute(3.0));
    private static final String A_VECTOR_WITH_WARNINGS = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(100.0f), TestMixedQueueResourceCalculation.weight(6.0f));
    private static final String A12_VECTOR_WITH_WARNING = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.percentage(100.0f), TestMixedQueueResourceCalculation.percentage(100.0f));
    private static final String A2_VECTOR_WITH_WARNING = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(2048.0), TestMixedQueueResourceCalculation.percentage(100.0f));
    private static final String B_VECTOR_WITH_WARNING = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(8096.0), TestMixedQueueResourceCalculation.percentage(30.0f));
    private static final String B1_VECTOR_WITH_WARNING = TestMixedQueueResourceCalculation.createCapacityVector(TestMixedQueueResourceCalculation.absolute(10256.0), TestMixedQueueResourceCalculation.absolute(3.0));

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.csConf.setLegacyQueueModeEnabled(false);
    }

    @Test
    public void testComplexHierarchyWithoutRemainingResource() throws IOException {
        this.setupQueueHierarchyWithoutRemainingResource();
        QueueAssertionBuilder assertionBuilder = this.createAssertionBuilder().withQueue("root.a").assertEffectiveMinResource(A_COMPLEX_NO_REMAINING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, A_COMPLEX_NO_REMAINING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.a.a1").assertEffectiveMinResource(A1_COMPLEX_NO_REMAINING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, A1_COMPLEX_NO_REMAINING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.a.a1.a11").assertEffectiveMinResource(A11_COMPLEX_NO_REMAINING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, A11_COMPLEX_NO_REMAINING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.a.a1.a12").assertEffectiveMinResource(A12_COMPLEX_NO_REMAINING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, A12_COMPLEX_NO_REMAINING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.a.a2").assertEffectiveMinResource(A2_COMPLEX_NO_REMAINING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, A2_COMPLEX_NO_REMAINING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.b").assertEffectiveMinResource(B_COMPLEX_NO_REMAINING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, B_COMPLEX_NO_REMAINING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.b.b1").assertEffectiveMinResource(B1_COMPLEX_NO_REMAINING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, B1_COMPLEX_NO_REMAINING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.c").assertEffectiveMinResource(C_COMPLEX_NO_REMAINING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, C_COMPLEX_NO_REMAINING_RESOURCE, UPDATE_RESOURCE)).build();
        this.update(assertionBuilder, UPDATE_RESOURCE);
    }

    @Test
    public void testComplexHierarchyWithWarnings() throws IOException {
        this.setupQueueHierarchyWithWarnings();
        QueueAssertionBuilder assertionBuilder = this.createAssertionBuilder().withQueue("root.a").assertEffectiveMinResource(A_WARNING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, A_WARNING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.a.a1").assertEffectiveMinResource(A1_WARNING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, A1_WARNING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.a.a2").assertEffectiveMinResource(A2_WARNING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, A2_WARNING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.a.a1.a11").assertEffectiveMinResource(ZERO_RESOURCE).assertAbsoluteCapacity(0.0).withQueue("root.a.a1.a12").assertEffectiveMinResource(A12_WARNING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, A12_WARNING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.b").assertEffectiveMinResource(B_WARNING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, B_WARNING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.b.b1").assertEffectiveMinResource(B1_WARNING_RESOURCE).assertAbsoluteCapacity(this.resourceCalculator.divide(UPDATE_RESOURCE, B1_WARNING_RESOURCE, UPDATE_RESOURCE)).withQueue("root.c").assertEffectiveMinResource(ZERO_RESOURCE).assertAbsoluteCapacity(0.0).build();
        QueueCapacityUpdateContext updateContext = this.update(assertionBuilder, UPDATE_RESOURCE);
        Optional<QueueUpdateWarning> queueCZeroResourceWarning = this.getSpecificWarning(updateContext.getUpdateWarnings(), QueueUpdateWarning.QueueUpdateWarningType.QUEUE_ZERO_RESOURCE, "root.c");
        Optional<QueueUpdateWarning> queueARemainingResourceWarning = this.getSpecificWarning(updateContext.getUpdateWarnings(), QueueUpdateWarning.QueueUpdateWarningType.BRANCH_UNDERUTILIZED, "root.a");
        Optional<QueueUpdateWarning> queueBDownscalingWarning = this.getSpecificWarning(updateContext.getUpdateWarnings(), QueueUpdateWarning.QueueUpdateWarningType.BRANCH_DOWNSCALED, "root.b");
        Optional<QueueUpdateWarning> queueA11ZeroResourceWarning = this.getSpecificWarning(updateContext.getUpdateWarnings(), QueueUpdateWarning.QueueUpdateWarningType.QUEUE_ZERO_RESOURCE, "root.a.a1.a11");
        Assert.assertTrue((boolean)queueCZeroResourceWarning.isPresent());
        Assert.assertTrue((boolean)queueARemainingResourceWarning.isPresent());
        Assert.assertTrue((boolean)queueBDownscalingWarning.isPresent());
        Assert.assertTrue((boolean)queueA11ZeroResourceWarning.isPresent());
    }

    @Test
    public void testZeroResourceIfNoMemory() throws IOException {
        this.csConf.setCapacityVector("root.a", "", A_VECTOR_ZERO_RESOURCE);
        this.csConf.setCapacityVector("root.b", "", B_VECTOR_ZERO_RESOURCE);
        QueueAssertionBuilder assertionBuilder = this.createAssertionBuilder().withQueue("root.a").assertEffectiveMinResource(ZERO_RESOURCE).withQueue("root.b").assertEffectiveMinResource(TestMixedQueueResourceCalculation.createResource(16384.0, 8.0)).build();
        QueueCapacityUpdateContext updateContext = this.update(assertionBuilder, UPDATE_RESOURCE);
        Optional<QueueUpdateWarning> queueAZeroResourceWarning = this.getSpecificWarning(updateContext.getUpdateWarnings(), QueueUpdateWarning.QueueUpdateWarningType.QUEUE_ZERO_RESOURCE, "root.a");
        Optional<QueueUpdateWarning> rootUnderUtilizedWarning = this.getSpecificWarning(updateContext.getUpdateWarnings(), QueueUpdateWarning.QueueUpdateWarningType.BRANCH_UNDERUTILIZED, "root");
        Assert.assertTrue((boolean)queueAZeroResourceWarning.isPresent());
        Assert.assertTrue((boolean)rootUnderUtilizedWarning.isPresent());
    }

    @Test
    public void testDifferentMinimumAndMaximumCapacityTypes() throws IOException {
        this.csConf.setCapacityVector("root.a", "", A_MIN_VECTOR_DIFFERENT_MIN_MAX);
        this.csConf.setMaximumCapacityVector("root.a", "", A_MAX_VECTOR_DIFFERENT_MIN_MAX);
        this.csConf.setCapacityVector("root.b", "", B_MIN_VECTOR_DIFFERENT_MIN_MAX);
        this.csConf.setMaximumCapacityVector("root.b", "", B_MAX_VECTOR_DIFFERENT_MIN_MAX);
        QueueAssertionBuilder assertionBuilder = this.createAssertionBuilder().withQueue("root.a").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)UPDATE_RESOURCE, (double)0.5)).assertEffectiveMaxResource(A_EXPECTED_MAX_RESOURCE_DIFFERENT_MIN_MAX).withQueue("root.b").assertEffectiveMinResource(ResourceUtils.multiplyFloor((Resource)UPDATE_RESOURCE, (double)0.5)).assertEffectiveMaxResource(B_EXPECTED_MAX_RESOURCE_DIFFERENT_MIN_MAX).build();
        QueueCapacityUpdateContext updateContext = this.update(assertionBuilder, UPDATE_RESOURCE);
        Assert.assertEquals((long)0L, (long)updateContext.getUpdateWarnings().size());
        this.csConf.setMaximumCapacityVector("root.b", "", B_INVALID_MAX_VECTOR);
        try {
            this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
            this.update(assertionBuilder, UPDATE_RESOURCE);
            Assert.fail((String)"WEIGHT maximum capacity type is not supported, an error should be thrown when set up");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMaximumResourceWarnings() throws IOException {
        this.csConf.setMaximumCapacityVector("root.a.a1", "", A1_MAX_VECTOR_MAX_WARNINGS);
        this.csConf.setCapacityVector("root.a.a1.a11", "", A11_MIN_VECTOR_MAX_WARNINGS);
        this.csConf.setCapacityVector("root.a.a1.a12", "", A12_MIN_VECTOR_MAX_WARNINGS);
        this.csConf.setMaximumCapacityVector("root.a.a1.a11", "", A11_MAX_VECTOR_MAX_WARNINGS);
        QueueAssertionBuilder assertionBuilder = this.createAssertionBuilder().withQueue("root.a.a1.a11").assertEffectiveMinResource(A11_EXPECTED_MIN_RESOURCE_MAX_WARNINGS).assertEffectiveMaxResource(A11_EXPECTED_MAX_RESOURCE_MAX_WARNINGS).withQueue("root.a.a1.a12").assertEffectiveMinResource(A12_EXPECTED_MIN_RESOURCE_MAX_WARNINGS).assertEffectiveMaxResource(A12_EXPECTED_MAX_RESOURCE_MAX_WARNINGS).build();
        QueueCapacityUpdateContext updateContext = this.update(assertionBuilder, UPDATE_RESOURCE);
        Optional<QueueUpdateWarning> queueA11ExceedsParentMaxResourceWarning = this.getSpecificWarning(updateContext.getUpdateWarnings(), QueueUpdateWarning.QueueUpdateWarningType.QUEUE_MAX_RESOURCE_EXCEEDS_PARENT, "root.a.a1.a11");
        Optional<QueueUpdateWarning> queueA11MinExceedsMaxWarning = this.getSpecificWarning(updateContext.getUpdateWarnings(), QueueUpdateWarning.QueueUpdateWarningType.QUEUE_EXCEEDS_MAX_RESOURCE, "root.a.a1.a11");
        Assert.assertTrue((boolean)queueA11ExceedsParentMaxResourceWarning.isPresent());
        Assert.assertTrue((boolean)queueA11MinExceedsMaxWarning.isPresent());
    }

    @Test
    public void testNodeLabels() throws Exception {
        this.setLabeledQueueConfigs();
        QueueAssertionBuilder assertionBuilder = this.createAssertionBuilder().withQueue("root.a").assertEffectiveMinResource(A_EXPECTED_MIN_RESOURCE_NO_LABEL, "").withQueue("root.a.a1").assertEffectiveMinResource(A1_EXPECTED_MIN_RESOURCE_NO_LABEL, "").withQueue("root.a.a2").assertEffectiveMinResource(A2_EXPECTED_MIN_RESOURCE_NO_LABEL, "").withQueue("root.b").assertEffectiveMinResource(B_EXPECTED_MIN_RESOURCE_NO_LABEL, "").withQueue("root.a").assertEffectiveMinResource(A_EXPECTED_MIN_RESOURCE_X_LABEL, X_LABEL).withQueue("root.a.a1").assertEffectiveMinResource(A1_EXPECTED_MIN_RESOURCE_X_LABEL, X_LABEL).withQueue("root.a.a2").assertEffectiveMinResource(A2_EXPECTED_MIN_RESOURCE_X_LABEL, X_LABEL).withQueue("root.b").assertEffectiveMinResource(B_EXPECTED_MIN_RESOURCE_X_LABEL, X_LABEL).withQueue("root.a").assertEffectiveMinResource(A_EXPECTED_MIN_RESOURCE_Y_LABEL, Y_LABEL).withQueue("root.a.a1").assertEffectiveMinResource(A1_EXPECTED_MIN_RESOURCE_Y_LABEL, Y_LABEL).withQueue("root.a.a2").assertEffectiveMinResource(A2_EXPECTED_MIN_RESOURCE_Y_LABEL, Y_LABEL).withQueue("root.b").assertEffectiveMinResource(B_EXPECTED_MIN_RESOURCE_Y_LABEL, Y_LABEL).withQueue("root.a").assertEffectiveMinResource(A_EXPECTED_MIN_RESOURCE_Z_LABEL, Z_LABEL).withQueue("root.a.a1").assertEffectiveMinResource(A1_EXPECTED_MIN_RESOURCE_Z_LABEL, Z_LABEL).withQueue("root.a.a2").assertEffectiveMinResource(A2_EXPECTED_MIN_RESOURCE_Z_LABEL, Z_LABEL).withQueue("root.b").assertEffectiveMinResource(B_EXPECTED_MIN_RESOURCE_Z_LABEL, Z_LABEL).build();
        this.update(assertionBuilder, UPDATE_RESOURCE, EMPTY_LABEL_RESOURCE);
    }

    private void setLabeledQueueConfigs() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)X_LABEL, (Object)Y_LABEL, (Object)Z_LABEL));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)H1_NODE, (int)0), TestUtils.toSet(X_LABEL), (Object)NodeId.newInstance((String)H2_NODE, (int)0), TestUtils.toSet(Y_LABEL), (Object)NodeId.newInstance((String)H3_NODE, (int)0), TestUtils.toSet(Y_LABEL), (Object)NodeId.newInstance((String)H4_NODE, (int)0), TestUtils.toSet(Z_LABEL), (Object)NodeId.newInstance((String)H5_NODE, (int)0), (Object)RMNodeLabelsManager.EMPTY_STRING_SET));
        this.mockRM.registerNode("h1:1234", 61440, 60);
        this.mockRM.registerNode("h2:1234", 10240, 25);
        this.mockRM.registerNode("h3:1234", 10240, 35);
        this.mockRM.registerNode("h4:1234", 10240, 15);
        this.csConf.setCapacityVector("root.a", "", A_VECTOR_NO_LABEL);
        this.csConf.setCapacityVector("root.a.a1", "", A1_VECTOR_NO_LABEL);
        this.csConf.setCapacityVector("root.a.a2", "", A2_VECTOR_NO_LABEL);
        this.csConf.setCapacityVector("root.b", "", B_VECTOR_NO_LABEL);
        this.csConf.setCapacityVector("root.a", X_LABEL, A_VECTOR_X_LABEL);
        this.csConf.setCapacityVector("root.a.a1", X_LABEL, A1_VECTOR_X_LABEL);
        this.csConf.setCapacityVector("root.a.a2", X_LABEL, A2_VECTOR_X_LABEL);
        this.csConf.setCapacityVector("root.b", X_LABEL, B_VECTOR_X_LABEL);
        this.csConf.setCapacityVector("root.a", Y_LABEL, A_VECTOR_Y_LABEL);
        this.csConf.setCapacityVector("root.a.a1", Y_LABEL, A1_VECTOR_Y_LABEL);
        this.csConf.setCapacityVector("root.a.a2", Y_LABEL, A2_VECTOR_Y_LABEL);
        this.csConf.setCapacityVector("root.b", Y_LABEL, B_VECTOR_Y_LABEL);
        this.csConf.setCapacityVector("root.a", Z_LABEL, A_VECTOR_Z_LABEL);
        this.csConf.setCapacityVector("root.a.a1", Z_LABEL, A1_VECTOR_Z_LABEL);
        this.csConf.setCapacityVector("root.a.a2", Z_LABEL, A2_VECTOR_Z_LABEL);
        this.csConf.setCapacityVector("root.b", Z_LABEL, B_VECTOR_Z_LABEL);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
    }

    private void setupQueueHierarchyWithoutRemainingResource() throws IOException {
        this.csConf.setState("root.b", QueueState.STOPPED);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        this.setQueues();
        this.csConf.setState("root.b", QueueState.RUNNING);
        this.csConf.setCapacityVector("root.a", "", A_VECTOR_NO_REMAINING_RESOURCE);
        this.csConf.setCapacityVector("root.a.a1", "", A1_VECTOR_NO_REMAINING_RESOURCE);
        this.csConf.setCapacityVector("root.a.a1.a11", "", A11_VECTOR_NO_REMAINING_RESOURCE);
        this.csConf.setCapacityVector("root.a.a1.a12", "", A12_VECTOR_NO_REMAINING_RESOURCE);
        this.csConf.setCapacityVector("root.a.a2", "", A2_VECTOR_NO_REMAINING_RESOURCE);
        this.csConf.setCapacityVector("root.b", "", B_VECTOR_NO_REMAINING_RESOURCE);
        this.csConf.setCapacityVector("root.b.b1", "", B1_VECTOR_NO_REMAINING_RESOURCE);
        this.csConf.setCapacityVector("root.c", "", C_VECTOR_NO_REMAINING_RESOURCE);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
    }

    private void setupQueueHierarchyWithWarnings() throws IOException {
        this.csConf.setState("root.b", QueueState.STOPPED);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
        this.setQueues();
        this.csConf.setState("root.b", QueueState.RUNNING);
        this.csConf.setCapacityVector("root.a", "", A_VECTOR_WITH_WARNINGS);
        this.csConf.setCapacityVector("root.a.a1", "", A1_VECTOR_WITH_WARNING);
        this.csConf.setCapacityVector("root.a.a1.a11", "", A11_VECTOR_WITH_WARNING);
        this.csConf.setCapacityVector("root.a.a1.a12", "", A12_VECTOR_WITH_WARNING);
        this.csConf.setCapacityVector("root.a.a2", "", A2_VECTOR_WITH_WARNING);
        this.csConf.setCapacityVector("root.b", "", B_VECTOR_WITH_WARNING);
        this.csConf.setCapacityVector("root.b.b1", "", B1_VECTOR_WITH_WARNING);
        this.csConf.setCapacityVector("root.c", "", C_VECTOR_WITH_WARNING);
        this.cs.reinitialize((Configuration)this.csConf, this.mockRM.getRMContext());
    }

    private void setQueues() {
        this.csConf.setQueues("root", new String[]{"a", "b", "c"});
        this.csConf.setQueues("root.a", new String[]{"a1", "a2"});
        this.csConf.setQueues("root.b", new String[]{"b1"});
    }

    private Optional<QueueUpdateWarning> getSpecificWarning(Collection<QueueUpdateWarning> warnings, QueueUpdateWarning.QueueUpdateWarningType warningTypeToSelect, String queue) {
        return warnings.stream().filter(w -> w.getWarningType().equals((Object)warningTypeToSelect) && w.getQueue().equals(queue)).findFirst();
    }
}

