/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestPartitionQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.PendingAsk;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNodeLabelContainerAllocation {
    private final int GB = 1024;
    private YarnConfiguration conf;
    RMNodeLabelsManager mgr;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        this.mgr = new NullRMNodeLabelsManager();
        this.mgr.init((Configuration)this.conf);
    }

    private Configuration getConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{"a", "b", "c"});
        conf.setCapacityByLabel("root", "x", 100.0f);
        conf.setCapacityByLabel("root", "y", 100.0f);
        conf.setCapacityByLabel("root", "z", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 10.0f);
        conf.setMaximumCapacity("root.a", 15.0f);
        conf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        conf.setCapacityByLabel("root.a", "x", 100.0f);
        String B = "root.b";
        conf.setCapacity("root.b", 20.0f);
        conf.setAccessibleNodeLabels("root.b", this.toSet("y", "z"));
        conf.setCapacityByLabel("root.b", "y", 100.0f);
        conf.setCapacityByLabel("root.b", "z", 100.0f);
        String C = "root.c";
        conf.setCapacity("root.c", 70.0f);
        conf.setMaximumCapacity("root.c", 70.0f);
        conf.setAccessibleNodeLabels("root.c", RMNodeLabelsManager.EMPTY_STRING_SET);
        String A1 = "root.a.a1";
        conf.setQueues("root.a", new String[]{"a1"});
        conf.setCapacity("root.a.a1", 100.0f);
        conf.setMaximumCapacity("root.a.a1", 100.0f);
        conf.setCapacityByLabel("root.a.a1", "x", 100.0f);
        String B1 = "root.b.b1";
        conf.setQueues("root.b", new String[]{"b1"});
        conf.setCapacity("root.b.b1", 100.0f);
        conf.setMaximumCapacity("root.b.b1", 100.0f);
        conf.setCapacityByLabel("root.b.b1", "y", 100.0f);
        conf.setCapacityByLabel("root.b.b1", "z", 100.0f);
        String C1 = "root.c.c1";
        conf.setQueues("root.c", new String[]{"c1"});
        conf.setCapacity("root.c.c1", 100.0f);
        conf.setMaximumCapacity("root.c.c1", 100.0f);
        return conf;
    }

    private void checkTaskContainersHost(ApplicationAttemptId attemptId, ContainerId containerId, ResourceManager rm, String host) {
        ResourceScheduler scheduler = rm.getRMContext().getScheduler();
        SchedulerAppReport appReport = scheduler.getSchedulerAppInfo(attemptId);
        Assert.assertTrue((appReport.getLiveContainers().size() > 0 ? 1 : 0) != 0);
        for (RMContainer c : appReport.getLiveContainers()) {
            if (!c.getContainerId().equals((Object)containerId)) continue;
            Assert.assertEquals((Object)host, (Object)c.getAllocatedNode().getHost());
        }
    }

    private <E> Set<E> toSet(E ... elements) {
        HashSet set = Sets.newHashSet((Object[])elements);
        return set;
    }

    @Test(timeout=300000L)
    public void testContainerAllocationWithSingleUserLimits() throws Exception {
        final NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
        mgr.init((Configuration)this.conf);
        mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithDefaultQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager((RMNodeLabelsManager)mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8000);
        rm1.registerNode("h2:1234", 8000);
        MockNM nm3 = rm1.registerNode("h3:1234", 8000);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "");
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED));
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "");
        Assert.assertFalse((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED));
        for (int id = 3; id <= 8; ++id) {
            containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)id);
            am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
            Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED));
        }
        rm1.close();
    }

    @Test(timeout=300000L)
    public void testContainerAllocateWithComplexLabels() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y"), (Object)NodeId.newInstance((String)"h3", (int)0), this.toSet("y"), (Object)NodeId.newInstance((String)"h4", (int)0), this.toSet("z"), (Object)NodeId.newInstance((String)"h5", (int)0), (Object)RMNodeLabelsManager.EMPTY_STRING_SET));
        MockRM rm1 = new MockRM(TestUtils.getComplexConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 2048);
        MockNM nm2 = rm1.registerNode("h2:1234", 2048);
        MockNM nm3 = rm1.registerNode("h3:1234", 2048);
        MockNM nm4 = rm1.registerNode("h4:1234", 2048);
        MockNM nm5 = rm1.registerNode("h5:1234", 2048);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data2);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertTrue((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED));
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h2");
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm5);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm4, containerId, RMContainerState.ALLOCATED));
        Assert.assertFalse((boolean)rm1.waitForState(nm5, containerId, RMContainerState.ALLOCATED));
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b2").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm5);
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED));
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h3");
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "z");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)3L);
        Assert.assertTrue((boolean)rm1.waitForState(nm4, containerId, RMContainerState.ALLOCATED));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h4");
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testContainerAllocateWithLabels() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8000);
        MockNM nm2 = rm1.registerNode("h2:1234", 8000);
        MockNM nm3 = rm1.registerNode("h3:1234", 8000);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data2);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm3);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED));
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED));
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h1");
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm3);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "y");
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED));
        Assert.assertTrue((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED));
        this.checkTaskContainersHost(am2.getApplicationAttemptId(), containerId, rm1, "h2");
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c1").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm3);
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED));
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h3");
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testContainerAllocateWithDefaultQueueLabels() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithDefaultQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8000);
        MockNM nm2 = rm1.registerNode("h2:1234", 8000);
        MockNM nm3 = rm1.registerNode("h3:1234", 8000);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data2);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED));
        Assert.assertTrue((boolean)rm1.waitForState(nm1, containerId, RMContainerState.ALLOCATED));
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h1");
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED));
        Assert.assertTrue((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED));
        this.checkTaskContainersHost(am2.getApplicationAttemptId(), containerId, rm1, "h2");
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(200L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c1").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm3);
        am3.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am3.getApplicationAttemptId(), (long)2L);
        Assert.assertFalse((boolean)rm1.waitForState(nm2, containerId, RMContainerState.ALLOCATED));
        Assert.assertTrue((boolean)rm1.waitForState(nm3, containerId, RMContainerState.ALLOCATED));
        this.checkTaskContainersHost(am3.getApplicationAttemptId(), containerId, rm1, "h3");
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testContainerReservationWithLabels() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y"), (Object)NodeId.newInstance((String)"h3", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithDefaultQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        rm1.registerNode("h2:1234", 8192);
        rm1.registerNode("h3:1234", 8192);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 4096, 2, new ArrayList<ContainerId>());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h1");
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertTrue((schedulerApp1.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)9216L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)4096L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved("x").getMemorySize());
        Assert.assertEquals((long)4096L, (long)leafQueue.getQueueResourceUsage().getReserved("x").getMemorySize());
        am1.allocate("*", 4096, 0, new ArrayList<ContainerId>());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertEquals((long)5120L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved("x").getMemorySize());
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testContainerReservationContinueLookingWithLabels() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app1").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).withAmLabel("x").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h1");
        Assert.assertEquals((long)1L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertFalse((schedulerApp1.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2048L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved("x").getMemorySize());
        Assert.assertEquals((long)2048L, (long)leafQueue.getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved("x").getMemorySize());
        am1.allocate("*", 5120, 2, 5, new ArrayList<ContainerId>(), "x");
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h1");
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertFalse((schedulerApp1.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)7168L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved("x").getMemorySize());
        Assert.assertEquals((long)7168L, (long)leafQueue.getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved("x").getMemorySize());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h2");
        Assert.assertEquals((long)3L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertFalse((schedulerApp1.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)12288L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved("x").getMemorySize());
        Assert.assertEquals((long)12288L, (long)leafQueue.getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved("x").getMemorySize());
        am1.allocate("*", 3072, 2, 10, new ArrayList<ContainerId>(), "x");
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertEquals((long)3L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getReservedContainers().size());
        Assert.assertEquals((long)15360L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)3072L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved("x").getMemorySize());
        Assert.assertEquals((long)15360L, (long)leafQueue.getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)3072L, (long)leafQueue.getQueueResourceUsage().getReserved("x").getMemorySize());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)5L);
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h2");
        Assert.assertEquals((long)4L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)schedulerApp1.getReservedContainers().size());
        Assert.assertEquals((long)15360L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved("x").getMemorySize());
        Assert.assertEquals((long)15360L, (long)leafQueue.getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved("x").getMemorySize());
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testContainerReservationContinueLookingWithDefaultLabels() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithDefaultQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 8192);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm1).withAppName("app1").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h1");
        Assert.assertEquals((long)1L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertFalse((schedulerApp1.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2048L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved("x").getMemorySize());
        Assert.assertEquals((long)2048L, (long)leafQueue.getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved("x").getMemorySize());
        am1.allocate("*", 5120, 2, 5, new ArrayList<ContainerId>(), null);
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L);
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h1");
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertFalse((schedulerApp1.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)7168L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved("x").getMemorySize());
        Assert.assertEquals((long)7168L, (long)leafQueue.getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved("x").getMemorySize());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L);
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h2");
        Assert.assertEquals((long)3L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertFalse((schedulerApp1.getReservedContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)12288L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved("x").getMemorySize());
        Assert.assertEquals((long)12288L, (long)leafQueue.getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved("x").getMemorySize());
        am1.allocate("*", 3072, 2, 10, new ArrayList<ContainerId>(), null);
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertEquals((long)3L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getReservedContainers().size());
        Assert.assertEquals((long)15360L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)3072L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved("x").getMemorySize());
        Assert.assertEquals((long)15360L, (long)leafQueue.getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)3072L, (long)leafQueue.getQueueResourceUsage().getReserved("x").getMemorySize());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        containerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)5L);
        this.checkTaskContainersHost(am1.getApplicationAttemptId(), containerId, rm1, "h2");
        Assert.assertEquals((long)4L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)schedulerApp1.getReservedContainers().size());
        Assert.assertEquals((long)15360L, (long)cs.getRootQueue().getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)cs.getRootQueue().getQueueResourceUsage().getReserved("x").getMemorySize());
        Assert.assertEquals((long)15360L, (long)leafQueue.getQueueResourceUsage().getUsed("x").getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueue.getQueueResourceUsage().getReserved("x").getMemorySize());
        rm1.close();
    }

    @Test(timeout=120000L)
    public void testRMContainerLeakInLeafQueue() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x"));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x"), (Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithDefaultQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        rm1.registerNode("h2:1234", 8192);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app1").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app2").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data);
        MockRM.launchAndRegisterAM(app2, rm1, nm1);
        am1.allocate("*", 7168, 2, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a1");
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)1L, (long)schedulerApp1.getReservedContainers().size());
        rm1.killApp(app2.getApplicationId());
        rm1.waitForState(app2.getApplicationId(), RMAppState.KILLED);
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        Assert.assertEquals((long)2L, (long)schedulerApp1.getLiveContainers().size());
        Assert.assertEquals((long)0L, (long)schedulerApp1.getReservedContainers().size());
        rm1.killApp(app1.getApplicationId());
        rm1.waitForState(app1.getApplicationId(), RMAppState.KILLED);
        Assert.assertEquals((long)0L, (long)leafQueue.getIgnoreExclusivityRMContainers().size());
        rm1.close();
    }

    private void checkPendingResource(MockRM rm, int priority2, ApplicationAttemptId attemptId, int memory) {
        CapacityScheduler cs = (CapacityScheduler)rm.getRMContext().getScheduler();
        FiCaSchedulerApp app = cs.getApplicationAttempt(attemptId);
        PendingAsk ask = app.getAppSchedulingInfo().getPendingAsk(TestUtils.toSchedulerKey(priority2), "*");
        Assert.assertEquals((long)memory, (long)(ask.getPerAllocationResource().getMemorySize() * (long)ask.getCount()));
    }

    private void checkLaunchedContainerNumOnNode(MockRM rm, NodeId nodeId, int numContainers) {
        CapacityScheduler cs = (CapacityScheduler)rm.getRMContext().getScheduler();
        SchedulerNode node = cs.getSchedulerNode(nodeId);
        Assert.assertEquals((long)numContainers, (long)node.getNumContainers());
    }

    @Test
    public void testResourceRequestUpdateNodePartitions() throws Exception {
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x"), (Object)NodeLabel.newInstance((String)"y", (boolean)false), (Object)NodeLabel.newInstance((String)"z", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(this.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm2 = rm1.registerNode("h2:1234", 40960);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        ArrayList<ResourceRequest> resourceRequest = new ArrayList<ResourceRequest>();
        resourceRequest.add(am1.createResourceReq("/default-rack", 1024, 3, 1, ""));
        resourceRequest.add(am1.createResourceReq("*", 1024, 3, 5, "y"));
        resourceRequest.add(am1.createResourceReq("h1:1234", 1024, 3, 2, ""));
        resourceRequest.add(am1.createResourceReq("*", 1024, 2, 3, "y"));
        resourceRequest.add(am1.createResourceReq("h2:1234", 1024, 2, 4, null));
        resourceRequest.add(am1.createResourceReq("*", 1024, 4, 3, null));
        resourceRequest.add(am1.createResourceReq("h2:1234", 1024, 4, 4, null));
        am1.allocate(resourceRequest, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getRMContext().getScheduler();
        FiCaSchedulerApp app = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        this.checkNodePartitionOfRequestedPriority(app.getAppSchedulingInfo(), 2, "y");
        this.checkNodePartitionOfRequestedPriority(app.getAppSchedulingInfo(), 3, "y");
        this.checkNodePartitionOfRequestedPriority(app.getAppSchedulingInfo(), 4, "");
        ArrayList<ResourceRequest> newReq = new ArrayList<ResourceRequest>();
        newReq.add(am1.createResourceReq("h2:1234", 1024, 3, 4, null));
        newReq.add(am1.createResourceReq("*", 1024, 3, 5, "z"));
        newReq.add(am1.createResourceReq("h1:1234", 1024, 3, 4, null));
        newReq.add(am1.createResourceReq("*", 1024, 4, 5, "z"));
        am1.allocate(newReq, new ArrayList<ContainerId>());
        this.checkNodePartitionOfRequestedPriority(app.getAppSchedulingInfo(), 3, "z");
        this.checkNodePartitionOfRequestedPriority(app.getAppSchedulingInfo(), 4, "z");
        this.checkNodePartitionOfRequestedPriority(app.getAppSchedulingInfo(), 2, "y");
        ArrayList<ResourceRequest> resourceRequest1 = new ArrayList<ResourceRequest>();
        resourceRequest1.add(am1.createResourceReq("/default-rack", 1024, 3, 1, null));
        resourceRequest1.add(am1.createResourceReq("*", 1024, 3, 5, null));
        resourceRequest1.add(am1.createResourceReq("h1:1234", 1024, 3, 2, ""));
        resourceRequest1.add(am1.createResourceReq("/default-rack", 1024, 2, 1, null));
        resourceRequest1.add(am1.createResourceReq("*", 1024, 2, 3, ""));
        resourceRequest1.add(am1.createResourceReq("h2:1234", 1024, 2, 4, null));
        am1.allocate(resourceRequest1, new ArrayList<ContainerId>());
        this.checkNodePartitionOfRequestedPriority(app.getAppSchedulingInfo(), 3, "");
        this.checkNodePartitionOfRequestedPriority(app.getAppSchedulingInfo(), 2, "");
    }

    private void checkNodePartitionOfRequestedPriority(AppSchedulingInfo info, int priority2, String expectedPartition) {
        for (SchedulerRequestKey key : info.getSchedulerKeys()) {
            if (key.getPriority().getPriority() != priority2) continue;
            Assert.assertEquals((String)("Expected partition is " + expectedPartition), (Object)expectedPartition, (Object)info.getAppPlacementAllocator(key).getPrimaryRequestedNodePartition());
        }
    }

    @Test
    public void testPreferenceOfNeedyAppsTowardsNodePartitions() throws Exception {
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x"), (Object)NodeLabel.newInstance((String)"y", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 102400);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        am1.allocate("*", 1024, 8, new ArrayList<ContainerId>());
        am2.allocate("*", 1024, 8, new ArrayList<ContainerId>(), "y");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        }
        FiCaSchedulerApp schedulerApp1 = cs.getApplicationAttempt(am1.getApplicationAttemptId());
        FiCaSchedulerApp schedulerApp2 = cs.getApplicationAttempt(am2.getApplicationAttemptId());
        this.checkNumOfContainersInAnAppOnGivenNode(0, nm1.getNodeId(), schedulerApp1);
        this.checkNumOfContainersInAnAppOnGivenNode(9, nm2.getNodeId(), schedulerApp1);
        this.checkNumOfContainersInAnAppOnGivenNode(8, nm1.getNodeId(), schedulerApp2);
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm2.getNodeId(), schedulerApp2);
        rm1.close();
    }

    private void checkNumOfContainersInAnAppOnGivenNode(int expectedNum, NodeId nodeId, FiCaSchedulerApp app) {
        int num = 0;
        for (RMContainer container : app.getLiveContainers()) {
            if (!container.getAllocatedNode().equals((Object)nodeId)) continue;
            ++num;
        }
        Assert.assertEquals((long)expectedNum, (long)num);
    }

    @Test
    public void testPreferenceOfNeedyPrioritiesUnderSameAppTowardsNodePartitions() throws Exception {
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x"), (Object)NodeLabel.newInstance((String)"y", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 102400);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        am1.allocate("*", 1024, 1, 1, new ArrayList<ContainerId>(), "");
        am1.allocate("*", 1024, 1, 2, new ArrayList<ContainerId>(), "y");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent((RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId())));
        this.checkPendingResource(rm1, 1, am1.getApplicationAttemptId(), 1024);
        this.checkPendingResource(rm1, 2, am1.getApplicationAttemptId(), 0);
        rm1.close();
    }

    @Test
    public void testNonLabeledResourceRequestGetPreferrenceToNonLabeledNode() throws Exception {
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false), (Object)NodeLabel.newInstance((String)"y")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 8192);
        MockNM nm2 = rm1.registerNode("h2:1234", 102400);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        am1.allocate("*", 1024, 6, 1, new ArrayList<ContainerId>(), "");
        for (int i = 2; i < 8; ++i) {
            ContainerId nextContainerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)i);
            Assert.assertTrue((boolean)rm1.waitForState(Arrays.asList(nm1, nm2), nextContainerId, RMContainerState.ALLOCATED));
        }
        this.checkLaunchedContainerNumOnNode(rm1, nm1.getNodeId(), 0);
        this.checkLaunchedContainerNumOnNode(rm1, nm2.getNodeId(), 7);
        rm1.close();
    }

    @Test
    public void testPreferenceOfQueuesTowardsNodePartitions() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b", "c"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 33.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 33.0f);
        csConf.setQueues("root.a", new String[]{"a1", "a2"});
        String B = "root.b";
        csConf.setCapacity("root.b", 33.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 33.0f);
        csConf.setQueues("root.b", new String[]{"b1", "b2"});
        String C = "root.c";
        csConf.setCapacity("root.c", 34.0f);
        csConf.setAccessibleNodeLabels("root.c", this.toSet("x"));
        csConf.setCapacityByLabel("root.c", "x", 34.0f);
        csConf.setQueues("root.c", new String[]{"c1", "c2"});
        String A1 = "root.a.a1";
        csConf.setCapacity("root.a.a1", 50.0f);
        csConf.setCapacityByLabel("root.a.a1", "x", 100.0f);
        csConf.setDefaultNodeLabelExpression("root.a.a1", "x");
        String A2 = "root.a.a2";
        csConf.setCapacity("root.a.a2", 50.0f);
        csConf.setCapacityByLabel("root.a.a2", "x", 0.0f);
        String B1 = "root.b.b1";
        csConf.setCapacity("root.b.b1", 50.0f);
        csConf.setCapacityByLabel("root.b.b1", "x", 100.0f);
        csConf.setDefaultNodeLabelExpression("root.b.b1", "x");
        String B2 = "root.b.b2";
        csConf.setCapacity("root.b.b2", 50.0f);
        csConf.setCapacityByLabel("root.b.b2", "x", 0.0f);
        String C1 = "root.c.c1";
        csConf.setCapacity("root.c.c1", 50.0f);
        csConf.setCapacityByLabel("root.c.c1", "x", 100.0f);
        csConf.setDefaultNodeLabelExpression("root.c.c1", "x");
        String C2 = "root.c.c2";
        csConf.setCapacity("root.c.c2", 50.0f);
        csConf.setCapacityByLabel("root.c.c2", "x", 0.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false), (Object)NodeLabel.newInstance((String)"y")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 20480);
        MockNM nm2 = rm1.registerNode("h2:1234", 102400);
        MockRMAppSubmissionData data5 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data5);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        MockRMAppSubmissionData data4 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a2").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data4);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        MockRMAppSubmissionData data3 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data3);
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm1);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b2").withUnmanagedAM(false).build();
        RMApp app4 = MockRMAppSubmitter.submit(rm1, data2);
        MockAM am4 = MockRM.launchAndRegisterAM(app4, rm1, nm2);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c1").withUnmanagedAM(false).build();
        RMApp app5 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am5 = MockRM.launchAndRegisterAM(app5, rm1, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("c2").withUnmanagedAM(false).build();
        RMApp app6 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am6 = MockRM.launchAndRegisterAM(app6, rm1, nm2);
        am1.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        am2.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        am3.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        am4.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        am5.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        am6.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        for (int i = 0; i < 15; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        this.checkLaunchedContainerNumOnNode(rm1, nm1.getNodeId(), 18);
        this.checkPendingResource(rm1, 1, am1.getApplicationAttemptId(), 0);
        this.checkPendingResource(rm1, 1, am2.getApplicationAttemptId(), 5120);
        this.checkPendingResource(rm1, 1, am3.getApplicationAttemptId(), 0);
        this.checkPendingResource(rm1, 1, am4.getApplicationAttemptId(), 5120);
        this.checkPendingResource(rm1, 1, am5.getApplicationAttemptId(), 0);
        this.checkPendingResource(rm1, 1, am6.getApplicationAttemptId(), 5120);
        rm1.close();
    }

    @Test
    public void testQueuesWithoutAccessUsingPartitionedNodes() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 50.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 100.0f);
        String B = "root.b";
        csConf.setCapacity("root.b", 50.0f);
        csConf.setAccessibleNodeLabels("root.b", new HashSet());
        csConf.setUserLimitFactor("root.b", 5.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false), (Object)NodeLabel.newInstance((String)"y")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        MockNM nm2 = rm1.registerNode("h2:1234", 10240);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        am1.allocate("*", 1024, 50, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        SchedulerNode schedulerNode1 = cs.getSchedulerNode(nm1.getNodeId());
        int cycleWaited = 0;
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
            if (schedulerNode1.getNumContainers() != 0) continue;
            ++cycleWaited;
        }
        Assert.assertEquals((long)10L, (long)cycleWaited);
        this.checkLaunchedContainerNumOnNode(rm1, nm1.getNodeId(), 10);
        this.checkLaunchedContainerNumOnNode(rm1, nm2.getNodeId(), 10);
        rm1.close();
    }

    @Test
    public void testAMContainerAllocationWillAlwaysBeExclusive() throws Exception {
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false), (Object)NodeLabel.newInstance((String)"y")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM(TestUtils.getConfigurationWithQueueLabels((Configuration)this.conf)){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        String nodeIdStr = "h1:1234";
        MockNM nm1 = rm1.registerNode(nodeIdStr, 8192);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
        RMApp app = MockRMAppSubmitter.submit(rm1, data);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        Assert.assertTrue((String)"Scheduler diagnostics should have reason for not assigning the node", (boolean)app.getDiagnostics().toString().contains("Skipping assigning to Node in Ignore Exclusivity mode. "));
        Assert.assertTrue((String)"Scheduler diagnostics should have last processed node information", (boolean)app.getDiagnostics().toString().contains(" Last Node which was processed for the application : " + nodeIdStr + " ( Partition : [x]"));
        Assert.assertEquals((long)0L, (long)((FiCaSchedulerNode)cs.getSchedulerNode(nm1.getNodeId())).getNumContainers());
        rm1.close();
    }

    @Test(timeout=60000L)
    public void testQueueMaxCapacitiesWillNotBeHonoredWhenNotRespectingExclusivity() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 50.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.a", "x", 50.0f);
        csConf.setUserLimit("root.a", 200.0f);
        String B = "root.b";
        csConf.setCapacity("root.b", 50.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.b", "x", 50.0f);
        csConf.setUserLimit("root.b", 200.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        MockNM nm2 = rm1.registerNode("h2:1234", 10240);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        am1.allocate("*", 1024, 10, new ArrayList<ContainerId>());
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        SchedulerNode schedulerNode1 = cs.getSchedulerNode(nm1.getNodeId());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        Assert.assertEquals((long)10L, (long)schedulerNode1.getNumContainers());
        LeafQueue leafQueue = (LeafQueue)cs.getQueue("a");
        Assert.assertFalse((boolean)leafQueue.getIgnoreExclusivityRMContainers().containsKey("y"));
        Assert.assertEquals((long)10L, (long)((TreeSet)leafQueue.getIgnoreExclusivityRMContainers().get("x")).size());
        cs.handle((SchedulerEvent)new AppAttemptRemovedSchedulerEvent(am1.getApplicationAttemptId(), RMAppAttemptState.FINISHED, false));
        Assert.assertFalse((boolean)leafQueue.getIgnoreExclusivityRMContainers().containsKey("x"));
        rm1.close();
    }

    private void checkQueueUsedCapacity(String queueName, CapacityScheduler cs, String nodePartition, float usedCapacity, float absoluteUsedCapacity) {
        float epsilon = 1.0E-6f;
        CSQueue queue = cs.getQueue(queueName);
        Assert.assertNotNull((String)("Failed to get queue=" + queueName), (Object)queue);
        Assert.assertEquals((float)usedCapacity, (float)queue.getQueueCapacities().getUsedCapacity(nodePartition), (float)epsilon);
        Assert.assertEquals((float)absoluteUsedCapacity, (float)queue.getQueueCapacities().getAbsoluteUsedCapacity(nodePartition), (float)epsilon);
    }

    private void doNMHeartbeat(MockRM rm, NodeId nodeId, int nHeartbeat) {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm.getRMContext().getRMNodes().get(nodeId);
        for (int i = 0; i < nHeartbeat; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
    }

    private void waitSchedulerNodeJoined(MockRM rm, int expectedNodeNum) throws InterruptedException {
        for (int totalWaitTick = 100; expectedNodeNum > rm.getResourceScheduler().getNumClusterNodes() && totalWaitTick > 0; --totalWaitTick) {
            Thread.sleep(100L);
        }
    }

    private void waitSchedulerNodeHasUpdatedLabels(CapacityScheduler cs, MockNM nm, String partition) throws InterruptedException {
        FiCaSchedulerNode node = cs.getNode(nm.getNodeId());
        for (int totalWaitTick = 20; !node.getLabels().contains(partition) && totalWaitTick > 0; --totalWaitTick) {
            Thread.sleep(100L);
        }
    }

    @Test
    public void testQueueUsedCapacitiesUpdate() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 50.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 50.0f);
        csConf.setQueues("root.a", new String[]{"a1", "a2"});
        String A1 = "root.a.a1";
        csConf.setCapacity("root.a.a1", 50.0f);
        csConf.setAccessibleNodeLabels("root.a.a1", this.toSet("x"));
        csConf.setCapacityByLabel("root.a.a1", "x", 50.0f);
        String A2 = "root.a.a2";
        csConf.setCapacity("root.a.a2", 50.0f);
        csConf.setAccessibleNodeLabels("root.a.a2", this.toSet("x"));
        csConf.setCapacityByLabel("root.a.a2", "x", 50.0f);
        String B = "root.b";
        csConf.setCapacity("root.b", 50.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 50.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        this.checkQueueUsedCapacity("a", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "", 0.0f, 0.0f);
        MockNM nm1 = rm.registerNode("h1:1234", 10240);
        MockNM nm2 = rm.registerNode("h2:1234", 10240);
        this.checkQueueUsedCapacity("a", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "", 0.0f, 0.0f);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm2);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>());
        this.doNMHeartbeat(rm, nm2.getNodeId(), 10);
        this.checkQueueUsedCapacity("a", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a", cs, "", 0.4f, 0.2f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.8f, 0.2f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "", 0.2f, 0.2f);
        am1.allocate("*", 1024, 2, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 10);
        this.checkQueueUsedCapacity("a", cs, "x", 0.4f, 0.2f);
        this.checkQueueUsedCapacity("a", cs, "", 0.4f, 0.2f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.8f, 0.2f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.8f, 0.2f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.2f, 0.2f);
        this.checkQueueUsedCapacity("root", cs, "", 0.2f, 0.2f);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a2").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 10);
        this.checkQueueUsedCapacity("a", cs, "x", 0.6f, 0.3f);
        this.checkQueueUsedCapacity("a", cs, "", 0.6f, 0.3f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.8f, 0.2f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.8f, 0.2f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.4f, 0.1f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.4f, 0.1f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.3f, 0.3f);
        this.checkQueueUsedCapacity("root", cs, "", 0.3f, 0.3f);
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h3", (int)0), this.toSet("x")));
        MockNM nm3 = rm.registerNode("h3:1234", 10240);
        MockNM nm4 = rm.registerNode("h4:1234", 10240);
        this.waitSchedulerNodeJoined(rm, 4);
        this.waitSchedulerNodeHasUpdatedLabels(cs, nm3, "x");
        this.waitSchedulerNodeHasUpdatedLabels(cs, nm4, "");
        this.checkQueueUsedCapacity("a", cs, "x", 0.3f, 0.15f);
        this.checkQueueUsedCapacity("a", cs, "", 0.3f, 0.15f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.4f, 0.1f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.4f, 0.1f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.2f, 0.05f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.2f, 0.05f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.15f, 0.15f);
        this.checkQueueUsedCapacity("root", cs, "", 0.15f, 0.15f);
        csConf.setCapacity("root.a", 100.0f);
        csConf.setCapacityByLabel("root.a", "x", 100.0f);
        csConf.setCapacity("root.b", 0.0f);
        csConf.setCapacityByLabel("root.b", "x", 0.0f);
        cs.reinitialize((Configuration)csConf, rm.getRMContext());
        this.checkQueueUsedCapacity("a", cs, "x", 0.15f, 0.15f);
        this.checkQueueUsedCapacity("a", cs, "", 0.15f, 0.15f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.2f, 0.1f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.2f, 0.1f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.1f, 0.05f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.1f, 0.05f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.15f, 0.15f);
        this.checkQueueUsedCapacity("root", cs, "", 0.15f, 0.15f);
        am1.allocate(null, Arrays.asList(ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)2L), ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)3L), ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)4L)));
        this.checkQueueUsedCapacity("a", cs, "x", 0.05f, 0.05f);
        this.checkQueueUsedCapacity("a", cs, "", 0.1f, 0.1f);
        this.checkQueueUsedCapacity("a1", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("a1", cs, "", 0.1f, 0.05f);
        this.checkQueueUsedCapacity("a2", cs, "x", 0.1f, 0.05f);
        this.checkQueueUsedCapacity("a2", cs, "", 0.1f, 0.05f);
        this.checkQueueUsedCapacity("b", cs, "x", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("b", cs, "", 0.0f, 0.0f);
        this.checkQueueUsedCapacity("root", cs, "x", 0.05f, 0.05f);
        this.checkQueueUsedCapacity("root", cs, "", 0.1f, 0.1f);
        rm.close();
    }

    @Test
    public void testOrderOfAllocationOnPartitions() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b", "c", "d"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 25.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 30.0f);
        String B = "root.b";
        csConf.setCapacity("root.b", 25.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 70.0f);
        String C = "root.c";
        csConf.setAccessibleNodeLabels("root.c", Collections.emptySet());
        csConf.setCapacity("root.c", 25.0f);
        String D = "root.d";
        csConf.setAccessibleNodeLabels("root.d", Collections.emptySet());
        csConf.setCapacity("root.d", 25.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("h1:1234", 10240);
        MockNM nm2 = rm.registerNode("h2:1234", 10240);
        MockRMAppSubmissionData data3 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data3);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm2);
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("b").withUnmanagedAM(false).build();
        RMApp app2 = MockRMAppSubmitter.submit(rm, data2);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm2);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("c").withUnmanagedAM(false).build();
        RMApp app3 = MockRMAppSubmitter.submit(rm, data1);
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm, nm2);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("d").withUnmanagedAM(false).build();
        RMApp app4 = MockRMAppSubmitter.submit(rm, data);
        MockAM am4 = MockRM.launchAndRegisterAM(app4, rm, nm2);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 1);
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 1);
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "");
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 2);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        this.doNMHeartbeat(rm, nm1.getNodeId(), 2);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "");
        am3.allocate("*", 1024, 2, new ArrayList<ContainerId>(), "");
        am4.allocate("*", 1024, 2, new ArrayList<ContainerId>(), "");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 2);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(3, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(0, nm1.getNodeId(), cs.getApplicationAttempt(am3.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(0, nm1.getNodeId(), cs.getApplicationAttempt(am4.getApplicationAttemptId()));
        this.doNMHeartbeat(rm, nm1.getNodeId(), 1);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(3, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am3.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(0, nm1.getNodeId(), cs.getApplicationAttempt(am4.getApplicationAttemptId()));
        this.doNMHeartbeat(rm, nm1.getNodeId(), 1);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(3, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am3.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am4.getApplicationAttemptId()));
        this.doNMHeartbeat(rm, nm1.getNodeId(), 1);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(3, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am3.getApplicationAttemptId()));
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am4.getApplicationAttemptId()));
    }

    @Test
    public void testOrderOfAllocationOnPartitionsWhenAccessibilityIsAll() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 25.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("*"));
        csConf.setCapacityByLabel("root.a", "x", 60.0f);
        String B = "root.b";
        csConf.setCapacity("root.b", 75.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 40.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = rm.registerNode("h1:1234", 10240);
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a").withAmLabel("x").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("b").withAmLabel("x").build();
        RMApp app2 = MockRMAppSubmitter.submit(rm, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm1);
        am1.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        am2.allocate("*", 1024, 1, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 1);
        this.checkNumOfContainersInAnAppOnGivenNode(2, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
    }

    @Test
    public void testParentQueueMaxCapsAreRespected() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        csConf.setCapacity("root.a", 10.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.a", "x", 50.0f);
        String B = "root.b";
        csConf.setCapacity("root.b", 90.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.b", "x", 50.0f);
        csConf.setQueues("root.a", new String[]{"a1", "a2"});
        String A1 = "root.a.a1";
        csConf.setCapacity("root.a.a1", 50.0f);
        csConf.setAccessibleNodeLabels("root.a.a1", this.toSet("x"));
        csConf.setCapacityByLabel("root.a.a1", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.a.a1", "x", 100.0f);
        csConf.setUserLimitFactor("root.a.a1", 100.0f);
        String A2 = "root.a.a2";
        csConf.setCapacity("root.a.a2", 50.0f);
        csConf.setAccessibleNodeLabels("root.a.a2", this.toSet("x"));
        csConf.setCapacityByLabel("root.a.a2", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.a.a2", "x", 100.0f);
        csConf.setUserLimitFactor("root.a.a2", 100.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.mgr);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = new MockNM("h1:1234", 24576, rm.getResourceTrackerService());
        nm1.registerNode();
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm, data1);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        am1.allocate("*", 4096, 2, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 10);
        this.checkNumOfContainersInAnAppOnGivenNode(3, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(2048L, rm).withAppName("app").withUser("user").withAcls(null).withQueue("a2").withAmLabel("x").build();
        RMApp app2 = MockRMAppSubmitter.submit(rm, data);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm1);
        am2.allocate("*", 2048, 2, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm, nm1.getNodeId(), 10);
        this.checkNumOfContainersInAnAppOnGivenNode(1, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
    }

    @Test
    public void testQueueMetricsWithLabels() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String queueA = "root.a";
        csConf.setCapacity("root.a", 25.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.a", "x", 50.0f);
        String queueB = "root.b";
        csConf.setCapacity("root.b", 75.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.b", "x", 50.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"y", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h2", (int)0), this.toSet("y")));
        MockRM rm1 = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        MockNM nm2 = rm1.registerNode("h2:1234", 10240);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        LeafQueue leafQueueA = (LeafQueue)cs.getQueue("a");
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getAllocatedMB());
        LeafQueue leafQueueB = (LeafQueue)cs.getQueue("b");
        Assert.assertEquals((long)0L, (long)leafQueueB.getMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)leafQueueB.getMetrics().getAllocatedMB());
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a").withAmLabel("x").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 5, new ArrayList<ContainerId>(), "x");
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        SchedulerNode schedulerNode1 = cs.getSchedulerNode(nm1.getNodeId());
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        Assert.assertEquals((long)5L, (long)schedulerNode1.getNumContainers());
        SchedulerNodeReport reportNm1 = rm1.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)5120L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)5120L, (long)reportNm1.getAvailableResource().getMemorySize());
        SchedulerNodeReport reportNm2 = rm1.getResourceScheduler().getNodeReport(nm2.getNodeId());
        Assert.assertEquals((long)0L, (long)reportNm2.getUsedResource().getMemorySize());
        Assert.assertEquals((long)10240L, (long)reportNm2.getAvailableResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)0L, (long)leafQueueB.getMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)leafQueueB.getMetrics().getAllocatedMB());
        CSQueue rootQueue = cs.getRootQueue();
        Assert.assertEquals((long)0L, (long)(rootQueue.getMetrics().getAvailableMB() + rootQueue.getMetrics().getAllocatedMB()));
        cs.killAllAppsInQueue("a");
        rm1.waitForState(app1.getApplicationId(), RMAppState.KILLED);
        rm1.waitForAppRemovedFromScheduler(app1.getApplicationId());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getUsedAMResourceMB());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getUsedAMResourceVCores());
        rm1.close();
    }

    @Test
    public void testQueueMetricsWithLabelsOnDefaultLabelNode() throws Exception {
        int i;
        int i2;
        int i3;
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String queueA = "root.a";
        csConf.setCapacity("root.a", 25.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.a", "x", 50.0f);
        String queueB = "root.b";
        csConf.setCapacity("root.b", 75.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.b", "x", 50.0f);
        csConf.setBoolean("yarn.scheduler.capacity.user-metrics.enable", true);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        MockNM nm2 = rm1.registerNode("h2:1234", 10240);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        SchedulerNode schedulerNode1 = cs.getSchedulerNode(nm1.getNodeId());
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        SchedulerNode schedulerNode2 = cs.getSchedulerNode(nm2.getNodeId());
        for (i3 = 0; i3 < 50; ++i3) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        for (i3 = 0; i3 < 50; ++i3) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        }
        double delta = 1.0E-4;
        CSQueue leafQueue = cs.getQueue("a");
        CSQueue leafQueueB = cs.getQueue("b");
        CSQueue rootQueue = cs.getRootQueue();
        Assert.assertEquals((double)10240.0, (double)rootQueue.getMetrics().getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2560.0, (double)leafQueue.getMetrics().getAvailableMB(), (double)delta);
        Assert.assertEquals((double)7680.0, (double)leafQueueB.getMetrics().getAvailableMB(), (double)delta);
        MetricsSystem ms = leafQueueB.getMetrics().getMetricsSystem();
        QueueMetrics partXMetrics = (QueueMetrics)TestPartitionQueueMetrics.partitionSource(ms, "x");
        QueueMetrics partDefaultMetrics = (QueueMetrics)TestPartitionQueueMetrics.partitionSource(ms, "");
        QueueMetrics queueAMetrics = (QueueMetrics)TestQueueMetrics.queueSource(ms, "root.a");
        QueueMetrics queueBMetrics = (QueueMetrics)TestQueueMetrics.queueSource(ms, "root.b");
        QueueMetrics queueAPartDefaultMetrics = (QueueMetrics)TestPartitionQueueMetrics.queueSource(ms, "", "root.a");
        QueueMetrics queueAPartXMetrics = (QueueMetrics)TestPartitionQueueMetrics.queueSource(ms, "x", "root.a");
        QueueMetrics queueBPartDefaultMetrics = (QueueMetrics)TestPartitionQueueMetrics.queueSource(ms, "", "root.b");
        QueueMetrics queueBPartXMetrics = (QueueMetrics)TestPartitionQueueMetrics.queueSource(ms, "x", "root.b");
        QueueMetrics rootMetrics = (QueueMetrics)TestQueueMetrics.queueSource(ms, "root");
        Assert.assertEquals((double)10240.0, (double)partXMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)10240.0, (double)partDefaultMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2560.0, (double)queueAPartDefaultMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)7680.0, (double)queueBPartDefaultMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)5120.0, (double)queueAPartXMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)5120.0, (double)queueBPartXMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)10240.0, (double)rootMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2560.0, (double)queueAMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)7680.0, (double)queueBMetrics.getAvailableMB(), (double)delta);
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a").withUnmanagedAM(false).build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm2);
        am1.allocate("*", 1024, 3, new ArrayList<ContainerId>());
        for (i2 = 0; i2 < 50; ++i2) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        for (i2 = 0; i2 < 50; ++i2) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        }
        Assert.assertEquals((long)3L, (long)schedulerNode1.getNumContainers());
        SchedulerNodeReport reportNm1 = rm1.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)3072L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)7168L, (long)reportNm1.getAvailableResource().getMemorySize());
        SchedulerNodeReport reportNm2 = rm1.getResourceScheduler().getNodeReport(nm2.getNodeId());
        Assert.assertEquals((long)1024L, (long)reportNm2.getUsedResource().getMemorySize());
        Assert.assertEquals((long)9216L, (long)reportNm2.getAvailableResource().getMemorySize());
        Assert.assertEquals((double)7168.0, (double)partXMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)9216.0, (double)partDefaultMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)1536.0, (double)queueAPartDefaultMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)1024.0, (double)queueAPartDefaultMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)7680.0, (double)queueBPartDefaultMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)queueAPartXMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)3072.0, (double)queueAPartXMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)5120.0, (double)queueBPartXMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)1024.0, (double)queueAMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)1536.0, (double)queueAMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)queueBMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)7680.0, (double)queueBMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)queueAMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)queueAPartDefaultMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)queueAPartXMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)queueBPartDefaultMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)queueBPartXMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)1536.0, (double)leafQueue.getMetrics().getAvailableMB(), (double)delta);
        Assert.assertEquals((long)1024L, (long)leafQueue.getMetrics().getAllocatedMB());
        Assert.assertEquals((double)3072.0, (double)partXMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)1024.0, (double)partDefaultMetrics.getAllocatedMB(), (double)delta);
        QueueMetrics partDefaultQueueAUserMetrics = (QueueMetrics)TestPartitionQueueMetrics.userSource(ms, "", "user", "root.a");
        QueueMetrics partXQueueAUserMetrics = (QueueMetrics)TestPartitionQueueMetrics.userSource(ms, "x", "user", "root.a");
        QueueMetrics queueAUserMetrics = (QueueMetrics)TestQueueMetrics.userSource(ms, "root.a", "user");
        Assert.assertEquals((double)2048.0, (double)queueAUserMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)1024.0, (double)queueAUserMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)1536.0, (double)queueAPartDefaultMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)1024.0, (double)queueAPartDefaultMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)queueAPartXMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)3072.0, (double)queueAPartXMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)partDefaultQueueAUserMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)1024.0, (double)partDefaultQueueAUserMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)partXQueueAUserMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)3072.0, (double)partXQueueAUserMetrics.getAllocatedMB(), (double)delta);
        am1.allocate("*", 1024, 5, new ArrayList<ContainerId>());
        cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        Assert.assertEquals((long)2L, (long)schedulerNode2.getNumContainers());
        Assert.assertEquals((long)3L, (long)schedulerNode1.getNumContainers());
        Assert.assertEquals((long)512L, (long)leafQueue.getMetrics().getAvailableMB());
        Assert.assertEquals((long)2048L, (long)leafQueue.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)10240L, (long)(rootQueue.getMetrics().getAvailableMB() + rootQueue.getMetrics().getAllocatedMB()));
        Assert.assertEquals((double)512.0, (double)queueAMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((long)2048L, (long)queueAMetrics.getAllocatedMB());
        Assert.assertEquals((double)512.0, (double)queueAPartDefaultMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)queueAPartDefaultMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)queueAPartXMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)3072.0, (double)queueAPartXMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)1024.0, (double)partDefaultQueueAUserMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)partDefaultQueueAUserMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)partXQueueAUserMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)3072.0, (double)partXQueueAUserMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)1024.0, (double)queueAUserMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)queueAUserMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)7168.0, (double)partXMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)3072.0, (double)partXMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)8192.0, (double)partDefaultMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)partDefaultMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)4096.0, (double)queueAMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)4096.0, (double)queueAPartDefaultMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)4096.0, (double)partDefaultQueueAUserMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)4096.0, (double)queueAUserMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)4096.0, (double)partDefaultMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)queueAPartXMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)partXQueueAUserMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)partXMetrics.getPendingMB(), (double)delta);
        for (i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        for (i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        }
        Assert.assertEquals((double)512.0, (double)queueAMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((long)2048L, (long)queueAMetrics.getAllocatedMB());
        Assert.assertEquals((double)512.0, (double)queueAPartDefaultMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)queueAPartDefaultMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)queueAPartXMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)7168.0, (double)queueAPartXMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)1024.0, (double)partDefaultQueueAUserMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)partDefaultQueueAUserMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)partXQueueAUserMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)7168.0, (double)partXQueueAUserMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)1024.0, (double)queueAUserMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)queueAUserMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)3072.0, (double)partXMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)7168.0, (double)partXMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)8192.0, (double)partDefaultMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2048.0, (double)partDefaultMetrics.getAllocatedMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)queueAMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)queueAPartDefaultMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)partDefaultQueueAUserMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)queueAUserMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)partDefaultMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)queueAPartXMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)partXQueueAUserMetrics.getPendingMB(), (double)delta);
        Assert.assertEquals((double)0.0, (double)partXMetrics.getPendingMB(), (double)delta);
        rm1.killApp(app1.getApplicationId());
        rm1.waitForState(app1.getApplicationId(), RMAppState.KILLED);
        for (i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        for (i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        }
        Assert.assertEquals((double)10240.0, (double)rootQueue.getMetrics().getAvailableMB(), (double)delta);
        Assert.assertEquals((double)2560.0, (double)leafQueue.getMetrics().getAvailableMB(), (double)delta);
        Assert.assertEquals((double)7680.0, (double)leafQueueB.getMetrics().getAvailableMB(), (double)delta);
        Assert.assertEquals((long)2L, (long)queueAMetrics.getAggregateAllocatedContainers());
        Assert.assertEquals((long)2L, (long)queueAMetrics.getAggegatedReleasedContainers());
        Assert.assertEquals((long)2L, (long)queueAPartDefaultMetrics.getAggregateAllocatedContainers());
        Assert.assertEquals((long)2L, (long)queueAPartDefaultMetrics.getAggegatedReleasedContainers());
        Assert.assertEquals((long)7L, (long)partXMetrics.getAggregateAllocatedContainers());
        Assert.assertEquals((long)2L, (long)partDefaultMetrics.getAggregateAllocatedContainers());
        Assert.assertEquals((long)7L, (long)queueAPartXMetrics.getAggregateAllocatedContainers());
        Assert.assertEquals((long)7L, (long)queueAPartXMetrics.getAggegatedReleasedContainers());
        Assert.assertEquals((double)2560.0, (double)queueAPartDefaultMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)5120.0, (double)queueAPartXMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)3072.0, (double)queueAUserMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)3072.0, (double)partDefaultQueueAUserMetrics.getAvailableMB(), (double)delta);
        Assert.assertEquals((double)5120.0, (double)partXQueueAUserMetrics.getAvailableMB(), (double)delta);
        rm1.close();
    }

    @Test
    public void testQueueMetricsWithMixedLabels() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String queueA = "root.a";
        csConf.setCapacity("root.a", 100.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 100.0f);
        csConf.setMaximumCapacityByLabel("root.a", "x", 100.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)true)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        MockNM nm2 = rm1.registerNode("h2:1234", 12288);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        LeafQueue leafQueueA = (LeafQueue)cs.getQueue("a");
        Assert.assertEquals((long)12288L, (long)leafQueueA.getMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getAllocatedMB());
        RMApp app1 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a").withAmLabel("x").build());
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 5, new ArrayList<ContainerId>(), "x");
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        SchedulerNode schedulerNode1 = cs.getSchedulerNode(nm1.getNodeId());
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        Assert.assertEquals((long)6L, (long)schedulerNode1.getNumContainers());
        SchedulerNodeReport reportNm1 = rm1.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)6144L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)4096L, (long)reportNm1.getAvailableResource().getMemorySize());
        SchedulerNodeReport reportNm2 = rm1.getResourceScheduler().getNodeReport(nm2.getNodeId());
        Assert.assertEquals((long)0L, (long)reportNm2.getUsedResource().getMemorySize());
        Assert.assertEquals((long)12288L, (long)reportNm2.getAvailableResource().getMemorySize());
        Assert.assertEquals((long)12288L, (long)leafQueueA.getMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getAllocatedMB());
        RMApp app2 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a").withAmLabel("").build());
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        am2.allocate("*", 1024, 5, new ArrayList<ContainerId>(), "");
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        SchedulerNode schedulerNode2 = cs.getSchedulerNode(nm2.getNodeId());
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        }
        Assert.assertEquals((long)6L, (long)schedulerNode2.getNumContainers());
        reportNm1 = rm1.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)6144L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)4096L, (long)reportNm1.getAvailableResource().getMemorySize());
        reportNm2 = rm1.getResourceScheduler().getNodeReport(nm2.getNodeId());
        Assert.assertEquals((long)6144L, (long)reportNm2.getUsedResource().getMemorySize());
        Assert.assertEquals((long)6144L, (long)reportNm2.getAvailableResource().getMemorySize());
        Assert.assertEquals((long)6144L, (long)leafQueueA.getMetrics().getAvailableMB());
        Assert.assertEquals((long)6144L, (long)leafQueueA.getMetrics().getAllocatedMB());
        CSQueue rootQueue = cs.getRootQueue();
        Assert.assertEquals((long)12288L, (long)(rootQueue.getMetrics().getAvailableMB() + rootQueue.getMetrics().getAllocatedMB()));
        cs.killAllAppsInQueue("a");
        rm1.waitForState(app1.getApplicationId(), RMAppState.KILLED);
        rm1.waitForAppRemovedFromScheduler(app1.getApplicationId());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getUsedAMResourceMB());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getUsedAMResourceVCores());
        rm1.close();
    }

    @Test
    public void testTwoLevelQueueMetricsWithLabels() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String queueA = "root.a";
        csConf.setCapacity("root.a", 100.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 100.0f);
        csConf.setMaximumCapacityByLabel("root.a", "x", 100.0f);
        csConf.setQueues("root.a", new String[]{"a1"});
        String queueA1 = "root.a.a1";
        csConf.setCapacity("root.a.a1", 100.0f);
        csConf.setAccessibleNodeLabels("root.a.a1", this.toSet("x"));
        csConf.setCapacityByLabel("root.a.a1", "x", 100.0f);
        csConf.setMaximumCapacityByLabel("root.a.a1", "x", 100.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)true)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 10240);
        MockNM nm2 = rm1.registerNode("h2:1234", 12288);
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        ParentQueue leafQueueA = (ParentQueue)cs.getQueue("a");
        LeafQueue leafQueueA1 = (LeafQueue)cs.getQueue("a1");
        Assert.assertEquals((long)12288L, (long)leafQueueA1.getMetrics().getAvailableMB());
        Assert.assertEquals((long)0L, (long)leafQueueA1.getMetrics().getAllocatedMB());
        MetricsSystem ms = leafQueueA1.getMetrics().getMetricsSystem();
        QueueMetrics partXMetrics = (QueueMetrics)TestPartitionQueueMetrics.partitionSource(ms, "x");
        QueueMetrics partDefaultMetrics = (QueueMetrics)TestPartitionQueueMetrics.partitionSource(ms, "");
        QueueMetrics queueAPartDefaultMetrics = (QueueMetrics)TestPartitionQueueMetrics.queueSource(ms, "", "root.a");
        QueueMetrics queueAPartXMetrics = (QueueMetrics)TestPartitionQueueMetrics.queueSource(ms, "x", "root.a");
        QueueMetrics queueA1PartDefaultMetrics = (QueueMetrics)TestPartitionQueueMetrics.queueSource(ms, "", "root.a.a1");
        QueueMetrics queueA1PartXMetrics = (QueueMetrics)TestPartitionQueueMetrics.queueSource(ms, "x", "root.a.a1");
        QueueMetrics queueRootPartDefaultMetrics = (QueueMetrics)TestPartitionQueueMetrics.queueSource(ms, "", "root");
        QueueMetrics queueRootPartXMetrics = (QueueMetrics)TestPartitionQueueMetrics.queueSource(ms, "x", "root");
        QueueMetrics queueAMetrics = (QueueMetrics)TestQueueMetrics.queueSource(ms, "root.a");
        QueueMetrics queueA1Metrics = (QueueMetrics)TestQueueMetrics.queueSource(ms, "root.a.a1");
        QueueMetrics queueRootMetrics = (QueueMetrics)TestQueueMetrics.queueSource(ms, "root");
        Assert.assertEquals((long)12288L, (long)queueAMetrics.getAvailableMB());
        Assert.assertEquals((long)12288L, (long)queueA1Metrics.getAvailableMB());
        Assert.assertEquals((long)12288L, (long)queueRootMetrics.getAvailableMB());
        Assert.assertEquals((long)12288L, (long)leafQueueA.getMetrics().getAvailableMB());
        Assert.assertEquals((long)10240L, (long)queueA1PartXMetrics.getAvailableMB());
        Assert.assertEquals((long)10240L, (long)queueAPartXMetrics.getAvailableMB());
        Assert.assertEquals((long)10240L, (long)queueRootPartXMetrics.getAvailableMB());
        Assert.assertEquals((long)12288L, (long)queueA1PartDefaultMetrics.getAvailableMB());
        Assert.assertEquals((long)12288L, (long)queueAPartDefaultMetrics.getAvailableMB());
        Assert.assertEquals((long)12288L, (long)queueRootPartDefaultMetrics.getAvailableMB());
        Assert.assertEquals((long)10240L, (long)partXMetrics.getAvailableMB());
        Assert.assertEquals((long)12288L, (long)partDefaultMetrics.getAvailableMB());
        RMApp app1 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("x").build());
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 5, new ArrayList<ContainerId>(), "x");
        RMNode rmNode1 = (RMNode)rm1.getRMContext().getRMNodes().get(nm1.getNodeId());
        SchedulerNode schedulerNode1 = cs.getSchedulerNode(nm1.getNodeId());
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode1));
        }
        Assert.assertEquals((long)6L, (long)schedulerNode1.getNumContainers());
        SchedulerNodeReport reportNm1 = rm1.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)6144L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)4096L, (long)reportNm1.getAvailableResource().getMemorySize());
        SchedulerNodeReport reportNm2 = rm1.getResourceScheduler().getNodeReport(nm2.getNodeId());
        Assert.assertEquals((long)0L, (long)reportNm2.getUsedResource().getMemorySize());
        Assert.assertEquals((long)12288L, (long)reportNm2.getAvailableResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)queueAMetrics.getAllocatedMB());
        Assert.assertEquals((long)0L, (long)queueA1Metrics.getAllocatedMB());
        Assert.assertEquals((long)0L, (long)queueRootMetrics.getAllocatedMB());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)queueA1PartXMetrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)queueAPartXMetrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)queueRootPartXMetrics.getAllocatedMB());
        Assert.assertEquals((long)0L, (long)queueA1PartDefaultMetrics.getAllocatedMB());
        Assert.assertEquals((long)0L, (long)queueAPartDefaultMetrics.getAllocatedMB());
        Assert.assertEquals((long)0L, (long)queueRootPartDefaultMetrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)partXMetrics.getAllocatedMB());
        Assert.assertEquals((long)0L, (long)partDefaultMetrics.getAllocatedMB());
        RMApp app2 = MockRMAppSubmitter.submit(rm1, MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("").build());
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm2);
        am2.allocate("*", 1024, 5, new ArrayList<ContainerId>(), "");
        RMNode rmNode2 = (RMNode)rm1.getRMContext().getRMNodes().get(nm2.getNodeId());
        SchedulerNode schedulerNode2 = cs.getSchedulerNode(nm2.getNodeId());
        for (int i = 0; i < 50; ++i) {
            cs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(rmNode2));
        }
        Assert.assertEquals((long)6L, (long)schedulerNode2.getNumContainers());
        reportNm1 = rm1.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)6144L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)4096L, (long)reportNm1.getAvailableResource().getMemorySize());
        reportNm2 = rm1.getResourceScheduler().getNodeReport(nm2.getNodeId());
        Assert.assertEquals((long)6144L, (long)reportNm2.getUsedResource().getMemorySize());
        Assert.assertEquals((long)6144L, (long)reportNm2.getAvailableResource().getMemorySize());
        Assert.assertEquals((long)6144L, (long)leafQueueA.getMetrics().getAvailableMB());
        Assert.assertEquals((long)6144L, (long)leafQueueA.getMetrics().getAllocatedMB());
        CSQueue rootQueue = cs.getRootQueue();
        Assert.assertEquals((long)12288L, (long)(rootQueue.getMetrics().getAvailableMB() + rootQueue.getMetrics().getAllocatedMB()));
        Assert.assertEquals((long)6144L, (long)queueAMetrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)queueA1Metrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)queueRootMetrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)queueA1PartXMetrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)queueAPartXMetrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)queueRootPartXMetrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)queueA1PartDefaultMetrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)queueAPartDefaultMetrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)queueRootPartDefaultMetrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)partXMetrics.getAllocatedMB());
        Assert.assertEquals((long)6144L, (long)partDefaultMetrics.getAllocatedMB());
        cs.killAllAppsInQueue("a1");
        rm1.waitForState(app1.getApplicationId(), RMAppState.KILLED);
        rm1.waitForAppRemovedFromScheduler(app1.getApplicationId());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getUsedAMResourceMB());
        Assert.assertEquals((long)0L, (long)leafQueueA.getMetrics().getUsedAMResourceVCores());
        rm1.close();
    }

    @Test
    public void testQueueMetricsWithLabelsDisableElasticity() throws Exception {
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration((Configuration)this.conf);
        csConf.setQueues("root", new String[]{"a", "b"});
        csConf.setCapacityByLabel("root", "x", 100.0f);
        String queueA = "root.a";
        csConf.setCapacity("root.a", 50.0f);
        csConf.setMaximumCapacity("root.a", 100.0f);
        csConf.setAccessibleNodeLabels("root.a", this.toSet("x"));
        csConf.setCapacityByLabel("root.a", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.a", "x", 100.0f);
        String queueB = "root.b";
        csConf.setCapacity("root.b", 50.0f);
        csConf.setMaximumCapacity("root.b", 100.0f);
        csConf.setAccessibleNodeLabels("root.b", this.toSet("x"));
        csConf.setCapacityByLabel("root.b", "x", 50.0f);
        csConf.setMaximumCapacityByLabel("root.b", "x", 100.0f);
        csConf.setQueues("root.a", new String[]{"a1", "a2"});
        String A1 = "root.a.a1";
        csConf.setCapacity("root.a.a1", 20.0f);
        csConf.setMaximumCapacity("root.a.a1", 60.0f);
        csConf.setAccessibleNodeLabels("root.a.a1", this.toSet("x"));
        csConf.setCapacityByLabel("root.a.a1", "x", 60.0f);
        csConf.setMaximumCapacityByLabel("root.a.a1", "x", 30.0f);
        String A2 = "root.a.a2";
        csConf.setCapacity("root.a.a2", 80.0f);
        csConf.setMaximumCapacity("root.a.a2", 40.0f);
        csConf.setAccessibleNodeLabels("root.a.a2", this.toSet("x"));
        csConf.setCapacityByLabel("root.a.a2", "x", 40.0f);
        csConf.setMaximumCapacityByLabel("root.a.a2", "x", 20.0f);
        this.mgr.addToCluserNodeLabels((Collection)ImmutableSet.of((Object)NodeLabel.newInstance((String)"x", (boolean)false)));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"h1", (int)0), this.toSet("x")));
        MockRM rm1 = new MockRM((Configuration)csConf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestNodeLabelContainerAllocation.this.mgr;
            }
        };
        rm1.getRMContext().setNodeLabelManager(this.mgr);
        rm1.start();
        MockNM nm1 = rm1.registerNode("h1:1234", 20480);
        MockRMAppSubmissionData data3 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp app1 = MockRMAppSubmitter.submit(rm1, data3);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm1, nm1);
        am1.allocate("*", 1024, 6, new ArrayList<ContainerId>(), "x");
        CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
        this.doNMHeartbeat(rm1, nm1.getNodeId(), 50);
        this.checkNumOfContainersInAnAppOnGivenNode(6, nm1.getNodeId(), cs.getApplicationAttempt(am1.getApplicationAttemptId()));
        SchedulerNodeReport reportNm1 = rm1.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)6144L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)14336L, (long)reportNm1.getAvailableResource().getMemorySize());
        MockRMAppSubmissionData data2 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a2").withAmLabel("x").build();
        RMApp app2 = MockRMAppSubmitter.submit(rm1, data2);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm1, nm1);
        am2.allocate("*", 1024, 4, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm1, nm1.getNodeId(), 50);
        this.checkNumOfContainersInAnAppOnGivenNode(4, nm1.getNodeId(), cs.getApplicationAttempt(am2.getApplicationAttemptId()));
        reportNm1 = rm1.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)10240L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)10240L, (long)reportNm1.getAvailableResource().getMemorySize());
        cs.killAllAppsInQueue("a2");
        rm1.waitForState(app2.getApplicationId(), RMAppState.KILLED);
        rm1.waitForAppRemovedFromScheduler(app2.getApplicationId());
        MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a2").withAmLabel("x").build();
        RMApp app3 = MockRMAppSubmitter.submit(rm1, data1);
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm1, nm1);
        am3.allocate("*", 1024, 6, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm1, nm1.getNodeId(), 50);
        this.checkNumOfContainersInAnAppOnGivenNode(4, nm1.getNodeId(), cs.getApplicationAttempt(am3.getApplicationAttemptId()));
        Assert.assertEquals((long)10240L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)10240L, (long)reportNm1.getAvailableResource().getMemorySize());
        cs.killAllAppsInQueue("a1");
        rm1.waitForState(app1.getApplicationId(), RMAppState.KILLED);
        rm1.waitForAppRemovedFromScheduler(app1.getApplicationId());
        MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(1024L, rm1).withAppName("app").withUser("user").withAcls(null).withQueue("a1").withAmLabel("x").build();
        RMApp app4 = MockRMAppSubmitter.submit(rm1, data);
        MockAM am4 = MockRM.launchAndRegisterAM(app4, rm1, nm1);
        am4.allocate("*", 1024, 7, new ArrayList<ContainerId>(), "x");
        this.doNMHeartbeat(rm1, nm1.getNodeId(), 50);
        this.checkNumOfContainersInAnAppOnGivenNode(6, nm1.getNodeId(), cs.getApplicationAttempt(am4.getApplicationAttemptId()));
        Assert.assertEquals((long)10240L, (long)reportNm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)10240L, (long)reportNm1.getAvailableResource().getMemorySize());
        rm1.close();
    }
}

