/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerAllocationProposal;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.SchedulerContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;
import org.apache.hadoop.yarn.server.resourcemanager.security.AppPriorityACLsManager;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestParentQueue {
    private static final Resource QUEUE_B_RESOURCE = Resource.newInstance((int)14336, (int)22);
    private static final Resource QUEUE_A_RESOURCE = Resource.newInstance((int)6144, (int)10);
    private static final Logger LOG = LoggerFactory.getLogger(TestParentQueue.class);
    RMContext rmContext;
    YarnConfiguration conf;
    CapacitySchedulerConfiguration csConf;
    CapacitySchedulerContext csContext;
    CapacitySchedulerQueueContext queueContext;
    static final int GB = 1024;
    static final String DEFAULT_RACK = "/default";
    private final ResourceCalculator resourceComparator = new DefaultResourceCalculator();
    private static final String A = "a";
    private static final String B = "b";
    private static final String Q_A = "root.a";
    private static final String Q_B = "root.b";
    static final float DELTA = 1.0E-4f;
    private static final String C = "c";
    private static final String C1 = "c1";
    private static final String C11 = "c11";
    private static final String C111 = "c111";
    private static final String C1111 = "c1111";
    private static final String D = "d";
    private static final String A1 = "a1";
    private static final String A2 = "a2";
    private static final String B1 = "b1";
    private static final String B2 = "b2";
    private static final String B3 = "b3";
    private static final String B4 = "b4";

    @Before
    public void setUp() throws Exception {
        this.rmContext = TestUtils.getMockRMContext();
        this.conf = new YarnConfiguration();
        this.csConf = new CapacitySchedulerConfiguration();
        this.csContext = (CapacitySchedulerContext)Mockito.mock(CapacitySchedulerContext.class);
        Mockito.when((Object)this.csContext.getConf()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.csContext.getConfiguration()).thenReturn((Object)this.csConf);
        Mockito.when((Object)this.csContext.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024, (int)1));
        Mockito.when((Object)this.csContext.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)16384, (int)32));
        Mockito.when((Object)this.csContext.getClusterResource()).thenReturn((Object)Resources.createResource((int)0x190000, (int)3200));
        Mockito.when((Object)this.csContext.getPreemptionManager()).thenReturn((Object)new PreemptionManager());
        Mockito.when((Object)this.csContext.getResourceCalculator()).thenReturn((Object)this.resourceComparator);
        Mockito.when((Object)this.csContext.getRMContext()).thenReturn((Object)this.rmContext);
        Mockito.when((Object)this.csContext.getCapacitySchedulerQueueManager()).thenReturn((Object)new CapacitySchedulerQueueManager((Configuration)this.csConf, this.rmContext.getNodeLabelManager(), null));
        this.queueContext = new CapacitySchedulerQueueContext(this.csContext);
    }

    private void setupSingleLevelQueues(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{A, B});
        conf.setCapacity(Q_A, 30.0f);
        conf.setCapacity(Q_B, 70.0f);
        this.queueContext.reinitialize();
        LOG.info("Setup top-level queues a and b");
    }

    private void setupSingleLevelQueuesWithAbsoluteResource(CapacitySchedulerConfiguration conf) {
        conf.setQueues("root", new String[]{A, B});
        conf.setMinimumResourceRequirement("", new QueuePath(Q_A), QUEUE_A_RESOURCE);
        conf.setMinimumResourceRequirement("", new QueuePath(Q_B), QUEUE_B_RESOURCE);
        this.queueContext.reinitialize();
        LOG.info("Setup top-level queues a and b with absolute resource");
    }

    private FiCaSchedulerApp getMockApplication(int appId, String user) {
        FiCaSchedulerApp application = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
        ((FiCaSchedulerApp)Mockito.doReturn((Object)user).when((Object)application)).getUser();
        ((FiCaSchedulerApp)Mockito.doReturn((Object)Resources.createResource((int)0, (int)0)).when((Object)application)).getHeadroom();
        return application;
    }

    private void applyAllocationToQueue(Resource clusterResource, int allocatedMem, CSQueue queue) {
        ResourceCommitRequest request = (ResourceCommitRequest)Mockito.mock(ResourceCommitRequest.class);
        Mockito.when((Object)request.anythingAllocatedOrReserved()).thenReturn((Object)true);
        ContainerAllocationProposal allocation = (ContainerAllocationProposal)Mockito.mock(ContainerAllocationProposal.class);
        Mockito.when((Object)request.getTotalReleasedResource()).thenReturn((Object)Resources.none());
        Mockito.when((Object)request.getFirstAllocatedOrReservedContainer()).thenReturn((Object)allocation);
        SchedulerContainer scontainer = (SchedulerContainer)Mockito.mock(SchedulerContainer.class);
        Mockito.when((Object)allocation.getAllocatedOrReservedContainer()).thenReturn((Object)scontainer);
        Mockito.when((Object)allocation.getAllocatedOrReservedResource()).thenReturn((Object)Resources.createResource((int)allocatedMem));
        Mockito.when((Object)scontainer.getNodePartition()).thenReturn((Object)"");
        if (queue.accept(clusterResource, request)) {
            queue.apply(clusterResource, request);
        }
    }

    private void stubQueueAllocation(CSQueue queue, Resource clusterResource, FiCaSchedulerNode node, int allocation) {
        this.stubQueueAllocation(queue, clusterResource, node, allocation, NodeType.NODE_LOCAL);
    }

    private void stubQueueAllocation(final CSQueue queue, final Resource clusterResource, final FiCaSchedulerNode node, final int allocation, final NodeType type) {
        ((CSQueue)Mockito.doAnswer((Answer)new Answer<CSAssignment>(){

            public CSAssignment answer(InvocationOnMock invocation) throws Throwable {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    LOG.info("FOOBAR q.assignContainers q=" + queue.getQueuePath() + " alloc=" + allocation + " node=" + node.getNodeName());
                    Resource allocatedResource = Resources.createResource((int)allocation);
                    if (queue instanceof ParentQueue) {
                        ((ParentQueue)queue).allocateResource(clusterResource, allocatedResource, "");
                    } else {
                        FiCaSchedulerApp app1 = TestParentQueue.this.getMockApplication(0, "");
                        ((LeafQueue)queue).allocateResource(clusterResource, (SchedulerApplicationAttempt)app1, allocatedResource, null, null);
                    }
                    if (allocation > 0) {
                        ((CSQueue)Mockito.doReturn((Object)new CSAssignment(Resources.none(), type)).when((Object)queue)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), (ResourceLimits)ArgumentMatchers.any(ResourceLimits.class), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
                        Resource available = node.getUnallocatedResource();
                        ((FiCaSchedulerNode)Mockito.doReturn((Object)Resources.subtractFrom((Resource)available, (Resource)allocatedResource)).when((Object)node)).getUnallocatedResource();
                    }
                    return new CSAssignment(allocatedResource, type);
                }
            }
        }).when((Object)queue)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), (ResourceLimits)ArgumentMatchers.any(ResourceLimits.class), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
    }

    private float computeQueueAbsoluteUsedCapacity(CSQueue queue, int expectedMemory, Resource clusterResource) {
        return (float)expectedMemory / (float)clusterResource.getMemorySize();
    }

    private float computeQueueUsedCapacity(CSQueue queue, int expectedMemory, Resource clusterResource) {
        return (float)expectedMemory / ((float)clusterResource.getMemorySize() * queue.getAbsoluteCapacity());
    }

    private void verifyQueueMetrics(CSQueue queue, int expectedMemory, Resource clusterResource) {
        Assert.assertEquals((float)this.computeQueueAbsoluteUsedCapacity(queue, expectedMemory, clusterResource), (float)queue.getAbsoluteUsedCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)this.computeQueueUsedCapacity(queue, expectedMemory, clusterResource), (float)queue.getUsedCapacity(), (float)1.0E-4f);
    }

    @Test
    public void testSingleLevelQueues() throws Exception {
        this.setupSingleLevelQueues(this.csConf);
        CSQueueStore queues = new CSQueueStore();
        CSQueue root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        int memoryPerNode = 10;
        int coresPerNode = 16;
        int numNodes = 2;
        FiCaSchedulerNode node_0 = TestUtils.getMockNode("host_0", DEFAULT_RACK, 0, 10240);
        FiCaSchedulerNode node_1 = TestUtils.getMockNode("host_1", DEFAULT_RACK, 0, 10240);
        Resource clusterResource = Resources.createResource((int)20480, (int)32);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        LeafQueue a = (LeafQueue)queues.get(A);
        LeafQueue b = (LeafQueue)queues.get(B);
        a.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        b.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        queues.get("root").getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_0, 0);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_0, 1024);
        root.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.verifyQueueMetrics((CSQueue)a, 0, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 1024, clusterResource);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_1, 2048);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_1, 1024);
        root.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        InOrder allocationOrder = Mockito.inOrder((Object[])new Object[]{a, b});
        ((LeafQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        root.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        ((LeafQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.verifyQueueMetrics((CSQueue)a, 2048, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 2048, clusterResource);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_0, 1024);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_0, 2048);
        root.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        root.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        allocationOrder = Mockito.inOrder((Object[])new Object[]{b, a});
        ((LeafQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        ((LeafQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.verifyQueueMetrics((CSQueue)a, 3072, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 4096, clusterResource);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_0, 0);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_0, 4096);
        root.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        allocationOrder = Mockito.inOrder((Object[])new Object[]{b, a});
        ((LeafQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        ((LeafQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.verifyQueueMetrics((CSQueue)a, 3072, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 8192, clusterResource);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_1, 1024);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_1, 1024);
        root.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        root.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        allocationOrder = Mockito.inOrder((Object[])new Object[]{a, b});
        ((LeafQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        ((LeafQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.verifyQueueMetrics((CSQueue)a, 4096, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 9216, clusterResource);
    }

    @Test
    public void testSingleLevelQueuesPrecision() throws Exception {
        this.setupSingleLevelQueues(this.csConf);
        this.csConf.setCapacity(Q_A, 30.0f);
        this.csConf.setCapacity(Q_B, 70.5f);
        this.queueContext.reinitialize();
        CSQueueStore queues = new CSQueueStore();
        boolean exceptionOccurred = false;
        try {
            CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        }
        catch (IOException ie) {
            exceptionOccurred = true;
        }
        if (!exceptionOccurred) {
            Assert.fail((String)"Capacity is more then 100% so should be failed.");
        }
        this.csConf.setCapacity(Q_A, 30.0f);
        this.csConf.setCapacity(Q_B, 70.0f);
        this.queueContext.reinitialize();
        exceptionOccurred = false;
        queues.clear();
        try {
            CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        }
        catch (IllegalArgumentException ie) {
            exceptionOccurred = true;
        }
        if (exceptionOccurred) {
            Assert.fail((String)"Capacity is 100% so should not be failed.");
        }
        this.csConf.setCapacity(Q_A, 30.0f);
        this.csConf.setCapacity(Q_B, 70.005f);
        this.queueContext.reinitialize();
        exceptionOccurred = false;
        queues.clear();
        try {
            CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        }
        catch (IllegalArgumentException ie) {
            exceptionOccurred = true;
        }
        if (exceptionOccurred) {
            Assert.fail((String)"Capacity is under PRECISION which is .05% so should not be failed.");
        }
    }

    private void setupMultiLevelQueues(CapacitySchedulerConfiguration conf) {
        this.csConf.setQueues("root", new String[]{A, B, C, D});
        conf.setCapacity(Q_A, 10.0f);
        conf.setCapacity(Q_B, 50.0f);
        String Q_C = "root.c";
        conf.setCapacity("root.c", 19.5f);
        String Q_D = "root.d";
        conf.setCapacity("root.d", 20.5f);
        conf.setQueues(Q_A, new String[]{A1, A2});
        conf.setCapacity("root.a.a1", 50.0f);
        conf.setCapacity("root.a.a2", 50.0f);
        conf.setQueues(Q_B, new String[]{B1, B2, B3});
        conf.setCapacity("root.b.b1", 10.0f);
        conf.setCapacity("root.b.b2", 20.0f);
        conf.setCapacity("root.b.b3", 70.0f);
        conf.setQueues("root.c", new String[]{C1});
        String Q_C1 = "root.c.c1";
        conf.setCapacity("root.c.c1", 100.0f);
        conf.setQueues("root.c.c1", new String[]{C11});
        String Q_C11 = "root.c.c1.c11";
        conf.setCapacity("root.c.c1.c11", 100.0f);
        conf.setQueues("root.c.c1.c11", new String[]{C111});
        String Q_C111 = "root.c.c1.c11.c111";
        conf.setCapacity("root.c.c1.c11.c111", 100.0f);
        conf.setQueues("root.c.c1.c11.c111", new String[]{C1111});
        String Q_C1111 = "root.c.c1.c11.c111.c1111";
        conf.setCapacity("root.c.c1.c11.c111.c1111", 100.0f);
        this.queueContext.reinitialize();
    }

    @Test
    public void testMultiLevelQueues() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        CSQueueStore queues = new CSQueueStore();
        CSQueue root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        int memoryPerNode = 10;
        int coresPerNode = 16;
        int numNodes = 3;
        FiCaSchedulerNode node_0 = TestUtils.getMockNode("host_0", DEFAULT_RACK, 0, 10240);
        FiCaSchedulerNode node_1 = TestUtils.getMockNode("host_1", DEFAULT_RACK, 0, 10240);
        FiCaSchedulerNode node_2 = TestUtils.getMockNode("host_2", DEFAULT_RACK, 0, 10240);
        Resource clusterResource = Resources.createResource((int)30720, (int)48);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)3);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        CSQueue a = queues.get(A);
        a.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        CSQueue b = queues.get(B);
        b.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        CSQueue c = queues.get(C);
        c.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        CSQueue d = queues.get(D);
        d.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        CSQueue a1 = queues.get(A1);
        a1.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        CSQueue a2 = queues.get(A2);
        a2.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        CSQueue b1 = queues.get(B1);
        b1.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        CSQueue b2 = queues.get(B2);
        b2.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        CSQueue b3 = queues.get(B3);
        b3.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        queues.get("root").getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        this.stubQueueAllocation(a, clusterResource, node_0, 0);
        this.stubQueueAllocation(b, clusterResource, node_0, 0);
        this.stubQueueAllocation(c, clusterResource, node_0, 1024);
        this.stubQueueAllocation(d, clusterResource, node_0, 0);
        root.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.verifyQueueMetrics(a, 0, clusterResource);
        this.verifyQueueMetrics(b, 0, clusterResource);
        this.verifyQueueMetrics(c, 1024, clusterResource);
        this.verifyQueueMetrics(d, 0, clusterResource);
        Mockito.reset((Object[])new CSQueue[]{a});
        Mockito.reset((Object[])new CSQueue[]{b});
        Mockito.reset((Object[])new CSQueue[]{c});
        this.stubQueueAllocation(a, clusterResource, node_1, 0);
        this.stubQueueAllocation(b2, clusterResource, node_1, 4096);
        this.stubQueueAllocation(c, clusterResource, node_1, 0);
        root.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.applyAllocationToQueue(clusterResource, 4096, b);
        this.verifyQueueMetrics(a, 0, clusterResource);
        this.verifyQueueMetrics(b, 4096, clusterResource);
        this.verifyQueueMetrics(c, 1024, clusterResource);
        Mockito.reset((Object[])new CSQueue[]{a});
        Mockito.reset((Object[])new CSQueue[]{b});
        Mockito.reset((Object[])new CSQueue[]{c});
        this.stubQueueAllocation(a1, clusterResource, node_0, 1024);
        this.stubQueueAllocation(b3, clusterResource, node_0, 2048);
        this.stubQueueAllocation(c, clusterResource, node_0, 2048);
        root.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        InOrder allocationOrder = Mockito.inOrder((Object[])new Object[]{a, c, b});
        ((CSQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.applyAllocationToQueue(clusterResource, 1024, a);
        root.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        ((CSQueue)allocationOrder.verify((Object)c)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.applyAllocationToQueue(clusterResource, 2048, root);
        root.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        ((CSQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.applyAllocationToQueue(clusterResource, 2048, b);
        this.verifyQueueMetrics(a, 1024, clusterResource);
        this.verifyQueueMetrics(b, 6144, clusterResource);
        this.verifyQueueMetrics(c, 3072, clusterResource);
        Mockito.reset((Object[])new CSQueue[]{a});
        Mockito.reset((Object[])new CSQueue[]{b});
        Mockito.reset((Object[])new CSQueue[]{c});
        LOG.info("here");
        ((ParentQueue)a).setMaxCapacity(0.1f);
        this.stubQueueAllocation(a1, clusterResource, node_2, 1024);
        this.stubQueueAllocation(a2, clusterResource, node_2, 2048);
        this.stubQueueAllocation(b3, clusterResource, node_2, 1024);
        this.stubQueueAllocation(b1, clusterResource, node_2, 1024);
        this.stubQueueAllocation(c, clusterResource, node_2, 1024);
        root.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        allocationOrder = Mockito.inOrder((Object[])new Object[]{a, a2, a1, b, c});
        ((CSQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        ((CSQueue)allocationOrder.verify((Object)a2)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.applyAllocationToQueue(clusterResource, 2048, a);
        root.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        ((CSQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.applyAllocationToQueue(clusterResource, 2048, b);
        root.assignContainers(clusterResource, node_2, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        ((CSQueue)allocationOrder.verify((Object)c)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.verifyQueueMetrics(a, 3072, clusterResource);
        this.verifyQueueMetrics(b, 8192, clusterResource);
        this.verifyQueueMetrics(c, 4096, clusterResource);
        Mockito.reset((Object[])new CSQueue[]{a});
        Mockito.reset((Object[])new CSQueue[]{b});
        Mockito.reset((Object[])new CSQueue[]{c});
    }

    @Test(expected=IOException.class)
    public void testQueueCapacitySettingChildZero() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        this.csConf.setCapacity("root.b.b1", 0.0f);
        this.csConf.setCapacity("root.b.b2", 0.0f);
        this.csConf.setCapacity("root.b.b3", 0.0f);
        this.queueContext.reinitialize();
        CSQueueStore queues = new CSQueueStore();
        CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
    }

    @Test(expected=IOException.class)
    public void testQueueCapacitySettingParentZero() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        this.csConf.setCapacity(Q_B, 0.0f);
        this.csConf.setCapacity(Q_A, 60.0f);
        this.queueContext.reinitialize();
        CSQueueStore queues = new CSQueueStore();
        CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
    }

    @Test
    public void testQueueCapacitySettingParentZeroChildren100pctZeroSumAllowed() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        this.csConf.setCapacity(Q_B, 0.0f);
        this.csConf.setCapacity(Q_A, 60.0f);
        this.csConf.setAllowZeroCapacitySum(Q_B, true);
        this.queueContext.reinitialize();
        CSQueueStore queues = new CSQueueStore();
        CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
    }

    @Test(expected=IOException.class)
    public void testQueueCapacitySettingParentZeroChildren50pctZeroSumAllowed() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        this.csConf.setCapacity(Q_B, 0.0f);
        this.csConf.setCapacity(Q_A, 100.0f);
        this.csConf.setCapacity("root.b.b1", 10.0f);
        this.csConf.setCapacity("root.b.b2", 20.0f);
        this.csConf.setCapacity("root.b.b3", 20.0f);
        this.csConf.setAllowZeroCapacitySum(Q_B, true);
        this.queueContext.reinitialize();
        CSQueueStore queues = new CSQueueStore();
        CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
    }

    @Test
    public void testQueueCapacitySettingParentNonZeroChildrenZeroSumAllowed() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        this.csConf.setCapacity(Q_B, 10.0f);
        this.csConf.setCapacity(Q_A, 50.0f);
        this.csConf.setCapacity("root.b.b1", 0.0f);
        this.csConf.setCapacity("root.b.b2", 0.0f);
        this.csConf.setCapacity("root.b.b3", 0.0f);
        this.csConf.setAllowZeroCapacitySum(Q_B, true);
        this.queueContext.reinitialize();
        CSQueueStore queues = new CSQueueStore();
        CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
    }

    @Test
    public void testQueueCapacityZero() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        this.csConf.setCapacity(Q_B, 0.0f);
        this.csConf.setCapacity("root.b.b1", 0.0f);
        this.csConf.setCapacity("root.b.b2", 0.0f);
        this.csConf.setCapacity("root.b.b3", 0.0f);
        this.csConf.setCapacity(Q_A, 60.0f);
        this.queueContext.reinitialize();
        CSQueueStore queues = new CSQueueStore();
        try {
            CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Failed to create queues with 0 capacity: " + e));
        }
        Assert.assertTrue((String)"Failed to create queues with 0 capacity", (boolean)true);
    }

    @Test
    public void testOffSwitchScheduling() throws Exception {
        this.setupSingleLevelQueues(this.csConf);
        CSQueueStore queues = new CSQueueStore();
        CSQueue root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        int memoryPerNode = 10;
        int coresPerNode = 16;
        int numNodes = 2;
        FiCaSchedulerNode node_0 = TestUtils.getMockNode("host_0", DEFAULT_RACK, 0, 10240);
        FiCaSchedulerNode node_1 = TestUtils.getMockNode("host_1", DEFAULT_RACK, 0, 10240);
        Resource clusterResource = Resources.createResource((int)20480, (int)32);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        LeafQueue a = (LeafQueue)queues.get(A);
        LeafQueue b = (LeafQueue)queues.get(B);
        a.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        b.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        queues.get("root").getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_0, 0, NodeType.OFF_SWITCH);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_0, 1024, NodeType.OFF_SWITCH);
        root.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.verifyQueueMetrics((CSQueue)a, 0, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 1024, clusterResource);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_1, 2048, NodeType.RACK_LOCAL);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_1, 1024, NodeType.OFF_SWITCH);
        root.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        InOrder allocationOrder = Mockito.inOrder((Object[])new Object[]{a});
        ((LeafQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        root.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        allocationOrder = Mockito.inOrder((Object[])new Object[]{b});
        ((LeafQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.verifyQueueMetrics((CSQueue)a, 2048, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 2048, clusterResource);
        this.stubQueueAllocation((CSQueue)a, clusterResource, node_0, 1024, NodeType.NODE_LOCAL);
        this.stubQueueAllocation((CSQueue)b, clusterResource, node_0, 2048, NodeType.OFF_SWITCH);
        root.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        allocationOrder = Mockito.inOrder((Object[])new Object[]{b, a});
        ((LeafQueue)allocationOrder.verify((Object)b)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        ((LeafQueue)allocationOrder.verify((Object)a)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.verifyQueueMetrics((CSQueue)a, 2048, clusterResource);
        this.verifyQueueMetrics((CSQueue)b, 4096, clusterResource);
    }

    @Test
    public void testOffSwitchSchedulingMultiLevelQueues() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        CSQueueStore queues = new CSQueueStore();
        CSQueue root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        int memoryPerNode = 10;
        int coresPerNode = 10;
        int numNodes = 2;
        FiCaSchedulerNode node_0 = TestUtils.getMockNode("host_0", DEFAULT_RACK, 0, 10240);
        FiCaSchedulerNode node_1 = TestUtils.getMockNode("host_1", DEFAULT_RACK, 0, 10240);
        Resource clusterResource = Resources.createResource((int)20480, (int)20);
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)2);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        LeafQueue b3 = (LeafQueue)queues.get(B3);
        LeafQueue b2 = (LeafQueue)queues.get(B2);
        b2.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        b3.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        queues.get("root").getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        CSQueue b = queues.get(B);
        b.getQueueResourceUsage().incPending(Resources.createResource((int)1024));
        this.stubQueueAllocation((CSQueue)b2, clusterResource, node_0, 0, NodeType.OFF_SWITCH);
        this.stubQueueAllocation((CSQueue)b3, clusterResource, node_0, 1024, NodeType.OFF_SWITCH);
        root.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        this.verifyQueueMetrics((CSQueue)b2, 0, clusterResource);
        this.verifyQueueMetrics((CSQueue)b3, 1024, clusterResource);
        this.stubQueueAllocation((CSQueue)b2, clusterResource, node_1, 1024, NodeType.RACK_LOCAL);
        this.stubQueueAllocation((CSQueue)b3, clusterResource, node_1, 1024, NodeType.OFF_SWITCH);
        root.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        root.assignContainers(clusterResource, node_1, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        InOrder allocationOrder = Mockito.inOrder((Object[])new Object[]{b2, b3});
        ((LeafQueue)allocationOrder.verify((Object)b2)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        ((LeafQueue)allocationOrder.verify((Object)b3)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.verifyQueueMetrics((CSQueue)b2, 1024, clusterResource);
        this.verifyQueueMetrics((CSQueue)b3, 2048, clusterResource);
        this.stubQueueAllocation((CSQueue)b2, clusterResource, node_0, 1024, NodeType.NODE_LOCAL);
        this.stubQueueAllocation((CSQueue)b3, clusterResource, node_0, 1024, NodeType.OFF_SWITCH);
        root.assignContainers(clusterResource, node_0, new ResourceLimits(clusterResource), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
        allocationOrder = Mockito.inOrder((Object[])new Object[]{b3, b2});
        ((LeafQueue)allocationOrder.verify((Object)b3)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        ((LeafQueue)allocationOrder.verify((Object)b2)).assignContainers((Resource)ArgumentMatchers.eq((Object)clusterResource), (CandidateNodeSet)ArgumentMatchers.any(CandidateNodeSet.class), this.anyResourceLimits(), (SchedulingMode)ArgumentMatchers.any(SchedulingMode.class));
        this.verifyQueueMetrics((CSQueue)b2, 1024, clusterResource);
        this.verifyQueueMetrics((CSQueue)b3, 3072, clusterResource);
    }

    public boolean hasQueueACL(List<QueueUserACLInfo> aclInfos, QueueACL acl, String qName) {
        for (QueueUserACLInfo aclInfo : aclInfos) {
            if (!aclInfo.getQueueName().equals(qName) || !aclInfo.getUserAcls().contains(acl)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testQueueAcl() throws Exception {
        this.setupMultiLevelQueues(this.csConf);
        this.csConf.setAcl("root", QueueACL.SUBMIT_APPLICATIONS, " ");
        this.csConf.setAcl("root", QueueACL.ADMINISTER_QUEUE, " ");
        String Q_C = "root.c";
        this.csConf.setAcl("root.c", QueueACL.ADMINISTER_QUEUE, "*");
        String Q_C11 = "root.c.c1.c11";
        this.csConf.setAcl("root.c.c1.c11", QueueACL.SUBMIT_APPLICATIONS, "*");
        this.queueContext.reinitialize();
        CSQueueStore queues = new CSQueueStore();
        CSQueue root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        YarnAuthorizationProvider authorizer = YarnAuthorizationProvider.getInstance((Configuration)this.conf);
        AppPriorityACLsManager appPriorityACLManager = new AppPriorityACLsManager((Configuration)this.conf);
        CapacitySchedulerQueueManager.setQueueAcls((YarnAuthorizationProvider)authorizer, (AppPriorityACLsManager)appPriorityACLManager, (CSQueueStore)queues);
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        ParentQueue c = (ParentQueue)queues.get(C);
        ParentQueue c1 = (ParentQueue)queues.get(C1);
        ParentQueue c11 = (ParentQueue)queues.get(C11);
        ParentQueue c111 = (ParentQueue)queues.get(C111);
        Assert.assertFalse((boolean)root.hasAccess(QueueACL.ADMINISTER_QUEUE, user));
        List aclInfos = root.getQueueUserAclInfo(user);
        Assert.assertFalse((boolean)this.hasQueueACL(aclInfos, QueueACL.ADMINISTER_QUEUE, "root"));
        Assert.assertFalse((boolean)root.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertFalse((boolean)this.hasQueueACL(aclInfos, QueueACL.SUBMIT_APPLICATIONS, "root"));
        Assert.assertTrue((boolean)c.hasAccess(QueueACL.ADMINISTER_QUEUE, user));
        Assert.assertTrue((boolean)this.hasQueueACL(aclInfos, QueueACL.ADMINISTER_QUEUE, "root.c"));
        Assert.assertFalse((boolean)c.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertFalse((boolean)this.hasQueueACL(aclInfos, QueueACL.SUBMIT_APPLICATIONS, "root.c"));
        Assert.assertTrue((boolean)c1.hasAccess(QueueACL.ADMINISTER_QUEUE, user));
        Assert.assertTrue((boolean)this.hasQueueACL(aclInfos, QueueACL.ADMINISTER_QUEUE, "root.c.c1"));
        Assert.assertFalse((boolean)c1.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertFalse((boolean)this.hasQueueACL(aclInfos, QueueACL.SUBMIT_APPLICATIONS, "root.c.c1"));
        Assert.assertTrue((boolean)c11.hasAccess(QueueACL.ADMINISTER_QUEUE, user));
        Assert.assertTrue((boolean)this.hasQueueACL(aclInfos, QueueACL.ADMINISTER_QUEUE, "root.c.c1.c11"));
        Assert.assertTrue((boolean)c11.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertTrue((boolean)this.hasQueueACL(aclInfos, QueueACL.SUBMIT_APPLICATIONS, "root.c.c1.c11"));
        Assert.assertTrue((boolean)c111.hasAccess(QueueACL.ADMINISTER_QUEUE, user));
        Assert.assertTrue((boolean)this.hasQueueACL(aclInfos, QueueACL.ADMINISTER_QUEUE, "root.c.c1.c11.c111"));
        Assert.assertTrue((boolean)c111.hasAccess(QueueACL.SUBMIT_APPLICATIONS, user));
        Assert.assertTrue((boolean)this.hasQueueACL(aclInfos, QueueACL.SUBMIT_APPLICATIONS, "root.c.c1.c11.c111"));
        Mockito.reset((Object[])new ParentQueue[]{c});
    }

    @Test
    public void testAbsoluteResourceWithChangeInClusterResource() throws Exception {
        this.setupSingleLevelQueuesWithAbsoluteResource(this.csConf);
        CSQueueStore queues = new CSQueueStore();
        CSQueue root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        int memoryPerNode = 10;
        int coresPerNode = 16;
        int numNodes = 2;
        Resource clusterResource = Resources.createResource((int)(numNodes * 10240), (int)(numNodes * coresPerNode));
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)numNodes);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        LeafQueue a = (LeafQueue)queues.get(A);
        LeafQueue b = (LeafQueue)queues.get(B);
        Assert.assertEquals((Object)a.getQueueResourceQuotas().getConfiguredMinResource(), (Object)QUEUE_A_RESOURCE);
        Assert.assertEquals((Object)b.getQueueResourceQuotas().getConfiguredMinResource(), (Object)QUEUE_B_RESOURCE);
        Assert.assertEquals((Object)a.getQueueResourceQuotas().getEffectiveMinResource(), (Object)QUEUE_A_RESOURCE);
        Assert.assertEquals((Object)b.getQueueResourceQuotas().getEffectiveMinResource(), (Object)QUEUE_B_RESOURCE);
        numNodes = 1;
        clusterResource = Resources.createResource((int)(numNodes * 10240), (int)(numNodes * coresPerNode));
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)numNodes);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Resource QUEUE_B_RESOURCE_HALF = Resource.newInstance((int)7168, (int)11);
        Resource QUEUE_A_RESOURCE_HALF = Resource.newInstance((int)3072, (int)5);
        Assert.assertEquals((Object)a.getQueueResourceQuotas().getConfiguredMinResource(), (Object)QUEUE_A_RESOURCE);
        Assert.assertEquals((Object)b.getQueueResourceQuotas().getConfiguredMinResource(), (Object)QUEUE_B_RESOURCE);
        Assert.assertEquals((Object)a.getQueueResourceQuotas().getEffectiveMinResource(), (Object)QUEUE_A_RESOURCE_HALF);
        Assert.assertEquals((Object)b.getQueueResourceQuotas().getEffectiveMinResource(), (Object)QUEUE_B_RESOURCE_HALF);
        coresPerNode = 40;
        clusterResource = Resources.createResource((int)(numNodes * 10240), (int)(numNodes * coresPerNode));
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)numNodes);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Resource QUEUE_B_RESOURCE_70PERC = Resource.newInstance((int)7168, (int)27);
        Resource QUEUE_A_RESOURCE_30PERC = Resource.newInstance((int)3072, (int)12);
        Assert.assertEquals((Object)a.getQueueResourceQuotas().getConfiguredMinResource(), (Object)QUEUE_A_RESOURCE);
        Assert.assertEquals((Object)b.getQueueResourceQuotas().getConfiguredMinResource(), (Object)QUEUE_B_RESOURCE);
        Assert.assertEquals((Object)a.getQueueResourceQuotas().getEffectiveMinResource(), (Object)QUEUE_A_RESOURCE_30PERC);
        Assert.assertEquals((Object)b.getQueueResourceQuotas().getEffectiveMinResource(), (Object)QUEUE_B_RESOURCE_70PERC);
    }

    @Test
    public void testDeriveCapacityFromAbsoluteConfigurations() throws Exception {
        this.setupSingleLevelQueuesWithAbsoluteResource(this.csConf);
        CSQueueStore queues = new CSQueueStore();
        CSQueue root = CapacitySchedulerQueueManager.parseQueue((CapacitySchedulerQueueContext)this.queueContext, (CapacitySchedulerConfiguration)this.csConf, null, (String)"root", (CSQueueStore)queues, (CSQueueStore)queues, (CapacitySchedulerQueueManager.QueueHook)TestUtils.spyHook);
        int numNodes = 2;
        long memoryPerNode = (QUEUE_A_RESOURCE.getMemorySize() + QUEUE_B_RESOURCE.getMemorySize()) / (long)numNodes;
        int coresPerNode = (QUEUE_A_RESOURCE.getVirtualCores() + QUEUE_B_RESOURCE.getVirtualCores()) / numNodes;
        Resource clusterResource = Resources.createResource((long)((long)numNodes * memoryPerNode), (int)(numNodes * coresPerNode));
        Mockito.when((Object)this.csContext.getNumClusterNodes()).thenReturn((Object)numNodes);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        LeafQueue a = (LeafQueue)queues.get(A);
        LeafQueue b = (LeafQueue)queues.get(B);
        float queueAScale = (float)QUEUE_A_RESOURCE.getMemorySize() / (float)clusterResource.getMemorySize();
        float queueBScale = (float)QUEUE_B_RESOURCE.getMemorySize() / (float)clusterResource.getMemorySize();
        Assert.assertEquals((float)queueAScale, (float)a.getQueueCapacities().getCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)1.0f, (float)a.getQueueCapacities().getMaximumCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)queueAScale, (float)a.getQueueCapacities().getAbsoluteCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)1.0f, (float)a.getQueueCapacities().getAbsoluteMaximumCapacity(), (float)1.0E-4f);
        Assert.assertEquals((long)((int)((float)this.csConf.getMaximumSystemApplications() * queueAScale)), (long)a.getMaxApplications());
        Assert.assertEquals((long)a.getMaxApplications(), (long)a.getMaxApplicationsPerUser());
        Assert.assertEquals((float)queueBScale, (float)b.getQueueCapacities().getCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)1.0f, (float)b.getQueueCapacities().getMaximumCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)queueBScale, (float)b.getQueueCapacities().getAbsoluteCapacity(), (float)1.0E-4f);
        Assert.assertEquals((float)1.0f, (float)b.getQueueCapacities().getAbsoluteMaximumCapacity(), (float)1.0E-4f);
        Assert.assertEquals((long)((int)((float)this.csConf.getMaximumSystemApplications() * queueBScale)), (long)b.getMaxApplications());
        Assert.assertEquals((long)b.getMaxApplications(), (long)b.getMaxApplicationsPerUser());
        this.csConf.setGlobalMaximumApplicationsPerQueue(8000);
        this.queueContext.reinitialize();
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Assert.assertEquals((long)((int)((float)this.csConf.getGlobalMaximumApplicationsPerQueue() * queueAScale)), (long)a.getMaxApplications());
        Assert.assertEquals((long)a.getMaxApplications(), (long)a.getMaxApplicationsPerUser());
        Assert.assertEquals((long)((int)((float)this.csConf.getGlobalMaximumApplicationsPerQueue() * queueBScale)), (long)b.getMaxApplications());
        Assert.assertEquals((long)b.getMaxApplications(), (long)b.getMaxApplicationsPerUser());
        int queueAMaxApplications = 30000;
        int queueBMaxApplications = 30000;
        this.csConf.set("yarn.scheduler.capacity.root.a.maximum-applications", Integer.toString(queueAMaxApplications));
        this.csConf.set("yarn.scheduler.capacity.root.b.maximum-applications", Integer.toString(queueBMaxApplications));
        this.queueContext.reinitialize();
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Assert.assertEquals((long)queueAMaxApplications, (long)a.getMaxApplications());
        Assert.assertEquals((long)a.getMaxApplications(), (long)a.getMaxApplicationsPerUser());
        Assert.assertEquals((long)queueBMaxApplications, (long)b.getMaxApplications());
        Assert.assertEquals((long)b.getMaxApplications(), (long)b.getMaxApplicationsPerUser());
        float halfPercent = 50.0f;
        float oneAndQuarterPercent = 125.0f;
        float thirdPercent = 33.3f;
        a.getUsersManager().setUserLimit(halfPercent);
        b.getUsersManager().setUserLimit(oneAndQuarterPercent);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Assert.assertEquals((long)((int)((float)a.getMaxApplications() * halfPercent / 100.0f)), (long)a.getMaxApplicationsPerUser());
        Assert.assertEquals((long)b.getMaxApplications(), (long)b.getMaxApplicationsPerUser());
        b.getUsersManager().setUserLimit(thirdPercent);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Assert.assertEquals((long)((int)((float)b.getMaxApplications() * thirdPercent / 100.0f)), (long)b.getMaxApplicationsPerUser());
        float userLimitFactorQueueA = 0.9f;
        float userLimitFactorQueueB = 1.1f;
        a.getUsersManager().setUserLimit(halfPercent);
        a.getUsersManager().setUserLimitFactor(userLimitFactorQueueA);
        b.getUsersManager().setUserLimit(100.0f);
        b.getUsersManager().setUserLimitFactor(userLimitFactorQueueB);
        root.updateClusterResource(clusterResource, new ResourceLimits(clusterResource));
        Assert.assertEquals((long)((int)((float)a.getMaxApplications() * halfPercent * userLimitFactorQueueA / 100.0f)), (long)a.getMaxApplicationsPerUser());
        Assert.assertEquals((long)b.getMaxApplications(), (long)b.getMaxApplicationsPerUser());
    }

    @After
    public void tearDown() throws Exception {
    }

    private ResourceLimits anyResourceLimits() {
        return (ResourceLimits)ArgumentMatchers.any(ResourceLimits.class);
    }
}

