/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ResourceVector;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestResourceVector {
    private static final String CUSTOM_RESOURCE = "custom";
    private final YarnConfiguration conf = new YarnConfiguration();

    @Before
    public void setUp() {
        this.conf.set("yarn.resource-types", CUSTOM_RESOURCE);
        ResourceUtils.resetResourceTypes((Configuration)this.conf);
    }

    @Test
    public void testCreation() {
        ResourceVector zeroResourceVector = ResourceVector.newInstance();
        Assert.assertEquals((double)0.0, (double)zeroResourceVector.getValue("memory-mb"), (double)1.0E-4f);
        Assert.assertEquals((double)0.0, (double)zeroResourceVector.getValue("vcores"), (double)1.0E-4f);
        Assert.assertEquals((double)0.0, (double)zeroResourceVector.getValue(CUSTOM_RESOURCE), (double)1.0E-4f);
        ResourceVector uniformResourceVector = ResourceVector.of((double)10.0);
        Assert.assertEquals((double)10.0, (double)uniformResourceVector.getValue("memory-mb"), (double)1.0E-4f);
        Assert.assertEquals((double)10.0, (double)uniformResourceVector.getValue("vcores"), (double)1.0E-4f);
        Assert.assertEquals((double)10.0, (double)uniformResourceVector.getValue(CUSTOM_RESOURCE), (double)1.0E-4f);
        HashMap<String, Long> customResources = new HashMap<String, Long>();
        customResources.put(CUSTOM_RESOURCE, 2L);
        Resource resource = Resource.newInstance((long)10L, (int)5, customResources);
        ResourceVector resourceVectorFromResource = ResourceVector.of((Resource)resource);
        Assert.assertEquals((double)10.0, (double)resourceVectorFromResource.getValue("memory-mb"), (double)1.0E-4f);
        Assert.assertEquals((double)5.0, (double)resourceVectorFromResource.getValue("vcores"), (double)1.0E-4f);
        Assert.assertEquals((double)2.0, (double)resourceVectorFromResource.getValue(CUSTOM_RESOURCE), (double)1.0E-4f);
    }

    @Test
    public void testSubtract() {
        ResourceVector lhsResourceVector = ResourceVector.of((double)13.0);
        ResourceVector rhsResourceVector = ResourceVector.of((double)5.0);
        lhsResourceVector.decrement(rhsResourceVector);
        Assert.assertEquals((double)8.0, (double)lhsResourceVector.getValue("memory-mb"), (double)1.0E-4f);
        Assert.assertEquals((double)8.0, (double)lhsResourceVector.getValue("vcores"), (double)1.0E-4f);
        Assert.assertEquals((double)8.0, (double)lhsResourceVector.getValue(CUSTOM_RESOURCE), (double)1.0E-4f);
        ResourceVector negativeResourceVector = ResourceVector.of((double)-100.0);
        negativeResourceVector.decrement(ResourceVector.of((double)3.4028234663852886E38));
        Assert.assertEquals((double)-3.4028234663852886E38, (double)negativeResourceVector.getValue("memory-mb"), (double)1.0E-4f);
        Assert.assertEquals((double)-3.4028234663852886E38, (double)negativeResourceVector.getValue("vcores"), (double)1.0E-4f);
        Assert.assertEquals((double)-3.4028234663852886E38, (double)negativeResourceVector.getValue(CUSTOM_RESOURCE), (double)1.0E-4f);
    }

    @Test
    public void testIncrement() {
        ResourceVector resourceVector = ResourceVector.of((double)13.0);
        resourceVector.increment("memory-mb", 5.0);
        Assert.assertEquals((double)18.0, (double)resourceVector.getValue("memory-mb"), (double)1.0E-4f);
        Assert.assertEquals((double)13.0, (double)resourceVector.getValue("vcores"), (double)1.0E-4f);
        Assert.assertEquals((double)13.0, (double)resourceVector.getValue(CUSTOM_RESOURCE), (double)1.0E-4f);
        ResourceVector maxFloatResourceVector = ResourceVector.of((double)3.4028234663852886E38);
        maxFloatResourceVector.increment("memory-mb", 100.0);
        Assert.assertEquals((double)3.4028234663852886E38, (double)maxFloatResourceVector.getValue("memory-mb"), (double)1.0E-4f);
    }

    @Test
    public void testEquals() {
        ResourceVector resourceVector = ResourceVector.of((double)13.0);
        ResourceVector resourceVectorOther = ResourceVector.of((double)14.0);
        Resource resource = Resource.newInstance((int)13, (int)13);
        Assert.assertNotEquals(null, (Object)resourceVector);
        Assert.assertNotEquals((Object)resourceVectorOther, (Object)resourceVector);
        Assert.assertNotEquals((Object)resource, (Object)resourceVector);
        ResourceVector resourceVectorOne = ResourceVector.of((double)1.0);
        resourceVectorOther.decrement(resourceVectorOne);
        Assert.assertEquals((Object)resourceVectorOther, (Object)resourceVector);
    }
}

