/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecords;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSQueueMetrics {
    private static final Configuration CONF = new Configuration();
    private MetricsSystem ms;
    private static final String RESOURCE_NAME = "test1";
    private static final String QUEUE_NAME = "single";

    @Before
    public void setUp() {
        this.ms = new MetricsSystemImpl();
        QueueMetrics.clearQueueMetrics();
    }

    private FSQueueMetrics setupMetrics(String resourceName) {
        CONF.set("yarn.resource-types", resourceName);
        ResourceUtils.resetResourceTypes((Configuration)CONF);
        return FSQueueMetrics.forQueue((MetricsSystem)this.ms, (String)QUEUE_NAME, null, (boolean)false, (Configuration)CONF);
    }

    private String getErrorMessage(String metricsType) {
        return metricsType + " is not the expected!";
    }

    @Test
    public void testSchedulingPolicy() {
        String queueName = QUEUE_NAME;
        FSQueueMetrics metrics = FSQueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)CONF);
        metrics.setSchedulingPolicy("drf");
        this.checkSchedulingPolicy(queueName, "drf");
        metrics.setSchedulingPolicy("fair");
        this.checkSchedulingPolicy(queueName, "fair");
    }

    private void checkSchedulingPolicy(String queueName, String policy) {
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        MetricsCollectorImpl collector = new MetricsCollectorImpl();
        queueSource.getMetrics((MetricsCollector)collector, true);
        MetricsRecords.assertTag((MetricsRecord)((MetricsRecord)collector.getRecords().get(0)), (String)"SchedulingPolicy", (String)policy);
    }

    @Test
    public void testSetFairShare() {
        FSQueueMetrics metrics = this.setupMetrics(RESOURCE_NAME);
        Resource res = Resource.newInstance((long)2048L, (int)4, (Map)ImmutableMap.of((Object)RESOURCE_NAME, (Object)20L));
        metrics.setFairShare(res);
        Assert.assertEquals((String)this.getErrorMessage("fairShareMB"), (long)2048L, (long)metrics.getFairShareMB());
        Assert.assertEquals((String)this.getErrorMessage("fairShareVcores"), (long)4L, (long)metrics.getFairShareVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("fairShareMB"), (long)2048L, (long)metrics.getFairShare().getMemorySize());
        Assert.assertEquals((String)this.getErrorMessage("fairShareVcores"), (long)4L, (long)metrics.getFairShare().getVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("fairShare for resource: test1"), (long)20L, (long)metrics.getFairShare().getResourceValue(RESOURCE_NAME));
        res = Resource.newInstance((long)2049L, (int)5);
        metrics.setFairShare(res);
        Assert.assertEquals((String)this.getErrorMessage("fairShareMB"), (long)2049L, (long)metrics.getFairShareMB());
        Assert.assertEquals((String)this.getErrorMessage("fairShareVcores"), (long)5L, (long)metrics.getFairShareVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("fairShareMB"), (long)2049L, (long)metrics.getFairShare().getMemorySize());
        Assert.assertEquals((String)this.getErrorMessage("fairShareVcores"), (long)5L, (long)metrics.getFairShare().getVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("fairShare for resource: test1"), (long)0L, (long)metrics.getFairShare().getResourceValue(RESOURCE_NAME));
    }

    @Test
    public void testSetSteadyFairShare() {
        FSQueueMetrics metrics = this.setupMetrics(RESOURCE_NAME);
        Resource res = Resource.newInstance((long)2048L, (int)4, (Map)ImmutableMap.of((Object)RESOURCE_NAME, (Object)20L));
        metrics.setSteadyFairShare(res);
        Assert.assertEquals((String)this.getErrorMessage("steadyFairShareMB"), (long)2048L, (long)metrics.getSteadyFairShareMB());
        Assert.assertEquals((String)this.getErrorMessage("steadyFairShareVcores"), (long)4L, (long)metrics.getSteadyFairShareVCores());
        Resource steadyFairShare = metrics.getSteadyFairShare();
        Assert.assertEquals((String)this.getErrorMessage("steadyFairShareMB"), (long)2048L, (long)steadyFairShare.getMemorySize());
        Assert.assertEquals((String)this.getErrorMessage("steadyFairShareVcores"), (long)4L, (long)steadyFairShare.getVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("steadyFairShare for resource: test1"), (long)20L, (long)steadyFairShare.getResourceValue(RESOURCE_NAME));
        res = Resource.newInstance((long)2049L, (int)5);
        metrics.setSteadyFairShare(res);
        Assert.assertEquals((String)this.getErrorMessage("steadyFairShareMB"), (long)2049L, (long)metrics.getSteadyFairShareMB());
        Assert.assertEquals((String)this.getErrorMessage("steadyFairShareVcores"), (long)5L, (long)metrics.getSteadyFairShareVCores());
        steadyFairShare = metrics.getSteadyFairShare();
        Assert.assertEquals((String)this.getErrorMessage("steadyFairShareMB"), (long)2049L, (long)steadyFairShare.getMemorySize());
        Assert.assertEquals((String)this.getErrorMessage("steadyFairShareVcores"), (long)5L, (long)steadyFairShare.getVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("steadyFairShare for resource: test1"), (long)0L, (long)steadyFairShare.getResourceValue(RESOURCE_NAME));
    }

    @Test
    public void testSetMinShare() {
        FSQueueMetrics metrics = this.setupMetrics(RESOURCE_NAME);
        Resource res = Resource.newInstance((long)2048L, (int)4, (Map)ImmutableMap.of((Object)RESOURCE_NAME, (Object)20L));
        metrics.setMinShare(res);
        Assert.assertEquals((String)this.getErrorMessage("minShareMB"), (long)2048L, (long)metrics.getMinShareMB());
        Assert.assertEquals((String)this.getErrorMessage("minShareVcores"), (long)4L, (long)metrics.getMinShareVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("minShareMB"), (long)2048L, (long)metrics.getMinShare().getMemorySize());
        Assert.assertEquals((String)this.getErrorMessage("minShareVcores"), (long)4L, (long)metrics.getMinShare().getVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("minShare for resource: test1"), (long)20L, (long)metrics.getMinShare().getResourceValue(RESOURCE_NAME));
        res = Resource.newInstance((long)2049L, (int)5);
        metrics.setMinShare(res);
        Assert.assertEquals((String)this.getErrorMessage("minShareMB"), (long)2049L, (long)metrics.getMinShareMB());
        Assert.assertEquals((String)this.getErrorMessage("minShareVcores"), (long)5L, (long)metrics.getMinShareVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("minShareMB"), (long)2049L, (long)metrics.getMinShare().getMemorySize());
        Assert.assertEquals((String)this.getErrorMessage("minShareVcores"), (long)5L, (long)metrics.getMinShare().getVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("minShare for resource: test1"), (long)0L, (long)metrics.getMinShare().getResourceValue(RESOURCE_NAME));
    }

    @Test
    public void testSetMaxShare() {
        FSQueueMetrics metrics = this.setupMetrics(RESOURCE_NAME);
        Resource res = Resource.newInstance((long)2048L, (int)4, (Map)ImmutableMap.of((Object)RESOURCE_NAME, (Object)20L));
        metrics.setMaxShare(res);
        Assert.assertEquals((String)this.getErrorMessage("maxShareMB"), (long)2048L, (long)metrics.getMaxShareMB());
        Assert.assertEquals((String)this.getErrorMessage("maxShareVcores"), (long)4L, (long)metrics.getMaxShareVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("maxShareMB"), (long)2048L, (long)metrics.getMaxShare().getMemorySize());
        Assert.assertEquals((String)this.getErrorMessage("maxShareVcores"), (long)4L, (long)metrics.getMaxShare().getVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("maxShare for resource: test1"), (long)20L, (long)metrics.getMaxShare().getResourceValue(RESOURCE_NAME));
        res = Resource.newInstance((long)2049L, (int)5);
        metrics.setMaxShare(res);
        Assert.assertEquals((String)this.getErrorMessage("maxShareMB"), (long)2049L, (long)metrics.getMaxShareMB());
        Assert.assertEquals((String)this.getErrorMessage("maxShareVcores"), (long)5L, (long)metrics.getMaxShareVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("maxShareMB"), (long)2049L, (long)metrics.getMaxShare().getMemorySize());
        Assert.assertEquals((String)this.getErrorMessage("maxShareVcores"), (long)5L, (long)metrics.getMaxShare().getVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("maxShare for resource: test1"), (long)0L, (long)metrics.getMaxShare().getResourceValue(RESOURCE_NAME));
    }

    @Test
    public void testSetMaxAMShare() {
        FSQueueMetrics metrics = this.setupMetrics(RESOURCE_NAME);
        Resource res = Resource.newInstance((long)2048L, (int)4, (Map)ImmutableMap.of((Object)RESOURCE_NAME, (Object)20L));
        metrics.setMaxAMShare(res);
        Assert.assertEquals((String)this.getErrorMessage("maxAMShareMB"), (long)2048L, (long)metrics.getMaxAMShareMB());
        Assert.assertEquals((String)this.getErrorMessage("maxAMShareVcores"), (long)4L, (long)metrics.getMaxAMShareVCores());
        Assert.assertEquals((String)this.getErrorMessage("maxAMShareMB"), (long)2048L, (long)metrics.getMaxAMShare().getMemorySize());
        Assert.assertEquals((String)this.getErrorMessage("maxAMShareVcores"), (long)4L, (long)metrics.getMaxAMShare().getVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("maxAMShare for resource: test1"), (long)20L, (long)metrics.getMaxAMShare().getResourceValue(RESOURCE_NAME));
        res = Resource.newInstance((long)2049L, (int)5);
        metrics.setMaxAMShare(res);
        Assert.assertEquals((String)this.getErrorMessage("maxAMShareMB"), (long)2049L, (long)metrics.getMaxAMShareMB());
        Assert.assertEquals((String)this.getErrorMessage("maxAMShareVcores"), (long)5L, (long)metrics.getMaxAMShareVCores());
        Assert.assertEquals((String)this.getErrorMessage("maxAMShareMB"), (long)2049L, (long)metrics.getMaxAMShare().getMemorySize());
        Assert.assertEquals((String)this.getErrorMessage("maxAMShareVcores"), (long)5L, (long)metrics.getMaxAMShare().getVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("maxAMShare for resource: test1"), (long)0L, (long)metrics.getMaxAMShare().getResourceValue(RESOURCE_NAME));
    }

    @Test
    public void testSetAMResourceUsage() {
        FSQueueMetrics metrics = this.setupMetrics(RESOURCE_NAME);
        Resource res = Resource.newInstance((long)2048L, (int)4, (Map)ImmutableMap.of((Object)RESOURCE_NAME, (Object)20L));
        metrics.setAMResourceUsage(res);
        Assert.assertEquals((String)this.getErrorMessage("AMResourceUsageMB"), (long)2048L, (long)metrics.getAMResourceUsageMB());
        Assert.assertEquals((String)this.getErrorMessage("AMResourceUsageVcores"), (long)4L, (long)metrics.getAMResourceUsageVCores());
        Resource amResourceUsage = metrics.getAMResourceUsage();
        Assert.assertEquals((String)this.getErrorMessage("AMResourceUsageMB"), (long)2048L, (long)amResourceUsage.getMemorySize());
        Assert.assertEquals((String)this.getErrorMessage("AMResourceUsageVcores"), (long)4L, (long)amResourceUsage.getVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("AMResourceUsage for resource: test1"), (long)20L, (long)amResourceUsage.getResourceValue(RESOURCE_NAME));
        res = Resource.newInstance((long)2049L, (int)5);
        metrics.setAMResourceUsage(res);
        Assert.assertEquals((String)this.getErrorMessage("AMResourceUsageMB"), (long)2049L, (long)metrics.getAMResourceUsageMB());
        Assert.assertEquals((String)this.getErrorMessage("AMResourceUsageVcores"), (long)5L, (long)metrics.getAMResourceUsageVCores());
        amResourceUsage = metrics.getAMResourceUsage();
        Assert.assertEquals((String)this.getErrorMessage("AMResourceUsageMB"), (long)2049L, (long)amResourceUsage.getMemorySize());
        Assert.assertEquals((String)this.getErrorMessage("AMResourceUsageVcores"), (long)5L, (long)amResourceUsage.getVirtualCores());
        Assert.assertEquals((String)this.getErrorMessage("AMResourceUsage for resource: test1"), (long)0L, (long)amResourceUsage.getResourceValue(RESOURCE_NAME));
    }

    @Test
    public void testSetMaxApps() {
        FSQueueMetrics metrics = this.setupMetrics(RESOURCE_NAME);
        metrics.setMaxApps(25);
        Assert.assertEquals((String)this.getErrorMessage("maxApps"), (long)25L, (long)metrics.getMaxApps());
    }
}

