/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestFSSchedulerNode {
    private final ArrayList<RMContainer> containers = new ArrayList();

    private RMNode createNode() {
        RMNode node = (RMNode)Mockito.mock(RMNode.class);
        Mockito.when((Object)node.getTotalCapability()).thenReturn((Object)Resource.newInstance((int)8192, (int)8));
        Mockito.when((Object)node.getHostName()).thenReturn((Object)"host.domain.com");
        return node;
    }

    private void createDefaultContainer() {
        this.createContainer(Resource.newInstance((int)1024, (int)1), null);
    }

    private RMContainer createContainer(Resource request, ApplicationAttemptId appAttemptId) {
        RMContainer container = (RMContainer)Mockito.mock(RMContainer.class);
        Container containerInner = (Container)Mockito.mock(Container.class);
        ContainerId id = (ContainerId)Mockito.mock(ContainerId.class);
        Mockito.when((Object)id.getContainerId()).thenReturn((Object)this.containers.size());
        Mockito.when((Object)containerInner.getResource()).thenReturn((Object)Resources.clone((Resource)request));
        Mockito.when((Object)containerInner.getId()).thenReturn((Object)id);
        Mockito.when((Object)containerInner.getExecutionType()).thenReturn((Object)ExecutionType.GUARANTEED);
        Mockito.when((Object)container.getApplicationAttemptId()).thenReturn((Object)appAttemptId);
        Mockito.when((Object)container.getContainerId()).thenReturn((Object)id);
        Mockito.when((Object)container.getContainer()).thenReturn((Object)containerInner);
        Mockito.when((Object)container.getExecutionType()).thenReturn((Object)ExecutionType.GUARANTEED);
        Mockito.when((Object)container.getAllocatedResource()).thenReturn((Object)Resources.clone((Resource)request));
        Mockito.when((Object)container.compareTo(ArgumentMatchers.any())).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) {
                return Long.compare(((RMContainer)invocation.getMock()).getContainerId().getContainerId(), ((RMContainer)invocation.getArguments()[0]).getContainerId().getContainerId());
            }
        });
        this.containers.add(container);
        return container;
    }

    private void saturateCluster(FSSchedulerNode schedulerNode) {
        while (!Resources.isNone((Resource)schedulerNode.getUnallocatedResource())) {
            this.createDefaultContainer();
            schedulerNode.allocateContainer(this.containers.get(this.containers.size() - 1));
            schedulerNode.containerStarted(this.containers.get(this.containers.size() - 1).getContainerId());
        }
    }

    private FSAppAttempt createStarvingApp(final FSSchedulerNode schedulerNode, final Resource request) {
        FSAppAttempt starvingApp = (FSAppAttempt)Mockito.mock(FSAppAttempt.class);
        final ApplicationAttemptId appAttemptId = (ApplicationAttemptId)Mockito.mock(ApplicationAttemptId.class);
        Mockito.when((Object)starvingApp.getApplicationAttemptId()).thenReturn((Object)appAttemptId);
        Mockito.when((Object)starvingApp.assignContainer(schedulerNode)).thenAnswer((Answer)new Answer<Resource>(){

            public Resource answer(InvocationOnMock invocationOnMock) throws Throwable {
                Resource response = Resource.newInstance((int)0, (int)0);
                while (!Resources.isNone((Resource)request) && !Resources.isNone((Resource)schedulerNode.getUnallocatedResource())) {
                    RMContainer container = TestFSSchedulerNode.this.createContainer(request, appAttemptId);
                    schedulerNode.allocateContainer(container);
                    Resources.addTo((Resource)response, (Resource)container.getAllocatedResource());
                    Resources.subtractFrom((Resource)request, (Resource)container.getAllocatedResource());
                }
                return response;
            }
        });
        Mockito.when((Object)starvingApp.isStarved()).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) throws Throwable {
                return !Resources.isNone((Resource)request);
            }
        });
        Mockito.when((Object)starvingApp.getPendingDemand()).thenReturn((Object)request);
        return starvingApp;
    }

    private void finalValidation(FSSchedulerNode schedulerNode) {
        Assert.assertEquals((String)"Everything should have been released", (Object)Resources.none(), (Object)schedulerNode.getAllocatedResource());
        Assert.assertTrue((String)"No containers should be reserved for preemption", (boolean)schedulerNode.containersForPreemption.isEmpty());
        Assert.assertTrue((String)"No resources should be reserved for preemptors", (boolean)schedulerNode.resourcesPreemptedForApp.isEmpty());
        Assert.assertEquals((String)"No amount of resource should be reserved for preemptees", (Object)Resources.none(), (Object)schedulerNode.getTotalReserved());
    }

    private void allocateContainers(FSSchedulerNode schedulerNode) {
        FairScheduler.assignPreemptedContainers((FSSchedulerNode)schedulerNode);
    }

    @Test
    public void testSimpleAllocation() {
        RMNode node = this.createNode();
        FSSchedulerNode schedulerNode = new FSSchedulerNode(node, false);
        this.createDefaultContainer();
        Assert.assertEquals((String)"Nothing should have been allocated, yet", (Object)Resources.none(), (Object)schedulerNode.getAllocatedResource());
        schedulerNode.allocateContainer(this.containers.get(0));
        Assert.assertEquals((String)"Container should be allocated", (Object)this.containers.get(0).getContainer().getResource(), (Object)schedulerNode.getAllocatedResource());
        schedulerNode.releaseContainer(this.containers.get(0).getContainerId(), true);
        Assert.assertEquals((String)"Everything should have been released", (Object)Resources.none(), (Object)schedulerNode.getAllocatedResource());
        schedulerNode.releaseContainer(this.containers.get(0).getContainerId(), true);
        this.finalValidation(schedulerNode);
    }

    @Test
    public void testMultipleAllocations() {
        RMNode node = this.createNode();
        FSSchedulerNode schedulerNode = new FSSchedulerNode(node, false);
        this.createDefaultContainer();
        this.createDefaultContainer();
        this.createDefaultContainer();
        Assert.assertEquals((String)"Nothing should have been allocated, yet", (Object)Resources.none(), (Object)schedulerNode.getAllocatedResource());
        schedulerNode.allocateContainer(this.containers.get(0));
        schedulerNode.containerStarted(this.containers.get(0).getContainerId());
        schedulerNode.allocateContainer(this.containers.get(1));
        schedulerNode.containerStarted(this.containers.get(1).getContainerId());
        schedulerNode.allocateContainer(this.containers.get(2));
        Assert.assertEquals((String)"Container should be allocated", (Object)Resources.multiply((Resource)this.containers.get(0).getContainer().getResource(), (double)3.0), (Object)schedulerNode.getAllocatedResource());
        schedulerNode.releaseContainer(this.containers.get(1).getContainerId(), true);
        schedulerNode.releaseContainer(this.containers.get(2).getContainerId(), true);
        schedulerNode.releaseContainer(this.containers.get(0).getContainerId(), true);
        this.finalValidation(schedulerNode);
    }

    @Test
    public void testSimplePreemption() {
        RMNode node = this.createNode();
        FSSchedulerNode schedulerNode = new FSSchedulerNode(node, false);
        this.saturateCluster(schedulerNode);
        Assert.assertEquals((String)"Container should be allocated", (Object)Resources.multiply((Resource)this.containers.get(0).getContainer().getResource(), (double)this.containers.size()), (Object)schedulerNode.getAllocatedResource());
        FSAppAttempt starvingApp = this.createStarvingApp(schedulerNode, Resource.newInstance((int)1024, (int)1));
        schedulerNode.addContainersForPreemption(Collections.singletonList(this.containers.get(0)), starvingApp);
        Assert.assertEquals((String)"No resource amount should be reserved for preemptees", (Object)this.containers.get(0).getAllocatedResource(), (Object)schedulerNode.getTotalReserved());
        schedulerNode.releaseContainer(this.containers.get(0).getContainerId(), true);
        this.allocateContainers(schedulerNode);
        Assert.assertEquals((String)"Container should be allocated", (Object)schedulerNode.getTotalResource(), (Object)schedulerNode.getAllocatedResource());
        for (int i = 1; i < this.containers.size(); ++i) {
            schedulerNode.releaseContainer(this.containers.get(i).getContainerId(), true);
        }
        this.finalValidation(schedulerNode);
    }

    @Test
    public void testDuplicatePreemption() {
        RMNode node = this.createNode();
        FSSchedulerNode schedulerNode = new FSSchedulerNode(node, false);
        this.saturateCluster(schedulerNode);
        Assert.assertEquals((String)"Container should be allocated", (Object)Resources.multiply((Resource)this.containers.get(0).getContainer().getResource(), (double)this.containers.size()), (Object)schedulerNode.getAllocatedResource());
        FSAppAttempt starvingApp = this.createStarvingApp(schedulerNode, Resource.newInstance((int)1024, (int)1));
        schedulerNode.addContainersForPreemption(Collections.singletonList(this.containers.get(0)), starvingApp);
        schedulerNode.addContainersForPreemption(Collections.singletonList(this.containers.get(0)), starvingApp);
        Assert.assertEquals((String)"No resource amount should be reserved for preemptees", (Object)this.containers.get(0).getAllocatedResource(), (Object)schedulerNode.getTotalReserved());
        schedulerNode.releaseContainer(this.containers.get(0).getContainerId(), true);
        this.allocateContainers(schedulerNode);
        Assert.assertEquals((String)"Container should be allocated", (Object)schedulerNode.getTotalResource(), (Object)schedulerNode.getAllocatedResource());
        for (int i = 1; i < this.containers.size(); ++i) {
            schedulerNode.releaseContainer(this.containers.get(i).getContainerId(), true);
        }
        this.finalValidation(schedulerNode);
    }

    @Test
    public void testComplexPreemption() {
        RMNode node = this.createNode();
        FSSchedulerNode schedulerNode = new FSSchedulerNode(node, false);
        this.saturateCluster(schedulerNode);
        Assert.assertEquals((String)"Container should be allocated", (Object)Resources.multiply((Resource)this.containers.get(0).getContainer().getResource(), (double)this.containers.size()), (Object)schedulerNode.getAllocatedResource());
        FSAppAttempt starvingApp1 = this.createStarvingApp(schedulerNode, Resource.newInstance((int)2048, (int)2));
        FSAppAttempt starvingApp2 = this.createStarvingApp(schedulerNode, Resource.newInstance((int)1024, (int)1));
        schedulerNode.addContainersForPreemption(Collections.singletonList(this.containers.get(0)), starvingApp1);
        schedulerNode.addContainersForPreemption(Collections.singletonList(this.containers.get(1)), starvingApp1);
        schedulerNode.addContainersForPreemption(Collections.singletonList(this.containers.get(2)), starvingApp2);
        schedulerNode.releaseContainer(this.containers.get(0).getContainerId(), true);
        schedulerNode.releaseContainer(this.containers.get(2).getContainerId(), true);
        schedulerNode.releaseContainer(this.containers.get(1).getContainerId(), true);
        this.allocateContainers(schedulerNode);
        Assert.assertEquals((String)"Container should be allocated", (Object)schedulerNode.getTotalResource(), (Object)schedulerNode.getAllocatedResource());
        for (int i = 3; i < this.containers.size(); ++i) {
            schedulerNode.releaseContainer(this.containers.get(i).getContainerId(), true);
        }
        this.finalValidation(schedulerNode);
    }

    @Test
    public void testMultiplePreemptionEvents() {
        RMNode node = this.createNode();
        FSSchedulerNode schedulerNode = new FSSchedulerNode(node, false);
        this.saturateCluster(schedulerNode);
        Assert.assertEquals((String)"Container should be allocated", (Object)Resources.multiply((Resource)this.containers.get(0).getContainer().getResource(), (double)this.containers.size()), (Object)schedulerNode.getAllocatedResource());
        FSAppAttempt starvingApp1 = this.createStarvingApp(schedulerNode, Resource.newInstance((int)2048, (int)2));
        FSAppAttempt starvingApp2 = this.createStarvingApp(schedulerNode, Resource.newInstance((int)1024, (int)1));
        schedulerNode.addContainersForPreemption(Collections.singletonList(this.containers.get(0)), starvingApp1);
        schedulerNode.addContainersForPreemption(Collections.singletonList(this.containers.get(1)), starvingApp1);
        schedulerNode.addContainersForPreemption(Collections.singletonList(this.containers.get(2)), starvingApp2);
        schedulerNode.releaseContainer(this.containers.get(1).getContainerId(), true);
        this.allocateContainers(schedulerNode);
        schedulerNode.releaseContainer(this.containers.get(2).getContainerId(), true);
        schedulerNode.releaseContainer(this.containers.get(0).getContainerId(), true);
        this.allocateContainers(schedulerNode);
        Assert.assertEquals((String)"Container should be allocated", (Object)schedulerNode.getTotalResource(), (Object)schedulerNode.getAllocatedResource());
        for (int i = 3; i < this.containers.size(); ++i) {
            schedulerNode.releaseContainer(this.containers.get(i).getContainerId(), true);
        }
        this.finalValidation(schedulerNode);
    }

    @Test
    public void testPreemptionToCompletedApp() {
        RMNode node = this.createNode();
        FSSchedulerNode schedulerNode = new FSSchedulerNode(node, false);
        this.saturateCluster(schedulerNode);
        Assert.assertEquals((String)"Container should be allocated", (Object)Resources.multiply((Resource)this.containers.get(0).getContainer().getResource(), (double)this.containers.size()), (Object)schedulerNode.getAllocatedResource());
        FSAppAttempt starvingApp = this.createStarvingApp(schedulerNode, Resource.newInstance((int)1024, (int)1));
        schedulerNode.addContainersForPreemption(Collections.singletonList(this.containers.get(0)), starvingApp);
        schedulerNode.releaseContainer(this.containers.get(0).getContainerId(), true);
        Mockito.when((Object)starvingApp.isStopped()).thenReturn((Object)true);
        this.allocateContainers(schedulerNode);
        Assert.assertNotEquals((String)"Container should be allocated", (Object)schedulerNode.getTotalResource(), (Object)schedulerNode.getAllocatedResource());
        for (int i = 1; i < this.containers.size(); ++i) {
            schedulerNode.releaseContainer(this.containers.get(i).getContainerId(), true);
        }
        this.finalValidation(schedulerNode);
    }

    @Test
    public void testPartialReservedPreemption() {
        RMNode node = this.createNode();
        FSSchedulerNode schedulerNode = new FSSchedulerNode(node, false);
        this.saturateCluster(schedulerNode);
        Assert.assertEquals((String)"Container should be allocated", (Object)Resources.multiply((Resource)this.containers.get(0).getContainer().getResource(), (double)this.containers.size()), (Object)schedulerNode.getAllocatedResource());
        Resource originalStarvingAppDemand = Resource.newInstance((int)512, (int)1);
        FSAppAttempt starvingApp = this.createStarvingApp(schedulerNode, originalStarvingAppDemand);
        schedulerNode.addContainersForPreemption(Collections.singletonList(this.containers.get(0)), starvingApp);
        schedulerNode.releaseContainer(this.containers.get(0).getContainerId(), true);
        this.allocateContainers(schedulerNode);
        Assert.assertEquals((String)"Container should be allocated", (Object)Resources.subtract((Resource)schedulerNode.getTotalResource(), (Resource)Resource.newInstance((int)512, (int)0)), (Object)schedulerNode.getAllocatedResource());
        schedulerNode.getPreemptionList();
        for (int i = 1; i < this.containers.size(); ++i) {
            schedulerNode.releaseContainer(this.containers.get(i).getContainerId(), true);
        }
        this.finalValidation(schedulerNode);
    }
}

