/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.placement.schema.MappingRulesDescription;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionOptions;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.DryRunResultHolder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigConverterTestCommons;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigConverter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigConverterParams;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.PreconditionException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.QueuePlacementConverter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.UnsupportedPropertyException;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestFSConfigToCSConfigConverter {
    private static final String CLUSTER_RESOURCE_STRING = "vcores=20, memory-mb=240";
    private static final Resource CLUSTER_RESOURCE = Resource.newInstance((int)16384, (int)16);
    private static final String FILE_PREFIX = "file:";
    private static final String FAIR_SCHEDULER_XML = TestFSConfigToCSConfigConverter.prepareFileName("fair-scheduler-conversion.xml");
    private static final String FS_INVALID_PLACEMENT_RULES_XML = TestFSConfigToCSConfigConverter.prepareFileName("fair-scheduler-invalidplacementrules.xml");
    private static final String FS_ONLY_FAIR_POLICY_XML = TestFSConfigToCSConfigConverter.prepareFileName("fair-scheduler-onlyfairpolicy.xml");
    private static final String FS_MIXED_POLICY_XML = TestFSConfigToCSConfigConverter.prepareFileName("fair-scheduler-orderingpolicy-mixed.xml");
    private static final String FS_NO_PLACEMENT_RULES_XML = TestFSConfigToCSConfigConverter.prepareFileName("fair-scheduler-noplacementrules.xml");
    private static final String FS_MAX_AM_SHARE_DISABLED_XML = TestFSConfigToCSConfigConverter.prepareFileName("fair-scheduler-defaultMaxAmShareDisabled.xml");
    @Mock
    private FSConfigToCSConfigRuleHandler ruleHandler;
    @Mock
    private DryRunResultHolder dryRunResultHolder;
    @Mock
    private QueuePlacementConverter placementConverter;
    private FSConfigToCSConfigConverter converter;
    private Configuration config;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private FSConfigConverterTestCommons converterTestCommons;
    private static final String FAIR_SCHEDULER_XML_INVALID = TestFSConfigToCSConfigConverter.prepareFileName("fair-scheduler-invalid.xml");
    private static final String YARN_SITE_XML = TestFSConfigToCSConfigConverter.prepareFileName("yarn-site-with-allocation-file-ref.xml");
    private static final String YARN_SITE_XML_NO_REF_TO_FS_XML = TestFSConfigToCSConfigConverter.prepareFileName("yarn-site.xml");
    private static final String YARN_SITE_XML_INVALID = TestFSConfigToCSConfigConverter.prepareFileName("yarn-site-with-invalid-allocation-file-ref.xml");
    private static final String CONVERSION_RULES_FILE = new File("src/test/resources/conversion-rules.properties").getAbsolutePath();

    private static String prepareFileName(String f) {
        return FILE_PREFIX + new File("src/test/resources/" + f).getAbsolutePath();
    }

    private ConversionOptions createDefaultConversionOptions() {
        return new ConversionOptions(new DryRunResultHolder(), false);
    }

    @Before
    public void setup() throws IOException {
        this.config = new Configuration(false);
        this.config.set("yarn.scheduler.fair.allocation.file", FAIR_SCHEDULER_XML);
        this.config.setBoolean("yarn.scheduler.fair.migration.mode", true);
        this.config.setBoolean("yarn.scheduler.fair.user-as-default-queue", true);
        this.createConverter();
        this.converterTestCommons = new FSConfigConverterTestCommons();
        this.converterTestCommons.setUp();
    }

    @After
    public void tearDown() {
        this.converterTestCommons.tearDown();
    }

    private void createConverter() {
        this.converter = new FSConfigToCSConfigConverter(this.ruleHandler, this.createDefaultConversionOptions());
        this.converter.setClusterResource(CLUSTER_RESOURCE);
        this.converter.setConvertPlacementRules(false);
    }

    private FSConfigToCSConfigConverterParams.Builder createDefaultParamsBuilder() {
        return FSConfigToCSConfigConverterParams.Builder.create().withYarnSiteXmlConfig(YARN_SITE_XML).withOutputDirectory(FSConfigConverterTestCommons.OUTPUT_DIR);
    }

    private FSConfigToCSConfigConverterParams.Builder createParamsBuilder(String yarnSiteConfig) {
        return FSConfigToCSConfigConverterParams.Builder.create().withYarnSiteXmlConfig(yarnSiteConfig).withOutputDirectory(FSConfigConverterTestCommons.OUTPUT_DIR);
    }

    @Test
    public void testDefaultMaxAMShare() throws Exception {
        this.converter.convert(this.config);
        Configuration conf = this.converter.getCapacitySchedulerConfig();
        String maxAmShare = conf.get("yarn.scheduler.capacity.maximum-am-resource-percent");
        Assert.assertEquals((String)"Default max AM share", (Object)"0.16", (Object)maxAmShare);
        Assert.assertEquals((String)"root.admins.alice max-am-resource-percent", (Object)"0.15", (Object)conf.get("yarn.scheduler.capacity.root.admins.alice.maximum-am-resource-percent"));
        Assert.assertNull((String)"root.users.joe maximum-am-resource-percent should be null", (Object)conf.get("yarn.scheduler.capacity.root.users.joe.maximum-am-resource-percent"));
    }

    @Test
    public void testDefaultUserLimitFactor() throws Exception {
        this.converter.convert(this.config);
        Configuration conf = this.converter.getCapacitySchedulerConfig();
        Assert.assertNull((String)"root.users user-limit-factor should be null", (Object)conf.get("yarn.scheduler.capacity.root.users.user-limit-factor"));
        Assert.assertEquals((String)"root.users auto-queue-creation-v2.enabled", (Object)"true", (Object)conf.get("yarn.scheduler.capacity.root.users.auto-queue-creation-v2.enabled"));
        Assert.assertEquals((String)"root.default user-limit-factor", (Object)"-1.0", (Object)conf.get("yarn.scheduler.capacity.root.default.user-limit-factor"));
        Assert.assertEquals((String)"root.users.joe user-limit-factor", (Object)"-1.0", (Object)conf.get("yarn.scheduler.capacity.root.users.joe.user-limit-factor"));
        Assert.assertEquals((String)"root.admins.bob user-limit-factor", (Object)"-1.0", (Object)conf.get("yarn.scheduler.capacity.root.admins.bob.user-limit-factor"));
        Assert.assertNull((String)"root.admin.bob auto-queue-creation-v2.enabled should be null", (Object)conf.get("yarn.scheduler.capacity.root.admin.bob.auto-queue-creation-v2.enabled"));
    }

    @Test
    public void testDefaultMaxAMShareDisabled() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource(CLUSTER_RESOURCE_STRING).withFairSchedulerXmlConfig(FS_MAX_AM_SHARE_DISABLED_XML).build();
        this.converter.convert(params);
        Configuration conf = this.converter.getCapacitySchedulerConfig();
        Assert.assertEquals((String)"Default max-am-resource-percent", (Object)"1.0", (Object)conf.get("yarn.scheduler.capacity.maximum-am-resource-percent"));
        Assert.assertNull((String)"root.admins.bob maximum-am-resource-percent should be null", (Object)conf.get("yarn.scheduler.capacity.root.admins.bob.maximum-am-resource-percent"));
        Assert.assertEquals((String)"root.admins.alice max-am-resource-percent", (Object)"0.15", (Object)conf.get("yarn.scheduler.capacity.root.admins.alice.maximum-am-resource-percent"));
        Assert.assertNull((String)"root.users.joe maximum-am-resource-percent should be null", (Object)conf.get("yarn.scheduler.capacity.root.users.joe.maximum-am-resource-percent"));
    }

    @Test
    public void testConvertACLs() throws Exception {
        this.converter.convert(this.config);
        Configuration conf = this.converter.getCapacitySchedulerConfig();
        Assert.assertEquals((String)"root submit ACL", (Object)"alice,bob,joe,john hadoop_users", (Object)conf.get("yarn.scheduler.capacity.root.acl_submit_applications"));
        Assert.assertEquals((String)"root admin ACL", (Object)"alice,bob,joe,john hadoop_users", (Object)conf.get("yarn.scheduler.capacity.root.acl_administer_queue"));
        Assert.assertEquals((String)"root.admins.bob submit ACL", (Object)"bob ", (Object)conf.get("yarn.scheduler.capacity.root.admins.bob.acl_submit_applications"));
        Assert.assertEquals((String)"root.admins.bob admin ACL", (Object)"bob ", (Object)conf.get("yarn.scheduler.capacity.root.admins.bob.acl_administer_queue"));
        Assert.assertEquals((String)"root.admins.alice submit ACL", (Object)"alice ", (Object)conf.get("yarn.scheduler.capacity.root.admins.alice.acl_submit_applications"));
        Assert.assertEquals((String)"root.admins.alice admin ACL", (Object)"alice ", (Object)conf.get("yarn.scheduler.capacity.root.admins.alice.acl_administer_queue"));
        Assert.assertEquals((String)"root.users.john submit ACL", (Object)"john ", (Object)conf.get("yarn.scheduler.capacity.root.users.john.acl_submit_applications"));
        Assert.assertEquals((String)"root.users.john admin ACL", (Object)"john ", (Object)conf.get("yarn.scheduler.capacity.root.users.john.acl_administer_queue"));
        Assert.assertEquals((String)"root.users.joe submit ACL", (Object)"joe ", (Object)conf.get("yarn.scheduler.capacity.root.users.joe.acl_submit_applications"));
        Assert.assertEquals((String)"root.users.joe admin ACL", (Object)"joe ", (Object)conf.get("yarn.scheduler.capacity.root.users.joe.acl_administer_queue"));
    }

    @Test
    public void testDefaultQueueMaxParallelApps() throws Exception {
        this.converter.convert(this.config);
        Configuration conf = this.converter.getCapacitySchedulerConfig();
        Assert.assertEquals((String)"Default max parallel apps", (long)15L, (long)conf.getInt("yarn.scheduler.capacity.max-parallel-apps", -1));
    }

    @Test
    public void testSpecificQueueMaxParallelApps() throws Exception {
        this.converter.convert(this.config);
        Configuration conf = this.converter.getCapacitySchedulerConfig();
        Assert.assertEquals((String)"root.admins.alice max parallel apps", (long)2L, (long)conf.getInt("yarn.scheduler.capacity.root.admins.alice.max-parallel-apps", -1));
    }

    @Test
    public void testDefaultUserMaxParallelApps() throws Exception {
        this.converter.convert(this.config);
        Configuration conf = this.converter.getCapacitySchedulerConfig();
        int userMaxParallelApps = conf.getInt("yarn.scheduler.capacity.user.max-parallel-apps", -1);
        Assert.assertEquals((String)"Default user max parallel apps", (long)10L, (long)userMaxParallelApps);
    }

    @Test
    public void testSpecificUserMaxParallelApps() throws Exception {
        this.converter.convert(this.config);
        Configuration conf = this.converter.getCapacitySchedulerConfig();
        Assert.assertEquals((String)"Max parallel apps for alice", (long)30L, (long)conf.getInt("yarn.scheduler.capacity.user.alice.max-parallel-apps", -1));
        Assert.assertNull((String)"Max parallel apps should be undefined for user bob", (Object)conf.get("yarn.scheduler.capacity.user.bob.max-parallel-apps"));
        Assert.assertNull((String)"Max parallel apps should be undefined for user joe", (Object)conf.get("yarn.scheduler.capacity.user.joe.max-parallel-apps"));
        Assert.assertNull((String)"Max parallel apps should be undefined for user john", (Object)conf.get("yarn.scheduler.capacity.user.john.max-parallel-apps"));
    }

    @Test
    public void testQueueMaxChildCapacityNotSupported() throws Exception {
        this.expectedException.expect(UnsupportedPropertyException.class);
        this.expectedException.expectMessage("test");
        ((FSConfigToCSConfigRuleHandler)Mockito.doThrow((Throwable[])new Throwable[]{new UnsupportedPropertyException("test")}).when((Object)this.ruleHandler)).handleMaxChildCapacity();
        this.converter.convert(this.config);
    }

    @Test
    public void testReservationSystemNotSupported() throws Exception {
        this.expectedException.expect(UnsupportedPropertyException.class);
        this.expectedException.expectMessage("maxCapacity");
        ((FSConfigToCSConfigRuleHandler)Mockito.doThrow((Throwable[])new Throwable[]{new UnsupportedPropertyException("maxCapacity")}).when((Object)this.ruleHandler)).handleMaxChildCapacity();
        this.config.setBoolean("yarn.resourcemanager.reservation-system.enable", true);
        this.converter.convert(this.config);
    }

    @Test
    public void testConvertFSConfigurationClusterResource() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource(CLUSTER_RESOURCE_STRING).build();
        this.converter.convert(params);
        Assert.assertEquals((String)"Resource", (Object)Resource.newInstance((int)240, (int)20), (Object)this.converter.getClusterResource());
    }

    @Test
    public void testConvertFSConfigPctModeUsedAndClusterResourceDefined() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource(CLUSTER_RESOURCE_STRING).build();
        this.converter.convert(params);
        Assert.assertEquals((String)"Resource", (Object)Resource.newInstance((int)240, (int)20), (Object)this.converter.getClusterResource());
    }

    @Test
    public void testConvertFSConfigurationClusterResourceInvalid() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource("vcores=20, memory-mb=240G").build();
        this.expectedException.expect(ConversionException.class);
        this.expectedException.expectMessage("Error while parsing resource");
        this.converter.convert(params);
    }

    @Test
    public void testConvertFSConfigurationClusterResourceInvalid2() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource("vcores=20, memmmm=240").build();
        this.expectedException.expect(ConversionException.class);
        this.expectedException.expectMessage("Error while parsing resource");
        this.converter.convert(params);
    }

    @Test
    public void testConvertFSConfigurationRulesFile() throws Exception {
        this.ruleHandler = new FSConfigToCSConfigRuleHandler(this.createDefaultConversionOptions());
        this.createConverter();
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withConversionRulesConfig(CONVERSION_RULES_FILE).withClusterResource("vcores=20, memory-mb=2400").build();
        try {
            this.converter.convert(params);
            Assert.fail((String)"Should have thrown UnsupportedPropertyException!");
        }
        catch (UnsupportedPropertyException unsupportedPropertyException) {
            // empty catch block
        }
        this.ruleHandler = this.converter.getRuleHandler();
        Map actions = this.ruleHandler.getActions();
        Assert.assertEquals((String)"maxCapacityPercentage", (Object)FSConfigToCSConfigRuleHandler.RuleAction.ABORT, actions.get("maxCapacityPercentage.action"));
        Assert.assertEquals((String)"maxChildCapacity", (Object)FSConfigToCSConfigRuleHandler.RuleAction.ABORT, actions.get("maxChildCapacity.action"));
        Assert.assertEquals((String)"dynamicMaxAssign", (Object)FSConfigToCSConfigRuleHandler.RuleAction.ABORT, actions.get("dynamicMaxAssign.action"));
        Assert.assertEquals((String)"reservationSystem", (Object)FSConfigToCSConfigRuleHandler.RuleAction.ABORT, actions.get("reservationSystem.action"));
        Assert.assertEquals((String)"queueAutoCreate", (Object)FSConfigToCSConfigRuleHandler.RuleAction.ABORT, actions.get("queueAutoCreate.action"));
    }

    @Test
    public void testConvertFSConfigurationWithoutRulesFile() throws Exception {
        this.ruleHandler = new FSConfigToCSConfigRuleHandler(this.createDefaultConversionOptions());
        this.createConverter();
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource(CLUSTER_RESOURCE_STRING).build();
        this.converter.convert(params);
        this.ruleHandler = this.converter.getRuleHandler();
        Map actions = this.ruleHandler.getActions();
        Assert.assertEquals((String)"maxCapacityPercentage", (Object)FSConfigToCSConfigRuleHandler.RuleAction.WARNING, actions.get("maxCapacityPercentage.action"));
        Assert.assertEquals((String)"maxChildCapacity", (Object)FSConfigToCSConfigRuleHandler.RuleAction.WARNING, actions.get("maxChildCapacity.action"));
        Assert.assertEquals((String)"dynamicMaxAssign", (Object)FSConfigToCSConfigRuleHandler.RuleAction.WARNING, actions.get("dynamicMaxAssign.action"));
        Assert.assertEquals((String)"reservationSystem", (Object)FSConfigToCSConfigRuleHandler.RuleAction.WARNING, actions.get("reservationSystem.action"));
        Assert.assertEquals((String)"queueAutoCreate", (Object)FSConfigToCSConfigRuleHandler.RuleAction.WARNING, actions.get("queueAutoCreate.action"));
        Assert.assertEquals((String)"childStaticDynamicConflict", (Object)FSConfigToCSConfigRuleHandler.RuleAction.WARNING, actions.get("childStaticDynamicConflict.action"));
        Assert.assertEquals((String)"parentChildCreateDiffers", (Object)FSConfigToCSConfigRuleHandler.RuleAction.WARNING, actions.get("parentChildCreateDiff.action"));
        Assert.assertEquals((String)"fairAsDrf", (Object)FSConfigToCSConfigRuleHandler.RuleAction.WARNING, actions.get("fairAsDrf.action"));
        Assert.assertEquals((String)"maxResources", (Object)FSConfigToCSConfigRuleHandler.RuleAction.WARNING, actions.get("maxResources.action"));
        Assert.assertEquals((String)"minResources", (Object)FSConfigToCSConfigRuleHandler.RuleAction.WARNING, actions.get("minResources.action"));
        Assert.assertEquals((String)"parentDynamicCreate", (Object)FSConfigToCSConfigRuleHandler.RuleAction.WARNING, actions.get("parentDynamicCreate.action"));
    }

    @Test
    public void testConvertFSConfigurationUndefinedYarnSiteConfig() throws Exception {
        FSConfigToCSConfigConverterParams params = FSConfigToCSConfigConverterParams.Builder.create().withYarnSiteXmlConfig(null).withOutputDirectory(FSConfigConverterTestCommons.OUTPUT_DIR).build();
        this.expectedException.expect(PreconditionException.class);
        this.expectedException.expectMessage("yarn-site.xml configuration is not defined");
        this.converter.convert(params);
    }

    @Test
    public void testConvertCheckOutputDir() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource(CLUSTER_RESOURCE_STRING).withConvertPlacementRules(true).withPlacementRulesToFile(true).build();
        this.converter.convert(params);
        Configuration conf = this.getConvertedCSConfig(FSConfigConverterTestCommons.OUTPUT_DIR);
        File capacityFile = new File(FSConfigConverterTestCommons.OUTPUT_DIR, "capacity-scheduler.xml");
        Assert.assertTrue((String)"Capacity file exists", (boolean)capacityFile.exists());
        Assert.assertTrue((String)"Capacity file length > 0", (capacityFile.length() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"No. of configuration elements > 0", (conf.size() > 0 ? 1 : 0) != 0);
        File yarnSiteFile = new File(FSConfigConverterTestCommons.OUTPUT_DIR, "yarn-site.xml");
        Assert.assertTrue((String)"Yarn site exists", (boolean)yarnSiteFile.exists());
        Assert.assertTrue((String)"Yarn site length > 0", (yarnSiteFile.length() > 0L ? 1 : 0) != 0);
        File mappingRulesFile = new File(FSConfigConverterTestCommons.OUTPUT_DIR, "mapping-rules.json");
        Assert.assertTrue((String)"Mapping rules file exists", (boolean)mappingRulesFile.exists());
        Assert.assertTrue((String)"Mapping rules file length > 0", (mappingRulesFile.length() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testFairSchedulerXmlIsNotDefinedNeitherDirectlyNorInYarnSiteXml() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createParamsBuilder(YARN_SITE_XML_NO_REF_TO_FS_XML).withClusterResource(CLUSTER_RESOURCE_STRING).build();
        this.expectedException.expect(PreconditionException.class);
        this.expectedException.expectMessage("fair-scheduler.xml is not defined");
        this.converter.convert(params);
    }

    @Test
    public void testInvalidFairSchedulerXml() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource(CLUSTER_RESOURCE_STRING).withFairSchedulerXmlConfig(FAIR_SCHEDULER_XML_INVALID).build();
        this.expectedException.expect(RuntimeException.class);
        this.converter.convert(params);
    }

    @Test
    public void testInvalidYarnSiteXml() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createParamsBuilder(YARN_SITE_XML_INVALID).withClusterResource(CLUSTER_RESOURCE_STRING).build();
        this.expectedException.expect(RuntimeException.class);
        this.converter.convert(params);
    }

    @Test
    public void testConversionWithInvalidPlacementRules() throws Exception {
        this.config = new Configuration(false);
        this.config.set("yarn.scheduler.fair.allocation.file", FS_INVALID_PLACEMENT_RULES_XML);
        this.config.setBoolean("yarn.scheduler.fair.migration.mode", true);
        this.expectedException.expect(ServiceStateException.class);
        this.converter.convert(this.config);
    }

    @Test
    public void testConversionWhenInvalidPlacementRulesIgnored() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource(CLUSTER_RESOURCE_STRING).withFairSchedulerXmlConfig(FS_INVALID_PLACEMENT_RULES_XML).build();
        ConversionOptions conversionOptions = this.createDefaultConversionOptions();
        conversionOptions.setNoTerminalRuleCheck(true);
        this.converter = new FSConfigToCSConfigConverter(this.ruleHandler, conversionOptions);
        this.converter.convert(params);
    }

    @Test
    public void testConversionWhenOnlyFairPolicyIsUsed() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource(CLUSTER_RESOURCE_STRING).withFairSchedulerXmlConfig(FS_ONLY_FAIR_POLICY_XML).build();
        this.converter.convert(params);
        Configuration convertedConfig = this.converter.getYarnSiteConfig();
        Assert.assertEquals((String)"Resource calculator class shouldn't be set", null, (Object)convertedConfig.getClass("yarn.scheduler.capacity.resource-calculator", null));
    }

    @Test
    public void testConversionWhenMixedPolicyIsUsed() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource(CLUSTER_RESOURCE_STRING).withFairSchedulerXmlConfig(FS_MIXED_POLICY_XML).build();
        this.converter.convert(params);
        Configuration convertedConfig = this.converter.getYarnSiteConfig();
        Assert.assertEquals((String)"Resource calculator type", DominantResourceCalculator.class, (Object)convertedConfig.getClass("yarn.scheduler.capacity.resource-calculator", null));
    }

    @Test
    public void testUserAsDefaultQueueWithPlacementRules() throws Exception {
        this.testUserAsDefaultQueueAndPlacementRules(true);
    }

    @Test
    public void testUserAsDefaultQueueWithoutPlacementRules() throws Exception {
        this.testUserAsDefaultQueueAndPlacementRules(false);
    }

    private void testUserAsDefaultQueueAndPlacementRules(boolean hasPlacementRules) throws Exception {
        this.config = new Configuration(false);
        this.config.setBoolean("yarn.scheduler.fair.migration.mode", true);
        if (hasPlacementRules) {
            this.config.set("yarn.scheduler.fair.allocation.file", FAIR_SCHEDULER_XML);
        } else {
            this.config.set("yarn.scheduler.fair.allocation.file", FS_NO_PLACEMENT_RULES_XML);
        }
        this.config.setBoolean("yarn.scheduler.fair.user-as-default-queue", true);
        this.converter.setConvertPlacementRules(true);
        this.converter.setConsoleMode(true);
        this.converter.convert(this.config);
        String json = this.converter.getCapacitySchedulerConfig().get("yarn.scheduler.capacity.mapping-rule-json");
        MappingRulesDescription description = (MappingRulesDescription)new ObjectMapper().reader().forType(MappingRulesDescription.class).readValue(json);
        if (hasPlacementRules) {
            Assert.assertEquals((String)"Number of rules", (long)5L, (long)description.getRules().size());
        } else {
            Assert.assertEquals((String)"Number of rules", (long)2L, (long)description.getRules().size());
        }
    }

    @Test
    public void testPlacementRulesConversionDisabled() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource(CLUSTER_RESOURCE_STRING).withFairSchedulerXmlConfig(FAIR_SCHEDULER_XML).withConvertPlacementRules(false).build();
        this.converter.setPlacementConverter(this.placementConverter);
        this.converter.convert(params);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.placementConverter});
    }

    @Test
    public void testPlacementRulesConversionEnabled() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource(CLUSTER_RESOURCE_STRING).withFairSchedulerXmlConfig(FAIR_SCHEDULER_XML).withConvertPlacementRules(true).build();
        this.converter.setPlacementConverter(this.placementConverter);
        this.converter.convert(params);
        ((QueuePlacementConverter)Mockito.verify((Object)this.placementConverter)).convertPlacementPolicy((PlacementManager)ArgumentMatchers.any(PlacementManager.class), (FSConfigToCSConfigRuleHandler)ArgumentMatchers.any(FSConfigToCSConfigRuleHandler.class), (CapacitySchedulerConfiguration)ArgumentMatchers.any(CapacitySchedulerConfiguration.class), ArgumentMatchers.anyBoolean());
        Assert.assertTrue((boolean)this.converter.getCapacitySchedulerConfig().getBoolean("yarn.scheduler.capacity.queue-mappings-override.enable", false));
    }

    @Test
    public void testConversionWhenAsyncSchedulingIsEnabled() throws Exception {
        boolean schedulingEnabledValue = this.testConversionWithAsyncSchedulingOption(true);
        Assert.assertTrue((String)"Asynchronous scheduling should be true", (boolean)schedulingEnabledValue);
    }

    @Test
    public void testConversionWhenAsyncSchedulingIsDisabled() throws Exception {
        boolean schedulingEnabledValue = this.testConversionWithAsyncSchedulingOption(false);
        Assert.assertEquals((String)"Asynchronous scheduling should be the default value", (Object)false, (Object)schedulingEnabledValue);
    }

    @Test
    public void testSiteDisabledPreemptionWithObserveOnlyConversion() throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withDisablePreemption(FSConfigToCSConfigConverterParams.PreemptionMode.OBSERVE_ONLY).build();
        this.converter.convert(params);
        Assert.assertTrue((String)"The observe only should be true", (boolean)this.converter.getCapacitySchedulerConfig().getBoolean("yarn.resourcemanager.monitor.capacity.preemption.observe_only", false));
    }

    private boolean testConversionWithAsyncSchedulingOption(boolean enabled) throws Exception {
        FSConfigToCSConfigConverterParams params = this.createDefaultParamsBuilder().withClusterResource(CLUSTER_RESOURCE_STRING).withFairSchedulerXmlConfig(FAIR_SCHEDULER_XML).build();
        ConversionOptions conversionOptions = this.createDefaultConversionOptions();
        conversionOptions.setEnableAsyncScheduler(enabled);
        this.converter = new FSConfigToCSConfigConverter(this.ruleHandler, conversionOptions);
        this.converter.convert(params);
        Configuration convertedConfig = this.converter.getYarnSiteConfig();
        return convertedConfig.getBoolean("yarn.scheduler.capacity.schedule-asynchronously.enable", false);
    }

    private Configuration getConvertedCSConfig(String dir) throws IOException {
        File capacityFile = new File(dir, "capacity-scheduler.xml");
        ByteArrayInputStream input = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)capacityFile));
        Configuration conf = new Configuration(false);
        conf.addResource((InputStream)input);
        return conf;
    }
}

