/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.ConversionOptions;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.DryRunResultHolder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSConfigToCSConfigRuleHandler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSQueueConverter;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.FSQueueConverterBuilder;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.UnsupportedPropertyException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestFSQueueConverter {
    private static final float MAX_AM_SHARE_DEFAULT = 0.16f;
    private static final int MAX_APPS_DEFAULT = 15;
    private static final Resource CLUSTER_RESOURCE = Resource.newInstance((int)16384, (int)16);
    private static final Set<String> ALL_QUEUES = Sets.newHashSet((Object[])new String[]{"root", "root.default", "root.admins", "root.users", "root.admins.alice", "root.admins.bob", "root.users.joe", "root.users.john", "root.misc", "root.misc.a", "root.misc.b"});
    private static final String FILE_PREFIX = "file:";
    private static final String FAIR_SCHEDULER_XML = TestFSQueueConverter.prepareFileName("fair-scheduler-conversion.xml");
    private FSQueueConverter converter;
    private Configuration yarnConfig;
    private Configuration csConfig;
    private FairScheduler fs;
    private FSQueue rootQueue;
    private ConversionOptions conversionOptions;
    private DryRunResultHolder dryRunResultHolder;
    private FSQueueConverterBuilder builder;
    @Mock
    private FSConfigToCSConfigRuleHandler ruleHandler;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    private static String prepareFileName(String f) {
        return FILE_PREFIX + new File("src/test/resources/" + f).getAbsolutePath();
    }

    @Before
    public void setup() {
        this.yarnConfig = new Configuration(false);
        this.yarnConfig.set("yarn.scheduler.fair.allocation.file", FAIR_SCHEDULER_XML);
        this.yarnConfig.setBoolean("yarn.scheduler.fair.migration.mode", true);
        this.csConfig = new Configuration(false);
        this.dryRunResultHolder = new DryRunResultHolder();
        this.conversionOptions = new ConversionOptions(this.dryRunResultHolder, false);
        this.fs = this.createFairScheduler();
        this.createBuilder();
        this.rootQueue = this.fs.getQueueManager().getRootQueue();
    }

    @After
    public void tearDown() throws IOException {
        if (this.fs != null) {
            this.fs.close();
        }
    }

    private FairScheduler createFairScheduler() {
        RMContextImpl ctx = new RMContextImpl();
        PlacementManager placementManager = new PlacementManager();
        ctx.setQueuePlacementManager(placementManager);
        FairScheduler fairScheduler = new FairScheduler();
        fairScheduler.setRMContext((RMContext)ctx);
        fairScheduler.init(this.yarnConfig);
        return fairScheduler;
    }

    private void createBuilder() {
        this.builder = FSQueueConverterBuilder.create().withRuleHandler(this.ruleHandler).withCapacitySchedulerConfig(this.csConfig).withPreemptionEnabled(false).withSizeBasedWeight(false).withClusterResource(CLUSTER_RESOURCE).withQueueMaxAMShareDefault(0.16f).withQueueMaxAppsDefault(15).withConversionOptions(this.conversionOptions);
    }

    @Test
    public void testConvertQueueHierarchy() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root children", (Object)"admins,users,misc,default", (Object)this.csConfig.get("yarn.scheduler.capacity.root.queues"));
        Assert.assertEquals((String)"root.admins children", (Object)"bob,alice", (Object)this.csConfig.get("yarn.scheduler.capacity.root.admins.queues"));
        Assert.assertNull((String)"root.default children", (Object)this.csConfig.get("yarn.scheduler.capacity.root.default.queues"));
        Assert.assertEquals((String)"root.users children", (Object)"john,joe", (Object)this.csConfig.get("yarn.scheduler.capacity.root.users.queues"));
        Set leafs = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root", "root.default", "root.admins", "root.users", "root.misc"}));
        this.assertNoValueForQueues(leafs, ".queues", this.csConfig);
    }

    @Test
    public void testQueueMaxAMShare() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root.admins.bob AM share", (Object)"1.0", (Object)this.csConfig.get("yarn.scheduler.capacity.root.admins.bob.maximum-am-resource-percent"));
        Assert.assertEquals((String)"root.admins.alice AM share", (Object)"0.15", (Object)this.csConfig.get("yarn.scheduler.capacity.root.admins.alice.maximum-am-resource-percent"));
        Set remaining = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root.admins.bob", "root.admins.alice"}));
        this.assertNoValueForQueues(remaining, ".maximum-am-resource-percent", this.csConfig);
    }

    @Test
    public void testQueueMaxParallelApps() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root.admins.alice max apps", (long)2L, (long)this.csConfig.getInt("yarn.scheduler.capacity.root.admins.alice.max-parallel-apps", -1));
        Set remaining = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root.admins.alice"}));
        this.assertNoValueForQueues(remaining, ".max-parallel-apps", this.csConfig);
    }

    @Test
    public void testQueueMaxAllocations() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root.admins max vcores", (long)3L, (long)this.csConfig.getInt("yarn.scheduler.capacity.root.admins.maximum-allocation-vcores", -1));
        Assert.assertEquals((String)"root.admins max memory", (long)4096L, (long)this.csConfig.getInt("yarn.scheduler.capacity.root.admins.maximum-allocation-mb", -1));
        Assert.assertEquals((String)"root.users.john max vcores", (long)2L, (long)this.csConfig.getInt("yarn.scheduler.capacity.root.users.john.maximum-allocation-vcores", -1));
        Assert.assertEquals((String)"root.users.john max memory", (long)8192L, (long)this.csConfig.getInt("yarn.scheduler.capacity.root.users.john.maximum-allocation-mb", -1));
        Set remaining = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root.admins", "root.users.john"}));
        this.assertNoValueForQueues(remaining, ".maximum-allocation-vcores", this.csConfig);
        this.assertNoValueForQueues(remaining, ".maximum-allocation-mb", this.csConfig);
    }

    @Test
    public void testQueuePreemptionDisabled() {
        this.converter = this.builder.withPreemptionEnabled(true).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertTrue((String)"root.admins.alice preemption setting", (boolean)this.csConfig.getBoolean("yarn.scheduler.capacity.root.admins.alice.disable_preemption", false));
        Assert.assertTrue((String)"root.users.joe preemption setting", (boolean)this.csConfig.getBoolean("yarn.scheduler.capacity.root.users.joe.disable_preemption", false));
        Set remaining = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root.admins.alice", "root.users.joe"}));
        this.assertNoValueForQueues(remaining, ".disable_preemption", this.csConfig);
    }

    @Test
    public void testQueuePreemptionDisabledWhenGlobalPreemptionDisabled() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        this.assertNoValueForQueues(ALL_QUEUES, ".disable_preemption", this.csConfig);
    }

    @Test
    public void testChildCapacityInCapacityMode() {
        this.converter = this.builder.withPercentages(true).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root.default capacity", (Object)"33.333", (Object)this.csConfig.get("yarn.scheduler.capacity.root.default.capacity"));
        Assert.assertEquals((String)"root.admins capacity", (Object)"33.333", (Object)this.csConfig.get("yarn.scheduler.capacity.root.admins.capacity"));
        Assert.assertEquals((String)"root.users capacity", (Object)"33.334", (Object)this.csConfig.get("yarn.scheduler.capacity.root.users.capacity"));
        Assert.assertEquals((String)"root.users.john capacity", (Object)"25.000", (Object)this.csConfig.get("yarn.scheduler.capacity.root.users.john.capacity"));
        Assert.assertEquals((String)"root.users.joe capacity", (Object)"75.000", (Object)this.csConfig.get("yarn.scheduler.capacity.root.users.joe.capacity"));
        Assert.assertEquals((String)"root.admins.alice capacity", (Object)"75.000", (Object)this.csConfig.get("yarn.scheduler.capacity.root.admins.alice.capacity"));
        Assert.assertEquals((String)"root.admins.bob capacity", (Object)"25.000", (Object)this.csConfig.get("yarn.scheduler.capacity.root.admins.bob.capacity"));
        Assert.assertEquals((String)"root.misc capacity", (Object)"0.000", (Object)this.csConfig.get("yarn.scheduler.capacity.root.misc.capacity"));
        Assert.assertEquals((String)"root.misc.a capacity", (Object)"0.000", (Object)this.csConfig.get("yarn.scheduler.capacity.root.misc.a.capacity"));
        Assert.assertEquals((String)"root.misc.b capacity", (Object)"0.000", (Object)this.csConfig.get("yarn.scheduler.capacity.root.misc.b.capacity"));
    }

    @Test
    public void testChildCapacityInWeightMode() {
        this.converter = this.builder.withPercentages(false).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root.default weight", (Object)"1.0w", (Object)this.csConfig.get("yarn.scheduler.capacity.root.default.capacity"));
        Assert.assertEquals((String)"root.admins weight", (Object)"1.0w", (Object)this.csConfig.get("yarn.scheduler.capacity.root.admins.capacity"));
        Assert.assertEquals((String)"root.users weight", (Object)"1.0w", (Object)this.csConfig.get("yarn.scheduler.capacity.root.users.capacity"));
        Assert.assertEquals((String)"root.users.john weight", (Object)"1.0w", (Object)this.csConfig.get("yarn.scheduler.capacity.root.users.john.capacity"));
        Assert.assertEquals((String)"root.users.joe weight", (Object)"3.0w", (Object)this.csConfig.get("yarn.scheduler.capacity.root.users.joe.capacity"));
        Assert.assertEquals((String)"root.admins.alice weight", (Object)"3.0w", (Object)this.csConfig.get("yarn.scheduler.capacity.root.admins.alice.capacity"));
        Assert.assertEquals((String)"root.admins.bob weight", (Object)"1.0w", (Object)this.csConfig.get("yarn.scheduler.capacity.root.admins.bob.capacity"));
        Assert.assertEquals((String)"root.misc weight", (Object)"0.0w", (Object)this.csConfig.get("yarn.scheduler.capacity.root.misc.capacity"));
        Assert.assertEquals((String)"root.misc.a weight", (Object)"0.0w", (Object)this.csConfig.get("yarn.scheduler.capacity.root.misc.a.capacity"));
        Assert.assertEquals((String)"root.misc.b weight", (Object)"0.0w", (Object)this.csConfig.get("yarn.scheduler.capacity.root.misc.b.capacity"));
    }

    @Test
    public void testAutoCreateV2FlagsInWeightMode() {
        this.converter = this.builder.withPercentages(false).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertTrue((String)"root autocreate v2 flag", (boolean)this.csConfig.getBoolean("yarn.scheduler.capacity.root.auto-queue-creation-v2.enabled", false));
        Assert.assertTrue((String)"root.admins autocreate v2 flag", (boolean)this.csConfig.getBoolean("yarn.scheduler.capacity.root.admins.auto-queue-creation-v2.enabled", false));
        Assert.assertTrue((String)"root.users autocreate v2 flag", (boolean)this.csConfig.getBoolean("yarn.scheduler.capacity.root.users.auto-queue-creation-v2.enabled", false));
        Assert.assertTrue((String)"root.misc autocreate v2 flag", (boolean)this.csConfig.getBoolean("yarn.scheduler.capacity.root.misc.auto-queue-creation-v2.enabled", false));
        Set leafs = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root", "root.default", "root.admins", "root.users", "root.misc"}));
        this.assertNoValueForQueues(leafs, "auto-queue-creation-v2.enabled", this.csConfig);
    }

    @Test
    public void testZeroSumCapacityValidation() {
        this.converter = this.builder.withPercentages(true).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Set noZeroSumAllowedQueues = Sets.difference(ALL_QUEUES, (Set)Sets.newHashSet((Object[])new String[]{"root.misc"}));
        this.assertNoValueForQueues(noZeroSumAllowedQueues, ".allow-zero-capacity-sum", this.csConfig);
        Assert.assertTrue((String)"root.misc allow zero capacities", (boolean)this.csConfig.getBoolean("yarn.scheduler.capacity.root.misc.allow-zero-capacity-sum", false));
    }

    @Test
    public void testQueueMaximumCapacity() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        this.assertValueForQueues(ALL_QUEUES, ".maximum-capacity", this.csConfig, "100");
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler, (VerificationMode)Mockito.times((int)3))).handleMaxResources();
    }

    @Test
    public void testQueueMinimumCapacity() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler, (VerificationMode)Mockito.times((int)2))).handleMinResources();
    }

    @Test
    public void testQueueWithNoAutoCreateChildQueue() {
        this.converter = this.builder.withCapacitySchedulerConfig(this.csConfig).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        this.assertNoValueForQueues(ALL_QUEUES, ".auto-create-child-queue.enabled", this.csConfig);
    }

    @Test
    public void testQueueSizeBasedWeightEnabled() {
        this.converter = this.builder.withSizeBasedWeight(true).build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        this.assertTrueForQueues(ALL_QUEUES, ".ordering-policy.fair.enable-size-based-weight", this.csConfig);
    }

    @Test
    public void testQueueSizeBasedWeightDisabled() {
        this.converter = this.builder.build();
        this.converter.convertQueueHierarchy(this.rootQueue);
        this.assertNoValueForQueues(ALL_QUEUES, ".ordering-policy.fair.enable-size-based-weight", this.csConfig);
    }

    @Test
    public void testQueueOrderingPolicy() throws Exception {
        this.converter = this.builder.build();
        String absolutePath = new File("src/test/resources/fair-scheduler-orderingpolicy.xml").getAbsolutePath();
        this.yarnConfig.set("yarn.scheduler.fair.allocation.file", FILE_PREFIX + absolutePath);
        this.fs.close();
        this.fs = this.createFairScheduler();
        this.rootQueue = this.fs.getQueueManager().getRootQueue();
        this.converter.convertQueueHierarchy(this.rootQueue);
        Assert.assertEquals((String)"root ordering policy", null, (Object)this.csConfig.get("yarn.scheduler.capacity.root.ordering-policy"));
        Assert.assertEquals((String)"root.default ordering policy", (Object)"fair", (Object)this.csConfig.get("yarn.scheduler.capacity.root.default.ordering-policy"));
        Assert.assertEquals((String)"root.admins ordering policy", null, (Object)this.csConfig.get("yarn.scheduler.capacity.root.admins.ordering-policy"));
        Assert.assertEquals((String)"root.users ordering policy", null, (Object)this.csConfig.get("yarn.scheduler.capacity.root.users.ordering-policy"));
        Assert.assertEquals((String)"root.users.joe ordering policy", (Object)"fair", (Object)this.csConfig.get("yarn.scheduler.capacity.root.users.joe.ordering-policy"));
        Assert.assertEquals((String)"root.users.john ordering policy", (Object)"fifo", (Object)this.csConfig.get("yarn.scheduler.capacity.root.users.john.ordering-policy"));
        Assert.assertEquals((String)"root.admins.alice ordering policy", (Object)"fifo", (Object)this.csConfig.get("yarn.scheduler.capacity.root.admins.alice.ordering-policy"));
        Assert.assertEquals((String)"root.admins.bob ordering policy", (Object)"fair", (Object)this.csConfig.get("yarn.scheduler.capacity.root.admins.bob.ordering-policy"));
    }

    @Test
    public void testQueueUnsupportedMixedOrderingPolicy() throws IOException {
        this.converter = this.builder.withDrfUsed(true).build();
        String absolutePath = new File("src/test/resources/fair-scheduler-orderingpolicy-mixed.xml").getAbsolutePath();
        this.yarnConfig.set("yarn.scheduler.fair.allocation.file", FILE_PREFIX + absolutePath);
        this.fs.close();
        this.fs = this.createFairScheduler();
        this.rootQueue = this.fs.getQueueManager().getRootQueue();
        this.converter.convertQueueHierarchy(this.rootQueue);
        ((FSConfigToCSConfigRuleHandler)Mockito.verify((Object)this.ruleHandler, (VerificationMode)Mockito.times((int)5))).handleFairAsDrf(ArgumentMatchers.anyString());
    }

    @Test
    public void testQueueMaxChildCapacityNotSupported() {
        this.converter = this.builder.build();
        this.expectedException.expect(UnsupportedPropertyException.class);
        this.expectedException.expectMessage("test");
        ((FSConfigToCSConfigRuleHandler)Mockito.doThrow((Throwable[])new Throwable[]{new UnsupportedPropertyException("test")}).when((Object)this.ruleHandler)).handleMaxChildCapacity();
        this.converter.convertQueueHierarchy(this.rootQueue);
    }

    @Test
    public void testReservationSystemNotSupported() {
        this.converter = this.builder.build();
        this.expectedException.expect(UnsupportedPropertyException.class);
        this.expectedException.expectMessage("maxCapacity");
        ((FSConfigToCSConfigRuleHandler)Mockito.doThrow((Throwable[])new Throwable[]{new UnsupportedPropertyException("maxCapacity")}).when((Object)this.ruleHandler)).handleMaxChildCapacity();
        this.yarnConfig.setBoolean("yarn.resourcemanager.reservation-system.enable", true);
        this.converter.convertQueueHierarchy(this.rootQueue);
    }

    private void assertNoValueForQueues(Set<String> queues, String postfix, Configuration config) {
        for (String queue : queues) {
            String key = "yarn.scheduler.capacity." + queue + postfix;
            Assert.assertNull((String)("Key " + key + " has value, but it should be null"), (Object)config.get(key));
        }
    }

    private void assertValueForQueues(Set<String> queues, String postfix, Configuration config, String expectedValue) {
        for (String queue : queues) {
            String key = "yarn.scheduler.capacity." + queue + postfix;
            Assert.assertEquals((String)("Key " + key + " has different value"), (Object)expectedValue, (Object)config.get(key));
        }
    }

    private void assertTrueForQueues(Set<String> queues, String postfix, Configuration config) {
        for (String queue : queues) {
            String key = "yarn.scheduler.capacity." + queue + postfix;
            Assert.assertTrue((String)("Key " + key + " is false, should be true"), (boolean)config.getBoolean(key, false));
        }
    }
}

