/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.WeightConverterTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.WeightToPercentConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestWeightToPercentageConverter
extends WeightConverterTestBase {
    private WeightToPercentConverter converter;
    private Configuration config;

    @Before
    public void setup() {
        this.converter = new WeightToPercentConverter();
        this.config = new Configuration(false);
    }

    @Test
    public void testSingleWeightConversion() {
        FSQueue root = this.createFSQueues(1);
        this.converter.convertWeightsForChildQueues(root, this.config);
        Assert.assertFalse((String)"Capacity zerosum allowed", (boolean)this.config.getBoolean("yarn.scheduler.capacity.root.allow-zero-capacity-sum", false));
        Assert.assertEquals((String)"root.a capacity", (Object)"100.000", (Object)this.config.get("yarn.scheduler.capacity.root.a.capacity"));
    }

    @Test
    public void testNoChildQueueConversion() {
        FSQueue root = this.createFSQueues(new int[0]);
        this.converter.convertWeightsForChildQueues(root, this.config);
        Assert.assertEquals((String)"Converted items", (long)0L, (long)this.config.getPropsWithPrefix("yarn.scheduler.capacity.").size());
    }

    @Test
    public void testMultiWeightConversion() {
        FSQueue root = this.createFSQueues(1, 2, 3);
        this.converter.convertWeightsForChildQueues(root, this.config);
        Assert.assertEquals((String)"Number of properties", (long)3L, (long)this.config.getPropsWithPrefix("yarn.scheduler.capacity.").size());
        Assert.assertEquals((String)"root.a capacity", (Object)"16.667", (Object)this.config.get("yarn.scheduler.capacity.root.a.capacity"));
        Assert.assertEquals((String)"root.b capacity", (Object)"33.333", (Object)this.config.get("yarn.scheduler.capacity.root.b.capacity"));
        Assert.assertEquals((String)"root.c capacity", (Object)"50.000", (Object)this.config.get("yarn.scheduler.capacity.root.c.capacity"));
    }

    @Test
    public void testMultiWeightConversionWhenOfThemIsZero() {
        FSQueue root = this.createFSQueues(0, 1, 1);
        this.converter.convertWeightsForChildQueues(root, this.config);
        Assert.assertFalse((String)"Capacity zerosum allowed", (boolean)this.config.getBoolean("yarn.scheduler.capacity.root.allow-zero-capacity-sum", false));
        Assert.assertEquals((String)"Number of properties", (long)3L, (long)this.config.getPropsWithPrefix("yarn.scheduler.capacity.").size());
        Assert.assertEquals((String)"root.a capacity", (Object)"0.000", (Object)this.config.get("yarn.scheduler.capacity.root.a.capacity"));
        Assert.assertEquals((String)"root.b capacity", (Object)"50.000", (Object)this.config.get("yarn.scheduler.capacity.root.b.capacity"));
        Assert.assertEquals((String)"root.c capacity", (Object)"50.000", (Object)this.config.get("yarn.scheduler.capacity.root.c.capacity"));
    }

    @Test
    public void testMultiWeightConversionWhenAllOfThemAreZero() {
        FSQueue root = this.createFSQueues(0, 0, 0);
        this.converter.convertWeightsForChildQueues(root, this.config);
        Assert.assertEquals((String)"Number of properties", (long)4L, (long)this.config.getPropsWithPrefix("yarn.scheduler.capacity.").size());
        Assert.assertTrue((String)"Capacity zerosum allowed", (boolean)this.config.getBoolean("yarn.scheduler.capacity.root.allow-zero-capacity-sum", false));
        Assert.assertEquals((String)"root.a capacity", (Object)"0.000", (Object)this.config.get("yarn.scheduler.capacity.root.a.capacity"));
        Assert.assertEquals((String)"root.b capacity", (Object)"0.000", (Object)this.config.get("yarn.scheduler.capacity.root.b.capacity"));
        Assert.assertEquals((String)"root.c capacity", (Object)"0.000", (Object)this.config.get("yarn.scheduler.capacity.root.c.capacity"));
    }

    @Test
    public void testCapacityFixingWithThreeQueues() {
        FSQueue root = this.createFSQueues(1, 1, 1);
        this.converter.convertWeightsForChildQueues(root, this.config);
        Assert.assertEquals((String)"Number of properties", (long)3L, (long)this.config.getPropsWithPrefix("yarn.scheduler.capacity.").size());
        Assert.assertEquals((String)"root.a capacity", (Object)"33.334", (Object)this.config.get("yarn.scheduler.capacity.root.a.capacity"));
        Assert.assertEquals((String)"root.b capacity", (Object)"33.333", (Object)this.config.get("yarn.scheduler.capacity.root.b.capacity"));
        Assert.assertEquals((String)"root.c capacity", (Object)"33.333", (Object)this.config.get("yarn.scheduler.capacity.root.c.capacity"));
    }

    @Test
    public void testCapacityFixingWhenTotalCapacityIsGreaterThanHundred() {
        HashMap<String, BigDecimal> capacities = new HashMap<String, BigDecimal>();
        capacities.put("root.a", new BigDecimal("50.001"));
        capacities.put("root.b", new BigDecimal("25.500"));
        capacities.put("root.c", new BigDecimal("25.500"));
        this.testCapacityFixing(capacities, new BigDecimal("100.001"));
    }

    @Test
    public void testCapacityFixWhenTotalCapacityIsLessThanHundred() {
        HashMap<String, BigDecimal> capacities = new HashMap<String, BigDecimal>();
        capacities.put("root.a", new BigDecimal("49.999"));
        capacities.put("root.b", new BigDecimal("25.500"));
        capacities.put("root.c", new BigDecimal("25.500"));
        this.testCapacityFixing(capacities, new BigDecimal("99.999"));
    }

    private void testCapacityFixing(Map<String, BigDecimal> capacities, BigDecimal total) {
        boolean needCapacityValidationRelax = this.converter.fixCapacities(capacities, total);
        Assert.assertFalse((String)"Capacity zerosum allowed", (boolean)needCapacityValidationRelax);
        Assert.assertEquals((String)"root.a capacity", (Object)new BigDecimal("50.000"), (Object)capacities.get("root.a"));
        Assert.assertEquals((String)"root.b capacity", (Object)new BigDecimal("25.500"), (Object)capacities.get("root.b"));
        Assert.assertEquals((String)"root.c capacity", (Object)new BigDecimal("25.500"), (Object)capacities.get("root.c"));
    }
}

