/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.WeightConverterTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.converter.weightconversion.WeightToWeightConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestWeightToWeightConverter
extends WeightConverterTestBase {
    private WeightToWeightConverter converter;
    private Configuration config;

    @Before
    public void setup() {
        this.converter = new WeightToWeightConverter();
        this.config = new Configuration(false);
    }

    @Test
    public void testNoChildQueueConversion() {
        FSQueue root = this.createFSQueues(new int[0]);
        this.converter.convertWeightsForChildQueues(root, this.config);
        Assert.assertEquals((String)"root weight", (Object)"1.0w", (Object)this.config.get("yarn.scheduler.capacity.root.capacity"));
        Assert.assertEquals((String)"Converted items", (long)2L, (long)this.config.getPropsWithPrefix("yarn.scheduler.capacity.").size());
    }

    @Test
    public void testSingleWeightConversion() {
        FSQueue root = this.createFSQueues(1);
        this.converter.convertWeightsForChildQueues(root, this.config);
        Assert.assertEquals((String)"root weight", (Object)"1.0w", (Object)this.config.get("yarn.scheduler.capacity.root.capacity"));
        Assert.assertEquals((String)"root.a weight", (Object)"1.0w", (Object)this.config.get("yarn.scheduler.capacity.root.a.capacity"));
        Assert.assertEquals((String)"Number of properties", (long)3L, (long)this.config.getPropsWithPrefix("yarn.scheduler.capacity.").size());
    }

    @Test
    public void testMultiWeightConversion() {
        FSQueue root = this.createFSQueues(1, 2, 3);
        this.converter.convertWeightsForChildQueues(root, this.config);
        Assert.assertEquals((String)"Number of properties", (long)5L, (long)this.config.getPropsWithPrefix("yarn.scheduler.capacity.").size());
        Assert.assertEquals((String)"root weight", (Object)"1.0w", (Object)this.config.get("yarn.scheduler.capacity.root.capacity"));
        Assert.assertEquals((String)"root.a weight", (Object)"1.0w", (Object)this.config.get("yarn.scheduler.capacity.root.a.capacity"));
        Assert.assertEquals((String)"root.b weight", (Object)"2.0w", (Object)this.config.get("yarn.scheduler.capacity.root.b.capacity"));
        Assert.assertEquals((String)"root.c weight", (Object)"3.0w", (Object)this.config.get("yarn.scheduler.capacity.root.c.capacity"));
    }

    @Test
    public void testAutoCreateV2FlagOnParent() {
        FSQueue root = this.createFSQueues(1);
        this.converter.convertWeightsForChildQueues(root, this.config);
        Assert.assertTrue((String)"root autocreate v2 enabled", (boolean)this.config.getBoolean("yarn.scheduler.capacity.root.auto-queue-creation-v2.enabled", false));
    }

    @Test
    public void testAutoCreateV2FlagOnParentWithoutChildren() {
        FSParentQueue root = this.createParent(new ArrayList<FSQueue>());
        this.converter.convertWeightsForChildQueues((FSQueue)root, this.config);
        Assert.assertEquals((String)"Number of properties", (long)2L, (long)this.config.getPropsWithPrefix("yarn.scheduler.capacity.").size());
        Assert.assertTrue((String)"root autocreate v2 enabled", (boolean)this.config.getBoolean("yarn.scheduler.capacity.root.auto-queue-creation-v2.enabled", false));
    }
}

