/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmissionData;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMAppSubmitter;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServices;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TestRMWebServicesCapacitySched
extends JerseyTestBase {
    private MockRM rm;

    public TestRMWebServicesCapacitySched() {
        super(TestRMWebServicesCapacitySched.createWebAppDescriptor());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rm = TestRMWebServicesCapacitySched.createMockRM(new CapacitySchedulerConfiguration(new Configuration(false)));
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule(this.rm)}));
    }

    public static void setupQueueConfiguration(CapacitySchedulerConfiguration config) {
        config.setQueues("root", new String[]{"a", "b", "c"});
        String a = "root.a";
        config.setCapacity("root.a", 10.5f);
        config.setMaximumCapacity("root.a", 50.0f);
        config.setInt(CapacitySchedulerConfiguration.getQueuePrefix((String)"root.a") + "max-parallel-apps", 42);
        String b = "root.b";
        config.setCapacity("root.b", 89.5f);
        String c = "root.c";
        config.setCapacity("root.c", "[memory=1024]");
        String a1 = "root.a.a1";
        String a2 = "root.a.a2";
        config.setQueues("root.a", new String[]{"a1", "a2"});
        config.setCapacity("root.a.a1", 30.0f);
        config.setMaximumCapacity("root.a.a1", 50.0f);
        config.setMaximumLifetimePerQueue("root.a.a2", 100L);
        config.setDefaultLifetimePerQueue("root.a.a2", 50L);
        config.setUserLimitFactor("root.a.a1", 100.0f);
        config.setCapacity("root.a.a2", 70.0f);
        config.setUserLimitFactor("root.a.a2", 100.0f);
        String b1 = "root.b.b1";
        String b2 = "root.b.b2";
        String b3 = "root.b.b3";
        config.setQueues("root.b", new String[]{"b1", "b2", "b3"});
        config.setCapacity("root.b.b1", 60.0f);
        config.setUserLimitFactor("root.b.b1", 100.0f);
        config.setCapacity("root.b.b2", 39.5f);
        config.setUserLimitFactor("root.b.b2", 100.0f);
        config.setCapacity("root.b.b3", 0.5f);
        config.setUserLimitFactor("root.b.b3", 100.0f);
        config.setQueues("root.a.a1", new String[]{"a1a", "a1b", "a1c"});
        String a1A = "root.a.a1.a1a";
        config.setCapacity("root.a.a1.a1a", 65.0f);
        String a1B = "root.a.a1.a1b";
        config.setCapacity("root.a.a1.a1b", 15.0f);
        String a1C = "root.a.a1.a1c";
        config.setCapacity("root.a.a1.a1c", 20.0f);
        config.setAutoCreateChildQueueEnabled("root.a.a1.a1c", true);
        config.setInt("yarn.scheduler.capacity.root.a.a1.a1c.leaf-queue-template.capacity", 50);
    }

    @Test
    public void testClusterScheduler() throws Exception {
        ClientResponse response = (ClientResponse)this.resource().path("ws").path("v1").path("cluster").path("scheduler").accept(new String[]{"application/json"}).get(ClientResponse.class);
        TestRMWebServicesCapacitySched.assertJsonResponse(response, "webapp/scheduler-response.json");
    }

    @Test
    public void testClusterSchedulerSlash() throws Exception {
        ClientResponse response = (ClientResponse)this.resource().path("ws").path("v1").path("cluster").path("scheduler/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        TestRMWebServicesCapacitySched.assertJsonResponse(response, "webapp/scheduler-response.json");
    }

    @Test
    public void testClusterSchedulerDefault() throws Exception {
        ClientResponse response = (ClientResponse)this.resource().path("ws").path("v1").path("cluster").path("scheduler").get(ClientResponse.class);
        TestRMWebServicesCapacitySched.assertJsonResponse(response, "webapp/scheduler-response.json");
    }

    @Test
    public void testClusterSchedulerXML() throws Exception {
        ClientResponse response = (ClientResponse)this.resource().path("ws").path("v1").path("cluster").path("scheduler/").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        TestRMWebServicesCapacitySched.assertXmlResponse(response, "webapp/scheduler-response.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerUserResourcesXML() throws Exception {
        this.rm.start();
        try {
            MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(10L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            MockRMAppSubmitter.submit(this.rm, data1);
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(20L, this.rm).withAppName("app2").withUser("user2").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            MockRMAppSubmitter.submit(this.rm, data);
            ClientResponse response = (ClientResponse)this.resource().path("ws/v1/cluster/scheduler").accept(new String[]{"application/xml"}).get(ClientResponse.class);
            TestRMWebServicesCapacitySched.assertXmlResponse(response, "webapp/scheduler-response-PerUserResources.xml");
        }
        finally {
            this.rm.stop();
        }
    }

    @Test
    public void testNodeLabelDefaultAPI() throws Exception {
        CapacitySchedulerConfiguration config = ((CapacityScheduler)this.rm.getResourceScheduler()).getConfiguration();
        config.setDefaultNodeLabelExpression("root", "ROOT-INHERITED");
        config.setDefaultNodeLabelExpression("root.a", "root-a-default-label");
        this.rm.getResourceScheduler().reinitialize((Configuration)config, this.rm.getRMContext());
        this.rm.start();
        try {
            ClientResponse response = (ClientResponse)this.resource().path("ws/v1/cluster/scheduler").accept(new String[]{"application/xml"}).get(ClientResponse.class);
            TestRMWebServicesCapacitySched.assertXmlResponse(response, "webapp/scheduler-response-NodeLabelDefaultAPI.xml");
        }
        finally {
            this.rm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPerUserResourcesJSON() throws Exception {
        this.rm.start();
        try {
            MockRMAppSubmissionData data1 = MockRMAppSubmissionData.Builder.createWithMemory(10L, this.rm).withAppName("app1").withUser("user1").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            MockRMAppSubmitter.submit(this.rm, data1);
            MockRMAppSubmissionData data = MockRMAppSubmissionData.Builder.createWithMemory(20L, this.rm).withAppName("app2").withUser("user2").withAcls(null).withQueue("b1").withUnmanagedAM(false).build();
            MockRMAppSubmitter.submit(this.rm, data);
            ClientResponse response = (ClientResponse)this.resource().path("ws").path("v1").path("cluster").path("scheduler/").accept(new String[]{"application/json"}).get(ClientResponse.class);
            TestRMWebServicesCapacitySched.assertJsonResponse(response, "webapp/scheduler-response-PerUserResources.json");
        }
        finally {
            this.rm.stop();
        }
    }

    @Test
    public void testResourceInfo() {
        Resource res = Resources.createResource((int)10, (int)1);
        Assert.assertEquals((Object)"<memory:10, vCores:1>", (Object)res.toString());
    }

    public static void assertXmlType(ClientResponse response) {
        Assert.assertEquals((Object)(MediaType.APPLICATION_XML_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
    }

    public static void assertXmlResponse(ClientResponse response, String expectedResourceFilename) throws Exception {
        TestRMWebServicesCapacitySched.assertXmlType(response);
        Document document = TestRMWebServicesCapacitySched.loadDocument((String)response.getEntity(String.class));
        String actual = TestRMWebServicesCapacitySched.serializeDocument(document).trim();
        TestRMWebServicesCapacitySched.updateTestDataAutomatically(expectedResourceFilename, actual);
        Assert.assertEquals((Object)TestRMWebServicesCapacitySched.getResourceAsString(expectedResourceFilename), (Object)actual);
    }

    public static String serializeDocument(Document document) throws TransformerException {
        DOMSource domSource = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = XMLUtils.newSecureTransformerFactory();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(domSource, result);
        return writer.toString();
    }

    public static Document loadDocument(String xml) throws Exception {
        DocumentBuilderFactory factory = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        return builder.parse(is);
    }

    public static void assertJsonResponse(ClientResponse response, String expectedResourceFilename) throws JSONException, IOException {
        TestRMWebServicesCapacitySched.assertJsonType(response);
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        String actual = json.toString(2);
        TestRMWebServicesCapacitySched.updateTestDataAutomatically(expectedResourceFilename, actual);
        Assert.assertEquals((Object)TestRMWebServicesCapacitySched.prettyPrintJson(TestRMWebServicesCapacitySched.getResourceAsString(expectedResourceFilename)), (Object)TestRMWebServicesCapacitySched.prettyPrintJson(actual));
    }

    private static String prettyPrintJson(String in) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)objectMapper.readTree(in));
    }

    public static void assertJsonType(ClientResponse response) {
        Assert.assertEquals((Object)(MediaType.APPLICATION_JSON_TYPE + "; " + "charset=utf-8"), (Object)response.getType().toString());
    }

    public static InputStream getResourceAsStream(String configFilename) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(configFilename);
    }

    /*
     * Exception decompiling
     */
    public static String getResourceAsString(String configFilename) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void updateTestDataAutomatically(String configFilename, String actualContent) {
        if (System.getenv("UPDATE_TESTDATA") == null) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String resource = Objects.requireNonNull(Objects.requireNonNull(classLoader.getResource(configFilename)).toURI().getPath()).replaceAll("/target/test-classes/", "/src/test/resources/");
            try (FileWriter writer = new FileWriter(resource, false);){
                writer.write(actualContent);
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)("overwrite should not fail " + e.getMessage()));
        }
    }

    public static WebAppDescriptor createWebAppDescriptor() {
        return new WebAppDescriptor.Builder(new String[]{TestRMWebServicesCapacitySched.class.getPackage().getName()}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build();
    }

    public static MockRM createMockRM(CapacitySchedulerConfiguration csConf) {
        TestRMWebServicesCapacitySched.setupQueueConfiguration(csConf);
        YarnConfiguration conf = new YarnConfiguration((Configuration)csConf);
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.set("yarn.resourcemanager.placement-constraints.handler", "scheduler");
        return new MockRM((Configuration)conf);
    }

    @Test
    public void testClusterSchedulerOverviewCapacity() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler-overview").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        TestRMWebServices.verifyClusterSchedulerOverView(json, "Capacity Scheduler");
    }

    public static class WebServletModule
    extends ServletModule {
        private final MockRM rm;

        WebServletModule(MockRM rm) {
            this.rm = rm;
        }

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(RMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            this.bind(ResourceManager.class).toInstance((Object)this.rm);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }
}

