/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.TestRMWebServicesCapacitySched;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.junit.Test;

public class TestRMWebServicesCapacitySchedDynamicConfig
extends JerseyTestBase {
    private MockRM rm;
    private CapacitySchedulerQueueManager autoQueueHandler;

    public TestRMWebServicesCapacitySchedDynamicConfig() {
        super(TestRMWebServicesCapacitySched.createWebAppDescriptor());
    }

    @Test
    public void testSchedulerResponsePercentageMode() throws Exception {
        Configuration config = CSConfigGenerator.createPercentageConfig();
        this.initResourceManager(config);
        TestRMWebServicesCapacitySched.assertJsonResponse(this.sendRequest(), "webapp/scheduler-response-PercentageMode.json");
    }

    @Test
    public void testSchedulerResponsePercentageModeLegacyAutoCreation() throws Exception {
        Configuration config = CSConfigGenerator.createPercentageConfigLegacyAutoCreation();
        this.initResourceManager(config);
        TestRMWebServicesCapacitySched.assertJsonResponse(this.sendRequest(), "webapp/scheduler-response-PercentageModeLegacyAutoCreation.json");
    }

    @Test
    public void testSchedulerResponseAbsoluteModeLegacyAutoCreation() throws Exception {
        Configuration config = CSConfigGenerator.createAbsoluteConfigLegacyAutoCreation();
        this.initResourceManager(config);
        this.initAutoQueueHandler(0x800000);
        this.createQueue("root.managed.queue1");
        TestRMWebServicesCapacitySched.assertJsonResponse(this.sendRequest(), "webapp/scheduler-response-AbsoluteModeLegacyAutoCreation.json");
    }

    @Test
    public void testSchedulerResponseAbsoluteMode() throws Exception {
        Configuration config = CSConfigGenerator.createAbsoluteConfig();
        this.initResourceManager(config);
        TestRMWebServicesCapacitySched.assertJsonResponse(this.sendRequest(), "webapp/scheduler-response-AbsoluteMode.json");
    }

    @Test
    public void testSchedulerResponseWeightMode() throws Exception {
        Configuration config = CSConfigGenerator.createWeightConfig();
        this.initResourceManager(config);
        TestRMWebServicesCapacitySched.assertJsonResponse(this.sendRequest(), "webapp/scheduler-response-WeightMode.json");
    }

    @Test
    public void testSchedulerResponseWeightModeWithAutoCreatedQueues() throws Exception {
        Configuration config = CSConfigGenerator.createWeightConfigWithAutoQueueCreationEnabled();
        config.setInt(CapacitySchedulerConfiguration.getQueuePrefix((String)"root.autoParent1") + "auto-queue-creation-v2.template." + "maximum-applications", 300);
        this.initResourceManager(config);
        this.initAutoQueueHandler(1228800);
        TestRMWebServicesCapacitySched.assertJsonResponse(this.sendRequest(), "webapp/scheduler-response-WeightModeWithAutoCreatedQueues-Before.json");
        this.createQueue("root.auto1");
        this.createQueue("root.auto2");
        this.createQueue("root.auto3");
        this.createQueue("root.autoParent1.auto4");
        this.createQueue("root.autoParent2.auto5");
        this.createQueue("root.parent.autoParent3.auto6");
        TestRMWebServicesCapacitySched.assertJsonResponse(this.sendRequest(), "webapp/scheduler-response-WeightModeWithAutoCreatedQueues-After.json");
    }

    private void initAutoQueueHandler(int nodeMemory) throws Exception {
        CapacityScheduler cs = (CapacityScheduler)this.rm.getResourceScheduler();
        this.autoQueueHandler = cs.getCapacitySchedulerQueueManager();
        this.rm.registerNode("h1:1234", nodeMemory);
    }

    private void createQueue(String queuePath) throws YarnException, IOException {
        this.autoQueueHandler.createQueue(new QueuePath(queuePath));
    }

    private ClientResponse sendRequest() {
        return (ClientResponse)this.resource().path("ws").path("v1").path("cluster").path("scheduler").accept(new String[]{"application/json"}).get(ClientResponse.class);
    }

    private void initResourceManager(Configuration conf) throws IOException {
        this.rm = TestRMWebServicesCapacitySched.createMockRM(new CapacitySchedulerConfiguration(conf));
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new TestRMWebServicesCapacitySched.WebServletModule(this.rm)}));
        this.rm.start();
        ((CapacityScheduler)this.rm.getResourceScheduler()).reinitialize(conf, this.rm.getRMContext(), true);
    }

    private static class CSConfigGenerator {
        private CSConfigGenerator() {
        }

        public static Configuration createPercentageConfig() {
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("yarn.scheduler.capacity.root.queues", "default, test1, test2");
            conf.put("yarn.scheduler.capacity.root.test1.capacity", "50");
            conf.put("yarn.scheduler.capacity.root.test2.capacity", "50");
            conf.put("yarn.scheduler.capacity.root.test1.maximum-capacity", "100");
            conf.put("yarn.scheduler.capacity.root.test1.state", "RUNNING");
            conf.put("yarn.scheduler.capacity.root.test2.state", "RUNNING");
            return CSConfigGenerator.createConfiguration(conf);
        }

        public static Configuration createPercentageConfigLegacyAutoCreation() {
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("yarn.scheduler.capacity.root.queues", "default, test1, managedtest2");
            conf.put("yarn.scheduler.capacity.root.test1.capacity", "50");
            conf.put("yarn.scheduler.capacity.root.managedtest2.capacity", "50");
            conf.put("yarn.scheduler.capacity.root.test1.maximum-capacity", "100");
            conf.put("yarn.scheduler.capacity.root.test1.state", "RUNNING");
            conf.put("yarn.scheduler.capacity.root.managedtest2.state", "RUNNING");
            conf.put("yarn.scheduler.capacity.root.managedtest2.auto-create-child-queue.enabled", "true");
            return CSConfigGenerator.createConfiguration(conf);
        }

        public static Configuration createAbsoluteConfigLegacyAutoCreation() {
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("yarn.scheduler.capacity.root.queues", "default, managed");
            conf.put("yarn.scheduler.capacity.root.default.state", "STOPPED");
            conf.put("yarn.scheduler.capacity.root.managed.capacity", "[memory=4096,vcores=4]");
            conf.put("yarn.scheduler.capacity.root.managed.leaf-queue-template.capacity", "[memory=2048,vcores=2]");
            conf.put("yarn.scheduler.capacity.root.managed.state", "RUNNING");
            conf.put("yarn.scheduler.capacity.root.managed.auto-create-child-queue.enabled", "true");
            conf.put("yarn.scheduler.capacity.root.managed.leaf-queue-template.acl_submit_applications", "user");
            conf.put("yarn.scheduler.capacity.root.managed.leaf-queue-template.acl_administer_queue", "admin");
            return CSConfigGenerator.createConfiguration(conf);
        }

        public static Configuration createAbsoluteConfig() {
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("yarn.scheduler.capacity.root.queues", "default, test1, test2");
            conf.put("yarn.scheduler.capacity.root.capacity", "[memory=6136,vcores=30]");
            conf.put("yarn.scheduler.capacity.root.default.capacity", "[memory=3064,vcores=15]");
            conf.put("yarn.scheduler.capacity.root.test1.capacity", "[memory=2048,vcores=10]");
            conf.put("yarn.scheduler.capacity.root.test2.capacity", "[memory=1024,vcores=5]");
            conf.put("yarn.scheduler.capacity.root.test1.state", "RUNNING");
            conf.put("yarn.scheduler.capacity.root.test2.state", "RUNNING");
            return CSConfigGenerator.createConfiguration(conf);
        }

        public static Configuration createWeightConfig() {
            return CSConfigGenerator.createWeightConfigInternal(false);
        }

        public static Configuration createWeightConfigWithAutoQueueCreationEnabled() {
            return CSConfigGenerator.createWeightConfigInternal(true);
        }

        private static Configuration createWeightConfigInternal(boolean enableAqc) {
            HashMap<String, String> conf = new HashMap<String, String>();
            conf.put("yarn.scheduler.capacity.root.queues", "default, test1, test2, parent");
            conf.put("yarn.scheduler.capacity.root.capacity", "1w");
            conf.put("yarn.scheduler.capacity.root.default.capacity", "10w");
            conf.put("yarn.scheduler.capacity.root.test1.capacity", "5w");
            conf.put("yarn.scheduler.capacity.root.test2.capacity", "10w");
            conf.put("yarn.scheduler.capacity.root.parent.capacity", "20w");
            conf.put("yarn.scheduler.capacity.root.test1.state", "RUNNING");
            conf.put("yarn.scheduler.capacity.root.test2.state", "RUNNING");
            if (enableAqc) {
                String root = "yarn.scheduler.capacity.root.";
                conf.put("yarn.scheduler.capacity.root.auto-queue-creation-v2.enabled", "true");
                conf.put("yarn.scheduler.capacity.root.auto-queue-creation-v2.parent-template.acl_submit_applications", "parentUser1");
                conf.put("yarn.scheduler.capacity.root.auto-queue-creation-v2.parent-template.acl_administer_queue", "parentAdmin1");
                conf.put("yarn.scheduler.capacity.root.autoParent1.auto-queue-creation-v2.leaf-template.acl_submit_applications", "user1");
                conf.put("yarn.scheduler.capacity.root.autoParent1.auto-queue-creation-v2.leaf-template.acl_administer_queue", "admin1");
                conf.put("yarn.scheduler.capacity.root.*.auto-queue-creation-v2.leaf-template.acl_submit_applications", "wildUser1");
                conf.put("yarn.scheduler.capacity.root.*.auto-queue-creation-v2.leaf-template.acl_administer_queue", "wildAdmin1");
                conf.put("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.enabled", "true");
                conf.put("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.parent-template.acl_submit_applications", "parentUser2");
                conf.put("yarn.scheduler.capacity.root.parent.auto-queue-creation-v2.parent-template.acl_administer_queue", "parentAdmin2");
                conf.put("yarn.scheduler.capacity.root.parent.*.auto-queue-creation-v2.leaf-template.acl_submit_applications", "wildUser2");
                conf.put("yarn.scheduler.capacity.root.parent.*.auto-queue-creation-v2.leaf-template.acl_administer_queue", "wildAdmin2");
            }
            return CSConfigGenerator.createConfiguration(conf);
        }

        public static Configuration createConfiguration(Map<String, String> configs) {
            Configuration config = new Configuration();
            for (Map.Entry<String, String> entry : configs.entrySet()) {
                config.set(entry.getKey(), entry.getValue());
            }
            config.set("yarn.scheduler.configuration.store.class", "memory");
            return config;
        }
    }
}

