/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ProcedureState;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.procedure2.BadProcedureException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.hbase.util.NonceKey;

@InterfaceAudience.Private
public final class ProcedureUtil {
    private ProcedureUtil() {
    }

    public static Procedure newProcedure(String className) throws BadProcedureException {
        try {
            Class<?> clazz = Class.forName(className);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new Exception("the " + clazz + " class is not public");
            }
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            assert (ctor != null) : "no constructor found";
            if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new Exception("the " + clazz + " constructor is not public");
            }
            return (Procedure)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new BadProcedureException("The procedure class " + className + " must be accessible and have an empty constructor", e);
        }
    }

    public static void validateClass(Procedure proc) throws BadProcedureException {
        try {
            Class<?> clazz = proc.getClass();
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new Exception("the " + clazz + " class is not public");
            }
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            assert (ctor != null);
            if (!Modifier.isPublic(ctor.getModifiers())) {
                throw new Exception("the " + clazz + " constructor is not public");
            }
        }
        catch (Exception e) {
            throw new BadProcedureException("The procedure class " + proc.getClass().getName() + " must be accessible and have an empty constructor", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcedureProtos.Procedure convertToProtoProcedure(Procedure proc) throws IOException {
        byte[] result;
        int[] stackIds;
        Preconditions.checkArgument((proc != null ? 1 : 0) != 0);
        ProcedureUtil.validateClass(proc);
        ProcedureProtos.Procedure.Builder builder = ProcedureProtos.Procedure.newBuilder().setClassName(proc.getClass().getName()).setProcId(proc.getProcId()).setState(proc.getState()).setSubmittedTime(proc.getSubmittedTime()).setLastUpdate(proc.getLastUpdate());
        if (proc.hasParent()) {
            builder.setParentId(proc.getParentProcId());
        }
        if (proc.hasTimeout()) {
            builder.setTimeout(proc.getTimeout());
        }
        if (proc.hasOwner()) {
            builder.setOwner(proc.getOwner());
        }
        if ((stackIds = proc.getStackIndexes()) != null) {
            for (int i = 0; i < stackIds.length; ++i) {
                builder.addStackId(stackIds[i]);
            }
        }
        if (proc.hasException()) {
            RemoteProcedureException exception = proc.getException();
            builder.setException(RemoteProcedureException.toProto(exception.getSource(), exception.getCause()));
        }
        if ((result = proc.getResult()) != null) {
            builder.setResult(UnsafeByteOperations.unsafeWrap((byte[])result));
        }
        try (ByteString.Output stateStream = ByteString.newOutput();){
            proc.serializeStateData((OutputStream)stateStream);
            if (stateStream.size() > 0) {
                builder.setStateData(stateStream.toByteString());
            }
        }
        if (proc.getNonceKey() != null) {
            builder.setNonceGroup(proc.getNonceKey().getNonceGroup());
            builder.setNonce(proc.getNonceKey().getNonce());
        }
        return builder.build();
    }

    public static Procedure convertToProcedure(ProcedureProtos.Procedure proto) throws IOException {
        Procedure proc = ProcedureUtil.newProcedure(proto.getClassName());
        proc.setProcId(proto.getProcId());
        proc.setState(proto.getState());
        proc.setSubmittedTime(proto.getSubmittedTime());
        proc.setLastUpdate(proto.getLastUpdate());
        if (proto.hasParentId()) {
            proc.setParentProcId(proto.getParentId());
        }
        if (proto.hasOwner()) {
            proc.setOwner(proto.getOwner());
        }
        if (proto.hasTimeout()) {
            proc.setTimeout(proto.getTimeout());
        }
        if (proto.getStackIdCount() > 0) {
            proc.setStackIndexes(proto.getStackIdList());
        }
        if (proto.hasException()) {
            assert (proc.getState() == ProcedureProtos.ProcedureState.FAILED || proc.getState() == ProcedureProtos.ProcedureState.ROLLEDBACK) : "The procedure must be failed (waiting to rollback) or rolledback";
            proc.setFailure(RemoteProcedureException.fromProto(proto.getException()));
        }
        if (proto.hasResult()) {
            proc.setResult(proto.getResult().toByteArray());
        }
        if (proto.getNonce() != 0L) {
            proc.setNonceKey(new NonceKey(proto.getNonceGroup(), proto.getNonce()));
        }
        proc.deserializeStateData(proto.getStateData().newInput());
        return proc;
    }

    public static ProcedureProtos.Procedure convertToProtoProcedure(ProcedureInfo procInfo) {
        ProcedureProtos.Procedure.Builder builder = ProcedureProtos.Procedure.newBuilder();
        builder.setClassName(procInfo.getProcName());
        builder.setProcId(procInfo.getProcId());
        builder.setSubmittedTime(procInfo.getSubmittedTime());
        builder.setState(ProcedureProtos.ProcedureState.valueOf((String)procInfo.getProcState().name()));
        builder.setLastUpdate(procInfo.getLastUpdate());
        if (procInfo.hasParentId()) {
            builder.setParentId(procInfo.getParentId());
        }
        if (procInfo.hasOwner()) {
            builder.setOwner(procInfo.getProcOwner());
        }
        if (procInfo.isFailed()) {
            builder.setException(ForeignExceptionUtil.toProtoForeignException((Throwable)procInfo.getException()));
        }
        if (procInfo.hasResultData()) {
            builder.setResult(UnsafeByteOperations.unsafeWrap((byte[])procInfo.getResult()));
        }
        return builder.build();
    }

    public static ProcedureInfo convertToProcedureInfo(ProcedureProtos.Procedure procProto) {
        NonceKey nonceKey = null;
        if (procProto.getNonce() != 0L) {
            nonceKey = new NonceKey(procProto.getNonceGroup(), procProto.getNonce());
        }
        return new ProcedureInfo(procProto.getProcId(), procProto.getClassName(), procProto.hasOwner() ? procProto.getOwner() : null, ProcedureUtil.convertToProcedureState(procProto.getState()), procProto.hasParentId() ? procProto.getParentId() : -1L, nonceKey, procProto.hasException() ? ForeignExceptionUtil.toIOException((ErrorHandlingProtos.ForeignExceptionMessage)procProto.getException()) : null, procProto.getLastUpdate(), procProto.getSubmittedTime(), procProto.hasResult() ? procProto.getResult().toByteArray() : null);
    }

    public static ProcedureState convertToProcedureState(ProcedureProtos.ProcedureState state) {
        return ProcedureState.valueOf((String)state.name());
    }

    public static ProcedureInfo convertToProcedureInfo(Procedure proc) {
        return ProcedureUtil.convertToProcedureInfo(proc, null);
    }

    public static ProcedureInfo convertToProcedureInfo(Procedure proc, NonceKey nonceKey) {
        RemoteProcedureException exception = proc.hasException() ? proc.getException() : null;
        return new ProcedureInfo(proc.getProcId(), proc.toStringClass(), proc.getOwner(), ProcedureUtil.convertToProcedureState(proc.getState()), proc.hasParent() ? proc.getParentProcId() : -1L, nonceKey, exception != null ? exception.unwrapRemoteIOException() : null, proc.getLastUpdate(), proc.getSubmittedTime(), proc.getResult());
    }
}

