/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store;

import java.io.IOException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.Procedure;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface ProcedureStore {
    public void registerListener(ProcedureStoreListener var1);

    public boolean unregisterListener(ProcedureStoreListener var1);

    public void start(int var1) throws IOException;

    public void stop(boolean var1);

    public boolean isRunning();

    public int getNumThreads();

    public int setRunningProcedureCount(int var1);

    public void recoverLease() throws IOException;

    public void load(ProcedureLoader var1) throws IOException;

    public void insert(Procedure var1, Procedure[] var2);

    public void insert(Procedure[] var1);

    public void update(Procedure var1);

    public void delete(long var1);

    public void delete(Procedure var1, long[] var2);

    public void delete(long[] var1, int var2, int var3);

    public static interface ProcedureLoader {
        public void setMaxProcId(long var1);

        public void load(ProcedureIterator var1) throws IOException;

        public void handleCorrupted(ProcedureIterator var1) throws IOException;
    }

    public static interface ProcedureIterator {
        public void reset();

        public boolean hasNext();

        public boolean isNextFinished();

        public void skipNext();

        public Procedure nextAsProcedure() throws IOException;

        public ProcedureInfo nextAsProcedureInfo();
    }

    public static interface ProcedureStoreListener {
        public void postSync();

        public void abortProcess();
    }
}

