/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheColumnFamilySummary;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializerIdManager;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocatorException;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCacheStats;
import org.apache.hadoop.hbase.io.hfile.bucket.ByteBufferIOEngine;
import org.apache.hadoop.hbase.io.hfile.bucket.CacheFullException;
import org.apache.hadoop.hbase.io.hfile.bucket.CachedEntryQueue;
import org.apache.hadoop.hbase.io.hfile.bucket.FileIOEngine;
import org.apache.hadoop.hbase.io.hfile.bucket.IOEngine;
import org.apache.hadoop.hbase.io.hfile.bucket.UniqueIndexMap;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class BucketCache
implements BlockCache,
HeapSize {
    static final Log LOG = LogFactory.getLog(BucketCache.class);
    private static final float DEFAULT_SINGLE_FACTOR = 0.25f;
    private static final float DEFAULT_MULTI_FACTOR = 0.5f;
    private static final float DEFAULT_MEMORY_FACTOR = 0.25f;
    private static final float DEFAULT_EXTRA_FREE_FACTOR = 0.1f;
    private static final float DEFAULT_ACCEPT_FACTOR = 0.95f;
    private static final float DEFAULT_MIN_FACTOR = 0.85f;
    private static final int statThreadPeriod = 180;
    static final int DEFAULT_WRITER_THREADS = 3;
    static final int DEFAULT_WRITER_QUEUE_ITEMS = 64;
    IOEngine ioEngine;
    private ConcurrentHashMap<BlockCacheKey, RAMQueueEntry> ramCache;
    private ConcurrentHashMap<BlockCacheKey, BucketEntry> backingMap;
    private volatile boolean cacheEnabled;
    private ArrayList<BlockingQueue<RAMQueueEntry>> writerQueues = new ArrayList();
    WriterThread[] writerThreads;
    private volatile boolean freeInProgress = false;
    private Lock freeSpaceLock = new ReentrantLock();
    private UniqueIndexMap<Integer> deserialiserMap = new UniqueIndexMap();
    private final AtomicLong realCacheSize = new AtomicLong(0L);
    private final AtomicLong heapSize = new AtomicLong(0L);
    private final AtomicLong blockNumber = new AtomicLong(0L);
    private final AtomicLong failedBlockAdditions = new AtomicLong(0L);
    private final AtomicLong accessCount = new AtomicLong(0L);
    private final Object[] cacheWaitSignals;
    private static final int DEFAULT_CACHE_WAIT_TIME = 50;
    boolean wait_when_cache = false;
    private BucketCacheStats cacheStats = new BucketCacheStats();
    private String persistencePath;
    private long cacheCapacity;
    private final long blockSize;
    private final int ioErrorsTolerationDuration;
    public static final int DEFAULT_ERROR_TOLERATION_DURATION = 60000;
    private volatile long ioErrorStartTime = -1L;
    private IdLock offsetLock = new IdLock();
    private final ScheduledExecutorService scheduleThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("BucketCache Statistics #%d").setDaemon(true).build());
    private BucketAllocator bucketAllocator;

    public BucketCache(String ioEngineName, long capacity, int writerThreadNum, int writerQLen, String persistencePath) throws FileNotFoundException, IOException {
        this(ioEngineName, capacity, writerThreadNum, writerQLen, persistencePath, 60000);
    }

    public BucketCache(String ioEngineName, long capacity, int writerThreadNum, int writerQLen, String persistencePath, int ioErrorsTolerationDuration) throws FileNotFoundException, IOException {
        this.ioEngine = this.getIOEngineFromName(ioEngineName, capacity);
        this.writerThreads = new WriterThread[writerThreadNum];
        this.cacheWaitSignals = new Object[writerThreadNum];
        long blockNumCapacity = capacity / 16384L;
        if (blockNumCapacity >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cache capacity is too large, only support 32TB now");
        }
        this.cacheCapacity = capacity;
        this.persistencePath = persistencePath;
        this.blockSize = 8192L;
        this.ioErrorsTolerationDuration = ioErrorsTolerationDuration;
        this.bucketAllocator = new BucketAllocator(capacity);
        for (int i = 0; i < this.writerThreads.length; ++i) {
            this.writerQueues.add(new ArrayBlockingQueue(writerQLen));
            this.cacheWaitSignals[i] = new Object();
        }
        assert (this.writerQueues.size() == this.writerThreads.length);
        this.ramCache = new ConcurrentHashMap();
        this.backingMap = new ConcurrentHashMap((int)blockNumCapacity);
        if (this.ioEngine.isPersistent() && persistencePath != null) {
            try {
                this.retrieveFromFile();
            }
            catch (IOException ioex) {
                LOG.error((Object)"Can't restore from file because of", (Throwable)ioex);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error((Object)"Can't restore from file in rebuild because can't deserialise", (Throwable)cnfe);
                throw new RuntimeException(cnfe);
            }
        }
        String threadName = Thread.currentThread().getName();
        this.cacheEnabled = true;
        for (int i = 0; i < this.writerThreads.length; ++i) {
            this.writerThreads[i] = new WriterThread(this.writerQueues.get(i), i);
            this.writerThreads[i].setName(threadName + "-BucketCacheWriter-" + i);
            this.writerThreads[i].start();
        }
        this.scheduleThreadPool.scheduleAtFixedRate(new StatisticsThread(this), 180L, 180L, TimeUnit.SECONDS);
        LOG.info((Object)"Started bucket cache");
    }

    private IOEngine getIOEngineFromName(String ioEngineName, long capacity) throws IOException {
        if (ioEngineName.startsWith("file:")) {
            return new FileIOEngine(ioEngineName.substring(5), capacity);
        }
        if (ioEngineName.startsWith("offheap")) {
            return new ByteBufferIOEngine(capacity, true);
        }
        if (ioEngineName.startsWith("heap")) {
            return new ByteBufferIOEngine(capacity, false);
        }
        throw new IllegalArgumentException("Don't understand io engine name for cache - prefix with file:, heap or offheap");
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf) {
        this.cacheBlock(cacheKey, buf, false);
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable cachedItem, boolean inMemory) {
        this.cacheBlockWithWait(cacheKey, cachedItem, inMemory, this.wait_when_cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheBlockWithWait(BlockCacheKey cacheKey, Cacheable cachedItem, boolean inMemory, boolean wait) {
        if (!this.cacheEnabled) {
            return;
        }
        if (this.backingMap.containsKey(cacheKey) || this.ramCache.containsKey(cacheKey)) {
            return;
        }
        RAMQueueEntry re = new RAMQueueEntry(cacheKey, cachedItem, this.accessCount.incrementAndGet(), inMemory);
        this.ramCache.put(cacheKey, re);
        int queueNum = (cacheKey.hashCode() & Integer.MAX_VALUE) % this.writerQueues.size();
        BlockingQueue<RAMQueueEntry> bq = this.writerQueues.get(queueNum);
        boolean successfulAddition = bq.offer(re);
        if (!successfulAddition && wait) {
            Object object = this.cacheWaitSignals[queueNum];
            synchronized (object) {
                try {
                    this.cacheWaitSignals[queueNum].wait(50L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            successfulAddition = bq.offer(re);
        }
        if (!successfulAddition) {
            this.ramCache.remove(cacheKey);
            this.failedBlockAdditions.incrementAndGet();
        } else {
            this.blockNumber.incrementAndGet();
            this.heapSize.addAndGet(cachedItem.heapSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cacheable getBlock(BlockCacheKey key, boolean caching, boolean repeat) {
        if (!this.cacheEnabled) {
            return null;
        }
        RAMQueueEntry re = this.ramCache.get(key);
        if (re != null) {
            this.cacheStats.hit(caching);
            re.access(this.accessCount.incrementAndGet());
            return re.getData();
        }
        BucketEntry bucketEntry = this.backingMap.get(key);
        if (bucketEntry != null) {
            long start = System.nanoTime();
            IdLock.Entry lockEntry = null;
            try {
                lockEntry = this.offsetLock.getLockEntry(bucketEntry.offset());
                if (bucketEntry.equals(this.backingMap.get(key))) {
                    int len = bucketEntry.getLength();
                    ByteBuffer bb = ByteBuffer.allocate(len);
                    this.ioEngine.read(bb, bucketEntry.offset());
                    Cacheable cachedBlock = bucketEntry.deserializerReference(this.deserialiserMap).deserialize(bb, true);
                    long timeTaken = System.nanoTime() - start;
                    this.cacheStats.hit(caching);
                    this.cacheStats.ioHit(timeTaken);
                    bucketEntry.access(this.accessCount.incrementAndGet());
                    if (this.ioErrorStartTime > 0L) {
                        this.ioErrorStartTime = -1L;
                    }
                    Cacheable cacheable = cachedBlock;
                    return cacheable;
                }
            }
            catch (IOException ioex) {
                LOG.error((Object)("Failed reading block " + key + " from bucket cache"), (Throwable)ioex);
                this.checkIOErrorIsTolerated();
            }
            finally {
                if (lockEntry != null) {
                    this.offsetLock.releaseLockEntry(lockEntry);
                }
            }
        }
        if (!repeat) {
            this.cacheStats.miss(caching);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        block11: {
            BucketEntry bucketEntry;
            if (!this.cacheEnabled) {
                return false;
            }
            RAMQueueEntry removedBlock = this.ramCache.remove(cacheKey);
            if (removedBlock != null) {
                this.blockNumber.decrementAndGet();
                this.heapSize.addAndGet(-1L * removedBlock.getData().heapSize());
            }
            if ((bucketEntry = this.backingMap.get(cacheKey)) != null) {
                IdLock.Entry lockEntry = null;
                try {
                    lockEntry = this.offsetLock.getLockEntry(bucketEntry.offset());
                    if (bucketEntry.equals(this.backingMap.remove(cacheKey))) {
                        this.bucketAllocator.freeBlock(bucketEntry.offset());
                        this.realCacheSize.addAndGet(-1 * bucketEntry.getLength());
                        if (removedBlock == null) {
                            this.blockNumber.decrementAndGet();
                        }
                        break block11;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (IOException ie) {
                    LOG.warn((Object)("Failed evicting block " + cacheKey));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (lockEntry != null) {
                        this.offsetLock.releaseLockEntry(lockEntry);
                    }
                }
            }
        }
        this.cacheStats.evicted();
        return true;
    }

    public void logStats() {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        long totalSize = this.bucketAllocator.getTotalSize();
        long usedSize = this.bucketAllocator.getUsedSize();
        long freeSize = totalSize - usedSize;
        long cacheSize = this.realCacheSize.get();
        LOG.debug((Object)("BucketCache Stats: failedBlockAdditions=" + this.failedBlockAdditions.get() + ", " + "total=" + StringUtils.byteDesc((long)totalSize) + ", " + "free=" + StringUtils.byteDesc((long)freeSize) + ", " + "usedSize=" + StringUtils.byteDesc((long)usedSize) + ", " + "cacheSize=" + StringUtils.byteDesc((long)cacheSize) + ", " + "accesses=" + this.cacheStats.getRequestCount() + ", " + "hits=" + this.cacheStats.getHitCount() + ", " + "IOhitsPerSecond=" + this.cacheStats.getIOHitsPerSecond() + ", " + "IOTimePerHit=" + String.format("%.2f", this.cacheStats.getIOTimePerHit()) + ", " + "hitRatio=" + (this.cacheStats.getHitCount() == 0L ? "0," : StringUtils.formatPercent((double)this.cacheStats.getHitRatio(), (int)2) + ", ") + "cachingAccesses=" + this.cacheStats.getRequestCachingCount() + ", " + "cachingHits=" + this.cacheStats.getHitCachingCount() + ", " + "cachingHitsRatio=" + (this.cacheStats.getHitCachingCount() == 0L ? "0," : StringUtils.formatPercent((double)this.cacheStats.getHitCachingRatio(), (int)2) + ", ") + "evictions=" + this.cacheStats.getEvictionCount() + ", " + "evicted=" + this.cacheStats.getEvictedCount() + ", " + "evictedPerRun=" + this.cacheStats.evictedPerEviction()));
        this.cacheStats.reset();
    }

    private long acceptableSize() {
        return (long)Math.floor((float)this.bucketAllocator.getTotalSize() * 0.95f);
    }

    private long minSize() {
        return (long)Math.floor((float)this.bucketAllocator.getTotalSize() * 0.85f);
    }

    private long singleSize() {
        return (long)Math.floor((float)this.bucketAllocator.getTotalSize() * 0.25f * 0.85f);
    }

    private long multiSize() {
        return (long)Math.floor((float)this.bucketAllocator.getTotalSize() * 0.5f * 0.85f);
    }

    private long memorySize() {
        return (long)Math.floor((float)this.bucketAllocator.getTotalSize() * 0.25f * 0.85f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSpace() {
        if (!this.freeSpaceLock.tryLock()) {
            return;
        }
        try {
            BucketEntryGroup bucketGroup;
            this.freeInProgress = true;
            long bytesToFreeWithoutExtra = 0L;
            StringBuffer msgBuffer = new StringBuffer();
            BucketAllocator.IndexStatistics[] stats = this.bucketAllocator.getIndexStatistics();
            long[] bytesToFreeForBucket = new long[stats.length];
            for (int i = 0; i < stats.length; ++i) {
                bytesToFreeForBucket[i] = 0L;
                long freeGoal = (long)Math.floor((float)stats[i].totalCount() * 0.14999998f);
                freeGoal = Math.max(freeGoal, 1L);
                if (stats[i].freeCount() >= freeGoal) continue;
                bytesToFreeForBucket[i] = stats[i].itemSize() * (freeGoal - stats[i].freeCount());
                bytesToFreeWithoutExtra += bytesToFreeForBucket[i];
                msgBuffer.append("Free for bucketSize(" + stats[i].itemSize() + ")=" + StringUtils.byteDesc((long)bytesToFreeForBucket[i]) + ", ");
            }
            msgBuffer.append("Free for total=" + StringUtils.byteDesc((long)bytesToFreeWithoutExtra) + ", ");
            if (bytesToFreeWithoutExtra <= 0L) {
                return;
            }
            long currentSize = this.bucketAllocator.getUsedSize();
            long totalSize = this.bucketAllocator.getTotalSize();
            LOG.debug((Object)("Bucket cache free space started; Attempting to  " + msgBuffer.toString() + " of current used=" + StringUtils.byteDesc((long)currentSize) + ",actual cacheSize=" + StringUtils.byteDesc((long)this.realCacheSize.get()) + ",total=" + StringUtils.byteDesc((long)totalSize)));
            long bytesToFreeWithExtra = (long)Math.floor((float)bytesToFreeWithoutExtra * 1.1f);
            BucketEntryGroup bucketSingle = new BucketEntryGroup(bytesToFreeWithExtra, this.blockSize, this.singleSize());
            BucketEntryGroup bucketMulti = new BucketEntryGroup(bytesToFreeWithExtra, this.blockSize, this.multiSize());
            BucketEntryGroup bucketMemory = new BucketEntryGroup(bytesToFreeWithExtra, this.blockSize, this.memorySize());
            for (Map.Entry<BlockCacheKey, BucketEntry> bucketEntryWithKey : this.backingMap.entrySet()) {
                switch (bucketEntryWithKey.getValue().getPriority()) {
                    case SINGLE: {
                        bucketSingle.add(bucketEntryWithKey);
                        break;
                    }
                    case MULTI: {
                        bucketMulti.add(bucketEntryWithKey);
                        break;
                    }
                    case MEMORY: {
                        bucketMemory.add(bucketEntryWithKey);
                    }
                }
            }
            PriorityQueue<BucketEntryGroup> bucketQueue = new PriorityQueue<BucketEntryGroup>(3);
            bucketQueue.add(bucketSingle);
            bucketQueue.add(bucketMulti);
            bucketQueue.add(bucketMemory);
            int remainingBuckets = 3;
            long bytesFreed = 0L;
            while ((bucketGroup = (BucketEntryGroup)bucketQueue.poll()) != null) {
                long overflow = bucketGroup.overflow();
                if (overflow > 0L) {
                    long bucketBytesToFree = Math.min(overflow, (bytesToFreeWithoutExtra - bytesFreed) / (long)remainingBuckets);
                    bytesFreed += bucketGroup.free(bucketBytesToFree);
                }
                --remainingBuckets;
            }
            stats = this.bucketAllocator.getIndexStatistics();
            boolean needFreeForExtra = false;
            for (int i = 0; i < stats.length; ++i) {
                long freeGoal = (long)Math.floor((float)stats[i].totalCount() * 0.14999998f);
                freeGoal = Math.max(freeGoal, 1L);
                if (stats[i].freeCount() >= freeGoal) continue;
                needFreeForExtra = true;
                break;
            }
            if (needFreeForExtra) {
                bucketQueue.clear();
                remainingBuckets = 2;
                bucketQueue.add(bucketSingle);
                bucketQueue.add(bucketMulti);
                while ((bucketGroup = (BucketEntryGroup)bucketQueue.poll()) != null) {
                    long bucketBytesToFree = (bytesToFreeWithExtra - bytesFreed) / (long)remainingBuckets;
                    bytesFreed += bucketGroup.free(bucketBytesToFree);
                    --remainingBuckets;
                }
            }
            if (LOG.isDebugEnabled()) {
                long single = bucketSingle.totalSize();
                long multi = bucketMulti.totalSize();
                long memory = bucketMemory.totalSize();
                LOG.debug((Object)("Bucket cache free space completed; freed=" + StringUtils.byteDesc((long)bytesFreed) + ", " + "total=" + StringUtils.byteDesc((long)totalSize) + ", " + "single=" + StringUtils.byteDesc((long)single) + ", " + "multi=" + StringUtils.byteDesc((long)multi) + ", " + "memory=" + StringUtils.byteDesc((long)memory)));
            }
        }
        finally {
            this.cacheStats.evict();
            this.freeInProgress = false;
            this.freeSpaceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistToFile() throws IOException {
        assert (!this.cacheEnabled);
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            if (!this.ioEngine.isPersistent()) {
                throw new IOException("Attempt to persist non-persistent cache mappings!");
            }
            fos = new FileOutputStream(this.persistencePath, false);
            oos = new ObjectOutputStream(fos);
            oos.writeLong(this.cacheCapacity);
            oos.writeUTF(this.ioEngine.getClass().getName());
            oos.writeUTF(this.backingMap.getClass().getName());
            oos.writeObject(this.deserialiserMap);
            oos.writeObject(this.backingMap);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveFromFile() throws IOException, BucketAllocatorException, ClassNotFoundException {
        File persistenceFile = new File(this.persistencePath);
        if (!persistenceFile.exists()) {
            return;
        }
        assert (!this.cacheEnabled);
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            if (!this.ioEngine.isPersistent()) {
                throw new IOException("Attempt to restore non-persistent cache mappings!");
            }
            fis = new FileInputStream(this.persistencePath);
            ois = new ObjectInputStream(fis);
            long capacitySize = ois.readLong();
            if (capacitySize != this.cacheCapacity) {
                throw new IOException("Mismatched cache capacity:" + StringUtils.byteDesc((long)capacitySize) + ", expected: " + StringUtils.byteDesc((long)this.cacheCapacity));
            }
            String ioclass = ois.readUTF();
            String mapclass = ois.readUTF();
            if (!this.ioEngine.getClass().getName().equals(ioclass)) {
                throw new IOException("Class name for IO engine mismatch: " + ioclass + ", expected:" + this.ioEngine.getClass().getName());
            }
            if (!this.backingMap.getClass().getName().equals(mapclass)) {
                throw new IOException("Class name for cache map mismatch: " + mapclass + ", expected:" + this.backingMap.getClass().getName());
            }
            UniqueIndexMap deserMap = (UniqueIndexMap)ois.readObject();
            BucketAllocator allocator = new BucketAllocator(this.cacheCapacity, this.backingMap, this.realCacheSize);
            this.backingMap = (ConcurrentHashMap)ois.readObject();
            this.bucketAllocator = allocator;
            this.deserialiserMap = deserMap;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
            if (fis != null) {
                fis.close();
            }
            if (!persistenceFile.delete()) {
                throw new IOException("Failed deleting persistence file " + persistenceFile.getAbsolutePath());
            }
        }
    }

    private void checkIOErrorIsTolerated() {
        long now = EnvironmentEdgeManager.currentTimeMillis();
        if (this.ioErrorStartTime > 0L) {
            if (this.cacheEnabled && now - this.ioErrorStartTime > (long)this.ioErrorsTolerationDuration) {
                LOG.error((Object)("IO errors duration time has exceeded " + this.ioErrorsTolerationDuration + "ms, disabing cache, please check your IOEngine"));
                this.disableCache();
            }
        } else {
            this.ioErrorStartTime = now;
        }
    }

    private void disableCache() {
        if (!this.cacheEnabled) {
            return;
        }
        this.cacheEnabled = false;
        this.ioEngine.shutdown();
        this.scheduleThreadPool.shutdown();
        for (int i = 0; i < this.writerThreads.length; ++i) {
            this.writerThreads[i].interrupt();
        }
        this.ramCache.clear();
        if (!this.ioEngine.isPersistent() || this.persistencePath == null) {
            this.backingMap.clear();
        }
    }

    private void join() throws InterruptedException {
        for (int i = 0; i < this.writerThreads.length; ++i) {
            this.writerThreads[i].join();
        }
    }

    @Override
    public void shutdown() {
        this.disableCache();
        LOG.info((Object)("Shutdown bucket cache: IO persistent=" + this.ioEngine.isPersistent() + "; path to write=" + this.persistencePath));
        if (this.ioEngine.isPersistent() && this.persistencePath != null) {
            try {
                this.join();
                this.persistToFile();
            }
            catch (IOException ex) {
                LOG.error((Object)("Unable to persist data on exit: " + ex.toString()), (Throwable)ex);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Failed to persist data on exit", (Throwable)e);
            }
        }
    }

    @Override
    public CacheStats getStats() {
        return this.cacheStats;
    }

    BucketAllocator getAllocator() {
        return this.bucketAllocator;
    }

    public long heapSize() {
        return this.heapSize.get();
    }

    @Override
    public long size() {
        return this.realCacheSize.get();
    }

    @Override
    public long getFreeSize() {
        return this.bucketAllocator.getFreeSize();
    }

    @Override
    public long getBlockCount() {
        return this.blockNumber.get();
    }

    @Override
    public long getCurrentSize() {
        return this.bucketAllocator.getUsedSize();
    }

    @Override
    public long getEvictedCount() {
        return this.cacheStats.getEvictedCount();
    }

    @Override
    public int evictBlocksByHfileName(String hfileName) {
        int numEvicted = 0;
        for (BlockCacheKey key : this.backingMap.keySet()) {
            if (!key.getHfileName().equals(hfileName) || !this.evictBlock(key)) continue;
            ++numEvicted;
        }
        return numEvicted;
    }

    @Override
    public List<BlockCacheColumnFamilySummary> getBlockCacheColumnFamilySummaries(Configuration conf) {
        throw new UnsupportedOperationException();
    }

    void stopWriterThreads() throws InterruptedException {
        for (WriterThread writerThread : this.writerThreads) {
            writerThread.disableWriter();
            writerThread.interrupt();
            writerThread.join();
        }
    }

    private static class RAMQueueEntry {
        private BlockCacheKey key;
        private Cacheable data;
        private long accessTime;
        private boolean inMemory;

        public RAMQueueEntry(BlockCacheKey bck, Cacheable data, long accessTime, boolean inMemory) {
            this.key = bck;
            this.data = data;
            this.accessTime = accessTime;
            this.inMemory = inMemory;
        }

        public Cacheable getData() {
            return this.data;
        }

        public BlockCacheKey getKey() {
            return this.key;
        }

        public void access(long accessTime) {
            this.accessTime = accessTime;
        }

        public BucketEntry writeToCache(IOEngine ioEngine, BucketAllocator bucketAllocator, UniqueIndexMap<Integer> deserialiserMap, AtomicLong realCacheSize) throws CacheFullException, IOException, BucketAllocatorException {
            int len = this.data.getSerializedLength();
            if (len == 0) {
                return null;
            }
            long offset = bucketAllocator.allocateBlock(len);
            BucketEntry bucketEntry = new BucketEntry(offset, len, this.accessTime, this.inMemory);
            bucketEntry.setDeserialiserReference(this.data.getDeserializer(), deserialiserMap);
            try {
                if (this.data instanceof HFileBlock) {
                    ByteBuffer sliceBuf = ((HFileBlock)this.data).getBufferReadOnlyWithHeader();
                    sliceBuf.rewind();
                    assert (len == sliceBuf.limit() + 16);
                    ByteBuffer extraInfoBuffer = ByteBuffer.allocate(16);
                    ((HFileBlock)this.data).serializeExtraInfo(extraInfoBuffer);
                    ioEngine.write(sliceBuf, offset);
                    ioEngine.write(extraInfoBuffer, offset + (long)len - 16L);
                } else {
                    ByteBuffer bb = ByteBuffer.allocate(len);
                    this.data.serialize(bb);
                    ioEngine.write(bb, offset);
                }
            }
            catch (IOException ioe) {
                bucketAllocator.freeBlock(offset);
                throw ioe;
            }
            realCacheSize.addAndGet(len);
            return bucketEntry;
        }
    }

    private class BucketEntryGroup
    implements Comparable<BucketEntryGroup> {
        private CachedEntryQueue queue;
        private long totalSize = 0L;
        private long bucketSize;

        public BucketEntryGroup(long bytesToFree, long blockSize, long bucketSize) {
            this.bucketSize = bucketSize;
            this.queue = new CachedEntryQueue(bytesToFree, blockSize);
            this.totalSize = 0L;
        }

        public void add(Map.Entry<BlockCacheKey, BucketEntry> block) {
            this.totalSize += (long)block.getValue().getLength();
            this.queue.add(block);
        }

        public long free(long toFree) {
            Map.Entry<BlockCacheKey, BucketEntry> entry;
            long freedBytes = 0L;
            while ((entry = this.queue.pollLast()) != null) {
                BucketCache.this.evictBlock(entry.getKey());
                if ((freedBytes += (long)entry.getValue().getLength()) < toFree) continue;
                return freedBytes;
            }
            return freedBytes;
        }

        public long overflow() {
            return this.totalSize - this.bucketSize;
        }

        public long totalSize() {
            return this.totalSize;
        }

        @Override
        public int compareTo(BucketEntryGroup that) {
            if (this.overflow() == that.overflow()) {
                return 0;
            }
            return this.overflow() > that.overflow() ? 1 : -1;
        }

        public boolean equals(Object that) {
            return this == that;
        }
    }

    static class BucketEntry
    implements Serializable,
    Comparable<BucketEntry> {
        private static final long serialVersionUID = -6741504807982257534L;
        private int offsetBase;
        private int length;
        private byte offset1;
        byte deserialiserIndex;
        private volatile long accessTime;
        private BlockPriority priority;

        BucketEntry(long offset, int length, long accessTime, boolean inMemory) {
            this.setOffset(offset);
            this.length = length;
            this.accessTime = accessTime;
            this.priority = inMemory ? BlockPriority.MEMORY : BlockPriority.SINGLE;
        }

        long offset() {
            long o = (long)this.offsetBase & 0xFFFFFFFFFFFFFFFFL;
            return (o += ((long)this.offset1 & 0xFFL) << 32) << 8;
        }

        private void setOffset(long value) {
            assert ((value & 0xFFL) == 0L);
            this.offsetBase = (int)(value >>= 8);
            this.offset1 = (byte)(value >> 32);
        }

        public int getLength() {
            return this.length;
        }

        protected CacheableDeserializer<Cacheable> deserializerReference(UniqueIndexMap<Integer> deserialiserMap) {
            return CacheableDeserializerIdManager.getDeserializer(deserialiserMap.unmap(this.deserialiserIndex));
        }

        protected void setDeserialiserReference(CacheableDeserializer<Cacheable> deserializer, UniqueIndexMap<Integer> deserialiserMap) {
            this.deserialiserIndex = (byte)deserialiserMap.map(deserializer.getDeserialiserIdentifier());
        }

        public void access(long accessTime) {
            this.accessTime = accessTime;
            if (this.priority == BlockPriority.SINGLE) {
                this.priority = BlockPriority.MULTI;
            }
        }

        public BlockPriority getPriority() {
            return this.priority;
        }

        @Override
        public int compareTo(BucketEntry that) {
            if (this.accessTime == that.accessTime) {
                return 0;
            }
            return this.accessTime < that.accessTime ? 1 : -1;
        }

        public boolean equals(Object that) {
            return this == that;
        }
    }

    static enum BlockPriority {
        SINGLE,
        MULTI,
        MEMORY;

    }

    private class WriterThread
    extends HasThread {
        BlockingQueue<RAMQueueEntry> inputQueue;
        final int threadNO;
        boolean writerEnabled = true;

        WriterThread(BlockingQueue<RAMQueueEntry> queue, int threadNO) {
            this.inputQueue = queue;
            this.threadNO = threadNO;
            this.setDaemon(true);
        }

        void disableWriter() {
            this.writerEnabled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList<RAMQueueEntry> entries = new ArrayList<RAMQueueEntry>();
            try {
                while (BucketCache.this.cacheEnabled && this.writerEnabled) {
                    try {
                        entries.add(this.inputQueue.take());
                        this.inputQueue.drainTo(entries);
                        Object object = BucketCache.this.cacheWaitSignals[this.threadNO];
                        synchronized (object) {
                            BucketCache.this.cacheWaitSignals[this.threadNO].notifyAll();
                        }
                    }
                    catch (InterruptedException ie) {
                        if (!BucketCache.this.cacheEnabled) break;
                    }
                    this.doDrain(entries);
                }
            }
            catch (Throwable t) {
                LOG.warn((Object)"Failed doing drain", t);
            }
            LOG.info((Object)(this.getName() + " exiting, cacheEnabled=" + BucketCache.this.cacheEnabled));
        }

        private void doDrain(List<RAMQueueEntry> entries) throws InterruptedException {
            BucketEntry[] bucketEntries = new BucketEntry[entries.size()];
            RAMQueueEntry[] ramEntries = new RAMQueueEntry[entries.size()];
            int done = 0;
            while (entries.size() > 0 && BucketCache.this.cacheEnabled) {
                RAMQueueEntry ramEntry = null;
                try {
                    ramEntry = entries.remove(entries.size() - 1);
                    if (ramEntry == null) {
                        LOG.warn((Object)"Couldn't get the entry from RAM queue, who steals it?");
                        continue;
                    }
                    BucketEntry bucketEntry = ramEntry.writeToCache(BucketCache.this.ioEngine, BucketCache.this.bucketAllocator, BucketCache.this.deserialiserMap, BucketCache.this.realCacheSize);
                    ramEntries[done] = ramEntry;
                    bucketEntries[done++] = bucketEntry;
                    if (BucketCache.this.ioErrorStartTime <= 0L) continue;
                    BucketCache.this.ioErrorStartTime = -1L;
                }
                catch (BucketAllocatorException fle) {
                    LOG.warn((Object)("Failed allocating for block " + (ramEntry == null ? "" : ramEntry.getKey())), (Throwable)fle);
                }
                catch (CacheFullException cfe) {
                    if (!BucketCache.this.freeInProgress) {
                        BucketCache.this.freeSpace();
                        continue;
                    }
                    Thread.sleep(50L);
                }
                catch (IOException ioex) {
                    LOG.error((Object)"Failed writing to bucket cache", (Throwable)ioex);
                    BucketCache.this.checkIOErrorIsTolerated();
                }
            }
            try {
                BucketCache.this.ioEngine.sync();
            }
            catch (IOException ioex) {
                LOG.error((Object)"Faild syncing IO engine", (Throwable)ioex);
                BucketCache.this.checkIOErrorIsTolerated();
                for (int i = 0; i < done; ++i) {
                    if (bucketEntries[i] == null) continue;
                    BucketCache.this.bucketAllocator.freeBlock(bucketEntries[i].offset());
                }
                done = 0;
            }
            for (int i = 0; i < done; ++i) {
                RAMQueueEntry ramCacheEntry;
                if (bucketEntries[i] != null) {
                    BucketCache.this.backingMap.put(ramEntries[i].getKey(), bucketEntries[i]);
                }
                if ((ramCacheEntry = (RAMQueueEntry)BucketCache.this.ramCache.remove(ramEntries[i].getKey())) == null) continue;
                BucketCache.this.heapSize.addAndGet(-1L * ramEntries[i].getData().heapSize());
            }
            if (BucketCache.this.bucketAllocator.getUsedSize() > BucketCache.this.acceptableSize()) {
                BucketCache.this.freeSpace();
            }
        }
    }

    private static class StatisticsThread
    extends Thread {
        BucketCache bucketCache;

        public StatisticsThread(BucketCache bucketCache) {
            super("BucketCache.StatisticsThread");
            this.setDaemon(true);
            this.bucketCache = bucketCache;
        }

        @Override
        public void run() {
            this.bucketCache.logStats();
        }
    }
}

