/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;

@InterfaceAudience.Private
public class CollectionBackedScanner
extends NonLazyKeyValueScanner {
    private final Iterable<KeyValue> data;
    final KeyValue.KVComparator comparator;
    private Iterator<KeyValue> iter;
    private KeyValue current;

    public CollectionBackedScanner(SortedSet<KeyValue> set) {
        this(set, KeyValue.COMPARATOR);
    }

    public CollectionBackedScanner(SortedSet<KeyValue> set, KeyValue.KVComparator comparator) {
        this.comparator = comparator;
        this.data = set;
        this.init();
    }

    public CollectionBackedScanner(List<KeyValue> list) {
        this(list, KeyValue.COMPARATOR);
    }

    public CollectionBackedScanner(List<KeyValue> list, KeyValue.KVComparator comparator) {
        Collections.sort(list, comparator);
        this.comparator = comparator;
        this.data = list;
        this.init();
    }

    public CollectionBackedScanner(KeyValue.KVComparator comparator, KeyValue ... array) {
        this.comparator = comparator;
        ArrayList<KeyValue> tmp = new ArrayList<KeyValue>(array.length);
        for (int i = 0; i < array.length; ++i) {
            tmp.add(array[i]);
        }
        Collections.sort(tmp, comparator);
        this.data = tmp;
        this.init();
    }

    private void init() {
        this.iter = this.data.iterator();
        if (this.iter.hasNext()) {
            this.current = this.iter.next();
        }
    }

    @Override
    public KeyValue peek() {
        return this.current;
    }

    @Override
    public KeyValue next() {
        KeyValue oldCurrent = this.current;
        this.current = this.iter.hasNext() ? this.iter.next() : null;
        return oldCurrent;
    }

    @Override
    public boolean seek(KeyValue seekKv) {
        this.iter = this.data.iterator();
        return this.reseek(seekKv);
    }

    @Override
    public boolean reseek(KeyValue seekKv) {
        while (this.iter.hasNext()) {
            KeyValue next = this.iter.next();
            int ret = this.comparator.compare((Cell)next, (Cell)seekKv);
            if (ret < 0) continue;
            this.current = next;
            return true;
        }
        return false;
    }

    @Override
    public long getSequenceID() {
        return 0L;
    }

    @Override
    public void close() {
    }
}

