/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.InvalidLabelException;
import org.apache.hadoop.hbase.security.visibility.LabelAlreadyExistsException;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityExpEvaluator;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsCache;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public class DefaultVisibilityLabelServiceImpl
implements VisibilityLabelService {
    private static final Log LOG = LogFactory.getLog(DefaultVisibilityLabelServiceImpl.class);
    private static final int SYSTEM_LABEL_ORDINAL = 1;
    private static final Tag[] LABELS_TABLE_TAGS = new Tag[1];
    private static final byte[] DUMMY_VALUE = new byte[0];
    private volatile int ordinalCounter = -1;
    private Configuration conf;
    private HRegion labelsRegion;
    private VisibilityLabelsCache labelsCache;
    private List<ScanLabelGenerator> scanLabelGenerators;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void init(RegionCoprocessorEnvironment e) throws IOException {
        ZooKeeperWatcher zk = e.getRegionServerServices().getZooKeeper();
        try {
            this.labelsCache = VisibilityLabelsCache.createAndGet(zk, this.conf);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Error creating VisibilityLabelsCache", (Throwable)ioe);
            throw ioe;
        }
        this.scanLabelGenerators = VisibilityUtils.getScanLabelGenerators(this.conf);
        if (e.getRegion().getRegionInfo().getTable().equals((Object)VisibilityConstants.LABELS_TABLE_NAME)) {
            byte[] serialized;
            this.labelsRegion = e.getRegion();
            Pair<Map<String, Integer>, Map<String, List<Integer>>> labelsAndUserAuths = this.extractLabelsAndAuths(this.getExistingLabelsWithAuths());
            Map labels = (Map)labelsAndUserAuths.getFirst();
            Map userAuths = (Map)labelsAndUserAuths.getSecond();
            this.addSystemLabel(this.labelsRegion, labels, userAuths);
            int ordinal = 1;
            for (Integer i : labels.values()) {
                if (i <= ordinal) continue;
                ordinal = i;
            }
            this.ordinalCounter = ordinal + 1;
            if (labels.size() > 0) {
                serialized = VisibilityUtils.getDataToWriteToZooKeeper(labels);
                this.labelsCache.writeToZookeeper(serialized, true);
                this.labelsCache.refreshLabelsCache(serialized);
            }
            if (userAuths.size() > 0) {
                serialized = VisibilityUtils.getUserAuthsDataToWriteToZooKeeper(userAuths);
                this.labelsCache.writeToZookeeper(serialized, false);
                this.labelsCache.refreshUserAuthsCache(serialized);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<List<Cell>> getExistingLabelsWithAuths() throws IOException {
        Scan scan = new Scan();
        RegionScanner scanner = this.labelsRegion.getScanner(scan);
        ArrayList<List<Cell>> existingLabels = new ArrayList<List<Cell>>();
        try {
            while (true) {
                ArrayList<Cell> cells = new ArrayList<Cell>();
                scanner.next(cells);
                if (cells.isEmpty()) {
                    break;
                }
                existingLabels.add(cells);
            }
        }
        finally {
            scanner.close();
        }
        return existingLabels;
    }

    protected Pair<Map<String, Integer>, Map<String, List<Integer>>> extractLabelsAndAuths(List<List<Cell>> labelDetails) {
        HashMap<String, Integer> labels = new HashMap<String, Integer>();
        HashMap<String, ArrayList<Integer>> userAuths = new HashMap<String, ArrayList<Integer>>();
        for (List<Cell> cells : labelDetails) {
            for (Cell cell : cells) {
                if (Bytes.equals((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])VisibilityConstants.LABEL_QUALIFIER, (int)0, (int)VisibilityConstants.LABEL_QUALIFIER.length)) {
                    labels.put(Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()), Bytes.toInt((byte[])cell.getRowArray(), (int)cell.getRowOffset()));
                    continue;
                }
                String user = Bytes.toString((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength());
                ArrayList<Integer> auths = (ArrayList<Integer>)userAuths.get(user);
                if (auths == null) {
                    auths = new ArrayList<Integer>();
                    userAuths.put(user, auths);
                }
                auths.add(Bytes.toInt((byte[])cell.getRowArray(), (int)cell.getRowOffset()));
            }
        }
        return new Pair(labels, userAuths);
    }

    protected void addSystemLabel(HRegion region, Map<String, Integer> labels, Map<String, List<Integer>> userAuths) throws IOException {
        if (!labels.containsKey("system")) {
            Put p = new Put(Bytes.toBytes((int)1));
            p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER, Bytes.toBytes((String)"system"));
            List<String> superUsers = this.getSystemAndSuperUsers();
            for (String superUser : superUsers) {
                p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, Bytes.toBytes((String)superUser), DUMMY_VALUE, LABELS_TABLE_TAGS);
            }
            region.put(p);
            labels.put("system", 1);
            for (String superUser : superUsers) {
                List<Integer> auths = userAuths.get(superUser);
                if (auths == null) {
                    auths = new ArrayList<Integer>(1);
                    userAuths.put(superUser, auths);
                }
                auths.add(1);
            }
        }
    }

    protected List<String> getSystemAndSuperUsers() throws IOException {
        User user = User.getCurrent();
        if (user == null) {
            throw new IOException("Unable to obtain the current user, authorization checks for internal operations will not work correctly!");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Current user name is " + user.getShortName()));
        }
        String currentUser = user.getShortName();
        List superUsers = Lists.asList((Object)currentUser, (Object[])this.conf.getStrings("hbase.superuser", new String[0]));
        return superUsers;
    }

    @Override
    public OperationStatus[] addLabels(List<byte[]> labels) throws IOException {
        assert (this.labelsRegion != null);
        OperationStatus[] finalOpStatus = new OperationStatus[labels.size()];
        ArrayList<Mutation> puts = new ArrayList<Mutation>(labels.size());
        int i = 0;
        for (byte[] label : labels) {
            String labelStr = Bytes.toString((byte[])label);
            if (this.labelsCache.getLabelOrdinal(labelStr) > 0) {
                finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, (Exception)new LabelAlreadyExistsException("Label '" + labelStr + "' already exists"));
            } else {
                Put p = new Put(Bytes.toBytes((int)this.ordinalCounter));
                p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER, label, LABELS_TABLE_TAGS);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding the label " + labelStr));
                }
                puts.add((Mutation)p);
                ++this.ordinalCounter;
            }
            ++i;
        }
        if (this.mutateLabelsRegion(puts, finalOpStatus)) {
            this.updateZk(true);
        }
        return finalOpStatus;
    }

    @Override
    public OperationStatus[] setAuths(byte[] user, List<byte[]> authLabels) throws IOException {
        assert (this.labelsRegion != null);
        OperationStatus[] finalOpStatus = new OperationStatus[authLabels.size()];
        ArrayList<Mutation> puts = new ArrayList<Mutation>(authLabels.size());
        int i = 0;
        for (byte[] auth : authLabels) {
            String authStr = Bytes.toString((byte[])auth);
            int labelOrdinal = this.labelsCache.getLabelOrdinal(authStr);
            if (labelOrdinal == 0) {
                finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, (Exception)((Object)new InvalidLabelException("Label '" + authStr + "' doesn't exists")));
            } else {
                Put p = new Put(Bytes.toBytes((int)labelOrdinal));
                p.addImmutable(VisibilityConstants.LABELS_TABLE_FAMILY, user, DUMMY_VALUE, LABELS_TABLE_TAGS);
                puts.add((Mutation)p);
            }
            ++i;
        }
        if (this.mutateLabelsRegion(puts, finalOpStatus)) {
            this.updateZk(false);
        }
        return finalOpStatus;
    }

    @Override
    public OperationStatus[] clearAuths(byte[] user, List<byte[]> authLabels) throws IOException {
        assert (this.labelsRegion != null);
        OperationStatus[] finalOpStatus = new OperationStatus[authLabels.size()];
        List<String> currentAuths = this.getAuths(user, true);
        ArrayList<Mutation> deletes = new ArrayList<Mutation>(authLabels.size());
        int i = 0;
        for (byte[] authLabel : authLabels) {
            String authLabelStr = Bytes.toString((byte[])authLabel);
            if (currentAuths.contains(authLabelStr)) {
                int labelOrdinal = this.labelsCache.getLabelOrdinal(authLabelStr);
                assert (labelOrdinal > 0);
                Delete d = new Delete(Bytes.toBytes((int)labelOrdinal));
                d.deleteColumns(VisibilityConstants.LABELS_TABLE_FAMILY, user);
                deletes.add((Mutation)d);
            } else {
                finalOpStatus[i] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, (Exception)((Object)new InvalidLabelException("Label '" + authLabelStr + "' is not set for the user " + Bytes.toString((byte[])user))));
            }
            ++i;
        }
        if (this.mutateLabelsRegion(deletes, finalOpStatus)) {
            this.updateZk(false);
        }
        return finalOpStatus;
    }

    private boolean mutateLabelsRegion(List<Mutation> mutations, OperationStatus[] finalOpStatus) throws IOException {
        OperationStatus[] opStatus = this.labelsRegion.batchMutate(mutations.toArray(new Mutation[mutations.size()]));
        int i = 0;
        boolean updateZk = false;
        block0: for (OperationStatus status : opStatus) {
            boolean bl = updateZk = updateZk || status.getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS;
            while (i < finalOpStatus.length) {
                if (finalOpStatus[i] == null) {
                    finalOpStatus[i] = status;
                    continue block0;
                }
                ++i;
            }
        }
        return updateZk;
    }

    @Override
    public List<String> getAuths(byte[] user, boolean systemCall) throws IOException {
        assert (this.labelsRegion != null || systemCall);
        if (systemCall || this.labelsRegion == null) {
            return this.labelsCache.getAuths(Bytes.toString((byte[])user));
        }
        Scan s = new Scan();
        s.addColumn(VisibilityConstants.LABELS_TABLE_FAMILY, user);
        Filter filter = VisibilityUtils.createVisibilityLabelFilter(this.labelsRegion, new Authorizations(new String[]{"system"}));
        s.setFilter(filter);
        ArrayList<String> auths = new ArrayList<String>();
        RegionScanner scanner = this.labelsRegion.getScanner(s);
        ArrayList<Cell> results = new ArrayList<Cell>(1);
        while (true) {
            scanner.next(results);
            if (results.isEmpty()) break;
            Cell cell = (Cell)results.get(0);
            int ordinal = Bytes.toInt((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength());
            String label = this.labelsCache.getLabel(ordinal);
            if (label != null) {
                auths.add(label);
            }
            results.clear();
        }
        return auths;
    }

    @Override
    public List<Tag> createVisibilityExpTags(String visExpression, boolean withSerializationFormat, boolean checkAuths) throws IOException {
        Set<Integer> auths = null;
        if (checkAuths) {
            auths = this.labelsCache.getAuthsAsOrdinals(VisibilityUtils.getActiveUser().getShortName());
        }
        return VisibilityUtils.createVisibilityExpTags(visExpression, withSerializationFormat, checkAuths, auths, this.labelsCache);
    }

    protected void updateZk(boolean labelAddition) throws IOException {
        Pair<Map<String, Integer>, Map<String, List<Integer>>> labelsAndUserAuths = this.extractLabelsAndAuths(this.getExistingLabelsWithAuths());
        Map existingLabels = (Map)labelsAndUserAuths.getFirst();
        Map userAuths = (Map)labelsAndUserAuths.getSecond();
        if (labelAddition) {
            byte[] serialized = VisibilityUtils.getDataToWriteToZooKeeper(existingLabels);
            this.labelsCache.writeToZookeeper(serialized, true);
        } else {
            byte[] serialized = VisibilityUtils.getUserAuthsDataToWriteToZooKeeper(userAuths);
            this.labelsCache.writeToZookeeper(serialized, false);
        }
    }

    @Override
    public VisibilityExpEvaluator getVisibilityExpEvaluator(Authorizations authorizations) throws IOException {
        if (this.isReadFromSuperUser()) {
            return new VisibilityExpEvaluator(){

                @Override
                public boolean evaluate(Cell cell) throws IOException {
                    return true;
                }
            };
        }
        ArrayList authLabels = null;
        for (ScanLabelGenerator scanLabelGenerator : this.scanLabelGenerators) {
            try {
                authLabels = scanLabelGenerator.getLabels(VisibilityUtils.getActiveUser(), authorizations);
                authLabels = authLabels == null ? new ArrayList() : authLabels;
                authorizations = new Authorizations(authLabels);
            }
            catch (Throwable t) {
                LOG.error((Object)t);
                throw new IOException(t);
            }
        }
        int labelsCount = this.labelsCache.getLabelsCount();
        final BitSet bs = new BitSet(labelsCount + 1);
        if (authLabels != null) {
            for (String authLabel : authLabels) {
                int labelOrdinal = this.labelsCache.getLabelOrdinal(authLabel);
                if (labelOrdinal == 0) continue;
                bs.set(labelOrdinal);
            }
        }
        return new VisibilityExpEvaluator(){

            @Override
            public boolean evaluate(Cell cell) throws IOException {
                boolean visibilityTagPresent = false;
                if (cell.getTagsLengthUnsigned() > 0) {
                    Iterator tagsItr = CellUtil.tagsIterator((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLengthUnsigned());
                    while (tagsItr.hasNext()) {
                        Pair result;
                        int offset;
                        boolean includeKV = true;
                        Tag tag = (Tag)tagsItr.next();
                        if (tag.getType() != 2) continue;
                        visibilityTagPresent = true;
                        int endOffset = offset + tag.getTagLength();
                        for (offset = tag.getTagOffset(); offset < endOffset; offset += ((Integer)result.getSecond()).intValue()) {
                            result = StreamUtils.readRawVarint32((byte[])tag.getBuffer(), (int)offset);
                            int currLabelOrdinal = (Integer)result.getFirst();
                            if (currLabelOrdinal < 0) {
                                int temp = -currLabelOrdinal;
                                if (!bs.get(temp)) continue;
                                includeKV = false;
                                break;
                            }
                            if (bs.get(currLabelOrdinal)) continue;
                            includeKV = false;
                            break;
                        }
                        if (!includeKV) continue;
                        return true;
                    }
                }
                return !visibilityTagPresent;
            }
        };
    }

    protected boolean isReadFromSuperUser() throws IOException {
        byte[] user = Bytes.toBytes((String)VisibilityUtils.getActiveUser().getShortName());
        return this.havingSystemAuth(user);
    }

    @Override
    public boolean havingSystemAuth(byte[] user) throws IOException {
        List<String> auths = this.getAuths(user, true);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("The auths for user " + Bytes.toString((byte[])user) + " are " + auths));
        }
        return auths.contains("system");
    }

    @Override
    public boolean matchVisibility(List<Tag> putVisTags, Byte putTagsFormat, List<Tag> deleteVisTags, Byte deleteTagsFormat) throws IOException {
        if (deleteTagsFormat != null && deleteTagsFormat == 1 && (putTagsFormat == null || putTagsFormat == 1)) {
            if (putVisTags.size() == 0) {
                return false;
            }
            if (putTagsFormat == null) {
                return DefaultVisibilityLabelServiceImpl.matchUnSortedVisibilityTags(putVisTags, deleteVisTags);
            }
            return DefaultVisibilityLabelServiceImpl.matchOrdinalSortedVisibilityTags(putVisTags, deleteVisTags);
        }
        throw new IOException("Unexpected tag format passed for comparison, deleteTagsFormat : " + deleteTagsFormat + ", putTagsFormat : " + putTagsFormat);
    }

    private static boolean matchUnSortedVisibilityTags(List<Tag> putVisTags, List<Tag> deleteVisTags) throws IOException {
        return DefaultVisibilityLabelServiceImpl.compareTagsOrdinals(DefaultVisibilityLabelServiceImpl.sortTagsBasedOnOrdinal(putVisTags), DefaultVisibilityLabelServiceImpl.sortTagsBasedOnOrdinal(deleteVisTags));
    }

    private static boolean matchOrdinalSortedVisibilityTags(List<Tag> putVisTags, List<Tag> deleteVisTags) {
        boolean matchFound = false;
        if (deleteVisTags.size() == putVisTags.size()) {
            for (Tag tag : deleteVisTags) {
                matchFound = false;
                for (Tag givenTag : putVisTags) {
                    if (!Bytes.equals((byte[])tag.getBuffer(), (int)tag.getTagOffset(), (int)tag.getTagLength(), (byte[])givenTag.getBuffer(), (int)givenTag.getTagOffset(), (int)givenTag.getTagLength())) continue;
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                break;
            }
        }
        return matchFound;
    }

    private static List<List<Integer>> sortTagsBasedOnOrdinal(List<Tag> tags) throws IOException {
        ArrayList<List<Integer>> fullTagsList = new ArrayList<List<Integer>>();
        for (Tag tag : tags) {
            if (tag.getType() != 2) continue;
            DefaultVisibilityLabelServiceImpl.getSortedTagOrdinals(fullTagsList, tag);
        }
        return fullTagsList;
    }

    private static void getSortedTagOrdinals(List<List<Integer>> fullTagsList, Tag tag) throws IOException {
        Pair result;
        int offset;
        ArrayList<Object> tagsOrdinalInSortedOrder = new ArrayList<Object>();
        int endOffset = offset + tag.getTagLength();
        for (offset = tag.getTagOffset(); offset < endOffset; offset += ((Integer)result.getSecond()).intValue()) {
            result = StreamUtils.readRawVarint32((byte[])tag.getBuffer(), (int)offset);
            tagsOrdinalInSortedOrder.add(result.getFirst());
        }
        Collections.sort(tagsOrdinalInSortedOrder);
        fullTagsList.add(tagsOrdinalInSortedOrder);
    }

    private static boolean compareTagsOrdinals(List<List<Integer>> putVisTags, List<List<Integer>> deleteVisTags) {
        boolean matchFound = false;
        if (deleteVisTags.size() == putVisTags.size()) {
            for (List<Integer> deleteTagOrdinals : deleteVisTags) {
                matchFound = false;
                for (List<Integer> tagOrdinals : putVisTags) {
                    if (!deleteTagOrdinals.equals(tagOrdinals)) continue;
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                break;
            }
        }
        return matchFound;
    }

    static {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            StreamUtils.writeRawVInt32((OutputStream)dos, (int)1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DefaultVisibilityLabelServiceImpl.LABELS_TABLE_TAGS[0] = new Tag(2, baos.toByteArray());
    }
}

