/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.wal.RegionGroupingProvider;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALProvider;

@InterfaceAudience.Private
class BoundedRegionGroupingProvider
extends RegionGroupingProvider {
    private static final Log LOG = LogFactory.getLog(BoundedRegionGroupingProvider.class);
    static final String NUM_REGION_GROUPS = "hbase.wal.regiongrouping.numgroups";
    static final int DEFAULT_NUM_REGION_GROUPS = 2;
    private WALProvider[] delegates;
    private AtomicInteger counter = new AtomicInteger(0);

    BoundedRegionGroupingProvider() {
    }

    @Override
    public void init(WALFactory factory, Configuration conf, List<WALActionsListener> listeners, String providerId) throws IOException {
        super.init(factory, conf, listeners, providerId);
        this.delegates = new WALProvider[Math.max(1, conf.getInt(NUM_REGION_GROUPS, 2))];
        for (int i = 0; i < this.delegates.length; ++i) {
            this.delegates[i] = factory.getProvider("hbase.wal.regiongrouping.delegate", DEFAULT_DELEGATE_PROVIDER, listeners, providerId + i);
        }
        LOG.info((Object)("Configured to run with " + this.delegates.length + " delegate WAL providers."));
    }

    @Override
    WALProvider populateCache(byte[] group) {
        WALProvider temp = this.delegates[this.counter.getAndIncrement() % this.delegates.length];
        WALProvider extant = this.cached.putIfAbsent(group, temp);
        return extant == null ? temp : extant;
    }

    @Override
    public void shutdown() throws IOException {
        IOException failure = null;
        for (WALProvider provider : this.delegates) {
            try {
                provider.shutdown();
            }
            catch (IOException exception) {
                LOG.error((Object)("Problem shutting down provider '" + provider + "': " + exception.getMessage()));
                LOG.debug((Object)("Details of problem shutting down provider '" + provider + "'"), (Throwable)exception);
                failure = exception;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public void close() throws IOException {
        IOException failure = null;
        for (WALProvider provider : this.delegates) {
            try {
                provider.close();
            }
            catch (IOException exception) {
                LOG.error((Object)("Problem closing provider '" + provider + "': " + exception.getMessage()));
                LOG.debug((Object)("Details of problem shutting down provider '" + provider + "'"), (Throwable)exception);
                failure = exception;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }
}

