/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.quotas.AverageIntervalRateLimiter;
import org.apache.hadoop.hbase.quotas.FixedIntervalRateLimiter;
import org.apache.hadoop.hbase.quotas.RateLimiter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRateLimiter {
    @Test
    public void testWaitIntervalTimeUnitSeconds() {
        this.testWaitInterval(TimeUnit.SECONDS, 10L, 100L);
    }

    @Test
    public void testWaitIntervalTimeUnitMinutes() {
        this.testWaitInterval(TimeUnit.MINUTES, 10L, 6000L);
    }

    @Test
    public void testWaitIntervalTimeUnitHours() {
        this.testWaitInterval(TimeUnit.HOURS, 10L, 360000L);
    }

    @Test
    public void testWaitIntervalTimeUnitDays() {
        this.testWaitInterval(TimeUnit.DAYS, 10L, 8640000L);
    }

    private void testWaitInterval(TimeUnit timeUnit, long limit, long expectedWaitInterval) {
        long waitInterval;
        AverageIntervalRateLimiter limiter = new AverageIntervalRateLimiter();
        limiter.set(limit, timeUnit);
        long nowTs = 0L;
        int i = 0;
        while ((long)i < limit - 1L) {
            Assert.assertTrue((boolean)limiter.canExecute());
            limiter.consume();
            waitInterval = limiter.waitInterval();
            Assert.assertEquals((long)0L, (long)waitInterval);
            ++i;
        }
        i = 0;
        while ((long)i < limit * 4L) {
            limiter.setNextRefillTime(limiter.getNextRefillTime() - nowTs);
            Assert.assertTrue((boolean)limiter.canExecute());
            Assert.assertEquals((long)0L, (long)limiter.waitInterval());
            limiter.consume();
            waitInterval = limiter.waitInterval();
            Assert.assertEquals((long)expectedWaitInterval, (long)waitInterval);
            nowTs = waitInterval;
            long temp = nowTs + 500L;
            limiter.setNextRefillTime(limiter.getNextRefillTime() + temp);
            Assert.assertFalse((boolean)limiter.canExecute());
            limiter.setNextRefillTime(limiter.getNextRefillTime() - temp);
            ++i;
        }
    }

    @Test
    public void testOverconsumptionAverageIntervalRefillStrategy() {
        AverageIntervalRateLimiter limiter = new AverageIntervalRateLimiter();
        limiter.set(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)limiter.canExecute());
        limiter.consume(20L);
        Assert.assertEquals((long)100L, (long)limiter.waitInterval(1L));
        Assert.assertEquals((long)1000L, (long)limiter.waitInterval(10L));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 900L);
        Assert.assertTrue((boolean)limiter.canExecute(1L));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 100L);
        Assert.assertTrue((boolean)limiter.canExecute());
        Assert.assertEquals((long)0L, (long)limiter.waitInterval());
    }

    @Test
    public void testOverconsumptionFixedIntervalRefillStrategy() throws InterruptedException {
        FixedIntervalRateLimiter limiter = new FixedIntervalRateLimiter();
        limiter.set(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)limiter.canExecute());
        limiter.consume(20L);
        Assert.assertEquals((long)1000L, (long)limiter.waitInterval(1L));
        Assert.assertEquals((long)1000L, (long)limiter.waitInterval(10L));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 900L);
        Assert.assertFalse((boolean)limiter.canExecute(1L));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 100L);
        Assert.assertTrue((boolean)limiter.canExecute());
        Assert.assertEquals((long)0L, (long)limiter.waitInterval());
    }

    @Test
    public void testFixedIntervalResourceAvailability() throws Exception {
        FixedIntervalRateLimiter limiter = new FixedIntervalRateLimiter();
        limiter.set(10L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)limiter.canExecute(10L));
        limiter.consume(3L);
        Assert.assertEquals((long)7L, (long)limiter.getAvailable());
        Assert.assertFalse((boolean)limiter.canExecute(10L));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 3L);
        Assert.assertTrue((boolean)limiter.canExecute(10L));
        Assert.assertEquals((long)10L, (long)limiter.getAvailable());
    }

    @Test
    public void testLimiterBySmallerRate() throws InterruptedException {
        FixedIntervalRateLimiter limiter = new FixedIntervalRateLimiter();
        limiter.set(10L, TimeUnit.SECONDS);
        int count = 0;
        while (count++ < 10) {
            limiter.setNextRefillTime(limiter.getNextRefillTime() - 500L);
            for (int i = 0; i < 3; ++i) {
                Assert.assertEquals((Object)true, (Object)limiter.canExecute());
                limiter.consume();
            }
        }
    }

    @Test
    public void testCanExecuteOfAverageIntervalRateLimiter() throws InterruptedException {
        AverageIntervalRateLimiter limiter = new AverageIntervalRateLimiter();
        limiter.set(100L, TimeUnit.SECONDS);
        limiter.setNextRefillTime(EnvironmentEdgeManager.currentTime());
        Assert.assertEquals((long)50L, (long)this.testCanExecuteByRate((RateLimiter)limiter, 50));
        limiter.set(100L, TimeUnit.SECONDS);
        limiter.setNextRefillTime(EnvironmentEdgeManager.currentTime());
        Assert.assertEquals((long)100L, (long)this.testCanExecuteByRate((RateLimiter)limiter, 100));
        limiter.set(100L, TimeUnit.SECONDS);
        limiter.setNextRefillTime(EnvironmentEdgeManager.currentTime());
        Assert.assertEquals((long)200L, (long)this.testCanExecuteByRate((RateLimiter)limiter, 200));
        limiter.set(100L, TimeUnit.SECONDS);
        limiter.setNextRefillTime(EnvironmentEdgeManager.currentTime());
        Assert.assertEquals((long)200L, (long)this.testCanExecuteByRate((RateLimiter)limiter, 500));
    }

    @Test
    public void testCanExecuteOfFixedIntervalRateLimiter() throws InterruptedException {
        FixedIntervalRateLimiter limiter = new FixedIntervalRateLimiter();
        limiter.set(100L, TimeUnit.SECONDS);
        limiter.setNextRefillTime(EnvironmentEdgeManager.currentTime());
        Assert.assertEquals((long)50L, (long)this.testCanExecuteByRate((RateLimiter)limiter, 50));
        limiter.set(100L, TimeUnit.SECONDS);
        limiter.setNextRefillTime(EnvironmentEdgeManager.currentTime());
        Assert.assertEquals((long)100L, (long)this.testCanExecuteByRate((RateLimiter)limiter, 100));
        limiter.set(100L, TimeUnit.SECONDS);
        limiter.setNextRefillTime(EnvironmentEdgeManager.currentTime());
        Assert.assertEquals((long)100L, (long)this.testCanExecuteByRate((RateLimiter)limiter, 200));
    }

    public int testCanExecuteByRate(RateLimiter limiter, int rate) {
        int request = 0;
        int count = 0;
        while (request++ < rate) {
            limiter.setNextRefillTime(limiter.getNextRefillTime() - limiter.getTimeUnitInMillis() / (long)rate);
            if (!limiter.canExecute()) continue;
            ++count;
            limiter.consume();
        }
        return count;
    }

    @Test
    public void testRefillOfAverageIntervalRateLimiter() throws InterruptedException {
        AverageIntervalRateLimiter limiter = new AverageIntervalRateLimiter();
        limiter.set(60L, TimeUnit.SECONDS);
        Assert.assertEquals((long)60L, (long)limiter.getAvailable());
        Assert.assertEquals((long)60L, (long)limiter.refill(limiter.getLimit()));
        limiter.consume(30L);
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 200L);
        Assert.assertEquals((long)12L, (long)limiter.refill(limiter.getLimit()));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 500L);
        Assert.assertEquals((long)30L, (long)limiter.refill(limiter.getLimit()));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 1000L);
        Assert.assertEquals((long)60L, (long)limiter.refill(limiter.getLimit()));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 3000L);
        Assert.assertEquals((long)60L, (long)limiter.refill(limiter.getLimit()));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 5000L);
        Assert.assertEquals((long)60L, (long)limiter.refill(limiter.getLimit()));
    }

    @Test
    public void testRefillOfFixedIntervalRateLimiter() throws InterruptedException {
        FixedIntervalRateLimiter limiter = new FixedIntervalRateLimiter();
        limiter.set(60L, TimeUnit.SECONDS);
        Assert.assertEquals((long)60L, (long)limiter.getAvailable());
        Assert.assertEquals((long)60L, (long)limiter.refill(limiter.getLimit()));
        limiter.consume(30L);
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 200L);
        Assert.assertEquals((long)0L, (long)limiter.refill(limiter.getLimit()));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 500L);
        Assert.assertEquals((long)0L, (long)limiter.refill(limiter.getLimit()));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 1000L);
        Assert.assertEquals((long)60L, (long)limiter.refill(limiter.getLimit()));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 3000L);
        Assert.assertEquals((long)60L, (long)limiter.refill(limiter.getLimit()));
        limiter.setNextRefillTime(limiter.getNextRefillTime() - 5000L);
        Assert.assertEquals((long)60L, (long)limiter.refill(limiter.getLimit()));
    }
}

