/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALObserver;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestProtobufLog {
    private static final Log LOG = LogFactory.getLog(TestProtobufLog.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected FileSystem fs;
    protected Path dir;
    protected WALFactory wals;
    @Rule
    public final TestName currentTest = new TestName();

    @Before
    public void setUp() throws Exception {
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        this.dir = new Path(TEST_UTIL.createRootDir(), this.currentTest.getMethodName());
        this.wals = new WALFactory(TEST_UTIL.getConfiguration(), null, this.currentTest.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        FileStatus[] entries;
        this.wals.close();
        for (FileStatus dir : entries = this.fs.listStatus(new Path("/"))) {
            this.fs.delete(dir.getPath(), true);
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("dfs.blocksize", 0x100000);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.broken.append", true);
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.socket-timeout", 5000);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connect.max.retries", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.recovery.retries", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.ipc.client.connection.maxidletime", 500);
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.wal.classes", SampleRegionWALObserver.class.getName());
        TEST_UTIL.startMiniDFSCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testWALTrailer() throws IOException {
        this.doRead(true);
        this.doRead(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRead(boolean withTrailer) throws IOException {
        int columnCount = 5;
        int recordCount = 5;
        TableName tableName = TableName.valueOf((String)"tablename");
        byte[] row = Bytes.toBytes((String)"row");
        long timestamp = System.currentTimeMillis();
        Path path = new Path(this.dir, "tempwal");
        this.fs.delete(path, true);
        WALProvider.Writer writer = null;
        ProtobufLogReader reader = null;
        try {
            int i;
            HRegionInfo hri = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            HTableDescriptor htd = new HTableDescriptor(tableName);
            this.fs.mkdirs(this.dir);
            writer = this.wals.createWALWriter(this.fs, path);
            for (i = 0; i < 5; ++i) {
                WALKey key = new WALKey(hri.getEncodedNameAsBytes(), tableName, (long)i, timestamp, HConstants.DEFAULT_CLUSTER_ID);
                WALEdit edit = new WALEdit();
                for (int j = 0; j < 5; ++j) {
                    if (i == 0) {
                        htd.addFamily(new HColumnDescriptor("column" + j));
                    }
                    String value = i + "" + j;
                    edit.add((Cell)new KeyValue(row, row, row, timestamp, Bytes.toBytes((String)value)));
                }
                writer.append(new WAL.Entry(key, edit));
            }
            writer.sync();
            if (withTrailer) {
                writer.close();
            }
            reader = (ProtobufLogReader)this.wals.createReader(this.fs, path);
            if (withTrailer) {
                Assert.assertNotNull((Object)reader.trailer);
            } else {
                Assert.assertNull((Object)reader.trailer);
            }
            for (i = 0; i < 5; ++i) {
                WAL.Entry entry = reader.next();
                Assert.assertNotNull((Object)entry);
                Assert.assertEquals((long)5L, (long)entry.getEdit().size());
                Assert.assertArrayEquals((byte[])hri.getEncodedNameAsBytes(), (byte[])entry.getKey().getEncodedRegionName());
                Assert.assertEquals((Object)tableName, (Object)entry.getKey().getTablename());
                int idx = 0;
                for (Cell val : entry.getEdit().getCells()) {
                    Assert.assertTrue((boolean)Bytes.equals((byte[])row, (byte[])val.getRow()));
                    String value = i + "" + idx;
                    Assert.assertArrayEquals((byte[])Bytes.toBytes((String)value), (byte[])val.getValue());
                    ++idx;
                }
            }
            WAL.Entry entry = reader.next();
            Assert.assertNull((Object)entry);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }
}

