/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestBitComparator {
    private static byte[] zeros = new byte[]{0, 0, 0, 0, 0, 0};
    private static byte[] ones = new byte[]{1, 1, 1, 1, 1, 1};
    private static byte[] data0 = new byte[]{0, 1, 2, 4, 8, 15};
    private static byte[] data1 = new byte[]{15, 0, 0, 0, 0, 0};
    private static byte[] data2 = new byte[]{0, 0, 0, 0, 0, 15};
    private static byte[] data3 = new byte[]{15, 15, 15, 15, 15};
    private static byte[] data1_2 = new byte[]{15, 15, 0, 0, 0, 0, 0, 15};
    private static byte[] data2_2 = new byte[]{15, 0, 0, 0, 0, 0, 15, 15};
    private final int Equal = 0;
    private final int NotEqual = 1;

    @Test
    public void testANDOperation() {
        this.testOperation(zeros, ones, BitComparator.BitwiseOp.AND, 1);
        this.testOperation(data1, ones, BitComparator.BitwiseOp.AND, 0);
        this.testOperation(data1, data0, BitComparator.BitwiseOp.AND, 1);
        this.testOperation(data2, data1, BitComparator.BitwiseOp.AND, 1);
        this.testOperation(ones, data0, BitComparator.BitwiseOp.AND, 0);
        this.testOperation(ones, data3, BitComparator.BitwiseOp.AND, 1);
    }

    @Test
    public void testOROperation() {
        this.testOperation(ones, zeros, BitComparator.BitwiseOp.OR, 0);
        this.testOperation(zeros, zeros, BitComparator.BitwiseOp.OR, 1);
        this.testOperation(data1, zeros, BitComparator.BitwiseOp.OR, 0);
        this.testOperation(data2, data1, BitComparator.BitwiseOp.OR, 0);
        this.testOperation(ones, data3, BitComparator.BitwiseOp.OR, 1);
    }

    @Test
    public void testXOROperation() {
        this.testOperation(ones, zeros, BitComparator.BitwiseOp.XOR, 0);
        this.testOperation(zeros, zeros, BitComparator.BitwiseOp.XOR, 1);
        this.testOperation(ones, ones, BitComparator.BitwiseOp.XOR, 1);
        this.testOperation(data2, data1, BitComparator.BitwiseOp.XOR, 0);
        this.testOperation(ones, data3, BitComparator.BitwiseOp.XOR, 1);
    }

    private void testOperation(byte[] data, byte[] comparatorBytes, BitComparator.BitwiseOp operator, int expected) {
        BitComparator comparator = new BitComparator(comparatorBytes, operator);
        Assert.assertEquals((long)comparator.compareTo(data), (long)expected);
    }

    @Test
    public void testANDOperationWithOffset() {
        this.testOperationWithOffset(data1_2, ones, BitComparator.BitwiseOp.AND, 0);
        this.testOperationWithOffset(data1_2, data0, BitComparator.BitwiseOp.AND, 1);
        this.testOperationWithOffset(data2_2, data1, BitComparator.BitwiseOp.AND, 1);
    }

    @Test
    public void testOROperationWithOffset() {
        this.testOperationWithOffset(data1_2, zeros, BitComparator.BitwiseOp.OR, 0);
        this.testOperationWithOffset(data2_2, data1, BitComparator.BitwiseOp.OR, 0);
    }

    @Test
    public void testXOROperationWithOffset() {
        this.testOperationWithOffset(data2_2, data1, BitComparator.BitwiseOp.XOR, 0);
    }

    private void testOperationWithOffset(byte[] data, byte[] comparatorBytes, BitComparator.BitwiseOp operator, int expected) {
        BitComparator comparator = new BitComparator(comparatorBytes, operator);
        Assert.assertEquals((long)comparator.compareTo(data, 1, comparatorBytes.length), (long)expected);
    }
}

