/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.protobuf.BlockingService;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcClientImpl;
import org.apache.hadoop.hbase.ipc.RpcExecutor;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.SimpleRpcScheduler;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRpcHandlerException {
    private static final Log LOG = LogFactory.getLog(TestRpcHandlerException.class);
    static String example = "xyz";
    static byte[] CELL_BYTES = example.getBytes();
    static Cell CELL = new KeyValue(CELL_BYTES, CELL_BYTES, CELL_BYTES, CELL_BYTES);
    private static final Configuration CONF = HBaseConfiguration.create();
    RpcExecutor rpcExecutor = (RpcExecutor)Mockito.mock(RpcExecutor.class);
    private static final BlockingService SERVICE = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService(new TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface(){

        @Override
        public TestProtos.EmptyResponseProto ping(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
            return null;
        }

        @Override
        public TestProtos.EmptyResponseProto error(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
            return null;
        }

        @Override
        public TestProtos.EchoResponseProto echo(RpcController controller, TestProtos.EchoRequestProto request) throws Error, RuntimeException {
            if (controller instanceof PayloadCarryingRpcController) {
                PayloadCarryingRpcController pcrc = (PayloadCarryingRpcController)controller;
                CellScanner cellScanner = pcrc.cellScanner();
                ArrayList<Cell> list = null;
                if (cellScanner != null) {
                    list = new ArrayList<Cell>();
                    try {
                        if (cellScanner.advance()) {
                            list.add(cellScanner.current());
                            throw new StackOverflowError();
                        }
                    }
                    catch (StackOverflowError e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                cellScanner = CellUtil.createCellScanner(list);
                ((PayloadCarryingRpcController)controller).setCellScanner(cellScanner);
            }
            return TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testRpcScheduler() throws IOException, InterruptedException {
        PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        AbortServer abortable = new AbortServer();
        SimpleRpcScheduler scheduler = new SimpleRpcScheduler(CONF, 2, 0, 0, qosFunction, (Abortable)abortable, 0);
        TestRpcServer rpcServer = new TestRpcServer((RpcScheduler)scheduler);
        RpcClientImpl client = new RpcClientImpl(CONF, "default-cluster");
        try {
            rpcServer.start();
            Descriptors.MethodDescriptor md = SERVICE.getDescriptorForType().findMethodByName("echo");
            TestProtos.EchoRequestProto param = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
            PayloadCarryingRpcController controller = new PayloadCarryingRpcController(CellUtil.createCellScanner((Iterable)ImmutableList.of((Object)CELL)));
            InetSocketAddress address = rpcServer.getListenerAddress();
            if (address == null) {
                throw new IOException("Listener channel is closed");
            }
            client.call(controller, md, (Message)param, (Message)md.getOutputType().toProto(), User.getCurrent(), address, new MetricsConnection.CallStats());
        }
        catch (Throwable e) {
            assert (abortable.isAborted());
        }
        finally {
            rpcServer.stop();
        }
    }

    private class AbortServer
    implements Abortable {
        private boolean aborted = false;

        private AbortServer() {
        }

        public void abort(String why, Throwable e) {
            this.aborted = true;
        }

        public boolean isAborted() {
            return this.aborted;
        }
    }

    private static class TestRpcServer
    extends RpcServer {
        TestRpcServer() throws IOException {
            this((RpcScheduler)new FifoRpcScheduler(CONF, 1));
        }

        TestRpcServer(RpcScheduler scheduler) throws IOException {
            super(null, "testRpcServer", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(SERVICE, null)}), new InetSocketAddress("localhost", 0), CONF, scheduler);
        }

        public Pair<Message, CellScanner> call(BlockingService service, Descriptors.MethodDescriptor md, Message param, CellScanner cellScanner, long receiveTime, MonitoredRPCHandler status) throws IOException {
            return super.call(service, md, param, cellScanner, receiveTime, status);
        }
    }
}

