/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperStub;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMetricsRegionServer {
    public static MetricsAssertHelper HELPER = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private MetricsRegionServerWrapperStub wrapper;
    private MetricsRegionServer rsm;
    private MetricsRegionServerSource serverSource;
    String FLUSH_TIME = "flushTime";
    String FLUSH_TIME_DESC = "Histogram for the time in millis for memstore flush";
    String FLUSH_MEMSTORE_SIZE = "flushMemstoreSize";
    String FLUSH_MEMSTORE_SIZE_DESC = "Histogram for number of bytes in the memstore for a flush";
    String FLUSH_FILE_SIZE = "flushFileSize";
    String FLUSH_FILE_SIZE_DESC = "Histogram for number of bytes in the resulting file for a flush";
    String FLUSHED_OUTPUT_BYTES = "flushedOutputBytes";
    String FLUSHED_OUTPUT_BYTES_DESC = "Total number of bytes written from flush";
    String FLUSHED_MEMSTORE_BYTES = "flushedMemstoreBytes";
    String FLUSHED_MEMSTORE_BYTES_DESC = "Total number of bytes of cells in memstore from flush";

    @BeforeClass
    public static void classSetUp() {
        HELPER.init();
    }

    @Before
    public void setUp() {
        this.wrapper = new MetricsRegionServerWrapperStub();
        this.rsm = new MetricsRegionServer((MetricsRegionServerWrapper)this.wrapper);
        this.serverSource = this.rsm.getMetricsSource();
    }

    @Test
    public void testWrapperSource() {
        HELPER.assertTag("serverName", "test", (BaseSource)this.serverSource);
        HELPER.assertTag("clusterId", "tClusterId", (BaseSource)this.serverSource);
        HELPER.assertTag("zookeeperQuorum", "zk", (BaseSource)this.serverSource);
        HELPER.assertGauge("regionServerStartTime", 100L, (BaseSource)this.serverSource);
        HELPER.assertGauge("regionCount", 101L, (BaseSource)this.serverSource);
        HELPER.assertGauge("storeCount", 2L, (BaseSource)this.serverSource);
        HELPER.assertGauge("maxStoreFileAge", 2L, (BaseSource)this.serverSource);
        HELPER.assertGauge("minStoreFileAge", 2L, (BaseSource)this.serverSource);
        HELPER.assertGauge("avgStoreFileAge", 2L, (BaseSource)this.serverSource);
        HELPER.assertGauge("numReferenceFiles", 2L, (BaseSource)this.serverSource);
        HELPER.assertGauge("hlogFileCount", 10L, (BaseSource)this.serverSource);
        HELPER.assertGauge("hlogFileSize", 1024000L, (BaseSource)this.serverSource);
        HELPER.assertGauge("storeFileCount", 300L, (BaseSource)this.serverSource);
        HELPER.assertGauge("memstoreSize", 1025L, (BaseSource)this.serverSource);
        HELPER.assertGauge("storeFileSize", 1900L, (BaseSource)this.serverSource);
        HELPER.assertCounter("totalRequestCount", 899L, (BaseSource)this.serverSource);
        HELPER.assertCounter("readRequestCount", 997L, (BaseSource)this.serverSource);
        HELPER.assertCounter("writeRequestCount", 707L, (BaseSource)this.serverSource);
        HELPER.assertCounter("checkMutateFailedCount", 401L, (BaseSource)this.serverSource);
        HELPER.assertCounter("checkMutatePassedCount", 405L, (BaseSource)this.serverSource);
        HELPER.assertGauge("storeFileIndexSize", 406L, (BaseSource)this.serverSource);
        HELPER.assertGauge("staticIndexSize", 407L, (BaseSource)this.serverSource);
        HELPER.assertGauge("staticBloomSize", 408L, (BaseSource)this.serverSource);
        HELPER.assertGauge("mutationsWithoutWALCount", 409L, (BaseSource)this.serverSource);
        HELPER.assertGauge("mutationsWithoutWALSize", 410L, (BaseSource)this.serverSource);
        HELPER.assertGauge("percentFilesLocal", 99L, (BaseSource)this.serverSource);
        HELPER.assertGauge("percentFilesLocalSecondaryRegions", 99L, (BaseSource)this.serverSource);
        HELPER.assertGauge("compactionQueueLength", 411L, (BaseSource)this.serverSource);
        HELPER.assertGauge("flushQueueLength", 412L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheFreeSize", 413L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheCount", 414L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheSize", 415L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheHitCount", 416L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheMissCount", 417L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheEvictionCount", 418L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheCountHitPercent", 98L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheExpressHitPercent", 97L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheFailedInsertionCount", 36L, (BaseSource)this.serverSource);
        HELPER.assertCounter("updatesBlockedTime", 419L, (BaseSource)this.serverSource);
    }

    @Test
    public void testConstuctor() {
        Assert.assertNotNull((String)"There should be a hadoop1/hadoop2 metrics source", (Object)this.rsm.getMetricsSource());
        Assert.assertNotNull((String)"The RegionServerMetricsWrapper should be accessable", (Object)this.rsm.getRegionServerWrapper());
    }

    @Test
    public void testSlowCount() {
        int i;
        for (i = 0; i < 12; ++i) {
            this.rsm.updateAppend(12L);
            this.rsm.updateAppend(1002L);
        }
        for (i = 0; i < 13; ++i) {
            this.rsm.updateDelete(13L);
            this.rsm.updateDelete(1003L);
        }
        for (i = 0; i < 14; ++i) {
            this.rsm.updateGet(14L);
            this.rsm.updateGet(1004L);
        }
        for (i = 0; i < 15; ++i) {
            this.rsm.updateIncrement(15L);
            this.rsm.updateIncrement(1005L);
        }
        for (i = 0; i < 16; ++i) {
            this.rsm.updatePut(16L);
            this.rsm.updatePut(1006L);
        }
        HELPER.assertCounter("appendNumOps", 24L, (BaseSource)this.serverSource);
        HELPER.assertCounter("deleteNumOps", 26L, (BaseSource)this.serverSource);
        HELPER.assertCounter("getNumOps", 28L, (BaseSource)this.serverSource);
        HELPER.assertCounter("incrementNumOps", 30L, (BaseSource)this.serverSource);
        HELPER.assertCounter("mutateNumOps", 32L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowAppendCount", 12L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowDeleteCount", 13L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowGetCount", 14L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowIncrementCount", 15L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowPutCount", 16L, (BaseSource)this.serverSource);
    }

    @Test
    public void testFlush() {
        this.rsm.updateFlush(1L, 2L, 3L);
        HELPER.assertCounter("flushTime_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushMemstoreSize_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushOutputSize_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushedMemstoreBytes", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushedOutputBytes", 3L, (BaseSource)this.serverSource);
        this.rsm.updateFlush(10L, 20L, 30L);
        HELPER.assertCounter("flushTimeNumOps", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushMemstoreSize_num_ops", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushOutputSize_num_ops", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushedMemstoreBytes", 22L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushedOutputBytes", 33L, (BaseSource)this.serverSource);
    }

    @Test
    public void testCompaction() {
        this.rsm.updateCompaction(false, 1L, 2, 3, 4L, 5L);
        HELPER.assertCounter("compactionTime_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionInputFileCount_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionInputSize_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionOutputFileCount_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactedInputBytes", 4L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactedoutputBytes", 5L, (BaseSource)this.serverSource);
        this.rsm.updateCompaction(false, 10L, 20, 30, 40L, 50L);
        HELPER.assertCounter("compactionTime_num_ops", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionInputFileCount_num_ops", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionInputSize_num_ops", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionOutputFileCount_num_ops", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactedInputBytes", 44L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactedoutputBytes", 55L, (BaseSource)this.serverSource);
        this.rsm.updateCompaction(true, 100L, 200, 300, 400L, 500L);
        HELPER.assertCounter("compactionTime_num_ops", 3L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionInputFileCount_num_ops", 3L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionInputSize_num_ops", 3L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionOutputFileCount_num_ops", 3L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactedInputBytes", 444L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactedoutputBytes", 555L, (BaseSource)this.serverSource);
        HELPER.assertCounter("majorCompactionTime_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("majorCompactionInputFileCount_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("majorCompactionInputSize_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("majorCompactionOutputFileCount_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("majorCompactedInputBytes", 400L, (BaseSource)this.serverSource);
        HELPER.assertCounter("majorCompactedoutputBytes", 500L, (BaseSource)this.serverSource);
    }
}

